@echo off

:init
SETLOCAL EnableDelayedExpansion
SETLOCAL EnableExtensions
set curDir=%~dp0
set PnpUtil=pnputil.exe
set DriverDir=%curDir%\WIN10\NDIS6
rem set infName="rtvdevx86_ext.inf"
set infName="%1"

::if %PROCESSOR_ARCHITECTURE%==AMD64 (
::    set infName="rtvdevx64_ext.inf"
::)
goto start

:start
set PublishedName=
set OriginalName=

cd /D %curDir%

for /f "tokens=1,2 delims=:" %%a in ('%PnpUtil% /enum-drivers') do (
    set tmpStringA=%%a
    set tmpStringB=%%b
    set tmpStringA=!tmpStringA: =!
    set tmpStringB=!tmpStringB: =!
    rem call :Trim tmpStringA %%a
    rem call :Trim tmpStringB %%b
    
    if "!tmpStringA!"=="PublishedName" (
        set PublishedName="!tmpStringB!"
        rem echo published name = !PublishedName!
    )
    if "!tmpStringA!"=="OriginalName" (
        set OriginalName="!tmpStringB!"
        rem echo original name = !OriginalName!
    )
    
    if NOT !PublishedName!=="" (
        if NOT !OriginalName!=="" (
            if "!OriginalName!"=="!infName!" (
                echo "removing !PublishedName!..."
                call :pnpUninstall !PublishedName!
                
                set PublishedName=
                set OriginalName=
            )
        )
    )
)
goto exit

:pnpUninstall
%PnpUtil% /delete-driver %1 /uninstall
exit /b

:Trim
set Params=%*
for /f "tokens=1*" %%a in ("!Params!") do EndLocal & set %1=%%b
exit /b

:exit
cd /D %curDir%
rem pause
@echo on