Intel(R) Ethernet Flash Firmware Utility
========================================
October 23, 2020

CONTENTS
========
- DISCLAIMER
- INTRODUCTION
- RUNNING BootUtil
- COMMAND LINE OPTIONS
- EXAMPLES
- EXIT CODES


DISCLAIMER
==========
This README.TXT, as well as the software described in it, is furnished under
license and may only be used or copied in accordance with the terms of the
license. The information in this manual is furnished for informational
use only, is subject to change without notice, and should not be construed
as a commitment by Intel Corporation. Intel Corporation assumes no
responsibility or liability for any errors or inaccuracies that may appear
in this document or any software that may be provided in association with
this document.

Except as permitted by such license, no part of this document may be
reproduced, stored in a retrieval system, or transmitted in any form or
by any means without the express written consent of Intel Corporation.


INTRODUCTION
============
The Intel(R) Ethernet Flash Firmware Utility (BootUtil) is used to update
configurations and program the PCI option ROM on the flash memory of supported
Intel PCI and PCI-Express-based network adapters.
BootUtil replaces existing utilities and provides the functionality of the
older IBAUTIL, LANUTIL, and FLAUTIL. BootUtil supports all the adapters
supported by the previous utilities.

NOTES:
- Legacy iSCSI Boot and CLP images are not supported and cannot be loaded or
configured.
- Updating the adapter's flash memory using BootUtil will erase any existing
firmware image from the flash memory.
- If your device is flashed with a discrete FCoE firmware (no other Option ROMs
flashed), attempts to update your device will fail. This is expected. The data
required for FCoE functionality upgrades is no longer part of the latest
upgrade packages. The update will fail and FCoE functionality will continue to
work.
- If you update a device that is flashed with an FCoE-enabled combo image (for
example, an image that contains the EFI driver, legacy PXE, and FCoE boot
functionality), the Option ROM combination will change on update, usually to
the same combination without FCoE capabilities. This is expected. The data
required for FCoE functionality upgrades is no longer part of the latest
upgrade packages. The update will succeed and FCoE functionality will be
removed from your device.

Intel provides the following flash firmware in FLB file format for programming
to the flash memory:

- Intel(R) Boot Agent as PXE Option ROM for legacy BIOS
  http://www.intel.com/support/network/adapter/pro100/bootagent/
- Network Connectivity, UEFI network driver
  http://www.intel.com/support/network/sb/cs-006120.htm

OEMs may provide custom flash firmware images for OEM network adapters. Please
refer to the instructions given by OEMs.

BootUtil allows the user to flash supported firmware to the adapter from the
included BootIMG.FLB file. This option ROM includes PXE and UEFI, and the image
is programmed to the flash memory at once. BootUtil will also build the
required combo images for supported adapter and program those images to the
flash, as well. Since both discrete and combo images are supported, the
-BOOTENABLE command ONLY works on combo images.

PXE+EFI image combinations are supported for all OEM generic adapters, however
support is limited to devices which support both technologies as discrete
images. However, flash size is a limiting factor, as the image size can change
without notice.

The BOOTIMG.FLB file is the container for all the Intel(R) boot Option ROMs.
This file replaces the existing FLB files for PXE and EFI.

BootUtil without command-line options will display a list of all supported
Intel network ports in the system. BootUtil will also allow the user to enable
or disable the flash memory on specific ports by using -FLASHENABLE or
-FLASHDISABLE options in order to control access to the firmware from the
system.

BootUtil allows the user to individually set UEFI and  PXE boot configurations
by -NIC=xx -<OPTION>=<VALUE> options.

NOTES:
* BootUtil displays up to 128 adapter ports.
* No configuration settings are supported for the UEFI driver.
* -NIC, -MACADDR, and -DEVID are mutually exclusive. You cannot use more than
one of these options per command. Specifying more than one option will cause
BootUtil to fail.
* You cannot enable/disable 64-bit BAR addressing on Intel(R) Ethernet
Controller X550 Series devices.
* BootUtil may indicate that a device is in the "Pending Reboot" state. No
update or configuration changes are possible on a device in this state. Please
reboot your system.

Check the Intel Customer Support (http://support.intel.com) website for the
latest information and component updates.

NOTE: If the tool displays the error: "Unable to load the driver. Please close
all other applications and try again", you have a mix of old and new versions
of the utility tool on your system. Quit all open applications and retry your
operation. If the issue persists:
1. Download the latest version of the utility tools.
2. Run the uninstall script to remove the old version of the tool driver.
3. Run the install script from the downloaded tools package.
4. Retry your operation.
You may also need to download and install the latest Intel Ethernet driver or
Intel PROSet package for your device.


RUNNING THE UTILITY
===================
Using the "/?" option will display a list of supported command line options.
The syntax for issuing BootUtil command-line options is:
BOOTUTIL -[OPTION] or -<OPTION>=<VALUE>


COMMAND LINE OPTIONS
====================
BootUtil accepts one executable option and its associated non-executable
options in an execution. If conflicting executable options are specified,
BootUtil exits with an error.

The options, where applicable, are listed in logical groups.

NOTE: If you run BootUtil without any command-line options, the utility
displays a list of all supported Intel network ports found in the system.


GENERAL OPTIONS:
-? or -HELP
Displays a list of command-line options.
-ALL
Selects all supported network ports found in the system.

-64d
Disables 64-bit BAR (Base Address Register) addressing on the selected port.
This restricts the system BIOS to assigning 32-bit BARs to the port.

-64e
Enables 64-bit BAR addressing on the selected port.

-BLINK
Blinks the LED on the selected port for ten seconds.

-DEVID=[Device ID]
Selects the network port specified by [Device ID]. [Device ID] is a 4 digit
hexadecimal number, prepended by 0x.

-EXITCODES
Displays exit codes returned to the OS environment by BootUtil.

-E
Enumerates all supported network ports in the system.

-FILE=[FILENAME]
Specifies the file name for -SAVEIMAGE, -RESTOREIMAGE, -SAVECONFIG,
-RESTORECONFIG, -UP or -UPDATE options.

-IMAGEVERSION or -IV
Displays the firmware image type and version number from the specified source.
If no source is specified, displays the image type and version number from the
local BootIMG.FLB file. Use -FILE to specify a different file. Use -NIC to
specify a port. Use -ALL to display the firmware image types and version
numbers of images loaded onto all ports in the system. If a port does not have
an image loaded, or is not an Intel Ethernet port, the port will not be
included in the -ALL output.

-MACADDR=[MAC address string]
Selects the network port specified by [MAC address string]. [MAC address
string] is a 12 digit number. Separators (":" or "-") are allowed but not
required.

-NIC=XX
Selects a specific network port in the system.

-NODPL
With command, BootUtil does not display the PCI device location.

-O=[FILENAME]
Must be used with -E . Saves a list of all NICs and their MAC addresses to the
specified file.

-P
With this command, BootUtil pauses screen after displaying every 25th line. In
pause mode, last line of the screen will contain information that:
  - screen has been paused, and
  - user can press Enter to continue


POWER MANAGEMENT OPTIONS:

-WOLENABLE or -WOLE
Enables Wake On LAN (WOL) functionality on the selected port.

-WOLDISABLE or -WOLD
Disables Wake On LAN (WOL) functionality on the selected port.


ADAPTER FLASH ENABLE/DISABLE OPTIONS:

-BOOTENABLE=[PXE or DISABLED]
Selects flash firmware type to enable or disable on the selected port. The
combo option ROM could have all capabilities. This command will NOT WORK on
monolithic Option ROMs.

NOTE: This manual command is not applicable to the UEFI network driver. The
UEFI network driver is enabled by default and loaded automatically unless
network ports are already used by other flash firmware.

  BOOTENABLE=DISABLED
  Disables PXE functionalities for legacy BIOS.

-FLASHENABLE or -FE
Enables the capability to run flash firmware on the selected adapter.

NOTE: This parameter is not supported on the following adapters:
  - Intel(R) Gigabit ET Quad Port Mezzanine Card
  - Intel(R) Ethernet X520 10GbE Dual Port KX4 Mezz
  - Intel(R) Ethernet X520 10GbE Dual Port KX4-KR Mezz

-FLASHDISABLE or -FD
Disables the capability to run flash firmware on the selected adapter.

NOTE: This parameter is not supported on the following adapters:
  - Intel(R) Gigabit ET Quad Port Mezzanine Card
  - Intel(R) Ethernet X520 10GbE Dual Port KX4 Mezz
  - Intel(R) Ethernet X520 10GbE Dual Port KX4-KR Mezz


FLASH PROGRAMMING OPTIONS:

-QUIET
Runs BootUtil without confirmation prompts. This option is used with
-IMAGEVERSION, -UP, -UPDATE, -RESTOREIMAGE, or -HELP option.

-RESTOREIMAGE or RI
Restores a previously-saved firmware image to the same network adapter using
the -NIC option. The source file is specified by the -FILE option.

-SAVEIMAGE or SI
Saves the existing firmware image in the flash memory of the adapter specified
by the -NIC option to a disk file. The destination file is specified by the
-FILE option.

-UP or -UPDATE=[ROMType] [-FILE=Filename]
Updates the flash memory of the adapter specified by the -NIC option with the
given FLB flash firmware image file. If -QUIET is not specified, the user is
prompted to confirm overwriting the existing firmware image before upgrading.
If a Filename is not provided, the utility looks for the default <bootimg.FLB>
file which contains all image types.

The following examples use PXE, but could also be efi or efi64.
  Bootutil -Nic=x -up=pxe
  Bootutil -Nic=x -up=pxe -file=pxeimg.flb

If your adapter supports a combo option rom, the following command option
automatically detects the supported combo image and programs the adapter with
that image.
  -up=combo
    up=pxe+efi is valid.


PXE BOOT CONFIGURATION OPTIONS: (Can be used with -NIC or -ALL)

-DEFAULTCONFIG or -DEFCFG
Sets the PXE configuration of the selected NIC back to default settings.

-MODE
This parameter should not be used except as advised by Intel Support personnel.

-TITLEENABLE OR -TLE
Enables Initial Title Message.

-TITLEDISABLE OR -TLD
Disables Initial Title Message.


EXAMPLES
========
The following examples show how to enter some typical BootUtil command lines:

Example: To enable the flash firmware on the first network adapter for the
system to be capable of executing the flash firmware.
  BootUtil -NIC=1 -FLASHENABLE

Example: To disable the flash firmware on all the network adapters.
  BootUtil -ALL -FD

Example: To display BootUtil FLB flash firmware types and versions.
  BootUtil -IMAGEVERSION

Example: To update all ports of a supported NIC with PXE.
  1. BootUtil -UP=PXE -ALL (Assumes input file is bootimg.flb)
  2. BootUtil -UP=PXE -ALL -FILE=BOOTIMG.FLB (explicit user specified file)

Example: To update a combo image on supported adapter (eg, pxe+efi)
  1. BootUtil -UP=Combo -NIC=2 -FILE=BOOTIMG.FLB

The above command will succeed if the PXE+EFI combination is supported on NIC
#2. If not an error is displayed to the user.

NOTE: THE -UP and -UPDATE commands are equivalent and interchangeable.

Example: To enable PXE firmware on the third network port in the system.
  BootUtil -BOOTENABLE=PXE -NIC=3

NOTE: This command will work only if PXE is part of a combo Option ROM and not
a discrete Option ROM.

Example: To disable the firmware on the second network port in the system.
  BootUtil -NIC=2 -BOOTENABLE=DISABLED

Example: To get help descriptions.
  BootUtil -?


EXIT CODES
==========
BootUtil returns an exit code to the OS environment. Possible exit codes are
listed below:
Code Name                                      Value
----------------------------------------------+-----
All BootUtil operations completed successfully   0
Bad command-line parameter                       1
No supported network port detected               2
Invalid network port selected                    3
FLASH operation failed                           4
EEPROM read operation failed                     5
EEPROM write operation failed                    6
File content is missing or corrupt               7
Operator termination                             8
LOM not supported for selected operation         9
Network port is not bootable                    10
FLASH memory is disabled for flash firmware     11
FLASH memory too small for selected firmware    12
System memory allocation failed                 14
File operation failed                           15


Copyright(c) 2015 Intel Corporation.
I n t e l ( R )   N e t w o r k   C o n n e c t i o n   T o o l s 
 
 = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 
 
 A u g u s t   1 4 ,   2 0 2 0 
 
 
 
 C o n t e n t s 
 
 = = = = = = = = 
 
 -   O V E R V I E W 
 
 -   I N S T A L L I N G   T H E   T O O L S   O N   M I C R O S O F T *   W I N D O W S * 
 
 -   I N S T A L L I N G   T H E   T O O L S   O N   L I N U X * 
 
 -   I N S T A L L I N G   T H E   T O O L S   O N   E F I 
 
 -   I N S T A L L I N G   T H E   T O O L S   O N   F R E E B S D * 
 
 -   C U S T O M E R   S U P P O R T 
 
 
 
 
 
 O V E R V I E W 
 
 = = = = = = = = 
 
 T h i s   d o c u m e n t   d e s c r i b e s   h o w   t o   i n s t a l l   t h e   I n t e l ( R )   N e t w o r k   C o n n e c t i o n   T o o l s . 
 
 S e e   t h e   r e a d m e   p r o v i d e d   f o r   e a c h   t o o l   f o r   a   d e t a i l e d   e x p l a n a t i o n   o f   t h e 
 
 f e a t u r e s   a v a i l a b l e . 
 
 
 
 
 
 I n s t a l l i n g   t h e   t o o l   o n   M i c r o s o f t *   W i n d o w s * 
 
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 
 T o   i n s t a l l   t h e   t o o l s '   d r i v e r s   o n   W i n d o w s ,   r u n   i n s t a l l . b a t   f r o m   t h e   a p p r o p r i a t e 
 
 d i r e c t o r y   o f   t h e   i n s t a l l   p a c k a g e . 
 
 
 
 A l t h o u g h   t h e   t o o l s   a r e   n o t   i n s t a l l e d   w i t h   i n s t a l l . b a t ,   t h e   d r i v e r   t h a t   t h e   t o o l 
 
 r e q u i r e s   i s   c o p i e d   i n t o   t h e   l o c a l   m a c h i n e   W i n d o w s   d r i v e r   d i r e c t o r y .   T o   r u n   t h e 
 
 t o o l ,   l a u n c h   a   C o m m a n d   P r o m p t   w i n d o w   f r o m   t h e   W i n d o w s   S t a r t   M e n u .   G o   t o   t h e 
 
 m e d i a   a n d   d i r e c t o r y   w h e r e   t h e   t o o l   i s   l o c a t e d   a n d   r u n   t h e   u t i l i t y .   T h e   r e a d m e 
 
 f i l e s   f o r   e a c h   t o o l   a r e   f o u n d   i n   t h e   s a m e   d i r e c t o r y   a s   t h e   t o o l .   T h e s e   t o o l s 
 
 c a n   b e   m a n u a l l y   i n s t a l l e d   o n   t h e   l o c a l   h a r d   d r i v e   i n   a n y   d i r e c t o r y . 
 
 
 
 T h e   t o o l   u s e s   i t s   o w n   d r i v e r   f i l e   ( n o t   t h e   s a m e   a s   t h e   s y s t e m   n e t w o r k   d r i v e r ) . 
 
 I f   t h e   d r i v e r   s y s   f i l e   a l r e a d y   e x i s t s   i n   t h e   d r i v e r s   d i r e c t o r y ,   i n s t a l l . b a t   m a y 
 
 f a i l   t o   c o p y .   U s i n g   t h e   / y   s w i t c h   w i t h   i n s t a l l . b a t   w i l l   o v e r r i d e   a n d   c o p y   t h e 
 
 d r i v e r   f i l e   r e g a r d l e s s .   H o w e v e r ,   t h i s   c a n   b e   d a n g e r o u s   i f   a n   o l d e r   v e r s i o n   o f 
 
 t h e   d r i v e r   i s   b e i n g   u s e d   b y   a n o t h e r   a p p l i c a t i o n   s u c h   a s   I n t e l ( R )   P R O S e t   f o r 
 
 W i n d o w s   D e v i c e   M a n a g e r .   I f   a   d r i v e r   i s   a l r e a d y   p r e s e n t   i n   t h e   d r i v e r s 
 
 d i r e c t o r y ,   t r y   r u n n i n g   t h e   t o o l   f r o m   t h e   c o m m a n d   p r o m p t .   I f   i t   r u n s ,   t h e n   t h e 
 
 d r i v e r   i s   f i n e .   T h e   t o o l   w i l l   n o t   r u n   i f   t h e   d r i v e r   v e r s i o n   p r e s e n t   d o e s   n o t 
 
 m a t c h   t h e   d r i v e r   v e r s i o n   e x p e c t e d . 
 
 
 
 N o t e   t h a t   y o u   m u s t   h a v e   a c c e s s   t o   t h e   % s y s t e m r o o t % \ s y s t e m 3 2 \ d r i v e r s   d i r e c t o r y . 
 
 O n l y   t h e   a d m i n i s t r a t o r   a c c o u n t   h a s   t h e s e   p r i v i l e g e s .   Y o u   m u s t   b e   l o g g e d   i n   a s 
 
 a d m i n i s t r a t o r   o r   t h e   t o o l s   m u s t   b e   r u n   a s   a d m i n i s t r a t o r . 
 
 
 
 N o t e   t h a t   o n   W i n d o w s ,   a n y   d e v i c e   t h a t   i s   d i s a b l e d   i n   D e v i c e   M a n a g e r   w i l l   n o t   b e 
 
 a c c e s s i b l e   b y   t o o l s   d u e   t o   n o   m e m o r y   r e s o u r c e s .   Y o u   w o u l d   g e t   a n   e r r o r   c o d e 
 
 0 x C 8 6 A 8 0 0 E .   T o   s o l v e   t h i s   p r o b l e m ,   y o u   c a n   d o   o n e   o f   t h e   f o l l o w i n g : 
 
 1 )   R e - e n a b l e   t h e   d e v i c e   i n   D e v i c e   M a n a g e r .   N e v e r   d i s a b l e   t h i s   d e v i c e   w h e n 
 
       u s i n g   t o o l s . 
 
 2 )   I n s t a l l   a n   N D I S   d e v i c e   d r i v e r   f o r   t h e   d e v i c e   a n d   m a k e   s u r e   t h a t   i t   d o e s 
 
       n o t   h a v e   a   y e l l o w   o r   r e d   b a n g   b y   i t   i n   D e v i c e   M a n a g e r . 
 
 3 )   D e l e t e   t h e   d e v i c e   f r o m   D e v i c e   M a n a g e r   a n d   r e s t a r t   t h e   s y s t e m .   T h e   i n s t a l l 
 
       n e w   h a r d w a r e   w i z a r d   s h o u l d   a p p e a r   o n   n e x t   r e b o o t .   D o   n o t   c a n c e l   t h i s .   J u s t 
 
       m o v e   t h e   w i n d o w   a s i d e   a n d   r u n   t h e   t o o l ( s ) .   G e n e r a l l y ,   y o u   c a n   c l i c k   " c a n c e l " 
 
       o n   t h e   w i z a r d   b u t   t h e r e   a r e   s o m e   c a s e s   w h e r e   W i n d o w s   w i l l   d i s a b l e   t h e   m e m o r y 
 
       r e s o u r c e s ,   c a u s i n g   y o u   t o   g e t   b a c k   i n t o   t h e   s a m e   s t a t e . 
 
 
 
 
 
 I n s t a l l i n g   t h e   t o o l   o n   E F I 
 
 - - - - - - - - - - - - - - - - - - - - - - - - - - 
 
 T h e   E F I   1 . x   t o o l s   a r e   n o t   s u p p o r t e d   i n   t h i s   r e l e a s e . 
 
 
 
 T h e r e   i s   n o   i n s t a l l a t i o n   r e q u i r e d   f o r   E F I   t o o l s .   T h e   t o o l s   c a n   s i m p l y   b e   c o p i e d 
 
 f r o m   t h e   a p p r o p r i a t e   d i r e c t o r y   t o   t h e   d r i v e   t h a t   t h e y   w i l l   r u n   f r o m .   T h e   E F I 2 
 
 b i n a r i e s   a r e   f o r   u s e   w i t h   t h e   U E F I   S h e l l   2 . X   w i t h   t h e   U E F I   2 . 3   H I I   p r o t o c o l . 
 
 E F I 2   t o o l s   w i l l   n o t   r u n   o n   t h e   E F I   S h e l l   1 . X   o r   i f   t h e   U E F I   2 . 3   H I I   p r o t o c o l   i s 
 
 n o t   p r e s e n t . 
 
 
 
 N o t e   t h a t   w h i l e   E F I   s u p p o r t s   U S B   d r i v e s ,   t h e r e   m a y   b e   i s s u e s   r u n n i n g   t o o l s   f r o m 
 
 t h e   U S B   d r i v e .   W h e t h e r   o r   n o t   t h e r e   a r e   i s s u e s   a r e   B I O S   s p e c i f i c .   I f   y o u 
 
 e x p e r i e n c e   i s s u e s ,   r u n   t h e   t o o l   f r o m   h a r d   d i s k   i n s t e a d . 
 
 
 
 
 
 I n s t a l l i n g   t h e   t o o l   o n   L i n u x * 
 
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 
 I n   o r d e r   t o   r u n   t o o l s   o n   L i n u x * ,   a   d r i v e r   s t u b   m u s t   b e   b u i l t   a n d   i n s t a l l e d   o n 
 
 t h e   s y s t e m .   T h i s   d r i v e r   i s   n o t   r e l a t e d   t o   t h e   n e t w o r k   d e v i c e   d r i v e r   t h a t   i s 
 
 u s e d   t o   r u n   t h e   n e t w o r k   d u r i n g   l i v e   t r a f f i c .   I t   i s   a   s e p a r a t e   d r i v e r   u s e d 
 
 e x p l i c i t l y   f o r   t o o l s .   D u e   t o   t h e   n a t u r e   o f   L i n u x   w i t h   t h e   n u m b e r   o f   k e r n e l s 
 
 t h a t   c a n   e x i s t ,   w e   p r o v i d e   s o u r c e   f o r   t h e   d r i v e r   m o d u l e   a n d   a n   i n s t a l l   s c r i p t 
 
 t o   b u i l d / i n s t a l l   i t . 
 
 
 
 T h e   t o o l s   s u p p o r t   L i n u x   d i s t r i b u t i o n s   b a s e d   o n   k e r n e l s   2 . 6 . x .   V a l i d a t i o n   i s 
 
 d o n e   r a n d o m l y   o n   p o p u l a r   d i s t r i b u t i o n s   s u c h   a s   R e d   H a t *   o r   S u s e * .   C o n f i g u r e d 
 
 k e r n e l   s o u r c e   t h a t   m a t c h e s   t h e   c u r r e n t l y   i n s t a l l e d   k e r n e l   i s   r e q u i r e d .   A 
 
 w o r k i n g   G C C   i s   a l s o   r e q u i r e d .   T h e r e   a r e   s o m e   v e r s i o n s   o f   G C C   t h a t   h a d   a   b u g 
 
 w h i c h   d i d   n o t   s u p p o r t   u n n a m e d   s t r u c t u r e s .   T h e s e   v e r s i o n s   o f   G C C   a r e   n o t 
 
 s u p p o r t e d .   I f   y o u   h a v e   c o m p i l a t i o n   e r r o r s ,   t r y   u p d a t i n g   y o u r   v e r s i o n   o f   G C C .   I f 
 
 y o u   h a v e   l i n k e r   e r r o r s   w h e n   i n s t a l l i n g   t h e   d r i v e r ,   y o u   s h o u l d   u p d a t e   y o u r 
 
 k e r n e l   -   d o w n l o a d   t h e   l a t e s t   s t a b l e   o f f   w w w . k e r n e l . o r g   a n d   b u i l d / i n s t a l l   i t . 
 
 
 
 N o t e   t h a t   s o m e   d i s t r i b u t i o n s   s u c h   a s   r e c e n t   F e d o r a   c o r e   v e r s i o n s   d o   n o t   s h i p 
 
 w i t h   K e r n e l   s o u r c e .   Y o u   m u s t   d o w n l o a d ,   i n s t a l l ,   a n d   c o n f i g u r e   t h e   s o u r c e   i n 
 
 o r d e r   t o   g e t   t h e   t o o l s '   d r i v e r   b u i l t   o n   t h i s   O S .   I n s t a l l i n g   t h e   k e r n e l   s o u r c e 
 
 R P M   d o e s   n o t   s o l v e   t h e   p r o b l e m . 
 
 
 
 T h i s   i s   t h e   i n s t a l l a t i o n   p r o c e d u r e : 
 
     1 .   L o g   i n   a s   r o o t   a n d   c r e a t e   a   t e m p o r a r y   d i r e c t o r y   t o   b u i l d   t h e   I n t e l ( R ) 
 
           N e t w o r k   C o n n e c t i o n   T o o l s   d r i v e r . 
 
     2 .   C o p y   ' i n s t a l l '   a n d   ' i q v l i n u x . t a r . g z '   t o   t h e   t e m p o r a r y   d i r e c t o r y . 
 
           T h e r e   a r e   2   v e r s i o n s   o f   L i n u x   s u p p o r t e d :   L i n u x 3 2   ( x 8 6 ) a n d   L i n u x _ x 6 4   ( x 6 4 ) . 
 
           C o p i e s   o f   t h e   a b o v e   f i l e s   e x i s t   i n   t h e   a p p r o p r i a t e   d i r e c t o r y   f o r   y o u r 
 
           p l a t f o r m . 
 
     3 .   C D   t o   t h e   t e m p o r a r y   d i r e c t o r y   a n d   r u n   ' . / i n s t a l l . '   T h e   d r i v e r   h a s   b e e n 
 
           i n s t a l l e d   n o w ,   s o   t h e   f i l e s   i n   t h e   t e m p o r a r y   d i r e c t o r y   c a n   b e   r e m o v e d . 
 
     4 .   C o p y   t h e   t o o l s   t h a t   y o u   w a n t   t o   u s e   f r o m   t h e   a p p r o p r i a t e   d i r e c t o r y   o f 
 
           t h e   C D . 
 
 
 
 O n   k e r n e l   4 . 1 6   o r   h i g h e r ,   e n s u r e   i o m e m   p a r a m e t e r   s e t   t o   r e l a x e d 
 
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 
 O n   L i n u x *   k e r n e l   4 . 1 6   a n d   h i g h e r ,   t h e   i o m e m   p a r a m e t e r   i s   s e t   t o   " s t r i c t "   b y 
 
 d e f a u l t ,   w h i c h   m a y   p r e v e n t   t h e   t o o l   f r o m   a c c e s s i n g   t h e   M M I O   o f   t h e   d e v i c e . 
 
 T r y i n g   t o   u p d a t e   a   d e v i c e   w h e n   " s t r i c t "   i s   s e t   c a u s e s   t h e   d e v i c e   t o   l o s e   l i n k 
 
 d u r i n g   t h e   u p d a t e   p r o c e s s . 
 
 
 
 I f   y o u   w i s h   t o   u p d a t e   a   d e v i c e   w i t h o u t   l o s i n g   l i n k ,   y o u   c a n   e i t h e r : 
 
 1 .   I n s t a l l   L i n u x   b a s e   d r i v e r s   ( i g b   o r   i x g b e )   f r o m   R e l e a s e   2 4 . 1 ,   o r   n e w e r . 
 
 2 .   S e t   t h e   i o m e m   k e r n e l   p a r a m e t e r   t o   " r e l a x e d "   ( i . e . ,   i o m e m = r e l a x e d )   a n d   r e b o o t 
 
 t h e   s y s t e m   b e f o r e   r u n n i n g   t h e   u p d a t e   u t i l i t y . 
 
 
 
 
 
 I n s t a l l i n g   t h e   t o o l   o n   F r e e B S D * 
 
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 
 I n   o r d e r   t o   r u n   t o o l s   o n   F r e e B S D * ,   a   d r i v e r   s t u b   m u s t   b e   b u i l t   a n d   i n s t a l l e d   o n 
 
 t h e   s y s t e m .   T h i s   d r i v e r   i s   n o t   r e l a t e d   t o   t h e   n e t w o r k   d e v i c e   d r i v e r   t h a t   i s 
 
 u s e d   t o   r u n   t h e   n e t w o r k   d u r i n g   l i v e   t r a f f i c .   I t   i s   a   s e p a r a t e   d r i v e r   u s e d 
 
 e x p l i c i t l y   f o r   t o o l s .   D u e   t o   t h e   n a t u r e   o f   F r e e B S D   w i t h   t h e   n u m b e r   o f   k e r n e l s 
 
 t h a t   c a n   e x i s t ,   w e   p r o v i d e   s o u r c e   f o r   t h e   d r i v e r   m o d u l e   a n d   a n   i n s t a l l   s c r i p t 
 
 t o   b u i l d / i n s t a l l   i t . 
 
 
 
 T h e   t o o l s   s u p p o r t   F r e e B S D   d i s t r i b u t i o n s   v e r s i o n   1 0 . 1   a n d   l a t e r . 
 
 
 
 T h i s   i s   t h e   i n s t a l l a t i o n   p r o c e d u r e : 
 
     1 .   L o g   i n   a s   r o o t   a n d   c r e a t e   a   t e m p o r a r y   d i r e c t o r y   t o   b u i l d   t h e   I n t e l ( R ) 
 
           N e t w o r k   C o n n e c t i o n   T o o l s   d r i v e r . 
 
     2 .   C o p y   ' i n s t a l l '   a n d   ' i q v f r e e b s d . t a r '   t o   t h e   t e m p o r a r y   d i r e c t o r y . 
 
           T h e r e   a r e   2   v e r s i o n s   o f   F r e e B S D   s u p p o r t e d :   F r e e B S D 3 2   ( x 8 6 )   a n d 
 
           F r e e B S D 6 4 e   ( x 6 4 ) .   C o p i e s   o f   t h e   a b o v e   f i l e s   e x i s t   i n   t h e   a p p r o p r i a t e 
 
           d i r e c t o r y   f o r   y o u r   p l a t f o r m . 
 
     3 .   C D   t o   t h e   t e m p o r a r y   d i r e c t o r y   a n d   r u n   ' . / i n s t a l l '   T h e   d r i v e r   h a s 
 
           b e e n   i n s t a l l e d   n o w ,   s o   t h e   f i l e s   i n   t h e   t e m p o r a r y   d i r e c t o r y   c a n   b e 
 
           r e m o v e d . 
 
     4 .   C o p y   t h e   t o o l s   t h a t   y o u   w a n t   t o   u s e   f r o m   t h e   a p p r o p r i a t e   d i r e c t o r y   o f 
 
           t h e   C D . 
 
 
 
 
 
 C U S T O M E R   S U P P O R T 
 
 = = = = = = = = = = = = = = = = 
 
 -   M a i n   I n t e l   w e b   s u p p o r t   s i t e :   h t t p : / / s u p p o r t . i n t e l . c o m 
 
 
 
 -   N e t w o r k   p r o d u c t s   i n f o r m a t i o n :   h t t p : / / w w w . i n t e l . c o m / n e t w o r k 
 
 
 
 I n t e l   W i r e d   N e t w o r k i n g   p r o j e c t   h o s t e d   b y   S o u r c e f o r g e : 
 
 h t t p : / / s o u r c e f o r g e . n e t / p r o j e c t s / e 1 0 0 0 
 
 
 
 
 
 L E G A L   /   D I S C L A I M E R S 
 
 = = = = = = = = = = = = = = = = = = = 
 
 C o p y r i g h t   ( C )   2 0 0 2 - 2 0 2 0 ,   I n t e l   C o r p o r a t i o n .   A l l   r i g h t s   r e s e r v e d . 
 
 
 
 T h i s   s o f t w a r e   a n d   t h e   r e l a t e d   d o c u m e n t s   a r e   I n t e l   c o p y r i g h t e d   m a t e r i a l s ,   a n d 
 
 y o u r   u s e   o f   t h e m   i s   g o v e r n e d   b y   t h e   e x p r e s s   l i c e n s e   u n d e r   w h i c h   t h e y   w e r e 
 
 p r o v i d e d   t o   y o u   ( " L i c e n s e " ) .   U n l e s s   t h e   L i c e n s e   p r o v i d e s   o t h e r w i s e ,   y o u   m a y   n o t 
 
 u s e ,   m o d i f y ,   c o p y ,   p u b l i s h ,   d i s t r i b u t e ,   d i s c l o s e   o r   t r a n s m i t   t h i s   s o f t w a r e   o r 
 
 t h e   r e l a t e d   d o c u m e n t s   w i t h o u t   I n t e l ' s   p r i o r   w r i t t e n   p e r m i s s i o n . 
 
 
 
 T h i s   s o f t w a r e   a n d   t h e   r e l a t e d   d o c u m e n t s   a r e   p r o v i d e d   a s   i s ,   w i t h   n o   e x p r e s s   o r 
 
 i m p l i e d   w a r r a n t i e s ,   o t h e r   t h a n   t h o s e   t h a t   a r e   e x p r e s s l y   s t a t e d   i n   t h e   L i c e n s e . 
 
 
 
 I n t e l   t e c h n o l o g i e s   m a y   r e q u i r e   e n a b l e d   h a r d w a r e ,   s o f t w a r e   o r   s e r v i c e   a c t i v a t i o n . 
 
 
 
 N o   p r o d u c t   o r   c o m p o n e n t   c a n   b e   a b s o l u t e l y   s e c u r e . 
 
 
 
 Y o u r   c o s t s   a n d   r e s u l t s   m a y   v a r y . 
 
 
 
 I n t e l ,   t h e   I n t e l   l o g o ,   a n d   o t h e r   I n t e l   m a r k s   a r e   t r a d e m a r k s   o f   I n t e l 
 
 C o r p o r a t i o n   o r   i t s   s u b s i d i a r i e s . 
 
 
 
 * O t h e r   n a m e s   a n d   b r a n d s   m a y   b e   c l a i m e d   a s   t h e   p r o p e r t y   o f   o t h e r s . 
 
 
 
 
 
 