/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2015 - 2023, Intel Corporation                                                                    *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsddriverpci_i.c                                                                                 *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsddriverpci_i.c                                                              *
 *                                                                                                           *
 ************************************************************************************************************/
#include <freebsdpci_i.h>
#include <naltypes.h>
#include <nalcodes.h>

/***************************************************************************
**
** Name:            _NalReadPciDeviceCount()
**
** Description:     Scans all PCI buses and counts the number of devices.
**
** Arguments:       Nothing.
**
** Returns:         Number of devices on the system.
**
** Notes:           This scans the devices once in life of the driver currently. If
**                  drivers are enabled/disabled, this isnt updated. This needs to
**                  change somehow while not scanning this stuff everytime.
**
****************************************************************************/
UINT16
_NalReadPciDeviceCount(
    VOID
    )
{
    /* This is implemented in the library portion of FreeBSD NAL. This function only exists
     * so the generic IOCTL interface doesnt have an unresolved external reference */
    return 0;
}
/***************************************************************************
**
** Name:            _NalReadPciDevice()
**
** Description:     Scans all PCI buses and stores the config info.
**
** Arguments:       SlotIds = pointer to allocated memory of SlotIds.
**                  Count   = Number of slots to fill.
**
** Returns:         NAL_STATUS.
**
****************************************************************************/
NAL_STATUS
_NalReadPciDevice(
    OUT NAL_DEVICE_LOCATION* PciLocations,
    IN  UINT16*              Count
    )
{
    /* This is implemented in the library portion of FreeBSD NAL. This function only exists
     * so the generic IOCTL interface doesnt have an unresolved external reference */
    return NAL_NOT_IMPLEMENTED;
}
/***************************************************************************
**
** Name:            _NalEnablePciDevice()
**
** Description:     Enable the PCI slot.
**
** Arguments:       DeviceLocation = Slot to enable.
**
** Returns:         NAL_STATUS Value
**
****************************************************************************/
NAL_STATUS
_NalEnablePciDevice(
    IN      NAL_DEVICE_LOCATION     DeviceLocation
    )
{
    return NAL_NOT_IMPLEMENTED;
}
/***************************************************************************
**
** Name:            _NalFillPciConfigSpec()
**
** Description:     Fills the PCI_DEVICE structure at slot SlotId.
**
** Arguments:       PciLocation = PCI address (Bus, Dev, Function)
**                  Device      = PCI_DEVICE pointer to fill.
**                  DwordCount  = Number of words from PCI Config to fill
**
** Returns:         NAL_SUCCESS if the specified number of DWORDS were
**                  read into the PCI_DEVICE structure.
**                  NAL_INVALID_PARAMETER if one of the specified
**                  parameters were out of range or NULL.
**
****************************************************************************/
NAL_STATUS
_NalFillPciConfigSpec(
    IN  NAL_DEVICE_LOCATION PciLocation,
    OUT PCI_DEVICE*         Device,
    IN  UINT32              DwordCount
    )
{
    /* This is implemented in the library portion of FreeBSD NAL. This function only exists
     * so the generic IOCTL interface doesnt have an unresolved external reference */
    return NAL_NOT_IMPLEMENTED;
}

/***************************************************************************
**
** Name:            _NalOSReadPciConfig32()
**
** Description:     Reads a specified 32bit value from the PCI config space.
**
** Arguments:       SlotId        = Slot number (Bus, Dev, Function)
**                  DwordNumber   = One of the 64 DWORDS to read from PCI Config Space.
**                  Value         = Location to store the word read.
**
** Returns:         NAL_STATUS Value & Fills Device pointer.
**
****************************************************************************/
NAL_STATUS
_NalOSReadPciConfig32(
    IN  NAL_DEVICE_LOCATION PciLocation,
    IN  UINT32              DwordNumber,
    OUT UINT32*             Value
    )
{
    return NAL_NOT_IMPLEMENTED;
}

/***************************************************************************
**
** Name:            _NalOSWritePciConfig32()
**
** Description:     Writes a specified 32bit value to the PCI config space.
**
** Arguments:       SlotId     = Slot number (Bus, Dev, Function)
**                  DwordNumber   = One of the 64 DWORDS to read from PCI Config Space.
**                  Data       = Value to write.
**
** Returns:         NAL_STATUS Value
**
****************************************************************************/
NAL_STATUS
_NalOSWritePciConfig32(
    IN  NAL_DEVICE_LOCATION PciLocation,
    IN  UINT32              DwordNumber,
    IN  UINT32              Data
    )
{
    return NAL_NOT_IMPLEMENTED;
}

/***************************************************************************
**
** Name:            _NalOSWritePciConfigVariable()
**
** Description:     Write a value 32bits or less depending on the mask value to
**                  the PCI Config Space. Might require more than 1 write.
**
** Arguments:       SlotId        = Slot number (Bus, Dev, Function)
**                  DwordNumber   = One of the 64 DWORDS to read from PCI Config Space.
**                  ByteMask      = Mask value to mask on the Data value.
**                  Data          = Value to write.
**
** Returns:         NAL_STATUS Value
**
****************************************************************************/
NAL_STATUS
_NalOSWritePciConfigVariable(
    IN  NAL_DEVICE_LOCATION PciLocation,
    IN  UINT32              DwordNumber,
    IN  UINT8               ByteMask,
    IN  UINT32              Data
    )
{
    return NAL_NOT_IMPLEMENTED;
}

/***************************************************************************
**
** Name:            _NalOSWritePciExConfig32()
**
** Description:     Writes a specified 32bit value to the PCI config space.
**
** Arguments:       Location     = (Bus, Dev, Function)
**                  DwordNumber  = One of the 64 DWORDS to read from PCI Config Space.
**                  Data         = Value to write.
**
** Returns:         NAL_STATUS Value
**
****************************************************************************/
NAL_STATUS
_NalOSWritePciExConfig32(
    IN  NAL_DEVICE_LOCATION PciLocation,
    IN  UINT32              DwordNumber,
    IN  UINT32              Data
    )
{
    return NAL_NOT_IMPLEMENTED;
}

/***************************************************************************
**
** Name:            _NalOSReadPciExConfig32()
**
** Description:     Reads a specified 32bit value to the PCI config space.
**
** Arguments:       Location     = (Bus, Dev, Function)
**                  DwordNumber  = One of the 64 DWORDS to read from PCI Config Space.
**                  Value         = Value to read in.
**
** Returns:         NAL_STATUS Value
**
****************************************************************************/
NAL_STATUS
_NalOSReadPciExConfig32(
    IN  NAL_DEVICE_LOCATION PciLocation,
    IN  UINT32              DwordNumber,
    IN  UINT32*             Value
    )
{
    return NAL_NOT_IMPLEMENTED;
}

/***************************************************************************
**
** Name:            _NalOsReadPciExByte()
**
** Description:     Reads an  8bit value from the PCI config space, starting at a byteoffset.
**
** Arguments:       DeviceLocation = The device location.
**                  ByteIndex      = Starting offset to read from PCI Config Space.
**                  NoOfBytes      = Number of Bytes to read.
**                  Value          = Space provided by the user to return the read config space
**
** Returns:         NAL_INVALID_PARAMETER = Invalid paramter.
**                  NAL_SUCCESS           = Operation was successful
**
****************************************************************************/
NAL_STATUS
_NalOsReadPciExByte(
    IN  NAL_DEVICE_LOCATION  DeviceLocation,
    IN  UINT32               ByteIndex,
    OUT UINT8*               Value
    )
{
    return NAL_NOT_IMPLEMENTED;
}

/***************************************************************************
**
** Name:            _NalOsWritePciExByte()
**
** Description:     Writes a byte value to the PCI config space, starting at a byteoffset.
**
** Arguments:       DeviceLocation = The device location.
**                  ByteIndex      = Starting offset to read from PCI Config Space.
**                  NoOfBytes      = Number of Bytes to read.
**                  Value          = Space provided by the user to return the read config space
**
** Returns:         NAL_INVALID_PARAMETER = Invalid paramter.
**                  NAL_SUCCESS           = Operation was successful
**
****************************************************************************/
NAL_STATUS
_NalOsWritePciExByte(
    IN  NAL_DEVICE_LOCATION  DeviceLocation,
    IN  UINT32               ByteOffset,
    IN  UINT8                Data
    )
{
    return NAL_NOT_IMPLEMENTED;
}
