/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2015 - 2023, Intel Corporation                                                                    *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsddevice_i.h                                                                                    *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsddevice_i.h                                                                 *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef NAL_INC_FREEBSD_FREEBSDDEVICE_I_H_
#define NAL_INC_FREEBSD_FREEBSDDEVICE_I_H_

#include <naltypes.h>
#include <freebsdtypes.h>

#define NAL_OS_SPEC_IS_BIT_SET(Value,Bit)           (((Value) & (1<<Bit)) == (1<<Bit))
#define NAL_OS_SPEC_IS_BIT_CLEAR(Value,Bit)         (((Value) & (1<<Bit)) == 0)

#define NAL_OS_SPEC_IS_PCI_MEMORY_BAR(Register)     NAL_OS_SPEC_IS_BIT_CLEAR(Register,0)
#define NAL_OS_SPEC_IS_PCI_IO_BAR(Register)         NAL_OS_SPEC_IS_BIT_SET(Register,0)

#define NAL_OS_SPEC_GET_PCI_MEMORY_BAR_BASE_ADDRESS(Register)   (Register & 0xFFFFFFF0) >> 4
#define NAL_OS_SPEC_GET_PCI_IO_BAR_BASE_ADDRESS(Register)       (Register & 0xFFFFFFFC) >> 2
#ifndef NAL_DRIVER
#include <device_t.h>
BOOLEAN
_NalMarkAdapterInUse(
    IN  NAL_ADAPTER_STRUCTURE*  NalAdapter,
    IN  NAL_DEVICE_LOCATION     NalDevice,
    IN  BOOLEAN                 Lock
    );
#else
BOOLEAN
_NalMarkAdapterInUse(
    IN  NAL_DEVICE_LOCATION   NalDevice,
    IN  BOOLEAN               Lock
    );
#endif

BOOLEAN
_NalIsAdapterInUse(
    IN NAL_DEVICE_LOCATION NalDevice
    );

#endif /* NAL_INC_FREEBSD_FREEBSDDEVICE_I_H_ */
