/*
 * Decompiled with CFR 0.152.
 */
package manager.common;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class APIVersion
implements Comparable<APIVersion> {
    private int major;
    private int minor;
    private int patch;
    public static final String SEPARATOR = ".";
    public static final APIVersion emptyVersion = new APIVersion(1, 0, 0);
    public static final APIVersion dynamicVersion = new APIVersion(0, 0, 0);

    public APIVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.validate();
    }

    public APIVersion(String version) {
        int maj = 0;
        int min = 0;
        int pat = 0;
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            maj = APIVersion.parseInt(st.nextToken(), version);
            if (st.hasMoreTokens()) {
                st.nextToken();
                min = APIVersion.parseInt(st.nextToken(), version);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    pat = APIVersion.parseInt(st.nextToken(), version);
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException("Invalid number \"" + version + "\": invalid format");
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid number \"" + version + "\": invalid format");
            iae.initCause(e);
            throw iae;
        }
        this.major = maj;
        this.minor = min;
        this.patch = pat;
        this.validate();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public static APIVersion parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        return APIVersion.valueOf(version);
    }

    public static APIVersion valueOf(String version) {
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        if (version.equalsIgnoreCase("TOSTRING(SC_SENSOR_CORE_API_VER_MAJOR).TOSTRING(SC_SENSOR_CORE_API_VER_MINOR).TOSTRING(SC_SENSOR_CORE_API_VER_PATCH)")) {
            return emptyVersion;
        }
        return new APIVersion(version);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.patch);
        return result.toString();
    }

    public int hashCode() {
        return this.major * 1000 + this.minor * 100 + this.patch;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof APIVersion)) {
            return false;
        }
        APIVersion other = (APIVersion)object;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    @Override
    public int compareTo(APIVersion other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.patch - other.patch;
        return result;
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException exc = new IllegalArgumentException("Invalid number \"" + version + "\": non-numeric \"" + value + "\"");
            exc.initCause(e);
            throw exc;
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": negative integer \"" + this.major + "\"");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": negative integer \"" + this.minor + "\"");
        }
        if (this.patch < 0) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": negative integer \"" + this.patch + "\"");
        }
    }

    public boolean compatibleTo(APIVersion apiP) {
        if (this.equals(dynamicVersion) || apiP.equals(dynamicVersion)) {
            return true;
        }
        return this.major == apiP.getMajor();
    }
}

