/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import entity.SensorEntity;
import manager.utils.ManagerEnums;
import pdtEditor.InformationStore;
import pdtEditor.Luid;
import pdtEditor.Sensor;

public class DependenciesUtils {
    private static InformationStore infoStore = null;
    public static final int[] SAME_AS_ALGO_INSTANCE = new int[]{255, -1};

    public static void initInfoStore() {
        infoStore = null;
        try {
            infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDependencySensorType(SensorEntity dependency) {
        String sensorType = dependency.getSensorTypeName();
        if (sensorType == null) {
            boolean physical = dependency.getFlags() == ManagerEnums.Flags.SC_LUID_FLAG_PHYSICAL.getValue();
            String string = sensorType = infoStore != null ? infoStore.getSensorTypeName(dependency.getSensorTypeId(), physical) : String.valueOf(dependency.getSensorTypeId());
        }
        if (sensorType == null) {
            sensorType = String.valueOf(dependency.getSensorTypeId());
        }
        return sensorType;
    }

    public static String getDependencyVendor(SensorEntity dependency) {
        String vendor = dependency.getVendorName();
        if (vendor == null) {
            String string = vendor = infoStore != null ? infoStore.getVendorName(dependency.getVendorId()) : String.valueOf(dependency.getVendorId());
        }
        if (vendor.equals("-1")) {
            return "---";
        }
        return vendor;
    }

    public static String getDependencyModel(SensorEntity dependency) {
        String model = dependency.getModelName();
        if (model == null) {
            if (infoStore != null) {
                boolean physical = dependency.getFlags() == ManagerEnums.Flags.SC_LUID_FLAG_PHYSICAL.getValue();
                model = infoStore.getModelName(physical, dependency.getSensorTypeId(), dependency.getVendorId(), dependency.getModelId(), dependency.getFlags());
            } else {
                model = String.valueOf(dependency.getModelId());
            }
        }
        if (model.equals("-1")) {
            return "---";
        }
        return model;
    }

    public static int getDependencyInstance(SensorEntity dependency, Sensor sensor) {
        return dependency.getInstanceId() == SAME_AS_ALGO_INSTANCE[0] || dependency.getInstanceId() == SAME_AS_ALGO_INSTANCE[1] ? sensor.getLuid().getInstanceId() : dependency.getInstanceId();
    }

    public static String getDependencyFlags(SensorEntity dependency) {
        if (dependency.getFlags() == ManagerEnums.Flags.SC_LUID_FLAG_NONE.getValue()) {
            return "---";
        }
        return Luid.getFlagsStr(dependency.getFlags());
    }

    public static String getDependencyText(SensorEntity dependency, Sensor sensor) {
        DependenciesUtils.initInfoStore();
        int expectedInstanceId = DependenciesUtils.getDependencyInstance(dependency, sensor);
        String expectedFlags = dependency.getFlags() != ManagerEnums.Flags.SC_LUID_FLAG_NONE.getValue() ? ", Flags: {" + DependenciesUtils.getDependencyFlags(dependency) + "}." : "";
        String description = "";
        if (dependency.getDependencyType() != null) {
            description = description + " [" + dependency.getDependencyType().name() + "]:";
        }
        description = description + " Sensor type: " + dependency.getSensorTypeId() + " (" + DependenciesUtils.getDependencySensorType(dependency) + ")" + (dependency.getVendorId() >= 0 ? ", Vendor: " + DependenciesUtils.getDependencyVendor(dependency) : "") + (dependency.getModelId() >= 0 ? ", Model: " + DependenciesUtils.getDependencyModel(dependency) : "") + ", Instance ID: " + expectedInstanceId + expectedFlags;
        return description;
    }
}

