/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.utils;

import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.CUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;

public class ManagerFileUtils {
    public static final String SENSORS_DEFINITIONS_FILE_NAME = "ISS_Sensor_Definitions.xml";
    public static final String VENDOR_LIST_FILE_NAME = "vendorlist.json";
    public static final String SENSORS_TYPE_LIST_FILE_NAME = "sensortypelist.json";
    public static final String TOOLS_FOLDER = "tools";
    public static final String RESOURCES_FOLDER = "resources";
    public static final String KITS_FOLDER = "kits";
    public static final String INSTALLED_MODULES_FOLDER = "installed_modules";
    public static final String GENERAL_SETTINGS_FILE_NAME = "GeneralSettings.xml";
    private static final int DEFAULT_BUFSIZE = 8096;

    public static String getUserFDKDir() {
        try {
            return CUtils.getEnvVar("FDK_USER_DATA_HOME");
        }
        catch (Exception e) {
            ExceptionHandler.HandleExceptionInSeparateThread(e);
            return null;
        }
    }

    public static String getFDKDir() {
        return CUtils.getEnvVar("New_Intel_ISS_FDK");
    }

    public static String getResourcesDir() {
        return String.valueOf(ManagerFileUtils.getFDKDir()) + File.separator + RESOURCES_FOLDER;
    }

    public static String getToolsDir() {
        return String.valueOf(ManagerFileUtils.getFDKDir()) + File.separator + TOOLS_FOLDER;
    }

    public static String getUserEclipsePluginFolder() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserFDKDir()) + "\\EclipsePlugin\\";
    }

    public static String getLogDir() {
        return String.valueOf(ManagerFileUtils.getFDKDir()) + File.separator + "log";
    }

    public static String getGeneralSettingsFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + "EclipsePlugin" + File.separator + GENERAL_SETTINGS_FILE_NAME;
    }

    public static String getPlatformConfigureFile() {
        return String.valueOf(ManagerFileUtils.getResourcesDir()) + File.separator + "configuration" + File.separator + "platform.json";
    }

    public static String getSensorVendorListFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.getResourcesDir()) + File.separator + VENDOR_LIST_FILE_NAME;
    }

    public static String getIntelSensorDefinitionsFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.getResourcesDir()) + File.separator + SENSORS_DEFINITIONS_FILE_NAME;
    }

    public static String getIntelSensorTypeFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.getResourcesDir()) + File.separator + SENSORS_TYPE_LIST_FILE_NAME;
    }

    public static String getUserSensorVendorListFilePath() throws Exception {
        return String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + VENDOR_LIST_FILE_NAME;
    }

    public static String getUserSensorTypeDefinitionsFilePath() {
        return String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + SENSORS_TYPE_LIST_FILE_NAME;
    }

    public static String COMMON_INPUT_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.getResourcesDir()) + File.separator + "Common";
    }

    public static String TEMPLATES_FOLDER() throws Exception {
        return String.valueOf(ManagerFileUtils.COMMON_INPUT_FOLDER()) + File.separator + "templates";
    }

    public static String getInstalledRootDir() {
        Path folder = Paths.get(String.valueOf(ManagerFileUtils.getResourcesDir()) + File.separator + INSTALLED_MODULES_FOLDER, new String[0]);
        if (!folder.toFile().exists()) {
            try {
                Files.createDirectory(folder, new FileAttribute[0]);
            }
            catch (IOException e1) {
                ISSLogger.e(e1);
            }
        }
        return folder.toString();
    }

    public static String getInstalledModulesDir() {
        Path folder = Paths.get(String.valueOf(ManagerFileUtils.getResourcesDir()) + File.separator + INSTALLED_MODULES_FOLDER, new String[0]);
        if (!folder.toFile().exists()) {
            try {
                Files.createDirectory(folder, new FileAttribute[0]);
            }
            catch (IOException e1) {
                ISSLogger.e(e1);
            }
        }
        return folder.toString();
    }

    public static String getKitsBaseDir() {
        return String.valueOf(ManagerFileUtils.getToolsDir()) + File.separator + KITS_FOLDER;
    }

    public static String getJavaPath(boolean realPath) throws Exception {
        String javaPath = realPath ? CUtils.getEnvVar("FDK_JAVA_HOME") : "<FDK_JAVA_HOME>";
        if (javaPath != null) {
            if (!javaPath.toLowerCase().endsWith("bin")) {
                javaPath = String.valueOf(javaPath) + "/bin";
            }
            javaPath = String.valueOf(javaPath) + "/";
        } else {
            javaPath = "";
        }
        return String.valueOf(javaPath) + "java.exe";
    }

    public static String VERSIONS_FILE() {
        return "version.txt";
    }

    public static String getHostFwLoadFolder() throws Exception {
        return String.valueOf(ManagerFileUtils.COMMON_INPUT_FOLDER()) + "\\Host_Load_Fw";
    }

    public static String getHostFwLoadLicense() throws Exception {
        return String.valueOf(ManagerFileUtils.getHostFwLoadFolder()) + "\\HLF_license_agremeent.html";
    }

    public static void writeToFile(String fullPath, String content) throws Exception {
        PrintWriter writer = new PrintWriter(fullPath);
        writer.print(content);
        writer.close();
        File f = new File(fullPath);
        f.setReadOnly();
    }

    public static void createFolder(String path) throws Exception {
        File newSensorFolder = new File(path);
        if (!newSensorFolder.exists() && !newSensorFolder.mkdirs()) {
            throw new Exception("Could not create the folder.");
        }
    }

    public static boolean deleteFileOrDirectoryWithContent(File f) {
        boolean res = true;
        if (!f.isDirectory()) {
            if (f.exists()) {
                f.setWritable(true);
                System.gc();
                res = f.delete();
            }
            return res;
        }
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                res = ManagerFileUtils.deleteFileOrDirectoryWithContent(file);
            } else {
                f.setWritable(true);
                System.gc();
                res = file.delete();
            }
            ++n2;
        }
        if (res) {
            f.setWritable(true);
            System.gc();
            res = f.delete();
        }
        return res;
    }

    public static boolean fastDeleteFileOrDirectory(File f) {
        boolean res = true;
        if (!f.isDirectory()) {
            if (f.exists() && !(res = f.delete())) {
                f.setWritable(true);
                System.gc();
                res = f.delete();
            }
            return res;
        }
        File[] files = f.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    res = ManagerFileUtils.fastDeleteFileOrDirectory(file);
                } else {
                    res = file.delete();
                    if (!res) {
                        file.setWritable(true);
                        System.gc();
                        res = file.delete();
                    }
                }
                ++n2;
            }
        }
        if (res && !(res = f.delete())) {
            f.setWritable(true);
            System.gc();
            res = f.delete();
        }
        return res;
    }

    public static boolean renamePdtFiles(File newLocation, String oldName, String newName, boolean renameTheContaingFolder) {
        boolean res = true;
        File[] fileArray = newLocation.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (res) {
                if (file.getName().equals(String.valueOf(oldName) + ".bin")) {
                    res = file.renameTo(new File(newLocation, String.valueOf(newName) + ".bin"));
                } else if (file.getName().equals(String.valueOf(oldName) + "_NVAR.bin")) {
                    res = file.renameTo(new File(newLocation, String.valueOf(newName) + "_NVAR.bin"));
                }
            }
            ++n2;
        }
        if (res && renameTheContaingFolder && newLocation.getName().equals(oldName)) {
            res = newLocation.renameTo(new File(newLocation.getParent(), newName));
        }
        return res;
    }

    public static String readFile(File f) throws Exception {
        try {
            Scanner scanner = new Scanner(f);
            String text = scanner.useDelimiter("\\A").next();
            scanner.close();
            return text;
        }
        catch (FileNotFoundException e) {
            String err = ExceptionHandler.parseException(e);
            throw new Exception("Could not read the file. " + err);
        }
    }

    public static String readFile(String path) throws Exception {
        File inputFile = new File(path);
        FileInputStream sourceStream = new FileInputStream(inputFile);
        String source = CUtils.readStreamAsText(sourceStream);
        return source;
    }

    public static ArrayList<String> getFilesListRecursive(File root) {
        ArrayList<String> filesList = new ArrayList<String>();
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                filesList.add(file.getAbsolutePath());
            } else {
                filesList.addAll(ManagerFileUtils.getFilesListRecursive(file));
            }
            ++n2;
        }
        return filesList;
    }

    public static void copyFile(File suorceFile, File destFile) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                int len;
                in = new FileInputStream(suorceFile);
                out = new FileOutputStream(destFile);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                String err = ExceptionHandler.parseException(e);
                throw new Exception("Could not copy the file. " + err);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                ((InputStream)in).close();
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        if (in != null) {
            ((InputStream)in).close();
        }
    }

    public static void copyDirectory(File source, File dest) throws Exception {
        if (source.isDirectory()) {
            String[] children;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            String[] stringArray = children = source.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                ManagerFileUtils.copyDirectory(new File(source, element), new File(dest, element));
                ++n2;
            }
        } else {
            ManagerFileUtils.copyFile(source, dest);
        }
    }

    public static Path appendPath(Path path, String fileName) {
        return Paths.get(String.valueOf(path.toString()) + File.separator + fileName, new String[0]);
    }

    public static Path appendPath(Path formerPath, Path laterPath) {
        return ManagerFileUtils.appendPath(formerPath, laterPath.toString());
    }

    public static String getToolchainFile() {
        return "cmake/ish_tool_chain_xcc.cmake";
    }

    public static String appendPathAsStr(String formerPath, String laterPath) {
        return ManagerFileUtils.appendPath(Paths.get(formerPath, new String[0]), laterPath).toAbsolutePath().toString();
    }

    public static String appendPathAsStr(Path formerPath, String laterPath) {
        return ManagerFileUtils.appendPath(formerPath, laterPath).toAbsolutePath().toString();
    }

    public static Path appendPath(String formerPath, String laterPath) {
        Path resultingPath = ManagerFileUtils.appendPath(Paths.get(formerPath, new String[0]), laterPath);
        if (!resultingPath.toFile().exists() && resultingPath.toFile().isDirectory()) {
            try {
                Files.createDirectory(resultingPath, new FileAttribute[0]);
            }
            catch (IOException e1) {
                ISSLogger.e(e1);
            }
        }
        return resultingPath;
    }

    public static Path getCacheFolder() {
        Path cacheFolder = ManagerFileUtils.appendPath(ManagerFileUtils.getTmpFolder(), "cache");
        if (!cacheFolder.toFile().exists()) {
            try {
                Files.createDirectory(cacheFolder, new FileAttribute[0]);
            }
            catch (IOException e1) {
                ISSLogger.e(e1);
            }
        }
        return cacheFolder;
    }

    public static Path getTmpFolder() {
        Path tmpFolder = ManagerFileUtils.appendPath(ManagerFileUtils.getUserFDKDir(), "tmp");
        if (!tmpFolder.toFile().exists()) {
            try {
                Files.createDirectory(tmpFolder, new FileAttribute[0]);
            }
            catch (IOException e1) {
                ISSLogger.e(e1);
            }
        }
        return tmpFolder;
    }

    public static Path getTmpInstallFolder() {
        Path installFolder = ManagerFileUtils.appendPath(ManagerFileUtils.getTmpFolder(), "install");
        if (!installFolder.toFile().exists()) {
            try {
                Files.createDirectory(installFolder, new FileAttribute[0]);
            }
            catch (IOException e1) {
                ISSLogger.e(e1);
            }
        }
        return installFolder;
    }

    public static void write(InputStream is, File df) throws Exception {
        FileOutputStream os = null;
        try {
            int count;
            os = new FileOutputStream(df);
            byte[] buf = new byte[8096];
            while ((count = is.read(buf)) != -1) {
                os.write(buf, 0, count);
            }
            is.close();
            os.close();
        }
        catch (Throwable throwable) {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getExportTempFolder() {
        return ManagerFileUtils.getTmpFolder() + File.separator + "export";
    }

    public static String getTmpKitInstallFolder() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String time = df.format(new Date());
        return ManagerFileUtils.getTmpFolder() + File.separator + "kitsNew_" + time;
    }

    public static String getKitBackUpFolder() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String time = df.format(new Date());
        return ManagerFileUtils.getTmpFolder() + File.separator + "kitsBackup_" + time;
    }

    public static String appendFileExtension(String name, String extension) {
        return String.valueOf(name) + "." + extension;
    }

    public static String getTempFolder() {
        try {
            String filePath = String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + "temp";
            File file = new File(filePath);
            if (!file.exists()) {
                if (file.mkdirs()) {
                    return filePath;
                }
                throw new Exception("Can not create folder : " + filePath);
            }
            return filePath;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getInstallTempFolder() {
        return String.valueOf(ManagerFileUtils.getTempFolder()) + File.separator + "install";
    }

    public static String getEncryptedFolder() throws Exception {
        File encryptedFolder = new File(String.valueOf(ManagerFileUtils.getUserFDKDir()) + File.separator + "Encyption");
        if (!encryptedFolder.exists()) {
            ManagerFileUtils.createFolderNotExist(encryptedFolder);
        }
        return encryptedFolder.getCanonicalPath();
    }

    public static File getPackageKeyFolder() throws Exception {
        File packageKeyFolder = new File(String.valueOf(ManagerFileUtils.getEncryptedFolder()) + File.separator + "packageKey");
        if (!packageKeyFolder.exists()) {
            ManagerFileUtils.createFolderNotExist(packageKeyFolder);
        }
        return packageKeyFolder;
    }

    private static String createFolderNotExist(File folder) {
        try {
            if (!folder.exists()) {
                ManagerFileUtils.createFolder(folder.getCanonicalPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folder.getAbsolutePath();
    }
}

