<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class ApplicationDataAccess extends SQLite3DataAccess
{
    protected function createObj()
    {
        return new Application();
    }

    public function  __construct() {
        global $db;
        $this->tblName = "TBL_APP";
        $this->db = $db;
    }

    public function findByType($type) {
        $dataArray = array();
        $res = $this->query($dataArray);
        $ret = array();

        if($res) {
            foreach($res as $value) {
                if($value->getAppType() & $type) {
                    $ret[] = $value;
                }
            }
        }

        return $ret;
    }

    public function findByTypeAndVolume($type, $volume) {
        $dataArray = array("mykeys" => array("VOLUME_NAME" => $this->escapeText($volume)));
        $res = $this->query($dataArray);
        $ret = array();

        if($res) {
            foreach($res as $value) {
                if($value->getAppType() & $type) {
                    $ret[] = $value;
                }
            }
        }

        return $ret;
    }

    public function findByPinStatus($pinStatus)
    {
        $dataArray = array("mykeys" => array("PIN_STATUS"=>$pinStatus));
        $res = $this->query($dataArray);
        return $res;
    }

    public function findAll()
    {
        //"mysortkeys" => array("FREQUENCY" => "DESC", "APP_NAME" => "ASC")
        $dataArray = array("mysortkeys" => array("APP_NAME" => "ASC"));
        $res = $this->query($dataArray);
        
        if($res) {
            $newRes = array();
            $otherRes = array();
            foreach($res as $value) {
                if($value->getAppType() & AppType::TYPE_CUSTOM) {
                    $newRes[] = $value;
                } else if(!($value->getAppType() & AppType::TYPE_COMMON_FILE)){
                    $otherRes[] = $value;
                }
            }
            $res = array_merge($newRes, $otherRes);
        }

        return $res;
    }

    public function findAllByVolume($volume)
    {
        //"mysortkeys" => array("FREQUENCY" => "DESC", "APP_NAME" => "ASC")
        $dataArray = array("mykeys" => array("VOLUME_NAME" => $this->escapeText($volume)), "mysortkeys" => array("APP_NAME" => "ASC"));
        $res = $this->query($dataArray);

        if($res) {
            $newRes = array();
            $otherRes = array();
            foreach($res as $value) {
                if($value->getAppType() & AppType::TYPE_CUSTOM) {
                    $newRes[] = $value;
                } else if(!($value->getAppType() & AppType::TYPE_COMMON_FILE)){
                    $otherRes[] = $value;
                }
            }
            $res = array_merge($newRes, $otherRes);
        }

        return $res;
    }

    public function addApp($app)
    {
        $myvalues = array();

        $myvalues['APP_NAME'] = $this->escapeText($app->getAppName());
        $myvalues['FREQUENCY'] = ($app->getFrequencyIn30Days());
        $myvalues['APP_STATUS'] = $app->getAppStatus();
        $myvalues['PIN_STATUS'] = $app->getPinStatus();
        $myvalues['TOTAL_SIZE'] = $app->getTotalSize();
        $myvalues['APP_TYPE'] = $app->getAppType();
        $myvalues['VOLUME_NAME'] = $this->escapeText($app->getVolume());

        $dataArray = array("myvalues"=>$myvalues);

        return $this->insert($dataArray);
    }

    public function findById($keyId)
    {
        $dataArray = array("mykeys" => array("KEY_ID"=>$keyId));
        return $this->getOne($dataArray);
    }

    public function deleteById($keyId)
    {
        $dataArray = array("mykeys" => array("KEY_ID"=>$keyId));
        return $this->delete($dataArray);
    }

    public function findByAppName($appName)
    {
        $dataArray = array("mykeys" => array("APP_NAME"=>$this->escapeText($appName)));
        return $this->getOne($dataArray);
    }

    public function findByAppNameAndVolume($appName, $volume)
    {
        $dataArray = array("mykeys" => array("APP_NAME"=>$this->escapeText($appName), "VOLUME_NAME" => $this->escapeText($volume)));
        return $this->getOne($dataArray);
    }

    public function updateAppById($app)
    {
        $mykeys = array("KEY_ID" => $app->getKeyId());
        $myvalues = array();
        
        $myvalues['APP_NAME'] = $this->escapeText($app->getAppName());
        $myvalues['FREQUENCY'] = ($app->getFrequencyIn30Days());
        $myvalues['APP_STATUS'] = $app->getAppStatus();
        $myvalues['PIN_STATUS'] = $app->getPinStatus();
        $myvalues['TOTAL_SIZE'] = $app->getTotalSize();
        $myvalues['APP_TYPE'] = $app->getAppType();
        $myvalues['VOLUME_NAME'] = $this->escapeText($app->getVolume());

        $dataArray = array("mykeys" => $mykeys, "myvalues"=>$myvalues);

        return $this->update($dataArray);
    }

    public function updateAppType($app)
    {
        $mykeys = array("KEY_ID" => $app->getKeyId());
        $myvalues = array();
        
        $myvalues['APP_TYPE'] = $app->getAppType();
        $myvalues['APP_STATUS'] = AppStatus::STATUS_NOT_SYNC;

        $dataArray = array("mykeys" => $mykeys, "myvalues"=>$myvalues);

        return $this->update($dataArray);
    }

    public function updateAppStatus($app)
    {
        $mykeys = array("KEY_ID" => $app->getKeyId());
        $myvalues = array();

        $myvalues['APP_STATUS'] = $app->getAppStatus();

        $dataArray = array("mykeys" => $mykeys, "myvalues"=>$myvalues);

        return $this->update($dataArray);
    }
}

?>
