<?php

define("IMG_DIRECTORY", "./images/");
define("IMG_FILE_TYPE", ".gif");
define("IMG_TYPE_LINE", "line");
define("IMG_TYPE_EXPAND", "minus");
define("IMG_TYPE_UNEXPAND", "plus");
define("IMG_TYPE_CANNOTEXPAND", "branch");
define("IMG_TYPE_LAST", "bottom");

define("EXPAND_TYPE_NONE", 0);
define("EXPAND_TYPE_EXPAND", 1);
define("EXPAND_TYPE_UNEXPAND", 2);
define("EXPAND_TYPE_CANNOTEXPAND", 3);

$treeContent = "";

class MRUTreeNodeType
{
    const SYSTEM_LEAF = 0;
    const ADAPTER_TITLE_LEAF = 1;
    const ADAPTER_LEAF = 2;
    const ARRAY_TITLE_LEAF = 3;
    const ARRAY_LEAF = 4;
    const VDONARRAY_TITLE_LEAF = 5;
    const VDONARRAY_LEAF = 6;
    const HDONARRAY_TITLE_LEAF = 7;
    const HDONARRAY_LEAF = 8;
    const ENC_TITLE_LEAF = 9;
    const ENC_LEAF = 10;
    const HD_TITLE_LEAF = 11;
    const HD_LEAF = 12;
    const VD_TITLE_LEAF = 13;
    const VD_LEAF = 14;
    const BBU_TITLE_LEAF = 15;
    const BBU_LEAF = 16;    
    const HDONVD_TITLE_LEAF = 17;
    const HDONVD_LEAF = 18;
    
    const EXP_LEAF = 19;
    const PM_LEAF = 20;
    
    const AES_LEAF = 21;
    const AES_TITLE_LEAF = 22;
    
    const SSD_VOLUME_LEAF = 23;
    
    const STORAGE_SERVICE_LEAF = 24;
    const STORAGE_SETTING_LEAF = 25;
    const STORAGE_DEVICE_LEAF = 26;
    const MANAGE_SERVICE_LEAF = 27;
    const MANAGE_LOG_LEAF = 28;
    const RAID_SERVICE_LEAF = 29;
    const FLASH_SERVICE_LEAF = 30;
    const SSD_SERVICE_LEAF = 31;
    const RAID_SETTING_LEAF = 32;
    const FLASH_SETTING_LEAF = 33;
    const RAID_DEVICE_LEAF = 34;
    const FLASH_DEVICE_LEAF = 35;
    const SSD_DEVICE_LEAF = 36;
    const EMAIL_SETTING_LEAF = 37;
    const SCHEDULE_SETTING_LEAF = 38;
    const CREATE_HYPPER_LEAF = 39;
    const ACCOUNT_MANAGER_LEAF = 40;

    const SSD_ADAPTER_LEAF = 50;
    const HYPER_SSD_LEAF = 51;
    const HYPER_TITLE_LEAF = 52;
    
}


class MRUTreeNode
{
//    private $m_deep=1;
    private $m_icon;
    private $m_note;
    private $m_tip;
    private $m_ID;
    private $m_HBAID;
    private $m_Type;
    private $m_onclick;
    private $m_childrenlink = null;
    private $m_selflink = null;
    private $m_expand=IMG_TYPE_EXPAND;

    function __construct($icon,$note,$tip,$onclick,$ID,$type,$HBAID=0)
    {
        $this->m_icon=$icon;
        $this->m_note=$note;
        $this->m_tip=$tip;
        $this->m_onclick=$onclick;
        $this->m_ID=$ID;
        $this->m_HBAID=$HBAID;
        $this->m_Type=$type;
    }

    function __destruct() 
    { 
        $this->m_childrenlink = null;
        $this->m_selflink = null;
    }

    /*public function setDeep($NodeDeep)
	{
		if ($NodeDeep > $this->m_deep)
		{
		    $this->m_deep = $NodeDeep;
		}
	}*/

	public function addChild($child)
	{
	    if ($this->m_childrenlink == null)
	    {
	        $this->m_childrenlink = new MRUTreeLink($this);
	    }
	    $this->m_childrenlink->addChild($child);
	}

	public function getID()
	{
	    return $this->m_ID;
	}

	public function getNodeType()
	{
	    return $this->m_Type;
	}

    public function setSelfLink($link)
	{
	    $this->m_selflink=$link;
	    $this->m_selflink->setExpandStatus($this->m_expand);
	}
	
	public function getSelfLink()
	{
	    return $this->m_selflink;
	}
	
	public function draw()
	{
		global $treeContent;
	    //draw self
	    if ($this->m_icon != null && $this->m_icon != "")
	    {
	        $treeContent .= "<IMG id=\"" . "TreeNode_" . $this->m_note . "\" SRC=\"" . IMG_DIRECTORY . $this->m_icon . "\" class=\"treeImg\"";
	        if ($this->m_onclick != null && $this->m_onclick != "")
	        {
	            $treeContent .= " onclick=\"sendDetail('".htmlspecialchars($this->m_onclick, ENT_QUOTES)."');highLight(treelink_".$this->m_Type.$this->m_ID.$this->m_HBAID.");\"";
	        }
	        $treeContent .= "/>";
	    }
	    $treeContent .= "<A HREF=\"#\" class=\"treeHyperlink\" id=\"treelink_".$this->m_Type.$this->m_ID.$this->m_HBAID."\"";
	    if ($this->m_onclick != null && $this->m_onclick != "")
	    {
	        $treeContent .= " onclick=\"sendDetail('".htmlspecialchars($this->m_onclick, ENT_QUOTES)."');highLight(this);\"";
	    }
	    $treeContent .= ">" . $this->m_note . "</A>";
	    $treeContent .= "</nobr><br/>\n\r";
	}
	
	public function html()
	{
	    //fill parent link line

	    //draw self
	    $this->draw();

	    //draw children
	    if ($this->m_expand!=IMG_TYPE_UNEXPAND && $this->m_childrenlink != null)
	    {
	        $this->m_childrenlink->html();
	    }
	}

    public function getExpandTypeIndex()
    {
        switch ($this->m_expand)
        {
            case IMG_TYPE_EXPAND:
                return EXPAND_TYPE_EXPAND;
                break;
            case IMG_TYPE_UNEXPAND:
                return EXPAND_TYPE_UNEXPAND;
                break;
            default:
                return EXPAND_TYPE_CANNOTEXPAND;
                break;
         }
    }

    public function getExpandTypeImg()
    {
        return ($this->m_expand);
    }

	public function expand()
    {
        $this->m_expand=IMG_TYPE_EXPAND;
        if ($this->m_selflink != null)
	    {
	        $this->m_selflink->setExpandStatus($this->m_expand);
	    }
    }

    public function unExpand()
    {
        $this->m_expand=IMG_TYPE_UNEXPAND;
        if ($this->m_selflink != null)
	    {
	        $this->m_selflink->setExpandStatus($this->m_expand);
	    }
    }

    public function cannotExpand()
    {
        $this->m_expand=IMG_TYPE_CANNOTEXPAND;
        if ($this->m_selflink != null)
	    {
	        $this->m_selflink->setExpandStatus($this->m_expand);
	    }
    }

    public function printURL()
    {
       if ($this->m_expand!=IMG_TYPE_UNEXPAND && $this->m_childrenlink != null)
	    {
	        $this->m_childrenlink->printURL();
	    }
    }
}

class MRUTreeLink
{
    private $m_parent;
    private $m_children;
    private $m_lastOne=false;
    //protected $m_deep=1;
    private $m_expand=IMG_TYPE_EXPAND;

    function __construct($parent)
    {
		$this->m_parent=$parent;
		$children = array();
    }

    function __destruct() 
    { 
        $this->m_children = null;
        $this->m_parent = null;
    }

    public function addChild($childNode)
    {
        $this->m_children[count($this->m_children)]=$childNode;
        $childNode->setSelfLink($this);
    }
    
    public function setExpandStatus($expand)
    {
        $this->m_expand=$expand;
    }

    public function draw()
    {
    	global $treeContent;
        $this->m_parent->getSelfLink()->draw();
        $str = IMG_TYPE_LINE;
        if ($this->m_lastOne)
        {
             $str .= IMG_TYPE_LAST;
        }
        $treeContent .= "<IMG SRC=\"" .IMG_DIRECTORY . $str . IMG_FILE_TYPE ."\" class=\"treeImg\"/>";
    }

    public function html()
    {
    	global $treeContent;
        $i = 0;
        foreach ($this->m_children as $child)
        {
            $this->m_parent->getSelfLink()->draw();
            $str = $child->getExpandTypeImg();
            $i++;
            if ($i==count($this->m_children))
            {
                $str .= IMG_TYPE_LAST;
                $this->m_lastOne = true;
            }
            $treeContent .= "<IMG SRC=\"" .IMG_DIRECTORY . $str . IMG_FILE_TYPE ."\"";
            if ($child->getExpandTypeIndex()!=EXPAND_TYPE_CANNOTEXPAND)
            {
                $treeContent .= " onclick=\"sendChange('|";
                $treeContent .= $child->getID() ."_". $child->getNodeType()."_";
                $treeContent .= "','_";
                switch ($child->getExpandTypeIndex())
                {
                    case EXPAND_TYPE_EXPAND:
                        $treeContent .= EXPAND_TYPE_UNEXPAND;
                        break;
                    case EXPAND_TYPE_UNEXPAND:
                        $treeContent .= EXPAND_TYPE_EXPAND;
                        break;
                    default:
                        $treeContent .= EXPAND_TYPE_CANNOTEXPAND;
                        break;
                }
                $treeContent .= "|');\"";
            }
            $treeContent .= " class=\"treeImg\"/>";
            $child->html();
        }
    }

    public function printURL()
    {
       global $treeContent;
       foreach ($this->m_children as $child)
       {
            $treeContent .= $child->getID()."_" .$child->getNodeType();
            $treeContent .= "_".$child->getExpandTypeIndex()."|";
            $child->printURL();
       }
    }
}

class MRUTree
{
    private $root;
 
    function __construct($childNode)
    {
	    $this->root=$childNode;
	    $this->root->setSelfLink($this);
    }

    public function draw()
    {
       global $treeContent;
       $treeContent .= "<nobr>";
    }
    
    public function html()
    {
       $this->draw();
       $this->root->html();
    }
    
    public function printURL()
    {
       global $treeContent;
       $treeContent .= "<script>";
       $treeContent .= "oldURL=\"";
       $treeContent .= $this->root->getID()."_" .$this->root->getNodeType()."_".EXPAND_TYPE_NONE."|";
       $this->root->printURL();
       $treeContent .= "\";";
       $treeContent .= "</script>";
    }

    public function setExpandStatus($expand)
    {
    }
}

function DrawTree($root, $smarty)
{
	global $treeContent;
    $treeContent .= "<div>\n\r";
    $tree = new MRUTree($root);
    $tree->html();
    $tree->printURL();
    $treeContent .= "</div>";
    $smarty->assign("treeContent", $treeContent);
}

?>