<?php
class CtnEnclList extends Container 
{
	private $toGetEnclInfo;
	private $toGetEnclExpanderInfo;
	private $toGetEnclPMInfo;
	
	private $adapterId = 0;
	
	public function toGetEnclInfo()
	{
		$this->toGetEnclInfo = true;
	}
	
	public function toGetEnclExpanderInfo()
	{
		$this->toGetEnclExpanderInfo = true;
	}
	
	public function toGetEnclPMInfo()
	{
		$this->toGetEnclPMInfo = true;
	}
	
	protected function setBase()
	{
		$this->base = new EnclList();
		$this->base->setAdapterID($this->getAdapterID());
		if ($this->toGetEnclInfo) {
			$this->base->toGetEnclInfo();
		}
		if ($this->toGetEnclExpanderInfo) {
			$this->base->toGetEnclExpanderInfo();
		}
		if ($this->toGetEnclPMInfo) {
			$this->base->toGetEnclPMInfo();
		}
	}
	
	public function displayXML()
	{
		$this->display("XML_EnclList.tpl");
	}

	protected function setDataToPage()
	{
		$baseclasses = $this->base->getBaseClasses();
		$EnclList = array();
		foreach ($baseclasses as $Encl) {
			$Info = new EnclInfo();
			$Info->setEnclInfo($Encl);
			$Info->setEnclDtl($Encl);
			$EnclList[$Info->ID] = $Info;
		}
		
		//if no Enclosure, but has pm or expander, simulate a enclosure
		
		ksort($EnclList);
		$this->setInfo($EnclList);
		$this->smarty->assign("EnclList",$EnclList);
	}
}
?>