var PackageVDMigrate = new Object();

PackageVDMigrate.HBAID = 255;

PackageVDMigrate.initialize = function()
{
    PackageVDMigrate.aHDs=new Array();
    PackageVDMigrate.oSubmit=null;
    PackageVDMigrate.oRaidMode=null;
    PackageVDMigrate.iRaidMode=-1;
    PackageVDMigrate.ioldRaidMode=-1;
    PackageVDMigrate.oldaHDs=new Array();
    PackageVDMigrate.oParity=null;
    PackageVDMigrate.oParityDiv=null;
    PackageVDMigrate.iParityDisk=2;
    PackageVDMigrate.MSG_HD_LIMIT="Target virtual disk must include at least 1 PD in source virtual disk";
    PackageVDMigrate.MSG_LDLEVEL_LIMIT="Can not migrate to new RAID Mode";
    PackageVDMigrate.MSG_LDSIZE_LIMIT="Target size must more than original size."
    PackageVDMigrate.MSG_PARITY_INVALID="Parity disk number is invalid";
    PackageVDMigrate.MSG_PARITYNUM_OUTOFRANGE="Total parity disks of RAID6 should be a number between 2 and ";
    PackageVDMigrate.MSG_PARITYNUMERROE_R60="Total parity disks of RAID60 should be an EVEN number between 4 and ";
    PackageVDMigrate.MSG_PARITYNUMERROE_R6="Total parity disks of RAID6 should be a number between 2 and ";
    PackageVDMigrate.MSG_PARITY_BENUMBER = "Invalid parity disks number";
    PackageVDMigrate.sError=null;
    PackageVDMigrate.oError=null;
    PackageVDMigrate.xml=null;
    PackageVDMigrate.oDiv=null;
    PackageVDMigrate.ioldSize=0;
    PackageVDMigrate.iSize=0;
    PackageVDMigrate.ScheduledBgaType=255;
}

PackageVDMigrate.XMLResize=function(){
    var treeObj = getObjectById("TreeHtmlScrollBody");
    var subScrollPartObj1 = getObjectById("migrateScrollPart1");
    var subScrollPartObj2 = getObjectById("migrateScrollPart2");
    var memberPart = getObjectById("memberPartTR");
    if (treeObj) {
        var treeHeight = treeObj.style.height;
        treeHeight = treeHeight.slice(0, -2);
        var memberPartHeight=85;
        if (memberPart){
            memberPart.style.height=memberPartHeight;
            if (subScrollPartObj2) {
                subScrollPartObj2.style.height = memberPartHeight - 15;//treeHeight - 184;
            }
            if (subScrollPartObj1) {
                var minSubScrollPartHeight = 75;
                var height=treeHeight-memberPartHeight - 110;
                if (height>=minSubScrollPartHeight)
                    subScrollPartObj1.style.height = height;
                else
                    subScrollPartObj1.style.height = minSubScrollPartHeight;
            }
        }
    }
}

function PackageVDMigratePage()
{
    PackageVDMigrate.initialize();
    MarvellRaidDetail.currentPageObj = "PackageVDMigrate";
    PackageVDMigrate.oSubmit=document.getElementById("subButt");
    PackageVDMigrate.oRaidMode=document.getElementById("selRaidMode");
    PackageVDMigrate.oParity = document.getElementById("inputParity");
    if (PackageVDMigrate.oParity) PackageVDMigrate.oParity.options.length=0;
    PackageVDMigrate.oParityDiv = document.getElementById("inputParityDiv");
    PackageVDMigrate.oDiv=document.getElementById("pdAvailCap");

    AddSplitterChangeResize(PackageVDMigrate.XMLResize);

    MarvellRaidTree.setCurrentNode("treelink_"+MarvellRaidTree.VD_LEAF+PackageVDMigrate.ID+PackageVDMigrate.HBAID);
    clickTreeNode(MarvellRaidTree.currentNode);
}

PackageVDMigrate.checkCanMigrate=function(){
    PackageVDMigrate.getTargetSize();
    if (PackageVDMigrate.check()){
        PackageVDMigrate.enableSubmit();
    } else {
        PackageVDMigrate.disableSubmit();
    }
}

PackageVDMigrate.unSelectHD=function(oImg)
{
    if (oImg!=null)
    {
        oImg.className="drvSelOFF";
    }
}

PackageVDMigrate.selectHD=function(oImg)
{
    if (oImg!=null)
    {
        oImg.className="drvSelON";
    }
}

PackageVDMigrate.disableSubmit=function()
{
    if(PackageVDMigrate.oSubmit != null)
    {
        PackageVDMigrate.oSubmit.onclick=doNothing;
        PackageVDMigrate.oSubmit.className = "disButtChar";
    }
    
}

PackageVDMigrate.enableSubmit=function()
{
    if(PackageVDMigrate.oSubmit != null)
    {
        PackageVDMigrate.oSubmit.className = "buttonChar";
        PackageVDMigrate.oSubmit.onclick=PackageVDMigrate.doMigrate;
    }
}

PackageVDMigrate.getParityDiskUrl=function()
{
    var sPD="";
    if (PackageVDMigrate.iRaidMode==6||PackageVDMigrate.iRaidMode==96)
    {
        sPD="&NumOfParityDisk="+PackageVDMigrate.iParityDisk;
    }
    return sPD;
}

PackageVDMigrate.getHDsUrl=function()
{
    var sHDs="";
    if (PackageVDMigrate.aHDs.length>0) {
        sHDs="&HDs=";
    }
    for (var i=0;i<PackageVDMigrate.aHDs.length;i++)
    {
        if (i==0)
        {
            sHDs+=PackageVDMigrate.aHDs[i];
        }
        else
        {
            sHDs+=("%20"+PackageVDMigrate.aHDs[i]);
        }
    }
    return sHDs;
}

PackageVDMigrate.selMode=function()
{
    if (PackageVDMigrate.oRaidMode!=null) 
    {
        PackageVDMigrate.iRaidMode=parseInt(PackageVDMigrate.oRaidMode.options[PackageVDMigrate.oRaidMode.selectedIndex].value);
        PackageVDMigrate.oParityDiv = document.getElementById("inputParityDiv");
        PackageVDMigrate.InputParityShow();
    }
    if (PackageVDMigrate.oParity!=null && PackageVDMigrate.oParity.options != null && PackageVDMigrate.oParity.options.length > 0) 
    {
        PackageVDMigrate.iParityDisk = parseInt(PackageVDMigrate.oParity.options[PackageVDMigrate.oParity.selectedIndex].value);
    }

    PackageVDMigrate.getTargetSize();
    if (PackageVDMigrate.check()){
        PackageVDMigrate.enableSubmit();
    } else {
        PackageVDMigrate.disableSubmit();
    }
}

PackageVDMigrate.saveParity=function()
{
    PackageVDMigrate.iParityDisk = parseInt(PackageVDMigrate.oParity.options[PackageVDMigrate.oParity.selectedIndex].value);
    PackageVDMigrate.getTargetSize();
    if (PackageVDMigrate.check()){
        PackageVDMigrate.enableSubmit();
    } else {
        PackageVDMigrate.disableSubmit();
    }
}

PackageVDMigrate.doMigrate=function()
{
    PackageVDMigrate.disableSubmit();
    if (PackageVDMigrate.oRaidMode!=null) {
        PackageVDMigrate.iRaidMode=parseInt(PackageVDMigrate.oRaidMode.options[PackageVDMigrate.oRaidMode.selectedIndex].value);
    }
    if (PackageVDMigrate.oParityDiv.style.display != 'none') 
    {
        if (PackageVDMigrate.oParity!=null && PackageVDMigrate.oParity.options!=null && PackageVDMigrate.oParity.options.length > 0)
        {
            PackageVDMigrate.iParityDisk=parseInt(PackageVDMigrate.oParity.options[PackageVDMigrate.oParity.selectedIndex].value);
        }
    }
    if (PackageVDMigrate.check())
    {
        var strURL="command.php?cmdName=migratePackageVD&LDID="+PackageVDMigrate.ID+"&HBAID="+PackageVDMigrate.HBAID+"&RaidMode="+PackageVDMigrate.iRaidMode;
        
        strURL+=PackageVDMigrate.getHDsUrl();
        strURL+=PackageVDMigrate.getParityDiskUrl();
        var migrateCMD=new Command(strURL);
        migrateCMD.run();
        var result = migrateCMD.getResult();
        if (migrateCMD.isSuccessful())
        {
            MarvellRaidDetail.partUrl = result;
            MarvellRaidDetail.run();
        }
        migrateCMD = null;
        strURL=null;
        //PackageVDMigrate.enableSubmit();
        MarvellRaidTree.run();
    } else {
        PackageVDMigrate.notifyWarn();
    }
    return false;
}

PackageVDMigrate.getTargetSize=function()
{
    if (PackageVDMigrate.oRaidMode!=null) {
        PackageVDMigrate.iRaidMode=parseInt(PackageVDMigrate.oRaidMode.options[PackageVDMigrate.oRaidMode.selectedIndex].value);
    }
    if (PackageVDMigrate.oParity!=null && PackageVDMigrate.oParity.options!=null && PackageVDMigrate.oParity.options.length > 0) 
    {
        PackageVDMigrate.iParityDisk=parseInt(PackageVDMigrate.oParity.options[PackageVDMigrate.oParity.selectedIndex].value);
    }
    var strURL="command.php?cmdName=getMigratedPackageVDSize&LDID="+PackageVDMigrate.ID+"&HBAID="+PackageVDMigrate.HBAID+"&RaidMode="+PackageVDMigrate.iRaidMode;
    
    strURL+=PackageVDMigrate.getParityDiskUrl();
    strURL+=PackageVDMigrate.getHDsUrl();
    ContentLoader.loadXMLImmediate(PackageVDMigrate,strURL);
    strURL=null;
}

PackageVDMigrate.setXMLresult = function()
{
    if (PackageVDMigrate.xml != null)
    {
        PackageVDMigrate.oDiv.innerHTML = PackageVDMigrate.xml.responseXML.getElementsByTagName('MigratedSizeGB')[0].firstChild.nodeValue;
        PackageVDMigrate.iSize=parseFloat(PackageVDMigrate.xml.responseXML.getElementsByTagName('MigratedSize')[0].firstChild.nodeValue);
    }
    ContentLoader.returnBack(PackageVDMigrate.xml);
    PackageVDMigrate.xml=null;
}

PackageVDMigrate.clickHD=function(idClickHD,idSelImg)
{
    var selHDImg=document.getElementById(idSelImg);
    if(selHDImg == null) return;
    if (selHDImg.className=="drvSelON")
    {
        for (var i=0;i<PackageVDMigrate.aHDs.length;i++)
        {
            if (PackageVDMigrate.aHDs[i]==idClickHD)
            {
                PackageVDMigrate.aHDs.splice(i,1);
                break;
            }
        }
        PackageVDMigrate.unSelectHD(selHDImg);
    }
    else
    {
        PackageVDMigrate.aHDs[PackageVDMigrate.aHDs.length]=idClickHD;
        PackageVDMigrate.selectHD(selHDImg);
    }
    //PackageVDMigrate.changeParityTitle();
    PackageVDMigrate.getTargetSize();
    if (PackageVDMigrate.check()) {
        PackageVDMigrate.enableSubmit();
    } else {
        PackageVDMigrate.disableSubmit();
    }
    selHDImg=null;
    PackageVDMigrate.selMode();
    return false;
}

PackageVDMigrate.check=function()
{
    var bVaule= (CheckLDMode(PackageVDMigrate.iRaidMode,PackageVDMigrate.aHDs.length) &&(PackageVDMigrate.ioldRaidMode!=PackageVDMigrate.iRaidMode||PackageVDMigrate.oldaHDs.toString()!=PackageVDMigrate.aHDs.toString()));
	
    if (isNaN(PackageVDMigrate.iParityDisk)) {
        PackageVDMigrate.sError = PackageVDMigrate.MSG_PARITY_BENUMBER;
        PackageVDMigrate.oError = PackageVDMigrate.oRaidMode;
        return false;
    }
    if (!CheckParity(PackageVDMigrate.iRaidMode, PackageVDMigrate.iParityDisk, PackageVDMigrate.aHDs.length))
    {
        var alerlMsg;
        if (PackageVDMigrate.iRaidMode == 6)
        {
            PackageVDMigrate.sError= PackageVDMigrate.MSG_PARITYNUM_OUTOFRANGE + Math.min(Math.floor(PackageVDMigrate.aHDs.length/2), RAID6_MAXMUM_PARITY);
        }
        else if (PackageVDMigrate.iRaidMode == 96)
        {
            PackageVDMigrate.sError= PackageVDMigrate.MSG_PARITYNUMERROE_R60 + Math.min(Math.floor(PackageVDMigrate.aHDs.length/2), RAID60_MAXMUM_PARITY);
        }
        PackageVDMigrate.oError=PackageVDMigrate.oParity;
        return false;
    }
	
    if (RedundencyLevel(PackageVDMigrate.ioldRaidMode) > RedundencyLevel(PackageVDMigrate.iRaidMode))
    {
        PackageVDMigrate.sError=PackageVDMigrate.MSG_LDLEVEL_LIMIT;
        PackageVDMigrate.oError=PackageVDMigrate.oRaidMode;
        return false;
    }
    if (bVaule==true)
    {
        bVaule=false;
        for (var i=0;i<PackageVDMigrate.aHDs.length;i++)
        {
            for (var j=0;j<PackageVDMigrate.oldaHDs.length;j++)
            {
                if (PackageVDMigrate.oldaHDs[j]== PackageVDMigrate.aHDs[i]) {
                    bVaule=true;break;
                }
            }
            if (bVaule==true){
                break;
            }
        }
        if (bVaule==false)
        {
            PackageVDMigrate.sError=PackageVDMigrate.MSG_HD_LIMIT;
        }
    }
    if (bVaule==true)
    {
        if(PackageVDMigrate.ioldSize>PackageVDMigrate.iSize)
        {
            PackageVDMigrate.sError=PackageVDMigrate.MSG_LDSIZE_LIMIT;
            return false;
        }
    }
    return bVaule;
}

PackageVDMigrate.notifyWarn=function()
{
    if (PackageVDMigrate.sError!=null){
        alert(PackageVDMigrate.sError);PackageVDMigrate.sError=null
        };
    if (PackageVDMigrate.oError!=null){
        selHasError(PackageVDMigrate.oError)
        };
}

PackageVDMigrate.hasLoadedPage=function()
{
    for (var i=0;i<PackageVDMigrate.aHDs.length;i++) {
        PackageVDMigrate.oldaHDs[PackageVDMigrate.oldaHDs.length]= PackageVDMigrate.aHDs[i];
    }
}

function unPackageVDMigratePage()
{
    if(PackageVDMigrate.oSubmit != null)
        PackageVDMigrate.oSubmit=null;
    //PackageVDMigrate.oSave=null;
    PackageVDMigrate.oRaidMode=null;
    PackageVDMigrate.aHDs=null;
    PackageVDMigrate.oldaHDs=null;
    PackageVDMigrate.oParity=null;
    PackageVDMigrate.MSG_HD_LIMIT=null;
    PackageVDMigrate.MSG_LDLEVEL_LIMIT=null;
    PackageVDMigrate.sError=null;
    PackageVDMigrate.oError=null;
    PackageVDMigrate.xml=null;
    PackageVDMigrate.oDiv=null;
    PackageVDMigrate=null;
}

PackageVDMigrate.InputParityShow=function()
{
    var iMode=parseInt(PackageVDMigrate.oRaidMode.options[PackageVDMigrate.oRaidMode.selectedIndex].value);
    var i;
    PackageVDMigrate.oParity.options.length = 0;
    PackageVDMigrate.oParityDiv.style.display = "";
	
    if (iMode == 6)
    {
        var maxParity = Math.min(Math.floor(PackageVDMigrate.aHDs.length/2), RAID6_MAXMUM_PARITY);
        for (i = RAID6_MINIMUM_PARITY; i <= maxParity; i++)
        {
            PackageVDMigrate.oParity.options.add(new Option(i, i));
        }
    }
    else if (iMode == 96)
    {
        var maxParity = Math.min(Math.floor(PackageVDMigrate.aHDs.length/2), RAID60_MAXMUM_PARITY);
        for (i = RAID60_MINIMUM_PARITY; i <= maxParity; i = i+2)
        {
            PackageVDMigrate.oParity.options.add(new Option(i, i));
        }
    }
    else
    {
        PackageVDMigrate.oParityDiv.style.display = "none";
    }
}

addUnLoad(unPackageVDMigratePage);

