<?php
class ApplicationInfo
{
    public $keyId;
    public $appName;
    public $frequencyIn30Days;
    public $appStatus;  //fixed, auto
    public $pinStatus;  //pinning, pined, topin....
    public $totalSize;
    public $totalSizeKB;
    public $totalSizeGB;
    public $isFixed;
    public $isAuto;
    public $isCustomized = 0;
    public $isPinned;
    
    public $volume;
    public $statusStr;
    private $appType;
    private $isRunning = 0;

    public function setRunningStatus($isRunning)
    {
    	$this->isRunning = $isRunning;
    }
	
	public function setApplicationListInfo($app)
	{
		$this->keyId = $app->getKeyId();
		$this->appName = $app->getAppName();
		$this->frequencyIn30Days = $app->getFrequencyIn30Days();
		
		$this->appStatus = $app->getAppStatus();
		$this->pinStatus = $app->getPinStatus();

                $accStatus = new AcceleratorStatus();

                if($accStatus->isDefragging()) { //if defragging display app status
				if($this->appStatus == 0)
				$this->statusStr = trim(PinStatus::getPinStatus($this->pinStatus));
				else
                    $this->statusStr = trim(AppStatus::getAppStatus($this->appStatus));
                } else {
                    if ($accStatus->hasOperationRunning() || $this->appStatus == 0) {
                    //has operating  display pin status
						$this->statusStr = trim(PinStatus::getPinStatus($this->pinStatus));
                    } else{
						$this->statusStr = trim(AppStatus::getAppStatus($this->appStatus));
                    }
                }
                
                $this->isPinned = ($this->pinStatus & PinStatus::STATUS_PINNED);

		$this->totalSize = $app->getTotalSize();
		$this->totalSizeKB = number_format($app->getTotalSize());
		$this->totalSizeGB = FormatSize($app->getTotalSize());
		
		$this->appType = $app->getAppType();
		
		$this->isFixed = (AppType::TYPE_FIXED & $this->appType);
		$this->isAuto = (AppType::TYPE_AUTO & $this->appType);
                $this->isCustomized = (AppType::TYPE_CUSTOM & $this->appType);
		
	}
	
}
?>