# <copyright>
# INTEL CONFIDENTIAL
#
# Copyright 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of
# them is governed by the express license under which they were provided to you ("License").
# Unless the License provides otherwise, you may not use, modify, copy, publish, distribute,
# disclose or transmit this software or the related documents without Intel's prior written
# permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#
# <copyright>

$BusTypeMap = [ordered]@{
    0 = $Messages.Unknown
    1 = $Messages.ISA
    2 = $Messages.EISA
    3 = $Messages.PCMCIA
    4 = $Messages.CardBus
    5 = $Messages.PCI
    6 = $Messages.PCIX
    7 = $Messages.PCIExpress
    8 = $Messages.IOSF
}

# Map from *SpeedDuplex enum values to possible adapter speeds
$SupportedSpeedsMap = [ordered]@{
    "0"      = 0            #AutoNegotiation
    "1"      = 10000000     #10Mb Half Duplex
    "2"      = 10000000     #10Mb Full Duplex
    "3"      = 100000000    #100Mb Half Duplex
    "4"      = 100000000    #100Mb Full Duplex
    "5"      = 1000000000   #1Gb Full Duplex NDIS5
    "6"      = 1000000000   #1Gb Full Duplex NDIS6
    "7"      = 10000000000  #10Gb Full Duplex
    "8"      = 10000000000  #10Gb Half Duplex
    "9"      = 40000000000  #40Gb Half Duplex
    "2500"   = 2500000000   #2.5Gb
    "5000"   = 5000000000   #5Gb
    "25000"  = 25000000000  #25Gb
    "500000" = 50000000000  #50Gb
    "10"     = 100000000000 #100Gb
}


enum ADAPTER_STATUS
{
    Installed    = 0x1
    DriverLoaded = 0x2
    HwMissing    = 0x4
    Reserved     = 0x8
    HasDiag      = 0x10
    HasLink      = 0x20
    PoweredOff   = 0x1000
}


enum CVL_PHY_TYPE
{
    CVL100BaseTX = 0x0
    CVL100MSGMII = 0x1
    CVL1000BaseT = 0x2
    CVL1000BaseSX = 0x3
    CVL1000BaseLX = 0x4
    CVL1000BaseKX = 0x5
    CVL1GSGMII = 0x6
    CVL2Point5GBaseT = 0x7
    CVL2Point5gBaseX = 0x8
    CVL2Point5GBaseKX = 0x9
    CVL5GBaseT = 0xA
    CVL5GBaseKR = 0xB
    CVL10GBaseT = 0xC
    CVL10GSFIDA = 0xD
    CVL10GBaseSR = 0xE
    CVL10GBaseLR = 0xF
    CVL10GBaseKR = 0x10
    CVL10GSFIAOC_ACC = 0x11
    CVL10GSFIC2C = 0x12
    CVL25GBaseT = 0x13
    CVL25GBaseCR = 0x14
    CVL25GBaseCRS = 0x15
    CVL25GBaseCR1 = 0x16
    CVL25GBaseSR = 0x17
    CVL25GBaseLR = 0x18
    CVL25GBaseKR = 0x19
    CVL25GBaseKRS = 0x1A
    CVL25GBaseKR1 = 0x1B
    CVL25GAUIAOC_ACC = 0x1C
    CVL25GAUIC2C = 0x1D
    CVL40GBaseCR4 = 0x1E
    CVL40GBaseSR4 = 0x1F
    CVL40GBaseLR4 = 0x20
    CVL40GBaseKR4 = 0x21
    CVL40GXLAUIAOC_ACC = 0x22
    CVL40GXLAUI = 0x23
    CVL50GBaseCR2 = 0x24
    CVL50GBaseKR2 = 0x27
    CVL50GLAUI2AOC_ACC = 0x28
    CVL50GLAUI2 = 0x29
    CVL50GAUI2AOC_ACC = 0x2A
    CVL50GAUI2 = 0x2B
    CVL50GBaseCRPAM4 = 0x2C
    CVL50GBaseSR = 0x2D
    CVL50GBaseFR = 0x2E
    CVL50GBaseLR = 0x2F
    CVL50GBaseKRPAM4 = 0x30
    CVL50GAUI1AOC_ACC = 0x31
    CVL50GAUI1 = 0x32
    CVL100GBaseCR4 = 0x33
    CVL100GBaseSR4 = 0x34
    CVL100GBaseLR4 = 0x35
    CVL100GBaseKR4 = 0x36
    CVL100GCAUI4AOC_ACC = 0x37
    CVL100GCAUI4 = 0x38
    CVL100GAUI4AOC_ACC = 0x39
    CVL100GAUI4 = 0x3A
    CVL100GBaseKR4PAM4 = 0x3C
    CVL100GBaseCP2 = 0x3D
    CVL100GBaseSR2 = 0x3E
    CVL100GBaseDR = 0x3F
    CVL100GBaseKR2PAM4 = 0x40
    CVL100GAUI2AOC_ACC = 0x43
    CVL100GAUI2 = 0x44
    CVL200GBaseCR4PAM4 = 0x45
    CVL200GBaseSR4 = 0x46
    CVL200GBaseFR4 = 0x47
    CVL200GBaseLR4 = 0x48
    CVL200GBaseDR4 = 0x49
    CVL200GBaseKR4PAM4 = 0x4A
    CVL200GAUI4AOC_ACC = 0x4B
    CVL200GAUI4 = 0x4C
    CVL200GAUI8AOC_ACC = 0x4D
    CVL200GAUI8 = 0x4E
    CVL400GBaseFR8 = 0x4F
    CVL400GBaseLR8 = 0x50
    CVL400GBaseDR4 = 0x51
    CVL400GAUI8AOC_ACC = 0x52
    CVL400GAUI8 = 0x53
    CVLAutoNegotiation = 0x7E
    CVLOuterphydisabled = 0x7F
}

enum CPK_PHY_INFO
{
    CPK_PHYINFO_MEDIA_BACKPLANE = 1
    CPK_PHYINFO_MEDIA_QSFP      = 2
    CPK_PHYINFO_MEDIA_SFP       = 3
    CPK_PHYINFO_MEDIA_BASE_T    = 4
    CPK_PHYINFO_MEDIA_SGMII     = 5
    CPK_PHYINFO_MEDIA_FIBER     = 6
}

enum NCS_ADAPTER_MEDIA_TYPE
{
    NCS_MEDIA_UNKNOWN = 0
    NCS_MEDIA_COPPER = 1
    NCS_MEDIA_FIBER = 2
    NCS_MEDIA_PHONELINE = 3
    NCS_MEDIA_CX4COPPER = 4
    NCS_MEDIA_SFPDIRECTATTACH = 5
    NCS_MEDIA_SR_FIBER = 6
    NCS_MEDIA_LR_FIBER = 7
    NCS_MEDIA_KX4BACKPLANE = 8
    NCS_MEDIA_SERDES = 9
    NCS_MEDIA_BACKPLANE = 10
    NCS_MEDIA_XAUI = 11
    NCS_MEDIA_SFPACTIVEDIRECTATTACH = 12
    NCS_MEDIA_SWITCHHOST = 13
    NCS_MEDIA_QSFPDIRECTATTACH = 14
    NCS_MEDIA_SFP28DIRECTATTACH = 15
    NCS_MEDIA_CVL_AOC_ACC = 16
    NCS_MEDIA_CVL_Backplane_KR = 17
    NCS_MEDIA_CVL_Backplane_KR1 = 18
    NCS_MEDIA_CVL_Backplane_KR2 = 19
    NCS_MEDIA_CVL_Backplane_KR2_PAM4 = 20
    NCS_MEDIA_CVL_Backplane_KR4 = 21
    NCS_MEDIA_CVL_Backplane_KR4_PAM4 = 22
    NCS_MEDIA_CVL_Backplane_KR_PAM4 = 23
    NCS_MEDIA_CVL_Backplane_KR_S = 24
    NCS_MEDIA_CVL_Backplane_KX = 25
    NCS_MEDIA_CVL_Chip_to_Chip = 26
    NCS_MEDIA_CVL_Copper_T = 27
    NCS_MEDIA_CVL_Copper_TX = 28
    NCS_MEDIA_CVL_Direct_Attach = 29
    NCS_MEDIA_CVL_Direct_Attach_CP2 = 30
    NCS_MEDIA_CVL_Direct_Attach_CR = 31
    NCS_MEDIA_CVL_Direct_Attach_CR1 = 32
    NCS_MEDIA_CVL_Direct_Attach_CR2 = 33
    NCS_MEDIA_CVL_Direct_Attach_CR4 = 34
    NCS_MEDIA_CVL_Direct_Attach_CR_PAM4 = 35
    NCS_MEDIA_CVL_Direct_Attach_CR_S = 36
    NCS_MEDIA_CVL_Fiber_DR = 37
    NCS_MEDIA_CVL_Fiber_FR = 38
    NCS_MEDIA_CVL_Fiber_LR = 39
    NCS_MEDIA_CVL_Fiber_LR4 = 40
    NCS_MEDIA_CVL_Fiber_LX = 41
    NCS_MEDIA_CVL_Fiber_SR = 42
    NCS_MEDIA_CVL_Fiber_SR2 = 43
    NCS_MEDIA_CVL_Fiber_SR4 = 44
    NCS_MEDIA_CVL_Fiber_SX = 45
    NCS_MEDIA_CVL_Fiber_X = 46
    NCS_MEDIA_CVL_SGMII = 47
    NCS_MEDIA_CVL_Unknown = 48
    NCS_MEDIA_INTERFACE_CVL_BACKPLANE = 1000
    NCS_MEDIA_INTERFACE_CVL_QSFP = 1001
    NCS_MEDIA_INTERFACE_CVL_SFP = 1002
    NCS_MEDIA_INTERFACE_CVL_BASE_T = 1003
    NCS_MEDIA_INTERFACE_CVL_SGMII = 1004
    NCS_MEDIA_INTERFACE_CVL_FIBER = 1005
}

enum ADAPTER_CAPABILITY
{
    NCS_ADAPTER_CAP_UNKNOWN = 0
    NCS_ADAPTER_CAP_OTHER = 1
    NCS_ADAPTER_CAP_WAKE_ON_LAN = 3
    NCS_ADAPTER_CAP_FAILOVER = 4
    NCS_ADAPTER_CAP_LOADBALANCING = 5
    NCS_ADAPTER_CAP_IPSEC_OFFLOAD = 6
    NCS_ADAPTER_CAP_FEC = 9
    NCS_ADAPTER_CAP_802_3AD = 10
    NCS_ADAPTER_CAP_CHECKSUM_OFFLOAD = 11
    NCS_ADAPTER_CAP_SWITCHED_FAULT_TOLERANT = 12
    NCS_ADAPTER_CAP_TCO_CAPABILITY = 29
    NCS_ADAPTER_CAP_WAKEUP_CAPABILITIES = 30
    NCS_ADAPTER_CAP_IP_CHECKSUM_OFFLOAD = 31
    NCS_ADAPTER_CAP_SPEED_10_MBPS = 32
    NCS_ADAPTER_CAP_SPEED_100_MBPS = 33
    NCS_ADAPTER_CAP_SPEED_1000_MBPS = 34
    NCS_ADAPTER_CAP_SPEED_10000_MBPS = 35
    NCS_ADAPTER_CAP_TEAM_SUPPORT = 36
    NCS_ADAPTER_CAP_VLAN_SUPPORT = 37
    NCS_ADAPTER_CAP_VLAN_TYPE_IEEE = 38
    NCS_ADAPTER_CAP_VLAN_TYPE_ISL = 39
    NCS_ADAPTER_CAP_IDENTIFY_ADAPTER_SUPPORT = 41
    NCS_ADAPTER_CAP_CABLE_TEST_SUPPORT = 42
    NCS_ADAPTER_CAP_DIAGNOSTIC_SUPPORT = 43
    NCS_ADAPTER_CAP_FLASH_SUPPORT = 44
    NCS_ADAPTER_CAP_USAGE_SERVER = 46
    NCS_ADAPTER_CAP_VENDOR_INTEL = 47
    NCS_ADAPTER_CAP_PWMGMT_SUPPORT = 50
    NCS_ADAPTER_CAP_QUAD_PORT = 54
    NCS_ADAPTER_CAP_JUMBO_FRAMES = 56
    NCS_ADAPTER_CAP_IGP_SIGNAL_QUALITY_TEST = 58
    NCS_ADAPTER_CAP_CABLE_OFFLINE_TEST = 59
    NCS_ADAPTER_IS_A_LOM = 60
    NCS_ADAPTER_CAP_NDIS_IOAT = 61
    NCS_ADAPTER_CAP_CB_PLATFORM_IOAT = 62
    NCS_ADAPTER_CAP_ISCSI = 63
    NCS_ADAPTER_CAP_DCB = 65
    NCS_ADAPTER_CAP_FCOE = 66
    NCS_ADAPTER_CAP_KX_MODULE   = 67
    NCS_ADAPTER_CAP_VM_LOADBALANCING = 68
    NCS_ADAPTER_CAP_PERFORMANCE_PROFILE = 69
    NCS_ADAPTER_CAP_OS2BMC = 70
    NCS_ADAPTER_CAP_AMT = 71
    NCS_ADAPTER_CAP_SPEED_2500_MBPS = 72
    NCS_ADAPTER_CAP_BASIC_DMIX_SUPPORT = 73
    NCS_ADAPTER_CAP_EXTENDED_DMIX_SUPPORT = 74
    NCS_ADAPTER_CAP_SPEED_40000_MBPS = 75
    NCS_ADAPTER_CAP_NPAR_ENABLED = 76
    NCS_ADAPTER_CAP_ANS_SUPPORTED = 77
    NCS_ADAPTER_CAP_QSFP_LINK_MODE_ENABLED = 78
    NCS_ADAPTER_CAP_SPEED_25000_MBPS = 79
    NCS_ADAPTER_CAP_NPAR_CAPABLE = 80
    NCS_ADAPTER_CAP_SPEED_5000_MBPS = 81
    NCS_ADAPTER_CAP_SPEED_50000_MBPS = 82
    NCS_ADAPTER_CAP_SPEED_100000_MBPS = 83
    NCS_ADAPTER_CAP_CYPRESS = 84
}

# SIG # Begin signature block
# MIIo6AYJKoZIhvcNAQcCoIIo2TCCKNUCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCDNn4rZGlg9rGbR
# qtHhmKH2oKUmuwXfpOJpMp1wSrFgxKCCEgUwggWeMIIEhqADAgECAhEAzS1l4rws
# CIvYBjRVawV4ujANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJHQjEbMBkGA1UE
# CBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQK
# Ew9TZWN0aWdvIExpbWl0ZWQxJDAiBgNVBAMTG1NlY3RpZ28gUlNBIENvZGUgU2ln
# bmluZyBDQTAeFw0yMTA0MDIwMDAwMDBaFw0yMzA0MDIyMzU5NTlaMIGEMQswCQYD
# VQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEUMBIGA1UEBwwLU2FudGEgQ2xh
# cmExGjAYBgNVBAoMEUludGVsIENvcnBvcmF0aW9uMRIwEAYDVQQLDAlTb2xhcktN
# Q1MxGjAYBgNVBAMMEUludGVsIENvcnBvcmF0aW9uMIIBojANBgkqhkiG9w0BAQEF
# AAOCAY8AMIIBigKCAYEA7CCN9iKpDHOrRceKhlXFP/tf6Lllw2H2fR9KVI4/fQIx
# MU1hXwnlHmAzMCY7IgcCFY4p3F5/MJGKaqYngwOo28Zo6Q1N6ukysA7PSavmF2RY
# WD6VFeya/2H0PoNeRFjHaRzSeynFFeJAFew9r7UReUwM/507sxZYPQuWWIdAEK7H
# Dqp2VlHmgZOXVGHhNO6GFOKpC/C01g6X3x6OquddRNMt5UrZzZzDo5MpJz9SBB2V
# jiqwZ80dvNR2W2xi90cIHh4BkXvB54UNkp4VTVu16T0k3cweo+C39U7GrCAr5Axz
# DETjBvhNtP1sf9SoRV7xY6g5wssfI7yYT9J0gsifn/Vy8MWH355TPoA+PVhbAu0m
# 9FMz4EWu55nnUurNML2jaUxsos21/7ELat12kWC0tq9fhkODjKO8X9PuiBHflZLk
# d3F4QcSMvuGocWGqE77VV3vn8jlvigm2TOV0CfGTQajGMX0jeTRZ19fzBNkt2X9d
# SSGolI/Kj1gSvCggpkUBAgMBAAGjggGQMIIBjDAfBgNVHSMEGDAWgBQO4TqoUzox
# 1Yq+wbutZxoDha00DjAdBgNVHQ4EFgQUshkNuM2SdwJnW4vFy8c4FtUTrbQwDgYD
# VR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
# EQYJYIZIAYb4QgEBBAQDAgQQMEoGA1UdIARDMEEwNQYMKwYBBAGyMQECAQMCMCUw
# IwYIKwYBBQUHAgEWF2h0dHBzOi8vc2VjdGlnby5jb20vQ1BTMAgGBmeBDAEEATBD
# BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29S
# U0FDb2RlU2lnbmluZ0NBLmNybDBzBggrBgEFBQcBAQRnMGUwPgYIKwYBBQUHMAKG
# Mmh0dHA6Ly9jcnQuc2VjdGlnby5jb20vU2VjdGlnb1JTQUNvZGVTaWduaW5nQ0Eu
# Y3J0MCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTANBgkqhkiG
# 9w0BAQsFAAOCAQEAVadLNRW4f/pKMqrbn0BdOoQ8/1EJ87gvVfosei2bLwTEvpmv
# mn2n561H6AFedtIJ6L4FmXII4M4r20i+5LREbI6PpKDmOAf4xW7POxfCRvkTQAZO
# 3zoVxjMQBXo7cZVF1xHCdviXzD1usuIiCF8DLm6z4O/kyeFFNcn816yPQct91Pnk
# SBBVvL+Kwu8xvR+ZIQy632WUA4HnNpRdFnVSzUifEg2GrtsKZR8k+rm2o8K8yjJq
# 3SznwgJQCMVMh3CtRtUwE/c7o/6rvm53fTYJDd3aoPHVgH6S2WqS3+3mQG7A6hTD
# nrP/mYnS4PF7XzxxjZhUlhy4G/MarJPvT9IrNDCCBfUwggPdoAMCAQICEB2iSDBv
# myYY0ILgln0z02owDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYD
# VQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtKZXJzZXkgQ2l0eTEeMBwGA1UEChMV
# VGhlIFVTRVJUUlVTVCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNBIENl
# cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE4MTEwMjAwMDAwMFoXDTMwMTIzMTIz
# NTk1OVowfDELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3Rl
# cjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSQw
# IgYDVQQDExtTZWN0aWdvIFJTQSBDb2RlIFNpZ25pbmcgQ0EwggEiMA0GCSqGSIb3
# DQEBAQUAA4IBDwAwggEKAoIBAQCGIo0yhXoYn0nwli9jCB4t3HyfFM/jJrYlZilA
# hlRGdDFixRDtsocnppnLlTDAVvWkdcapDlBipVGREGrgS2Ku/fD4GKyn/+4uMyD6
# DBmJqGx7rQDDYaHcaWVtH24nlteXUYam9CflfGqLlR5bYNV+1xaSnAAvaPeX7Wpy
# vjg7Y96Pv25MQV0SIAhZ6DnNj9LWzwa0VwW2TqE+V2sfmLzEYtYbC43HZhtKn52B
# xHJAteJf7wtF/6POF6YtVbC3sLxUap28jVZTxvC6eVBJLPcDuf4vZTXyIuosB69G
# 2flGHNyMfHEo8/6nxhTdVZFuihEN3wYklX0Pp6F8OtqGNWHTAgMBAAGjggFkMIIB
# YDAfBgNVHSMEGDAWgBRTeb9aqitKz1SA4dibwJ3ysgNmyzAdBgNVHQ4EFgQUDuE6
# qFM6MdWKvsG7rWcaA4WtNA4wDgYDVR0PAQH/BAQDAgGGMBIGA1UdEwEB/wQIMAYB
# Af8CAQAwHQYDVR0lBBYwFAYIKwYBBQUHAwMGCCsGAQUFBwMIMBEGA1UdIAQKMAgw
# BgYEVR0gADBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8vY3JsLnVzZXJ0cnVzdC5j
# b20vVVNFUlRydXN0UlNBQ2VydGlmaWNhdGlvbkF1dGhvcml0eS5jcmwwdgYIKwYB
# BQUHAQEEajBoMD8GCCsGAQUFBzAChjNodHRwOi8vY3J0LnVzZXJ0cnVzdC5jb20v
# VVNFUlRydXN0UlNBQWRkVHJ1c3RDQS5jcnQwJQYIKwYBBQUHMAGGGWh0dHA6Ly9v
# Y3NwLnVzZXJ0cnVzdC5jb20wDQYJKoZIhvcNAQEMBQADggIBAE1jUO1HNEphpNve
# aiqMm/EAAB4dYns61zLC9rPgY7P7YQCImhttEAcET7646ol4IusPRuzzRl5ARokS
# 9At3WpwqQTr81vTr5/cVlTPDoYMot94v5JT3hTODLUpASL+awk9KsY8k9LOBN9O3
# ZLCmI2pZaFJCX/8E6+F0ZXkI9amT3mtxQJmWunjxucjiwwgWsatjWsgVgG10Xkp1
# fqW4w2y1z99KeYdcx0BNYzX2MNPPtQoOCwR/oEuuu6Ol0IQAkz5TXTSlADVpbL6f
# ICUQDRn7UJBhvjmPeo5N9p8OHv4HURJmgyYZSJXOSsnBf/M6BZv5b9+If8AjntIe
# Q3pFMcGcTanwWbJZGehqjSkEAnd8S0vNcL46slVaeD68u28DECV3FTSK+TbMQ5Lk
# uk/xYpMoJVcp+1EZx6ElQGqEV8aynbG8HArafGd+fS7pKEwYfsR7MUFxmksp7As9
# V1DSyt39ngVR5UR43QHesXWYDVQk/fBO4+L4g71yuss9Ou7wXheSaG3IYfmm8SoK
# C6W59J7umDIFhZ7r+YMp08Ysfb06dy6LN0KgaoLtO0qqlBCk4Q34F8W2WnkzGJLj
# tXX4oemOCiUe5B7xn1qHI/+fpFGe+zmAEc3btcSnqIBv5VPU4OOiwtJbGvoyJi1q
# V3AcPKRYLqPzW0sH3DJZ84enGm1YMIIGZjCCBE6gAwIBAgITMwAAAES3P/zvWs+i
# egAAAAAARDANBgkqhkiG9w0BAQUFADB/MQswCQYDVQQGEwJVUzETMBEGA1UECBMK
# V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
# IENvcnBvcmF0aW9uMSkwJwYDVQQDEyBNaWNyb3NvZnQgQ29kZSBWZXJpZmljYXRp
# b24gUm9vdDAeFw0xNTA3MjIyMTAzNDlaFw0yNTA3MjIyMTAzNDlaMIGIMQswCQYD
# VQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5IENp
# dHkxHjAcBgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwGA1UEAxMlVVNF
# UlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCAiIwDQYJKoZIhvcN
# AQEBBQADggIPADCCAgoCggIBAIASZRc2DsPbCLPQrFcNdu3NJ9NMrVCDYeKqIE0J
# LWQJ3M6Jn8w9qez2z8Hc8dOx1ns3KBErR9o5xrw6GbRfpr19naNjQrZ28qk7K5H4
# 4m/Q7BYgkAk+4uh0yRi0kdRiZNt/owbxiBhqkCI8vP4T8IcUe/bkH47U5FHGEWdG
# CFHLhhRUP7wz/n5snP8WnRi9UY41pqdmyHJn2yFmsdSbeAPAUDrozPDcvJ5M/q8F
# ljUfV1q3/875PbcstvZU3cjnEjpNrkyKt1yatLcgPcp/IjSufjtoZgFE5wFORlOb
# M2D3lL5TN5BzQ/Myw1Pv26r+dE5px2uMYJPexMcM3+EyrsyTO1F4lWeL7j1W/gzQ
# aQ8bD/MlJmszbfduR/pzQ+V+DqVmsSl8MoRjVYnEDcGTVDAZE6zTfTen6106bDVc
# 20HXEtqpSQvf2ICKCZNijrVmzyWIzYS4sT+kOQ/ZAp7rEkyVfPNrBaleFoPMuGfi
# 6BOdzFuC00yz7Vv/3uVzrCM7LQC/NVV0CUnYSVgaf5I25lGSDvMmfRxNF7zJ7EMm
# 0L9BX0CpRET0medXh55QH1dUqD79dGMvsVBlCeZYQi5DGky08CVHWfoEHpPUJkZK
# UIGy3r54t/xnFeHJV4QeD2PW6WK61l9VLupcxigIBCU5uA4rqfJMlxwHPw1S9e3v
# L4IPAgMBAAGjgdAwgc0wEwYDVR0lBAwwCgYIKwYBBQUHAwMwEgYDVR0TAQH/BAgw
# BgEB/wIBAjAdBgNVHQ4EFgQUU3m/WqorSs9UgOHYm8Cd8rIDZsswCwYDVR0PBAQD
# AgGGMB8GA1UdIwQYMBaAFGL7CiFbf0NuEdoJVFBr9dKWcfGeMFUGA1UdHwROMEww
# SqBIoEaGRGh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3Rz
# L01pY3Jvc29mdENvZGVWZXJpZlJvb3QuY3JsMA0GCSqGSIb3DQEBBQUAA4ICAQBr
# IpM8PTlUcWRrDvLkPDARxSBKS4YPkvH/M3k62eSYpw5AoCKAfmGy4KcZzyaVMSpl
# 1GpPMYbqwMYuxWSMPUhZzQsvdD2UJhMQQtSXmCdePHbSeGkdGmTnBXJ14OtmQEOf
# jwxG/5dgpshnrRAIm2Km6b46itMHTZ9ykyW8BhHgLJA4Pmcc/RnXnpDOPcLg52Gs
# wOUE9R6ZVAyRDQFWcTeuJ9SeQyKlySfNTeVxEjkkpUFWh/+8VRQPJcqJ7seX5dIT
# /z1+GqCPP8gs16Nw0MdgwPzYPlHnl8Y+O+3PeL6KyuPE8qen7Z6uCAKPoFLbch7V
# O8NNn476m3DH+OO/bD+Sm+Q3PuxqjCn5waK/iz4aaWb7HGNPJgHJAsQ+0v/DQ6gb
# /Zn61LylueKTLzsBxdH0Oi9ow+Bkt1qVXkbMB4NpuzwFklZzNXNFmE582BKlt0Lp
# omP2QmAYcNE7bzHAh8fmceHzRhbp9bhys+ltH2ImSaNJi91ox4toVvfe/PqHJLgD
# gReP5fFnah2u03T3jKVdswuOQimWzknEd35mfAEXGmwUJMOwF3cF2BpAt4Zr2OR7
# QKx+305vJPkggIKMM+fl+inYndqLcF0ryR2CTAtny4RBnucGfhGDRC2KGe70f5rd
# eRw3GR6fP4wpug1cEIY3bEjNRV3NcLy80U1d2MW4djGCFjkwghY1AgEBMIGRMHwx
# CzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNV
# BAcTB1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDEkMCIGA1UEAxMb
# U2VjdGlnbyBSU0EgQ29kZSBTaWduaW5nIENBAhEAzS1l4rwsCIvYBjRVawV4ujAN
# BglghkgBZQMEAgEFAKBqMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisG
# AQQBgjcCAQsxDjAMBgorBgEEAYI3AgEWMC8GCSqGSIb3DQEJBDEiBCAMn2+d34I6
# +2daAt+LIoqhgUvR3Pyecd5hOCV8j2S+ITANBgkqhkiG9w0BAQEFAASCAYBgiY6y
# 0REeV2GGl65xJ3UgpmF3aZ3c0XSYdJ3o9Yhbr7FPUwFv8w3JJffb17aHVMPsW+NO
# FBpEGiXKqAhh+Wg7+zmi1QRM0dYu51scqlTeXUWqW2uKTDAHj25+G4T8Njav6F/P
# 1F37LPesRRI6t2sQeov2r0rAQR2hCLM5CwZiNvOSfQxzHQBcckDJnL3D1QXko8mQ
# jw6xwWEbLQL8TqXpbD2WcBms0QaWIWdOxCmQeUqCxKW8FRP5fZsLTeslyMxMHs9o
# PDnIJwu5KGxxyGDz21X3ls09WrMw0AtdCpfVNAdo5WOB2H+yOjYLZUbhukA4Twbg
# 064nZXROgakqd9DmoTJ94p4ryZhazTWRXjc4CzwzlNmMcJUjxzN1QA72no91ZBXA
# JELK5cTNspNgguFQ5TpYXlg4ABZgCTBj5blWmPfzI1BdgL9Z8zZAFJ3qQ0lYYm97
# UNJaDb08UCUC4pvII6UJykn7UNsWosOVM+PxjUbXfLhg5a6t49IQZaQg0sahghOM
# MIITiAYKKwYBBAGCNwMDATGCE3gwghN0BgkqhkiG9w0BBwKgghNlMIITYQIBAzEP
# MA0GCWCGSAFlAwQCAgUAMIIBGQYLKoZIhvcNAQkQAQSgggEIBIIBBDCCAQACAQEG
# CisGAQQBsjECAQEwMTANBglghkgBZQMEAgEFAAQgFGR6DNeK0di3iFfUwQ+Fo7xl
# khQbCarVlNi6SnIZ+rQCFD51EMCi85Iq+ZaBsszYvYnTG63rGA8yMDIyMDQyNzA5
# NDkxOVoCCEXZZ6TFAWXioIGKpIGHMIGEMQswCQYDVQQGEwJHQjEbMBkGA1UECBMS
# R3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQKEw9T
# ZWN0aWdvIExpbWl0ZWQxLDAqBgNVBAMMI1NlY3RpZ28gUlNBIFRpbWUgU3RhbXBp
# bmcgU2lnbmVyICMyoIIN+zCCBwcwggTvoAMCAQICEQCMd6AAj/TRsMY9nzpIg41r
# MA0GCSqGSIb3DQEBDAUAMH0xCzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVy
# IE1hbmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28g
# TGltaXRlZDElMCMGA1UEAxMcU2VjdGlnbyBSU0EgVGltZSBTdGFtcGluZyBDQTAe
# Fw0yMDEwMjMwMDAwMDBaFw0zMjAxMjIyMzU5NTlaMIGEMQswCQYDVQQGEwJHQjEb
# MBkGA1UECBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgw
# FgYDVQQKEw9TZWN0aWdvIExpbWl0ZWQxLDAqBgNVBAMMI1NlY3RpZ28gUlNBIFRp
# bWUgU3RhbXBpbmcgU2lnbmVyICMyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIIC
# CgKCAgEAkYdLLIvB8R6gntMHxgHKUrC+eXldCWYGLS81fbvA+yfaQmpZGyVM6u9A
# 1pp+MshqgX20XD5WEIE1OiI2jPv4ICmHrHTQG2K8P2SHAl/vxYDvBhzcXk6Th7ia
# 3kwHToXMcMUNe+zD2eOX6csZ21ZFbO5LIGzJPmz98JvxKPiRmar8WsGagiA6t+/n
# 1rglScI5G4eBOcvDtzrNn1AEHxqZpIACTR0FqFXTbVKAg+ZuSKVfwYlYYIrv8azN
# h2MYjnTLhIdBaWOBvPYfqnzXwUHOrat2iyCA1C2VB43H9QsXHprl1plpUcdOpp0p
# b+d5kw0yY1OuzMYpiiDBYMbyAizE+cgi3/kngqGDUcK8yYIaIYSyl7zUr0QcloIi
# lSqFVK7x/T5JdHT8jq4/pXL0w1oBqlCli3aVG2br79rflC7ZGutMJ31MBff4I13E
# V8gmBXr8gSNfVAk4KmLVqsrf7c9Tqx/2RJzVmVnFVmRb945SD2b8mD9EBhNkbunh
# FWBQpbHsz7joyQu+xYT33Qqd2rwpbD1W7b94Z7ZbyF4UHLmvhC13ovc5lTdvTn8c
# xjwE1jHFfu896FF+ca0kdBss3Pl8qu/CdkloYtWL9QPfvn2ODzZ1RluTdsSD7oK+
# LK43EvG8VsPkrUPDt2aWXpQy+qD2q4lQ+s6g8wiBGtFEp8z3uDECAwEAAaOCAXgw
# ggF0MB8GA1UdIwQYMBaAFBqh+GEZIA/DQXdFKI7RNV8GEgRVMB0GA1UdDgQWBBRp
# dTd7u501Qk6/V9Oa258B0a7e0DAOBgNVHQ8BAf8EBAMCBsAwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDBABgNVHSAEOTA3MDUGDCsGAQQBsjEB
# AgEDCDAlMCMGCCsGAQUFBwIBFhdodHRwczovL3NlY3RpZ28uY29tL0NQUzBEBgNV
# HR8EPTA7MDmgN6A1hjNodHRwOi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29SU0FU
# aW1lU3RhbXBpbmdDQS5jcmwwdAYIKwYBBQUHAQEEaDBmMD8GCCsGAQUFBzAChjNo
# dHRwOi8vY3J0LnNlY3RpZ28uY29tL1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5j
# cnQwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNlY3RpZ28uY29tMA0GCSqGSIb3
# DQEBDAUAA4ICAQBKA3iQQjPsexqDCTYzmFW7nUAGMGtFavGUDhlQ/1slXjvhOcRb
# uumVkDc3vd/7ZOzlgreVzFdVcEtO9KiH3SKFple7uCEn1KAqMZSKByGeir2nGvUC
# FctEUJmM7D66A3emggKQwi6Tqb4hNHVjueAtD88BN8uNovq4WpquoXqeE5MZVY8J
# kC7f6ogXFutp1uElvUUIl4DXVCAoT8p7s7Ol0gCwYDRlxOPFw6XkuoWqemnbdaQ+
# eWiaNotDrjbUYXI8DoViDaBecNtkLwHHwaHHJJSjsjxusl6i0Pqo0bglHBbmwNV/
# aBrEZSk1Ki2IvOqudNaC58CIuOFPePBcysBAXMKf1TIcLNo8rDb3BlKao0AwF7Ap
# FpnJqreISffoCyUztT9tr59fClbfErHD7s6Rd+ggE+lcJMfqRAtK5hOEHE3rDbW4
# hqAwp4uhn7QszMAWI8mR5UIDS4DO5E3mKgE+wF6FoCShF0DV29vnmBCk8eoZG4BU
# +keJ6JiBqXXADt/QaJR5oaCejra3QmbL2dlrL03Y3j4yHiDk7JxNQo2dxzOZgjdE
# 1CYpJkCOeC+57vov8fGP/lC4eN0Ult4cDnCwKoVqsWxo6SrkECtuIf3TfJ035CoG
# 1sPx12jjTwd5gQgT/rJkXumxPObQeCOyCSziJmK/O6mXUczHRDKBsq/P3zCCBuww
# ggTUoAMCAQICEDAPb6zdZph0fKlGNqd4LbkwDQYJKoZIhvcNAQEMBQAwgYgxCzAJ
# BgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtKZXJzZXkg
# Q2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMS4wLAYDVQQDEyVV
# U0VSVHJ1c3QgUlNBIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE5MDUwMjAw
# MDAwMFoXDTM4MDExODIzNTk1OVowfTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdy
# ZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2Vj
# dGlnbyBMaW1pdGVkMSUwIwYDVQQDExxTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5n
# IENBMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAyBsBr9ksfoiZfQGY
# PyCQvZyAIVSTuc+gPlPvs1rAdtYaBKXOR4O168TMSTTL80VlufmnZBYmCfvVMlJ5
# LsljwhObtoY/AQWSZm8hq9VxEHmH9EYqzcRaydvXXUlNclYP3MnjU5g6Kh78zlhJ
# 07/zObu5pCNCrNAVw3+eolzXOPEWsnDTo8Tfs8VyrC4Kd/wNlFK3/B+VcyQ9ASi8
# Dw1Ps5EBjm6dJ3VV0Rc7NCF7lwGUr3+Az9ERCleEyX9W4L1GnIK+lJ2/tCCwYH64
# TfUNP9vQ6oWMilZx0S2UTMiMPNMUopy9Jv/TUyDHYGmbWApU9AXn/TGs+ciFF8e4
# KRmkKS9G493bkV+fPzY+DjBnK0a3Na+WvtpMYMyou58NFNQYxDCYdIIhz2JWtSFz
# Eh79qsoIWId3pBXrGVX/0DlULSbuRRo6b83XhPDX8CjFT2SDAtT74t7xvAIo9G3a
# J4oG0paH3uhrDvBbfel2aZMgHEqXLHcZK5OVmJyXnuuOwXhWxkQl3wYSmgYtnwNe
# /YOiU2fKsfqNoWTJiJJZy6hGwMnypv99V9sSdvqKQSTUG/xypRSi1K1DHKRJi0E5
# FAMeKfobpSKupcNNgtCN2mu32/cYQFdz8HGj+0p9RTbB942C+rnJDVOAffq2OVgy
# 728YUInXT50zvRq1naHelUF6p4MCAwEAAaOCAVowggFWMB8GA1UdIwQYMBaAFFN5
# v1qqK0rPVIDh2JvAnfKyA2bLMB0GA1UdDgQWBBQaofhhGSAPw0F3RSiO0TVfBhIE
# VTAOBgNVHQ8BAf8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADATBgNVHSUEDDAK
# BggrBgEFBQcDCDARBgNVHSAECjAIMAYGBFUdIAAwUAYDVR0fBEkwRzBFoEOgQYY/
# aHR0cDovL2NybC51c2VydHJ1c3QuY29tL1VTRVJUcnVzdFJTQUNlcnRpZmljYXRp
# b25BdXRob3JpdHkuY3JsMHYGCCsGAQUFBwEBBGowaDA/BggrBgEFBQcwAoYzaHR0
# cDovL2NydC51c2VydHJ1c3QuY29tL1VTRVJUcnVzdFJTQUFkZFRydXN0Q0EuY3J0
# MCUGCCsGAQUFBzABhhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMA0GCSqGSIb3
# DQEBDAUAA4ICAQBtVIGlM10W4bVTgZF13wN6MgstJYQRsrDbKn0qBfW8Oyf0WqC5
# SVmQKWxhy7VQ2+J9+Z8A70DDrdPi5Fb5WEHP8ULlEH3/sHQfj8ZcCfkzXuqgHCZY
# XPO0EQ/V1cPivNVYeL9IduFEZ22PsEMQD43k+ThivxMBxYWjTMXMslMwlaTW9JZW
# CLjNXH8Blr5yUmo7Qjd8Fng5k5OUm7Hcsm1BbWfNyW+QPX9FcsEbI9bCVYRm5LPF
# Zgb289ZLXq2jK0KKIZL+qG9aJXBigXNjXqC72NzXStM9r4MGOBIdJIct5PwC1j53
# BLwENrXnd8ucLo0jGLmjwkcd8F3WoXNXBWiap8k3ZR2+6rzYQoNDBaWLpgn/0aGU
# pk6qPQn1BWy30mRa2Coiwkud8TleTN5IPZs0lpoJX47997FSkc4/ifYcobWpdR9x
# v1tDXWU9UIFuq/DQ0/yysx+2mZYm9Dx5i1xkzM3uJ5rloMAMcofBbk1a0x7q8ETm
# Mm8c6xdOlMN4ZSA7D0GqH+mhQZ3+sbigZSo04N6o+TzmwTC7wKBjLPxcFgCo0MR/
# 6hGdHgbGpm0yXbQ4CStJB6r97DDa8acvz7f9+tCjhNknnvsBZne5VhDhIG7GrrH5
# trrINV0zdo7xfCAMKneutaIChrop7rRaALGMq+P5CslUXdS5anSevUiumDGCBC0w
# ggQpAgEBMIGSMH0xCzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNo
# ZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRl
# ZDElMCMGA1UEAxMcU2VjdGlnbyBSU0EgVGltZSBTdGFtcGluZyBDQQIRAIx3oACP
# 9NGwxj2fOkiDjWswDQYJYIZIAWUDBAICBQCgggFrMBoGCSqGSIb3DQEJAzENBgsq
# hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjIwNDI3MDk0OTE5WjA/BgkqhkiG
# 9w0BCQQxMgQw8PCWeL9OcqrmM9fWrSwjzckqDdNlzueGFTZAHCs2O54GucPkO08E
# jcu9gXDL1biYMIHtBgsqhkiG9w0BCRACDDGB3TCB2jCB1zAWBBSVETcQHYgvMb1R
# P5Sa2kxorYwI9TCBvAQUAtZbleKDcMFXAJX6iPkj3ZN/rY8wgaMwgY6kgYswgYgx
# CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtKZXJz
# ZXkgQ2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMS4wLAYDVQQD
# EyVVU0VSVHJ1c3QgUlNBIENlcnRpZmljYXRpb24gQXV0aG9yaXR5AhAwD2+s3WaY
# dHypRjaneC25MA0GCSqGSIb3DQEBAQUABIICABY0lLqCsgE17AsH+E+MOYNrndVD
# imOMFJfExS4+C/4A4KCtaMF7/qMgn2Oc57jd6nz4X/higwekU4VNF79AtvN9JDaZ
# 1JevDAlBgmRCZ4kgbAb3pnvu6XvZt7cI4qYuvMF+wRGq3bOvHYHUBEzo1KZFliB0
# JAFTCsgZBL0itPfHYEmbs8ZQg/DN8RQw8ToBZwDWsGF6EzDTUedaF+y8YCmAUsBK
# JzNDh2bs4RDQTThjXcdHQirNfeVRTqHKQx1oR2MyiGcMwASBC0ZayyzYwlP82wRF
# JH4T1UoX9bcc6kTYpH5IryD8UUhM21O9HXFni1jRNEGKszsGouehZfdzNgapK/YM
# nZDlFKtH0p4RtDrEM8wHaxEihGceuXwf+3vDrFdkIe6vwMgOwqEBDF0fn533thKM
# l9fY+3hatT+30LchUWZnVa85drSQJFBL8xfwlyGbUZN4QiDPowZJnRczmHZqDDZU
# VKE/iyddEcvYmPK4BGfSkmw+hipi3uUX4/QrsO5L1rFJtEAd6CB1K4YsTURJHeIv
# fWHgENOrOtyF+ZgCECvwwJBsf/Qz6ccAG2O5AdjRCTWMMWW8McbjLq8/63ta3rRb
# aKLKIgWgpL0gRfCqte37YL1b1BbjpT84fNQIE78JeEF3wxCxX0oVBV/GGLCOiIS6
# bnXTgJ6sGk1kt1BF
# SIG # End signature block
