/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.exceptions;

import org.eclipse.core.resources.IResource;

public class ISSError {
    public static final int ERROR_PROJECT_JSON_FILE = 1;
    public static final int ERROR_SELECT_JSON_FILE = 2;
    public static final int ERROR_MODULE_JSON_FILE = 4;
    public static final int ERROR_SENSOR_JSON_FILE = 8;
    public static final int ERROR_PLATFORM_NOT_SUPPORTED = 16;
    public static final int ERROR_FIRMWARE_VERSION_NOT_SUPPORTED = 32;
    public static final int ERROR_FIRMWARE_NOT_SUPPORTED = 48;
    public static final int ERROR_SELECTED_SENSOR_NOT_INSTALLED = 64;
    public static final int ERROR_COMBO_SENSING_MISSING = 128;
    public static final int ERROR_SELECTED_SENSOR_ERROR = 192;
    public static final int ERROR_ALL = -1;
    public static final int ERROR_UNKNOWN = 0;
    private final Severity severity;
    private int reason;
    private String msg;
    private IResource cause;
    private long markId;
    private int line;
    private int index;

    public ISSError(Severity severity, int reason, String msg, IResource cause) {
        this.severity = severity;
        this.reason = reason;
        this.msg = msg;
        this.cause = cause;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public int getReason() {
        return this.reason;
    }

    public void setReason(int reason) {
        this.reason = reason;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setMessage(String msg) {
        this.msg = msg;
    }

    public IResource getCause() {
        return this.cause;
    }

    public void setCauseFile(IResource cause) {
        this.cause = cause;
    }

    public long getMarkId() {
        return this.markId;
    }

    public void setMarkId(long markId) {
        this.markId = markId;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean canUpdate() {
        return (this.reason & 0x70) > 0;
    }

    public static enum Severity {
        INFO(0),
        WARNING(1),
        ERROR(2),
        FATAL(2);

        private int markerValue;

        private Severity(int markerValue) {
            this.markerValue = markerValue;
        }

        public int getMarkerValue() {
            return this.markerValue;
        }
    }
}

