/*
 * Decompiled with CFR 0.152.
 */
package manager.pack.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import manager.pack.ISSPackageException;
import manager.pack.data.Arch;
import manager.pack.data.Properties;
import manager.pack.data.Resource;
import manager.pack.data.SensorInfo;
import manager.pack.data.SensorInfos;
import manager.utils.ManagerEnums;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="FDK.package")
public class PackageInfo {
    @XmlElement
    private Properties properties;
    @XmlElement
    private String name;
    @XmlElement
    private String version;
    @XmlElement
    private String vendor;
    @XmlElement
    private String arch;
    @XmlElement
    private String type;
    @XmlElement
    private String category;
    @XmlElement
    private String testLevel;
    @XmlElement(name="description")
    private String desc;
    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    private List<Resource> resources = new ArrayList<Resource>();
    @XmlElement(name="sensors")
    private SensorInfos sensors;

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getTestLevel() {
        return this.testLevel;
    }

    public void setTestLevel(String testLevel) {
        this.testLevel = testLevel;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public List<Resource> getResourceList() {
        return this.resources;
    }

    public void setResourceList(List<Resource> resourcelist) {
        this.resources = resourcelist;
    }

    public List<SensorInfo> getSensors() {
        return this.sensors.getSensors();
    }

    public void setSensors(SensorInfos sensors) {
        this.sensors = sensors;
    }

    public void setSensors(List<SensorInfo> list, boolean bind) {
        if (this.sensors == null) {
            this.sensors = new SensorInfos();
        }
        this.sensors.setSensors(list);
        this.sensors.setBind(bind);
    }

    public String getDefinedPackageName() {
        if (this.arch == null) {
            this.arch = Arch.X86.toString();
        }
        if (this.version == null) {
            this.version = "1.0.0.0";
        }
        return String.valueOf(this.getName()) + "_" + this.getArch().toString() + "_" + this.getVersion().toString();
    }

    public static void validatePackageContent(PackageInfo packageInfo, boolean online) throws ISSPackageException {
        if (packageInfo.getProperties() == null) {
            throw new ISSPackageException("Empty property.");
        }
        Properties pro = packageInfo.getProperties();
        if (online && (pro.getDownloadUrl() == null || pro.getDownloadUrl().isEmpty())) {
            throw new ISSPackageException("Empty download uri.");
        }
        if (pro.getFormatId() != 1) {
            throw new ISSPackageException("Not support format id.");
        }
        if (packageInfo.getName() == null) {
            throw new ISSPackageException("Empty name.");
        }
        if (packageInfo.getVersion() == null) {
            throw new ISSPackageException("Empty version.");
        }
        if (packageInfo.getVendor() == null) {
            throw new ISSPackageException("Empty vendor.");
        }
        List<Resource> resouces = packageInfo.getResourceList();
        List<SensorInfo> sensors = packageInfo.getSensors();
        if (resouces == null || resouces.isEmpty()) {
            throw new ISSPackageException("Empty resources.");
        }
        for (Resource res : resouces) {
            if (!res.isComponent("library") || PackageInfo.getSensorDefine(sensors, res) != null) continue;
            throw new ISSPackageException("Sensor missed: " + res.getResName() + ".");
        }
        if (sensors != null) {
            for (SensorInfo si : sensors) {
                if (si.getSensorName() == null || si.getSensorName().isEmpty()) {
                    throw new ISSPackageException("Empty sensor name");
                }
                if (si.getBuildNumber() == null || si.getBuildNumber().isEmpty()) {
                    throw new ISSPackageException("Empty build number");
                }
                if (!si.getObjectType().equals(ManagerEnums.ObjectTypes.LIBRARY.getFriendlyName()) && (si.getInitFunction() == null || si.getInitFunction().isEmpty())) {
                    throw new ISSPackageException("Empty init function");
                }
                if (si.getObjectType() == null || ManagerEnums.ObjectTypes.getValueByFriendlyName(si.getObjectType()) == null) {
                    throw new ISSPackageException("Unknow object type");
                }
                if (!si.getObjectType().equals(ManagerEnums.ObjectTypes.LIBRARY.getFriendlyName()) && si.getFlags() == -1) {
                    throw new ISSPackageException("Unknow flag value");
                }
                boolean found = false;
                for (Resource res : packageInfo.getResourceList()) {
                    if (!res.getResName().equalsIgnoreCase(si.getSensorName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ISSPackageException("Sensor resource missed: " + si.getSensorName());
            }
        }
    }

    private static SensorInfo getSensorDefine(List<SensorInfo> sensors, Resource res) {
        if (sensors != null) {
            for (SensorInfo si : sensors) {
                if (!si.getSensorName().equalsIgnoreCase(res.getResName())) continue;
                return si;
            }
        }
        return null;
    }

    public boolean isBind() {
        if (this.sensors == null) {
            return false;
        }
        return this.sensors.getBind();
    }

    public boolean hasLicenseFile() {
        if (this.getResourceList() == null) {
            return false;
        }
        for (Resource res : this.getResourceList()) {
            if (!res.isComponent("license")) continue;
            return true;
        }
        return false;
    }

    public String getLicenseFilePath() {
        if (this.getResourceList() == null) {
            return null;
        }
        for (Resource res : this.getResourceList()) {
            if (!res.isComponent("license")) continue;
            return res.getSource();
        }
        return null;
    }
}

