/*
 * Decompiled with CFR 0.152.
 */
package manager.configure;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import manager.common.BiMap;
import manager.configure.Vendor;
import manager.utils.ManagerFileUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="VendorList")
public class VendorListConfiguration {
    @XmlAttribute
    private String version = "unKnonwn";
    @XmlElement(name="Vendor")
    protected List<Vendor> Vendors = new ArrayList<Vendor>();
    public static String CONFIG_FILL_NAME = "vendor.xml";
    public static String BAK_FILL_NAME = "vendor_bak.xml";
    private static VendorListConfiguration sVendorListConfig;
    protected static BiMap<Integer, String> VendorTable;

    static {
        VendorTable = new BiMap();
    }

    public static String getConfigFile() throws Exception {
        File VendorXML = new File(CONFIG_FILL_NAME);
        if (VendorXML.exists()) {
            return CONFIG_FILL_NAME;
        }
        String folder = ManagerFileUtils.FDK_ECLIPSE_CONFIG_FOLDER();
        return String.valueOf(folder) + File.separator + CONFIG_FILL_NAME;
    }

    public static String getConfigFile(String configfilepath) throws Exception {
        String folder = configfilepath;
        return String.valueOf(folder) + File.separator + CONFIG_FILL_NAME;
    }

    public static VendorListConfiguration getInstance() throws Exception {
        if (sVendorListConfig == null) {
            VendorListConfiguration.init(VendorListConfiguration.getConfigFile());
        }
        return sVendorListConfig;
    }

    protected static void init(String configfilepath) throws Exception {
        FileInputStream xmlInput = null;
        if (!new File(configfilepath).exists()) {
            return;
        }
        try {
            try {
                JAXBContext jc = JAXBContext.newInstance(VendorListConfiguration.class, Vendor.class);
                xmlInput = new FileInputStream(configfilepath);
                sVendorListConfig = (VendorListConfiguration)jc.createUnmarshaller().unmarshal(xmlInput);
                for (Vendor iVendor : VendorListConfiguration.sVendorListConfig.Vendors) {
                    VendorTable.put(iVendor.getVendorID(), iVendor.getVendorName());
                }
            }
            catch (Exception fe) {
                throw new Exception("vendor.xml not existed or parse error");
            }
        }
        finally {
            if (xmlInput != null) {
                xmlInput.close();
            }
        }
    }

    public BiMap<Integer, String> getVendorList() {
        return VendorTable;
    }
}

