/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model;

import com.intel.sensing.fdk.common.BiMap;
import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.model.SensorsDefinitionsMapping;
import com.intel.sensing.fdk.model.entity.Callbacks;
import com.intel.sensing.fdk.model.entity.FieldDetailEntity;
import com.intel.sensing.fdk.model.entity.FieldsEntity;
import com.intel.sensing.fdk.model.entity.GPInputEntity;
import com.intel.sensing.fdk.model.entity.GPOutputEntity;
import com.intel.sensing.fdk.model.entity.InterruptEntity;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.SPIEntity;
import com.intel.sensing.fdk.model.entity.SensorAttributesEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import com.intel.sensing.fdk.model.entity.SupportedCalibrationFormatsEntity;
import com.intel.sensing.fdk.model.entity.SystemEventsEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SensorDataModel {
    public static String findVendorNameById(int vendorID, boolean searchInUser) {
        String vendorName = null;
        try {
            BiMap<Integer, String> VendorList = SensorsDefinitionsMapping.getInstance().getVendors();
            for (Map.Entry entry : VendorList.getForwardMap().entrySet()) {
                if (!((Integer)entry.getKey()).equals(vendorID)) continue;
                vendorName = (String)entry.getValue();
            }
            if (vendorName == null || vendorName.isEmpty()) {
                vendorName = "Vendor_" + Integer.toString(vendorID);
            }
        }
        catch (Exception exception) {
            vendorName = "Vendor_" + Integer.toString(vendorID);
        }
        return vendorName;
    }

    public static String findSensorTypeNameById(int sensorTypeID, boolean searchInUser) {
        String sensorTypeName = null;
        try {
            BiMap<Integer, String> SensorTypes = SensorsDefinitionsMapping.getInstance().getFDKDefinedSensorTypes();
            for (Map.Entry entry : SensorTypes.getForwardMap().entrySet()) {
                if (!((Integer)entry.getKey()).equals(sensorTypeID)) continue;
                sensorTypeName = (String)entry.getValue();
            }
            if (sensorTypeName == null || sensorTypeName.isEmpty()) {
                sensorTypeName = "SensorType_" + Integer.toString(sensorTypeID);
            }
        }
        catch (Exception exception) {
            sensorTypeName = "SensorType_" + Integer.toString(sensorTypeID);
        }
        return sensorTypeName;
    }

    public static void fillReporterDataFromParent(SensorDataEntity currentSensorData, SensorDataEntity parentSensorData) throws ISSException {
        if (parentSensorData != null) {
            currentSensorData.setSensorName(parentSensorData.getSensorName());
            currentSensorData.setDependencyType(parentSensorData.getDependencyType());
            currentSensorData.setSensorTypeId(parentSensorData.getSensorTypeId());
            currentSensorData.setSensorTypeName(currentSensorData.getSensorTypeName());
            currentSensorData.setInstanceId(parentSensorData.getInstanceId());
            currentSensorData.setConfiguration(parentSensorData.getConfiguration());
            currentSensorData.setReportIntervalMin(parentSensorData.getReportIntervalMin());
            currentSensorData.setReportIntervalMax(parentSensorData.getReportIntervalMax());
            currentSensorData.setSensitivity(parentSensorData.getSensitivity());
            currentSensorData.setVendorId(parentSensorData.getVendorId());
            currentSensorData.setModelId(parentSensorData.getModelId());
            currentSensorData.setModelName(parentSensorData.getModelName());
            currentSensorData.setObjectType(parentSensorData.getObjectTypeAsStr());
            currentSensorData.setFlags(parentSensorData.getFlags());
        }
    }

    public static List<SensorDataEntity> getSensorDependency(SensorDataEntity sensor) {
        return sensor.getDependencies();
    }

    public static ManagerEnums.ObjectTypes getObjectType(SensorDataEntity sd) {
        return sd.getObjectType();
    }

    public static String[] getAddressesAsHexStringList(SensorDataEntity sensor) {
        if (sensor.getBusInfo() == null) {
            return null;
        }
        List addresses = sensor.getBusInfo().parallelStream().filter(busInfo -> busInfo != null && busInfo.getAddresses() != null && busInfo.getAddresses().getAddress().size() > 0).flatMap(busInfo -> busInfo.getAddresses().getAddress().parallelStream()).map(Integer::parseInt).collect(Collectors.toList());
        if (addresses != null) {
            int index = 0;
            String[] addressesHexStrings = new String[addresses.size()];
            for (Integer address : addresses) {
                String hex = Integer.toHexString(address);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                addressesHexStrings[index++] = "0x" + hex;
            }
            return addressesHexStrings;
        }
        return null;
    }

    public static Integer getSensorTypeIdAsInt(SensorDataEntity sensorData) {
        if (sensorData.getSensorTypeId() == null || sensorData.getSensorTypeId().isEmpty()) {
            return 0;
        }
        try {
            int ret = Integer.parseInt(sensorData.getSensorTypeId());
            return ret;
        }
        catch (NumberFormatException e) {
            ISSLogger.e((Exception)e);
            return 0;
        }
    }

    public static String getVendorById(SensorDataEntity sensorData) {
        Integer vendorId = Integer.parseInt(sensorData.getVendorId());
        String VendorNameString = (String)SensorsDefinitionsMapping.getInstance().getVendors().getForward((Object)vendorId);
        if (VendorNameString == null) {
            VendorNameString = "VENDOR_" + vendorId.toString();
        }
        return VendorNameString;
    }

    public static String getVendorById(ModuleEntity moduleData) {
        Integer vendorId = Integer.parseInt(moduleData.getVendorID());
        String VendorNameString = (String)SensorsDefinitionsMapping.getInstance().getVendors().getForward((Object)vendorId);
        if (VendorNameString == null) {
            VendorNameString = "VENDOR_" + vendorId.toString();
        }
        return VendorNameString;
    }

    public static String getSensorTypeName(SensorDataEntity sensorData) {
        String typeName = sensorData.getSensorTypeName();
        try {
            Integer typeId = Integer.parseInt(sensorData.getSensorTypeId());
            if (typeName == null || typeName.isEmpty()) {
                typeName = SensorDataModel.findSensorTypeNameById(typeId, false);
                sensorData.setSensorTypeName(typeName);
            }
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
        }
        return typeName;
    }

    public static String[] getGPInputsNames(SensorDataEntity sensorData) {
        if (sensorData.getGpInputEntity() == null || sensorData.getGpInputEntity().getInterruptEntity() == null) {
            return new String[0];
        }
        return (String[])sensorData.getGpInputEntity().getInterruptEntity().parallelStream().map(interrupt -> interrupt.getName()).toArray(String[]::new);
    }

    public static String[] getGPOutputsNames(SensorDataEntity sensorData) {
        if (sensorData.getGpOutputEntity() == null || sensorData.getGpOutputEntity().getInterruptEntity() == null) {
            return new String[0];
        }
        return (String[])sensorData.getGpOutputEntity().getInterruptEntity().parallelStream().map(interrupt -> interrupt.getName()).toArray(String[]::new);
    }

    public static String[] getCalibrationFormatsAsStringList(SensorDataEntity sensorData) {
        if (sensorData.getSupportedCalibrationFormats() == null) {
            return new String[0];
        }
        return (String[])sensorData.getSupportedCalibrationFormats().parallelStream().map(cali -> cali.getFormatId()).toArray(String[]::new);
    }

    public static String[] getBusTypesAsStringList(SensorDataEntity sensorData) {
        return (String[])SensorDataModel.getBusTypes(sensorData).parallelStream().map(busType -> busType.name()).toArray(String[]::new);
    }

    public static List<ManagerEnums.BusTypes> getBusTypes(SensorDataEntity sensorData) {
        if (sensorData.getBusInfo() == null) {
            return new ArrayList<ManagerEnums.BusTypes>();
        }
        return sensorData.getBusInfo().parallelStream().map(busInfo -> ManagerEnums.BusTypes.getValueByName((String)busInfo.getBusType())).collect(Collectors.toList());
    }

    public static SPIEntity getSpi(SensorDataEntity sensorData) {
        return sensorData.getBusInfo().parallelStream().filter(busInfo -> busInfo.getSpi() != null).map(busInfo -> busInfo.getSpi()).findFirst().orElseThrow();
    }

    public static GPInputEntity getGPInputs(SensorDataEntity _sensorData) {
        return _sensorData.getGpInputEntity();
    }

    public static GPOutputEntity getGPOutputs(SensorDataEntity _sensorData) {
        return _sensorData.getGpOutputEntity();
    }

    public static int getVendorIdAsInt(SensorDataEntity sensorData) {
        if (sensorData.getVendorId() == null || sensorData.getVendorId().isEmpty()) {
            return -1;
        }
        try {
            int ret = Integer.parseInt(sensorData.getVendorId());
            return ret;
        }
        catch (NumberFormatException e) {
            ISSLogger.e((Exception)e);
            return 0;
        }
    }

    public static int getModelIdAsInt(SensorDataEntity sensorData) {
        if (sensorData.getModelId() == null || sensorData.getModelId().isEmpty()) {
            return -1;
        }
        try {
            int ret = Integer.parseInt(sensorData.getModelId());
            return ret;
        }
        catch (NumberFormatException e) {
            ISSLogger.e((Exception)e);
            return 0;
        }
    }

    public static List<ManagerEnums.Flags> getFlags(SensorDataEntity sensorData) {
        if (sensorData.getFlags() == null) {
            return new ArrayList<ManagerEnums.Flags>();
        }
        return ManagerEnums.Flags.getFlagsFromInt((int)Integer.parseInt(sensorData.getFlags()));
    }

    public static Integer getFlagsAsInteger(SensorDataEntity sensorData) {
        if (sensorData.getFlags() == null) {
            return ManagerEnums.Flags.SC_LUID_FLAG_NONE.getValue();
        }
        try {
            Integer ret = Integer.parseInt(sensorData.getFlags());
            return ret;
        }
        catch (NumberFormatException e) {
            ISSLogger.e((Exception)e);
            return ManagerEnums.Flags.SC_LUID_FLAG_NONE.getValue();
        }
    }

    public static boolean reporterEquals(SensorDataEntity reporter1, SensorDataEntity reporter2) {
        return !reporter1.getSensorTypeId().contentEquals("-1") && !reporter2.getSensorTypeId().contentEquals("-1") && reporter1.getSensorTypeId().contentEquals(reporter2.getSensorTypeId()) && reporter1.getInstanceId().contentEquals(reporter2.getInstanceId());
    }

    public static void setSensorTypeId(SensorDataEntity sensorData, Integer typeId) {
        sensorData.setSensorTypeId(typeId.toString());
    }

    public static void setVendorId(SensorDataEntity sensorData, String vendor) {
        Integer vendorId = (Integer)SensorsDefinitionsMapping.getInstance().getVendors().getBackward((Object)vendor);
        sensorData.setVendorId(vendorId.toString());
    }

    public static void setModelId(SensorDataEntity sensorData, String modelID) {
        sensorData.setModelId(modelID);
    }

    public static void setDoNotAddSensorPostfix(SensorDataEntity sensorData, Boolean doNotAddSensorPostfix) {
        sensorData.setDoNotAddSensorPostfix(doNotAddSensorPostfix);
    }

    public static void setObjectType(SensorDataEntity sensorData, ManagerEnums.ObjectTypes objType) {
        sensorData.setObjectType(objType.getFriendlyName());
    }

    public static void setSensorAttributes(SensorDataEntity sensorData, ArrayList<ManagerEnums.SensorAttributes> virtualSensorAttributes) {
        SensorAttributesEntity attrEntity = new SensorAttributesEntity();
        if (virtualSensorAttributes.contains(ManagerEnums.SensorAttributes.ALWAYS_ON)) {
            attrEntity.setIsAlwaysOn(Boolean.TRUE.toString());
        }
        if (virtualSensorAttributes.contains(ManagerEnums.SensorAttributes.EVENT_DRIVEN)) {
            attrEntity.setIsEventDriven(Boolean.TRUE.toString());
        }
        if (virtualSensorAttributes.contains(ManagerEnums.SensorAttributes.OVERRIDE_SENSOR_STRINGS)) {
            attrEntity.setIsOverrideStrings(Boolean.TRUE.toString());
        }
        if (virtualSensorAttributes.contains(ManagerEnums.SensorAttributes.STATE_DRIVEN)) {
            attrEntity.setIsStateDriven(Boolean.TRUE.toString());
        }
        if (virtualSensorAttributes.contains(ManagerEnums.SensorAttributes.WAKE_FROM_CS)) {
            attrEntity.setIsWakeFromCS(Boolean.TRUE.toString());
        }
        sensorData.setSensorAttributes(attrEntity);
    }

    public static void setCalibrationFormats(SensorDataEntity sensorData, ArrayList<Integer> calibrationFormats) {
        List<SupportedCalibrationFormatsEntity> supportedCalibrationFormats = calibrationFormats.parallelStream().map(formatId -> {
            SupportedCalibrationFormatsEntity entity = new SupportedCalibrationFormatsEntity();
            entity.setFormatId(formatId.toString());
            return entity;
        }).collect(Collectors.toList());
        sensorData.setSupportedCalibrationFormats(supportedCalibrationFormats);
    }

    public static void setFlags(SensorDataEntity sensorData, ArrayList<ManagerEnums.Flags> flags) {
        int flagInt;
        if (flags == null || flags.size() == 0) {
            flagInt = -1;
        } else if (flags.size() == 1 && flags.get(0).equals((Object)ManagerEnums.Flags.SC_LUID_FLAG_NONE)) {
            flagInt = 0;
        }
        StringBuilder binStringFlags = new StringBuilder("00000000");
        if (flags != null) {
            for (ManagerEnums.Flags flag : flags) {
                if (flag.equals((Object)ManagerEnums.Flags.SC_LUID_FLAG_NONE)) continue;
                binStringFlags.setCharAt(8 - flag.getValue(), '1');
            }
        }
        flagInt = Integer.parseInt(binStringFlags.toString(), 2);
        sensorData.setFlags(Integer.toString(flagInt));
    }

    public static void setCustomFlagvalue(SensorDataEntity sensorData, ManagerEnums.FlagValues customFlagValue) {
        sensorData.setCustomFlagvalue(customFlagValue.getFriendlyName());
    }

    public static void setNotExposedFlagvalue(SensorDataEntity sensorData, ManagerEnums.FlagValues notExposedFlagValue) {
        sensorData.setNotExposedFlagValue(notExposedFlagValue.name());
    }

    public static void setFields(SensorDataEntity sensorData, FieldsEntity fieldsEntity) {
        sensorData.setFields(fieldsEntity);
    }

    public static void setSystemEvents(SensorDataEntity sensorData, ArrayList<ManagerEnums.SystemEvents> systemEvents) {
        SystemEventsEntity systemEventsEntity = new SystemEventsEntity();
        systemEventsEntity.setSystemEvents(systemEvents);
        sensorData.setSystemEvents(systemEventsEntity);
    }

    public static void setCallbacks(SensorDataEntity sensorData, ArrayList<String> callbacks) {
        List<Callbacks> callbacksEntity = callbacks.parallelStream().map(callBackStr -> {
            Callbacks callBack = new Callbacks();
            callBack.setCallback((String)callBackStr);
            return callBack;
        }).collect(Collectors.toList());
        sensorData.setCallbacks(callbacksEntity);
    }

    public static void setGPOutputs(SensorDataEntity sensorData, ArrayList<InterruptEntity> gpOutputs) {
        GPOutputEntity gpOutputEntity = new GPOutputEntity();
        gpOutputEntity.setInterruptEntity(gpOutputs);
        sensorData.setGpOutputEntity(gpOutputEntity);
    }

    public static ManagerEnums.Configurations getConfiguration(SensorDataEntity sensorData) {
        return ManagerEnums.Configurations.getValueByName((String)sensorData.getConfiguration());
    }

    public static Integer getInstanceIdAsInt(SensorDataEntity sensorData) {
        if (sensorData.getInstanceId() == null || sensorData.getInstanceId().isEmpty()) {
            return 0;
        }
        try {
            int ret = Integer.parseInt(sensorData.getInstanceId());
            return ret;
        }
        catch (NumberFormatException e) {
            ISSLogger.e((Exception)e);
            return 0;
        }
    }

    public static Boolean isUserDefinedOutput(SensorDataEntity sensorData) {
        return Boolean.parseBoolean(sensorData.getFields().getUserDefined());
    }

    public static List<String> getCallbacks(SensorDataEntity sensorData) {
        return sensorData.getCallbacks().parallelStream().map(c -> c.getCallback()).collect(Collectors.toList());
    }

    public static int getSensitivityAsInt(SensorDataEntity dependency) {
        return Integer.parseInt(dependency.getSensitivity());
    }

    public static List<ManagerEnums.SensorAttributes> getSensorAttributes(SensorDataEntity sensorData) {
        ArrayList<ManagerEnums.SensorAttributes> attrList = new ArrayList<ManagerEnums.SensorAttributes>();
        if (Boolean.getBoolean(sensorData.getSensorAttributes().getIsAlwaysOn())) {
            attrList.add(ManagerEnums.SensorAttributes.ALWAYS_ON);
        }
        if (Boolean.getBoolean(sensorData.getSensorAttributes().getIsEventDriven())) {
            attrList.add(ManagerEnums.SensorAttributes.EVENT_DRIVEN);
        }
        if (Boolean.getBoolean(sensorData.getSensorAttributes().getIsOverrideStrings())) {
            attrList.add(ManagerEnums.SensorAttributes.OVERRIDE_SENSOR_STRINGS);
        }
        if (Boolean.getBoolean(sensorData.getSensorAttributes().getIsStateDriven())) {
            attrList.add(ManagerEnums.SensorAttributes.STATE_DRIVEN);
        }
        if (Boolean.getBoolean(sensorData.getSensorAttributes().getIsWakeFromCS())) {
            attrList.add(ManagerEnums.SensorAttributes.WAKE_FROM_CS);
        }
        return attrList;
    }

    public static List<ManagerEnums.SystemEvents> getSystemEvents(SensorDataEntity sensorData) {
        return sensorData.getSystemEvents().getEventList();
    }

    public static List<FieldDetailEntity> getFields(SensorDataEntity sensorData) {
        return sensorData.getFields().getFieldDetailEntityList();
    }

    public static List<FieldDetailEntity> getPropertyFields(SensorDataEntity sensorData) {
        return sensorData.getPropertyFields().getFieldDetailEntityList();
    }

    public static String getHexStringLuidUsingSensorData(SensorDataEntity reporterData) {
        String instanceIdHex;
        Integer instanceId;
        Integer instanceIdDec;
        Integer modelId;
        StringBuilder builder = new StringBuilder("****************");
        Integer typeIdDec = Integer.parseInt(reporterData.getSensorTypeId());
        String typeIdHex = Integer.toHexString(typeIdDec);
        int len = typeIdHex.length();
        int i = 0;
        while (i < 4 - len) {
            typeIdHex = "0" + typeIdHex;
            ++i;
        }
        builder.replace(0, 4, typeIdHex);
        Integer vendorId = SensorDataModel.getVendorIdAsInt(reporterData);
        if (vendorId != -1) {
            Integer vendorIdDec = vendorId;
            String vendorIdHex = Integer.toHexString(vendorIdDec);
            len = vendorIdHex.length();
            int i2 = 0;
            while (i2 < 4 - len) {
                vendorIdHex = "0" + vendorIdHex;
                ++i2;
            }
            builder.replace(4, 8, vendorIdHex);
        }
        if ((modelId = Integer.valueOf(SensorDataModel.getModelIdAsInt(reporterData))) != -1) {
            Integer modelIdDec = modelId;
            String modelIdHex = Integer.toHexString(modelIdDec);
            len = modelIdHex.length();
            int i3 = 0;
            while (i3 < 4 - len) {
                modelIdHex = "0" + modelIdHex;
                ++i3;
            }
            builder.replace(8, 12, modelIdHex);
        }
        if ((instanceIdDec = (instanceId = SensorDataModel.getInstanceIdAsInt(reporterData))) != -1) {
            instanceIdHex = Integer.toHexString(instanceIdDec);
            len = instanceIdHex.length();
            int i4 = 0;
            while (i4 < 2 - len) {
                instanceIdHex = "0" + instanceIdHex;
                ++i4;
            }
        } else {
            instanceIdHex = "**";
        }
        builder.replace(12, 14, instanceIdHex);
        if (reporterData.getFlags() != null) {
            Integer flagsDec = SensorDataModel.getFlagsAsInteger(reporterData);
            String flagsHex = Integer.toHexString(flagsDec);
            len = flagsHex.length();
            int i5 = 0;
            while (i5 < 2 - len) {
                flagsHex = "0" + flagsHex;
                ++i5;
            }
            builder.replace(14, 16, flagsHex);
        }
        return "0x" + builder.toString();
    }
}

