/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class HingeConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 105;
    public static final String CONFIGURATION_FORMAT_STRING = "Hinge Configuration";
    private static final int LATEST_FORMAT_ID = 4;
    public static final int SENSITIVITY_MIN_VALUE = 0;
    public static final int SENSITIVITY_MAX_VALUE = 4000;
    public static final int SENSITIVITY_NO_VALUE = 65535;
    public static final int MONO_MODALITY_DISABLE = 0;
    public static final int MONO_MODALITY_ENABLE = 1;
    public static final int MID_GYROSCOPE_ALWAYS_ON_DISABLE = 0;
    public static final int MID_GYROSCOPE_ALWAYS_ON_ENABLE = 1;
    private int _formatID = 4;
    private int _version = 0;
    private boolean _disableOnConnectedStandby = true;
    private int _sensitivityOnConnectedStandby = 0;
    private int _tabletModeAngle = 360;
    private int _monoModality = 0;
    private int _midGyroAlwaysOn = 0;
    private static final int[] formatIdArray = new int[]{1, 2, 3, 4};

    public static int[] getAllSupportFormatId() {
        return formatIdArray;
    }

    public HingeConfigurationPayload() {
    }

    public HingeConfigurationPayload(HingeConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._disableOnConnectedStandby = other._disableOnConnectedStandby;
        this._sensitivityOnConnectedStandby = other._sensitivityOnConnectedStandby;
        this._tabletModeAngle = other._tabletModeAngle;
        this._monoModality = other._monoModality;
        this._midGyroAlwaysOn = other._midGyroAlwaysOn;
    }

    public HingeConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 4) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configuration = reader.readNewField((String)"HingeConfiguration", (Node)payloadXmlNode).xmlElement;
        this._disableOnConnectedStandby = reader.readNewField((String)"DisableOnConnectedStandby", (int)1, (boolean)false, (Node)configuration).value == 1;
        this._sensitivityOnConnectedStandby = reader.readNewField((String)"SensitivityOnConnectedStandby", (int)2, (boolean)false, (Node)configuration).value;
        if (this._formatID >= 2) {
            this._tabletModeAngle = reader.readNewField((String)"TabletModeAngle", (int)2, (boolean)false, (Node)configuration).value;
        }
        if (this._formatID >= 3) {
            this._monoModality = (short)reader.readNewField((String)"MonoModality", (int)1, (boolean)false, (Node)configuration).value;
        }
        if (this._formatID >= 4) {
            this._midGyroAlwaysOn = (short)reader.readNewField((String)"MidGyroscopeAlwaysOn", (int)1, (boolean)false, (Node)configuration).value;
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof HingeConfigurationPayload)) {
            return false;
        }
        HingeConfigurationPayload other = (HingeConfigurationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._disableOnConnectedStandby == other._disableOnConnectedStandby && this._sensitivityOnConnectedStandby == other._sensitivityOnConnectedStandby && this._tabletModeAngle == other._tabletModeAngle && this._monoModality == other._monoModality && this._midGyroAlwaysOn == other._midGyroAlwaysOn;
    }

    @Override
    public HingeConfigurationPayload clone() {
        return new HingeConfigurationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configuration = writer.writeNewField((String)"HingeConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("DisableOnConnectedStandby", 1, this._disableOnConnectedStandby ? 1 : 0, (Node)configuration);
        writer.writeNewField("SensitivityOnConnectedStandby", 2, this._sensitivityOnConnectedStandby, (Node)configuration);
        if (this._formatID >= 2) {
            writer.writeNewField("TabletModeAngle", 2, this._tabletModeAngle, (Node)configuration);
        }
        if (this._formatID >= 3) {
            writer.writeNewField("MonoModality", 1, this._monoModality, (Node)configuration);
        }
        if (this._formatID >= 4) {
            writer.writeNewField("MidGyroscopeAlwaysOn", 1, this._midGyroAlwaysOn, (Node)configuration);
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public String getConfigurationFormatString() {
        return CONFIGURATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public boolean isDisableOnConnectedStandby() {
        return this._disableOnConnectedStandby;
    }

    public void setDisableOnConnectedStandby(boolean disableOnConnectedStandby) {
        this._disableOnConnectedStandby = disableOnConnectedStandby;
    }

    public int getSensitivityOnConnectedStandby() {
        return this._sensitivityOnConnectedStandby;
    }

    public void setSensitivityOnConnectedStandby(int sensitivityOnConnectedStandby) {
        this._sensitivityOnConnectedStandby = sensitivityOnConnectedStandby;
    }

    public int getTabletModeAngle() {
        return this._tabletModeAngle;
    }

    public void setTabletModeAngle(int tabletModeAngle) {
        this._tabletModeAngle = tabletModeAngle;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int _formatID) {
        this._formatID = _formatID;
    }

    public int getMonoModality() {
        return this._monoModality;
    }

    public void setMonoModality(int monoModality) {
        this._monoModality = monoModality;
    }

    public int getMidGyroAlwaysOn() {
        return this._midGyroAlwaysOn;
    }

    public void setMidGyroAlwaysOn(int _midGyroAlwaysOn) {
        this._midGyroAlwaysOn = _midGyroAlwaysOn;
    }
}

