/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.payloads.configurations.FaceDetectionConfigurationPayload;
import resources.CustomSpinner;

public class FaceDetectionConfiguration
implements InterruptsModifierOpener,
ConfigurationEditor {
    protected Shell shell;
    private Display display;
    private SensorModifier parent;
    private boolean _modified = false;
    private DataStore _dataStore;
    private InformationStore infoStore = null;
    private FaceDetectionConfigurationPayload _payload;
    private static String noFaceToWomTimeTooltip = "Controls the timeout of face detection mode transit to WoM mode, when face is no longer detected";
    private static String eventFilteringThresholdTooltip = "Specifies the threshold used to filter out the subtle changes in the bounding box that may occur due to analog-to-digital processing or fluctuations in CVF's face detect algorithm.";
    private static String obstructionAlsThresholdTooltip = "Minimum lux threshold to determine valid ambient light environment";
    CustomSpinner spnNoFaceToWomTime;
    CustomSpinner spnEventFilteringThreshold;
    CustomSpinner spnObstructionAlsThreshold;

    public static void main(String[] args) {
        try {
            FaceDetectionConfiguration window = new FaceDetectionConfiguration(null, null, null);
            PdtFile pdtFile = new PdtFile("");
            pdtFile.setPath(null);
            DataStore.getInstance().addPdtFile(pdtFile);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public FaceDetectionConfiguration(SensorModifier parentWindow, FaceDetectionConfigurationPayload payload, Sensor sensor) {
        this.parent = parentWindow;
        this._payload = payload;
        this._dataStore = DataStore.getInstance();
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfigurationModifier.class, "/resources/Intel.ico"));
        this.shell.setText("Face Detection Configuration");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Group grpFaceDetection = GuiUtils.addGroupToComposite("", (Composite)this.shell, 4, 16384, 0x1000000, false, false, 1, 1, 3);
        GuiUtils.addLabelToComposite("No Face To WOM Time", (Composite)grpFaceDetection, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnNoFaceToWomTime = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpFaceDetection, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnNoFaceToWomTime.setToolTipText(noFaceToWomTimeTooltip);
        this.spnNoFaceToWomTime.setSelection(15000);
        GuiUtils.addLabelToComposite("ms", (Composite)grpFaceDetection, 4, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Event Filtering Threshold", (Composite)grpFaceDetection, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnEventFilteringThreshold = GuiUtils.addCustomSpinnerToComposite(65535, this.shell, (Composite)grpFaceDetection, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnEventFilteringThreshold.setToolTipText(eventFilteringThresholdTooltip);
        this.spnEventFilteringThreshold.setSelection(5);
        GuiUtils.addLabelToComposite("pixel", (Composite)grpFaceDetection, 4, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Obstruction ALS Threshold", (Composite)grpFaceDetection, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnObstructionAlsThreshold = GuiUtils.addCustomSpinnerToComposite(Integer.MAX_VALUE, this.shell, (Composite)grpFaceDetection, 2048, 16384, 0x1000000, true, true, 1, 1);
        this.spnObstructionAlsThreshold.setToolTipText(obstructionAlsThresholdTooltip);
        this.spnObstructionAlsThreshold.setSelection(10);
        GuiUtils.addLabelToComposite("lux", (Composite)grpFaceDetection, 4, 16384, 0x1000000, false, false, 1, 1);
        Composite cmpsOkCancel = new Composite((Composite)this.shell, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        Button btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FaceDetectionConfiguration.this.save();
            }
        });
        Button btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FaceDetectionConfiguration.this.shell.close();
            }
        });
        ((GridData)this.spnNoFaceToWomTime.getLayoutData()).widthHint = longSpinnerMinWidth = GuiUtils.getButtonWidth((Control)this.shell);
        ((GridData)this.spnEventFilteringThreshold.getLayoutData()).widthHint = longSpinnerMinWidth;
        ((GridData)this.spnObstructionAlsThreshold.getLayoutData()).widthHint = longSpinnerMinWidth;
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public void fillData() {
        if (this._payload == null) {
            return;
        }
        this.spnNoFaceToWomTime.setSelection(this._payload.noFaceToWomTime);
        this.spnEventFilteringThreshold.setSelection(this._payload.eventFilteringThreshold);
        this.spnObstructionAlsThreshold.setSelection(this._payload.obstructionAlsThreshold);
    }

    public void save() {
        boolean newConfiguration = false;
        if (this._payload == null) {
            this._payload = new FaceDetectionConfigurationPayload();
            newConfiguration = true;
        }
        this._payload.noFaceToWomTime = this.spnNoFaceToWomTime.getSelection();
        this._payload.eventFilteringThreshold = this.spnEventFilteringThreshold.getSelection();
        this._payload.obstructionAlsThreshold = this.spnObstructionAlsThreshold.getSelection();
        if (newConfiguration && this.parent != null) {
            this.parent.addNewConfiguration(this._payload);
        }
        this._modified = false;
        if (this.parent != null) {
            this.parent.setModified();
        }
        this.shell.close();
    }

    @Override
    public int getGpioCount() {
        return 0;
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return null;
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        return null;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
    }

    @Override
    public Shell getShell() {
        return null;
    }

    @Override
    public void setModified() {
    }

    @Override
    public String getConfigurationFormatName() {
        return "Face Detection Configuration";
    }
}

