/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import pdtEditor.gui.GuiUtils;

public class VendorCalibrationGroup {
    private ArrayList<Byte> _tempVendorData;
    private Shell _shell;
    public Group grpVendorDefinedData;
    private Label lblDataStatus;
    private Button btnBrowse;
    private Button btnExport;
    private Button btnClear;
    private Boolean _modified = false;

    public VendorCalibrationGroup(Shell parent, ArrayList<Byte> tempVendorData) {
        this._shell = parent;
        this._tempVendorData = tempVendorData;
        this.grpVendorDefinedData = new Group((Composite)parent, 0);
        this.grpVendorDefinedData.setText("Vendor-Defined Data");
        GuiUtils.setGridLayoutToComposite((Composite)this.grpVendorDefinedData, 3);
        this.lblDataStatus = new Label((Composite)this.grpVendorDefinedData, 0);
        this.lblDataStatus.setText("No Data");
        this.lblDataStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.btnBrowse = new Button((Composite)this.grpVendorDefinedData, 0);
        this.btnBrowse.setText("Browse");
        GridData gd_btnBrowse = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.btnBrowse.setLayoutData((Object)gd_btnBrowse);
        gd_btnBrowse.widthHint = GuiUtils.getButtonWidth((Control)parent);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VendorCalibrationGroup.this.browseVendorData();
            }
        });
        this.btnClear = new Button((Composite)this.grpVendorDefinedData, 0);
        this.btnClear.setEnabled(false);
        this.btnClear.setText("Clear");
        GridData gd_btnClear = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.btnClear.setLayoutData((Object)gd_btnClear);
        gd_btnClear.widthHint = GuiUtils.getButtonWidth((Control)parent);
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VendorCalibrationGroup.this._tempVendorData != null && VendorCalibrationGroup.this._tempVendorData.size() > 0) {
                    MessageBox messageBox = new MessageBox(VendorCalibrationGroup.this._shell, 296);
                    messageBox.setText("Clearing The Vendor Defined Data");
                    messageBox.setMessage("You are about to clear the vendor defined data. Do you want to continue?");
                    if (messageBox.open() != 32) {
                        return;
                    }
                    VendorCalibrationGroup.this._tempVendorData.clear();
                    VendorCalibrationGroup.this.updateVendorDataComponents();
                }
            }
        });
        this.btnExport = new Button((Composite)this.grpVendorDefinedData, 0);
        this.btnExport.setEnabled(false);
        this.btnExport.setText("Export");
        GridData gd_btnExport = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.btnExport.setLayoutData((Object)gd_btnExport);
        gd_btnExport.widthHint = GuiUtils.getButtonWidth((Control)parent);
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VendorCalibrationGroup.this.exportVendorData();
            }
        });
    }

    public void browseVendorData() {
        if (this._tempVendorData != null && this._tempVendorData.size() > 0) {
            MessageBox messageBox = new MessageBox(this._shell, 296);
            messageBox.setText("Loading New Vendor Defined Data");
            messageBox.setMessage("Loading new data will override the old one. Do you want to continue?");
            if (messageBox.open() != 32) {
                return;
            }
        }
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        }
        this._tempVendorData.clear();
        FileDialog fd = new FileDialog(this._shell, 4096);
        fd.setText("Import Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            byte[] binaryData = Files.readAllBytes(Paths.get(path, new String[0]));
            for (int i = 0; i < binaryData.length; ++i) {
                this._tempVendorData.add(binaryData[i]);
            }
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this._shell, 33);
            messageBox.setText("Loading Failed");
            messageBox.setMessage("The loading of the new data failed");
        }
        this.updateVendorDataComponents();
        this._modified = true;
    }

    public void exportVendorData() {
        if (this._tempVendorData == null || this._tempVendorData.size() == 0) {
            return;
        }
        FileDialog fd = new FileDialog(this._shell, 8192);
        fd.setText("Export Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        byte[] toWrite = new byte[this._tempVendorData.size()];
        for (int i = 0; i < toWrite.length; ++i) {
            toWrite[i] = this._tempVendorData.get(i);
        }
        try {
            Files.write(Paths.get(path, new String[0]), toWrite, new OpenOption[0]);
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this._shell, 33);
            messageBox.setText("Exporting Vendor Data");
            messageBox.setMessage("Exporting The Vendor Data Failed");
            messageBox.open();
        }
    }

    public void updateVendorDataComponents() {
        if (this._tempVendorData != null && this._tempVendorData.size() > 0) {
            this.lblDataStatus.setText("Contains Data");
            this.btnExport.setEnabled(true);
            this.btnClear.setEnabled(true);
        } else {
            this.lblDataStatus.setText("No Data");
            this.btnExport.setEnabled(false);
            this.btnClear.setEnabled(false);
        }
    }

    public void setEnablment(boolean enabled) {
        this.grpVendorDefinedData.setEnabled(enabled);
        this.lblDataStatus.setEnabled(enabled);
        this.btnBrowse.setEnabled(enabled);
        this.btnClear.setEnabled(enabled);
        this.btnExport.setEnabled(enabled);
    }

    public boolean getModified() {
        return this._modified;
    }

    public void setModified(boolean modified) {
        this._modified = modified;
    }
}

