/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.Luid;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.gui.calibration.OnTableDetectionAutoBomModifier;
import pdtEditor.gui.configuration.AngleRegulatorConfiguration;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.OnTableDetectionCalibrationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import resources.ByteEditor;
import resources.CustomSpinner;
import resources.DoubleHolder;

public class OnTableDetectionCalibration
implements CalibrationEditor {
    private static final int DOUBLE_PRECISION = 4;
    protected Shell shlEditConfiguration;
    private Display display;
    private OnTableDetectionCalibration _thisInstance = this;
    private boolean _modified = false;
    private DataStore _dataStore;
    private CalibrationEditorOpener _parent = null;
    private Sensor _sensor = null;
    private OnTableDetectionCalibrationPayload _data = null;
    private ArrayList<Integer> modeIdList = new ArrayList();
    private Combo cmbFormatId;
    private Button chkFlag;
    private CustomSpinner spnVersion;
    private CustomSpinner spnEnterHysteresis;
    private CustomSpinner spnExitHysteresis;
    private CustomSpinner spnHorizontalTolerance;
    private DoubleHolder dbhEnterThresh;
    private DoubleHolder dbhExitThreshBase;
    private DoubleHolder dbhExitThreshMax;
    private DoubleHolder dbhStepFactor;
    private Table tblAutoBomCalibrations;
    private Group grpAutoBomCalibrations;
    private Group grpThreshold;
    private Group grpPlmModeId;
    private Button rbtnNormalMode;
    private Button rbtnAutoBomMode;
    private Button btnAddAutoBomCalibration;
    private Button btnEditAutoBomCalibration;
    private Button btnDeleteAutoBomCalibration;
    private Button chkHorizontalEnable;
    private Button chkPlmModeIdGroup;
    private ByteEditor byteEditor;
    private boolean isNew = false;
    private static final int DEFAULT_PLM_ROW_CONTROL_COUNT = 6;
    private static final int DEFAULT_PLM_ROW_COUNT = 1;
    private ControlAdapter resizeColHandler = new ControlAdapter(){

        public void controlResized(ControlEvent arg0) {
            if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                ((TableColumn)arg0.getSource()).setWidth(50);
            }
        }
    };

    public static void main(String[] args) {
        try {
            OnTableDetectionCalibration window = new OnTableDetectionCalibration(null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OnTableDetectionCalibration(CalibrationEditorOpener parent, OnTableDetectionCalibrationPayload data, Sensor sensor) {
        this._data = data;
        this._sensor = sensor;
        this._parent = parent;
        this._dataStore = DataStore.getInstance();
        this.modeIdList = this.getSupportPlmModeIds();
    }

    public OnTableDetectionCalibration(SensorModifier parent, Sensor sensor) {
        this._parent = parent;
        this._sensor = sensor;
        this._dataStore = DataStore.getInstance();
        this.modeIdList = this.getSupportPlmModeIds();
    }

    @Override
    public String getCalibrationFormatName() {
        return "On Table Detection Calibration";
    }

    public void upadteControlState() {
        if (Integer.valueOf(this.cmbFormatId.getText()) == 1) {
            this.chkFlag.setSelection(false);
            this.chkFlag.setEnabled(false);
            this.rbtnAutoBomMode.setSelection(false);
            this.rbtnNormalMode.setSelection(true);
            this.rbtnNormalMode.notifyListeners(13, new Event());
            this.rbtnAutoBomMode.setEnabled(false);
            this.rbtnNormalMode.setEnabled(false);
            this.tblAutoBomCalibrations.clearAll();
            this.dbhEnterThresh.setValue(1.5);
            this.dbhExitThreshBase.setValue(5.0);
            this.dbhExitThreshMax.setValue(15.0);
            this.dbhStepFactor.setValue(0.002);
            this.spnEnterHysteresis.setSelection(20);
            this.spnExitHysteresis.setSelection(0);
            this.chkHorizontalEnable.setEnabled(false);
            this.chkHorizontalEnable.setSelection(false);
            this.chkHorizontalEnable.notifyListeners(13, new Event());
        } else if (Integer.valueOf(this.cmbFormatId.getText()) == 2) {
            this.chkFlag.setEnabled(true);
            this.rbtnAutoBomMode.setSelection(false);
            this.rbtnNormalMode.setSelection(true);
            this.rbtnNormalMode.notifyListeners(13, new Event());
            this.rbtnAutoBomMode.setEnabled(false);
            this.rbtnNormalMode.setEnabled(false);
            this.tblAutoBomCalibrations.clearAll();
            this.dbhEnterThresh.setValue(1.5);
            this.dbhExitThreshBase.setValue(5.0);
            this.dbhExitThreshMax.setValue(15.0);
            this.dbhStepFactor.setValue(0.002);
            this.spnEnterHysteresis.setSelection(20);
            this.spnExitHysteresis.setSelection(0);
            this.chkHorizontalEnable.setEnabled(false);
            this.chkHorizontalEnable.setSelection(false);
            this.chkHorizontalEnable.notifyListeners(13, new Event());
        } else if (Integer.valueOf(this.cmbFormatId.getText()) == 3) {
            this.chkFlag.setEnabled(true);
            this.rbtnAutoBomMode.setEnabled(true);
            this.rbtnNormalMode.setEnabled(true);
            this.updateAutoBomTableButton();
            this.chkHorizontalEnable.setEnabled(false);
            this.chkHorizontalEnable.setSelection(false);
            this.chkHorizontalEnable.notifyListeners(13, new Event());
        } else {
            this.chkFlag.setEnabled(true);
            this.rbtnAutoBomMode.setEnabled(true);
            this.rbtnNormalMode.setEnabled(true);
            this.updateAutoBomTableButton();
            this.chkHorizontalEnable.setEnabled(true);
            this.chkHorizontalEnable.setSelection(false);
            this.chkHorizontalEnable.notifyListeners(13, new Event());
        }
    }

    private void updateAutoBomTableButton() {
        if (this.tblAutoBomCalibrations.getSelectionCount() > 0) {
            this.btnEditAutoBomCalibration.setEnabled(true);
            this.btnDeleteAutoBomCalibration.setEnabled(true);
        } else {
            this.btnEditAutoBomCalibration.setEnabled(false);
            this.btnDeleteAutoBomCalibration.setEnabled(false);
        }
        Map<Integer, List<Sensor>> map = this.getAccVendorAndModelMap(true);
        if (this.tblAutoBomCalibrations.getItemCount() >= 5 || map.keySet().size() == 0) {
            this.btnAddAutoBomCalibration.setEnabled(false);
        } else {
            this.btnAddAutoBomCalibration.setEnabled(true);
        }
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditConfiguration.open();
        this.shlEditConfiguration.layout();
        while (!this.shlEditConfiguration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        int[] allFormatId;
        for (int formatId : allFormatId = OnTableDetectionCalibrationPayload.getAllSupportFormatId()) {
            this.cmbFormatId.add(Integer.toString(formatId));
        }
        if (this._data == null) {
            this.cmbFormatId.select(this.cmbFormatId.getItems().length - 1);
            this.spnVersion.setSelection(0);
            this.dbhEnterThresh.setValue(1.5);
            this.dbhExitThreshBase.setValue(5.0);
            this.dbhExitThreshMax.setValue(15.0);
            this.dbhStepFactor.setValue(0.002);
            this.spnEnterHysteresis.setSelection(20);
            this.spnExitHysteresis.setSelection(0);
            this._data = new OnTableDetectionCalibrationPayload();
            this.isNew = true;
        } else {
            for (int index = 0; index < allFormatId.length; ++index) {
                if (allFormatId[index] != this._data.getFormatID()) continue;
                this.cmbFormatId.select(index);
            }
            this.spnVersion.setSelection(this._data.getVersion());
            this.chkFlag.setSelection((this._data.getFlag() & 1) > 0);
            if (this._data.getFormatID() < 3) {
                this.dbhEnterThresh.setValue(this._data.getEnterThresh());
                this.dbhExitThreshBase.setValue(this._data.getExitThreshBase());
                this.dbhExitThreshMax.setValue(this._data.getExitThreshMax());
                this.dbhStepFactor.setValue(this._data.getStepFactor());
                this.spnEnterHysteresis.setSelection(this._data.getEnterHysteresis());
                this.spnExitHysteresis.setSelection(this._data.getExitHysteresis());
            }
            if (this._data.getFormatID() >= 3) {
                if (this._data.getAutoBomCalibrationPayloadTotalCount() == 1) {
                    if (this._data.getAutoBomCalibrationPayload(0).getLuid().getSensorTypeId() == 0 && this._data.getAutoBomCalibrationPayload(0).getLuid().getVendorId() == 0 && this._data.getAutoBomCalibrationPayload(0).getLuid().getSensorSubTypeId() == 0 && this._data.getAutoBomCalibrationPayload(0).getLuid().getInstanceId() == 0 && this._data.getAutoBomCalibrationPayload(0).getLuid().getFlags() == 0) {
                        this.dbhEnterThresh.setValue(this._data.getAutoBomCalibrationPayload(0).getEnterThresh());
                        this.dbhExitThreshBase.setValue(this._data.getAutoBomCalibrationPayload(0).getExitThreshBase());
                        this.dbhExitThreshMax.setValue(this._data.getAutoBomCalibrationPayload(0).getExitThreshMax());
                        this.dbhStepFactor.setValue(this._data.getAutoBomCalibrationPayload(0).getStepFactor());
                        this.spnEnterHysteresis.setSelection(this._data.getAutoBomCalibrationPayload(0).getEnterHysteresis());
                        this.spnExitHysteresis.setSelection(this._data.getAutoBomCalibrationPayload(0).getExitHysteresis());
                    } else {
                        this.rbtnNormalMode.setSelection(false);
                        this.rbtnAutoBomMode.setSelection(true);
                        this.rbtnAutoBomMode.notifyListeners(13, new Event());
                        this.fillAutoBomCalibrationTable();
                    }
                } else if (this._data.getAutoBomCalibrationPayloadTotalCount() > 1) {
                    this.rbtnNormalMode.setSelection(false);
                    this.rbtnAutoBomMode.setSelection(true);
                    this.rbtnAutoBomMode.notifyListeners(13, new Event());
                    this.fillAutoBomCalibrationTable();
                }
            }
            if (this._data.getFormatID() >= 4) {
                this.chkHorizontalEnable.setSelection((this._data.getFlag() & 2) > 0);
                this.chkHorizontalEnable.notifyListeners(13, new Event());
                this.spnHorizontalTolerance.setSelection(this._data.getHorizontalTolerance());
                if (this._data.getHorizontalValidPlmMode() == -1) {
                    this.chkPlmModeIdGroup.setSelection(false);
                    this.chkPlmModeIdGroup.notifyListeners(13, new Event());
                } else {
                    this.chkPlmModeIdGroup.setSelection(true);
                    this.chkPlmModeIdGroup.notifyListeners(13, new Event());
                    this.setChildrenCheckboxBySelectedData((Composite)this.grpPlmModeId, this._data.getHorizontalValidPlmMode());
                }
            }
        }
        this._modified = false;
    }

    public void fillAutoBomCalibrationTable() {
        for (int i = 0; i < this._data.getAutoBomCalibrationPayloadTotalCount(); ++i) {
            this.addAutoBomToTable(this._data.getAutoBomCalibrationPayload(i));
        }
    }

    public void saveData() {
        if (this.dbhExitThreshBase.getValue() < this.dbhEnterThresh.getValue()) {
            MessageBox messageBox = new MessageBox(this.shlEditConfiguration, 513);
            messageBox.setText("Invalid Threshold Values");
            messageBox.setMessage("The exit threshold base's value cannot be less than the enter threshold's value.");
            messageBox.open();
            return;
        }
        if (this.dbhExitThreshMax.getValue() < this.dbhExitThreshBase.getValue()) {
            MessageBox messageBox = new MessageBox(this.shlEditConfiguration, 513);
            messageBox.setText("Invalid Threshold Values");
            messageBox.setMessage("The exit threshold max's value cannot be less than the exit threshold base's value.");
            messageBox.open();
            return;
        }
        if (Integer.valueOf(this.cmbFormatId.getText()) > 2 && this.rbtnAutoBomMode.getSelection() && this.tblAutoBomCalibrations.getItemCount() == 0) {
            MessageBox messageBox = new MessageBox(this.shlEditConfiguration, 513);
            messageBox.setText("Empty Calibration Data");
            messageBox.setMessage("Please add at least calibration data in Auto-Bom mode.");
            messageBox.open();
            return;
        }
        if (this.isNew) {
            this._parent.addNewCalibration(this._sensor, this._data);
        }
        this._data.setFormatID(Integer.valueOf(this.cmbFormatId.getText()));
        this._data.setVersion(this.spnVersion.getSelection());
        this._data.setEnterThresh(this.dbhEnterThresh.getValue());
        this._data.setExitThreshBase(this.dbhExitThreshBase.getValue());
        this._data.setExitThreshMax(this.dbhExitThreshMax.getValue());
        this._data.setStepFactor(this.dbhStepFactor.getValue());
        this._data.setEnterHysteresis(Short.valueOf(this.spnEnterHysteresis.getText()));
        this._data.setExitHysteresis(Short.valueOf(this.spnExitHysteresis.getText()));
        int flag = 0;
        if (this.chkFlag.getEnabled() && this.chkFlag.getSelection()) {
            flag |= 1;
        }
        if (this.chkHorizontalEnable.getEnabled() && this.chkHorizontalEnable.getSelection()) {
            flag |= 2;
        }
        if (this._data.getFormatID() > 2) {
            this._data.removeAllAutoBomCalibrationPayload();
            if (this.rbtnAutoBomMode.getSelection()) {
                TableItem[] items;
                for (TableItem item : items = this.tblAutoBomCalibrations.getItems()) {
                    this._data.addAutoBomCalibrationPayload((OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload)item.getData("Data"));
                }
            } else {
                OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload normalPayload = new OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload(this._data);
                normalPayload.setEnterThresh(this.dbhEnterThresh.getValue());
                normalPayload.setExitThreshBase(this.dbhExitThreshBase.getValue());
                normalPayload.setExitThreshMax(this.dbhExitThreshMax.getValue());
                normalPayload.setStepFactor(this.dbhStepFactor.getValue());
                normalPayload.setEnterHysteresis(Short.valueOf(this.spnEnterHysteresis.getText()));
                normalPayload.setExitHysteresis(Short.valueOf(this.spnExitHysteresis.getText()));
                this._data.addAutoBomCalibrationPayload(normalPayload);
            }
        }
        if (this._data.getFormatID() >= 4) {
            this._data.setHorizontalTolerance(this.spnHorizontalTolerance.getSelection());
            this._data.setHorizontalValidPlmMode(this.getChildrenCheckboxSelectedDataAsInt((Composite)this.grpPlmModeId));
        }
        this._data.setFlag(flag);
        this._modified = false;
        this._parent.setModified();
        this._parent.refreshCalibrationData();
        this.shlEditConfiguration.close();
    }

    protected void createContents() {
        int longSpinnerMinWidth;
        this.shlEditConfiguration = new Shell(65632);
        this.shlEditConfiguration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (OnTableDetectionCalibration.this._modified) {
                    MessageBox messageBox = new MessageBox(OnTableDetectionCalibration.this.shlEditConfiguration, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditConfiguration.setImage(SWTResourceManager.getImage(AngleRegulatorConfiguration.class, "/resources/Intel.ico"));
        this.shlEditConfiguration.setText("On Table Detection Calibration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditConfiguration, 2, true);
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shlEditConfiguration, 0, 4, 0x1000000, true, true, 2, 1, 4);
        ((GridLayout)group.getLayout()).makeColumnsEqualWidth = true;
        GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, true, false, 1, 1);
        this.cmbFormatId = GuiUtils.addComboToComposite((Composite)group, 12, 4, 16384, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Calibration Version:", (Composite)group, 0, 16384, 0x1000000, true, false, 1, 1);
        this.spnVersion = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.VERSION_MAX_VALUE, this.shlEditConfiguration, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpMode = GuiUtils.addGroupToComposite("Mode Selection", (Composite)this.shlEditConfiguration, 4, 4, 128, false, false, 2, 1, 2);
        this.rbtnNormalMode = GuiUtils.addButtonToComposite("Normal Mode", "", (Composite)grpMode, 16, 16384, 0x1000000, false, false, 1, 1);
        this.rbtnAutoBomMode = GuiUtils.addButtonToComposite("Auto-BOM Mode", "", (Composite)grpMode, 16, 16384, 0x1000000, false, false, 1, 1);
        this.rbtnNormalMode.setSelection(true);
        this.grpThreshold = GuiUtils.addGroupToComposite("Threshold Configuration", (Composite)this.shlEditConfiguration, 0, 4, 128, true, false, 2, 1, 4);
        GuiUtils.addLabelToComposite("Enther Threshold:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhEnterThresh = GuiUtils.addDoubleHolderToComposite(0, 100, 4, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Step Factor:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhStepFactor = GuiUtils.addDoubleHolderToComposite(0, 1, 4, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Threshold Base:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhExitThreshBase = GuiUtils.addDoubleHolderToComposite(0, 200, 4, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Threshold Max:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.dbhExitThreshMax = GuiUtils.addDoubleHolderToComposite(0, 200, 4, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Enter Hysteresis:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnEnterHysteresis = GuiUtils.addCustomSpinnerToComposite(Short.MAX_VALUE, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Exit Hysteresis:", (Composite)this.grpThreshold, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnExitHysteresis = GuiUtils.addCustomSpinnerToComposite(Short.MAX_VALUE, this.shlEditConfiguration, (Composite)this.grpThreshold, 2048, 131072, 0x1000000, true, false, 1, 1);
        this.grpAutoBomCalibrations = GuiUtils.addGroupToComposite("", (Composite)this.shlEditConfiguration, 0, 4, 4, true, true, 2, 1, 3);
        this.tblAutoBomCalibrations = new Table((Composite)this.grpAutoBomCalibrations, 68352);
        this.tblAutoBomCalibrations.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tblAutoBomCalibrations.setLinesVisible(true);
        this.tblAutoBomCalibrations.setHeaderVisible(true);
        ((GridData)this.tblAutoBomCalibrations.getLayoutData()).widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfiguration) * 3;
        this.tblAutoBomCalibrations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnTableDetectionCalibration.this.updateAutoBomTableButton();
            }
        });
        this.tblAutoBomCalibrations.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelectionIndex() < 0) {
                    if (!OnTableDetectionCalibration.this.btnAddAutoBomCalibration.getEnabled()) {
                        return;
                    }
                    Map vendorAndModelMap = OnTableDetectionCalibration.this.getAccVendorAndModelMap(true);
                    new OnTableDetectionAutoBomModifier(OnTableDetectionCalibration.this._thisInstance, vendorAndModelMap, OnTableDetectionCalibration.this._data, null, OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelectionIndex()).open();
                } else {
                    Map vendorAndModelMap = OnTableDetectionCalibration.this.getAccVendorAndModelMap(false);
                    OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload data = (OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload)OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelection()[0].getData("Data");
                    new OnTableDetectionAutoBomModifier(OnTableDetectionCalibration.this._thisInstance, vendorAndModelMap, OnTableDetectionCalibration.this._data, data, OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelectionIndex()).open();
                }
            }
        });
        TableColumn tblclmnVendor = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnVendor.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnVendor.setText("Vendor");
        TableColumn tblclmnMode = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnMode.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnMode.setText("Model");
        TableColumn tblclmnInstance = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnInstance.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnInstance.setText("Instance");
        TableColumn tblclmnEntherThreshold = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnEntherThreshold.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnEntherThreshold.setText("Enther Threshold");
        TableColumn tblclmnExitThresholdBase = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnExitThresholdBase.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnExitThresholdBase.setText("Exit Threshold Base");
        TableColumn tblclmnExitThresholdMax = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnExitThresholdMax.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnExitThresholdMax.setText("Exit Threshold Max");
        TableColumn tblclmnStepFactor = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnStepFactor.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnStepFactor.setText("Step Factor");
        TableColumn tblclmnEnterHysteresis = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnEnterHysteresis.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnEnterHysteresis.setText("Enter Hysteresis");
        TableColumn tblclmnExitHysteresis = new TableColumn(this.tblAutoBomCalibrations, 0);
        tblclmnExitHysteresis.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnExitHysteresis.setText("Exit Hysteresis");
        int oneWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditConfiguration) * 1.5);
        tblclmnMode.setWidth(oneWidth);
        tblclmnVendor.setWidth(oneWidth);
        tblclmnInstance.setWidth(oneWidth);
        tblclmnEntherThreshold.setWidth(oneWidth);
        tblclmnExitThresholdBase.setWidth(oneWidth);
        tblclmnExitThresholdMax.setWidth(oneWidth);
        tblclmnStepFactor.setWidth(oneWidth);
        tblclmnEnterHysteresis.setWidth(oneWidth);
        tblclmnExitHysteresis.setWidth(oneWidth);
        this.btnAddAutoBomCalibration = new Button((Composite)this.grpAutoBomCalibrations, 0);
        GridData gd_btnAddHall = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddHall.widthHint = GuiUtils.getButtonWidth((Control)this.grpAutoBomCalibrations);
        this.btnAddAutoBomCalibration.setLayoutData((Object)gd_btnAddHall);
        this.btnAddAutoBomCalibration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                OnTableDetectionCalibration.this.tblAutoBomCalibrations.deselectAll();
                if (OnTableDetectionCalibration.this.tblAutoBomCalibrations.getItemCount() < 5) {
                    Map vendorAndModelMap = OnTableDetectionCalibration.this.getAccVendorAndModelMap(true);
                    new OnTableDetectionAutoBomModifier(OnTableDetectionCalibration.this._thisInstance, vendorAndModelMap, OnTableDetectionCalibration.this._data, null, OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelectionIndex()).open();
                } else {
                    GuiUtils.showErrorMessage(OnTableDetectionCalibration.this.shlEditConfiguration, "Error", "The Auto-BOM config cannot exceed 5.");
                }
            }
        });
        this.btnAddAutoBomCalibration.setText("Add");
        this.btnEditAutoBomCalibration = new Button((Composite)this.grpAutoBomCalibrations, 0);
        GridData gd_btnEditHall = new GridData(4, 4, false, false, 1, 1);
        gd_btnEditHall.widthHint = GuiUtils.getButtonWidth((Control)this.grpAutoBomCalibrations);
        this.btnEditAutoBomCalibration.setLayoutData((Object)gd_btnEditHall);
        this.btnEditAutoBomCalibration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableItem[] selectedItems = OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelection();
                if (selectedItems.length != 1) {
                    return;
                }
                Map vendorAndModelMap = OnTableDetectionCalibration.this.getAccVendorAndModelMap(false);
                OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload data = (OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload)selectedItems[0].getData("Data");
                new OnTableDetectionAutoBomModifier(OnTableDetectionCalibration.this._thisInstance, vendorAndModelMap, OnTableDetectionCalibration.this._data, data, OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelectionIndex()).open();
            }
        });
        this.btnEditAutoBomCalibration.setText("Edit");
        this.btnDeleteAutoBomCalibration = new Button((Composite)this.grpAutoBomCalibrations, 0);
        GridData gd_btnDeleteHall = new GridData(4, 4, false, false, 1, 1);
        gd_btnDeleteHall.widthHint = GuiUtils.getButtonWidth((Control)this.grpAutoBomCalibrations);
        this.btnDeleteAutoBomCalibration.setLayoutData((Object)gd_btnDeleteHall);
        this.btnDeleteAutoBomCalibration.setEnabled(false);
        this.btnDeleteAutoBomCalibration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = OnTableDetectionCalibration.this.tblAutoBomCalibrations.getSelectionIndices();
                for (int i = selectedIndices.length - 1; i >= 0; --i) {
                    OnTableDetectionCalibration.this.tblAutoBomCalibrations.remove(selectedIndices[i]);
                }
                OnTableDetectionCalibration.this.updateAutoBomTableButton();
            }
        });
        this.btnDeleteAutoBomCalibration.setText("Delete");
        this.updateAutoBomTableButton();
        Group grpFlag = GuiUtils.addGroupToComposite("", (Composite)this.shlEditConfiguration, 0, 4, 128, true, false, 2, 1, 1);
        this.chkFlag = GuiUtils.addButtonToComposite("Disable on CS mode", "", (Composite)grpFlag, 32, 16384, 0x1000000, false, false, 1, 1);
        Composite cmpHorizontalPlmMode = new Composite((Composite)this.shlEditConfiguration, 4);
        FormLayout cmpHorizontalPlmModeLayout = new FormLayout();
        cmpHorizontalPlmMode.setLayout((Layout)cmpHorizontalPlmModeLayout);
        GridData grdHorizontalPlmMode = new GridData(4, 0x1000000, true, true, 2, 1);
        cmpHorizontalPlmMode.setLayoutData((Object)grdHorizontalPlmMode);
        this.chkHorizontalEnable = new Button(cmpHorizontalPlmMode, 32);
        this.chkHorizontalEnable.setText("Horizontal Dectection");
        FormData frmDataChkHorizontalPlmModeGroup = new FormData();
        this.chkHorizontalEnable.setLayoutData((Object)frmDataChkHorizontalPlmModeGroup);
        frmDataChkHorizontalPlmModeGroup.left = new FormAttachment();
        frmDataChkHorizontalPlmModeGroup.left.offset = 8;
        this.chkHorizontalEnable.setSelection(false);
        this.chkHorizontalEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!OnTableDetectionCalibration.this.chkHorizontalEnable.getSelection()) {
                    OnTableDetectionCalibration.this.spnHorizontalTolerance.setSelection(50);
                    OnTableDetectionCalibration.this.spnHorizontalTolerance.setEnabled(false);
                    if (OnTableDetectionCalibration.this.modeIdList != null && OnTableDetectionCalibration.this.modeIdList.size() > 0) {
                        OnTableDetectionCalibration.this.chkPlmModeIdGroup.setSelection(false);
                        OnTableDetectionCalibration.this.chkPlmModeIdGroup.notifyListeners(13, new Event());
                        OnTableDetectionCalibration.this.chkPlmModeIdGroup.setEnabled(false);
                    }
                } else {
                    OnTableDetectionCalibration.this.spnHorizontalTolerance.setEnabled(true);
                    if (OnTableDetectionCalibration.this.modeIdList != null && OnTableDetectionCalibration.this.modeIdList.size() > 0) {
                        OnTableDetectionCalibration.this.chkPlmModeIdGroup.setEnabled(true);
                    }
                }
            }
        });
        Group grpHorizontalPlmMode = new Group(cmpHorizontalPlmMode, 4);
        FormData grpHorizontalPlmModeGroupData = new FormData();
        GridLayout grpHorizontalPlmModeGroupLayout = new GridLayout(1, true);
        grpHorizontalPlmModeGroupLayout.verticalSpacing = 15;
        grpHorizontalPlmModeGroupLayout.horizontalSpacing = 12;
        grpHorizontalPlmMode.setLayout((Layout)grpHorizontalPlmModeGroupLayout);
        grpHorizontalPlmMode.setLayoutData((Object)grpHorizontalPlmModeGroupData);
        Composite cmptemp = GuiUtils.addCompositeToComposite((Composite)grpHorizontalPlmMode, 4, 16384, 0x1000000, true, true, 1, 1, 3);
        Label lblScreenAngleLow = GuiUtils.addLabelToComposite("Horizontal Tolerance:", cmptemp, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHorizontalTolerance = GuiUtils.addCustomSpinnerToComposite(Short.MAX_VALUE, this.shlEditConfiguration, cmptemp, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("mg", cmptemp, 4, 16384, 0x1000000, false, false, 1, 1);
        this.spnHorizontalTolerance.setSelection(50);
        Composite cmpPlmModelId = new Composite((Composite)grpHorizontalPlmMode, 4);
        FormLayout cmpPlmModeIdLayout = new FormLayout();
        cmpPlmModelId.setLayout((Layout)cmpPlmModeIdLayout);
        cmpPlmModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.chkPlmModeIdGroup = new Button(cmpPlmModelId, 32);
        this.chkPlmModeIdGroup.setText("PLM Mode ID");
        FormData formData = new FormData();
        this.chkPlmModeIdGroup.setLayoutData((Object)formData);
        formData.left = new FormAttachment();
        formData.left.offset = 8;
        this.grpPlmModeId = new Group(cmpPlmModelId, 4);
        FormData grpPlmModeIdGroupData = new FormData();
        GridLayout plmModeIdGroupLayout = new GridLayout(6, true);
        plmModeIdGroupLayout.verticalSpacing = 15;
        plmModeIdGroupLayout.horizontalSpacing = 15;
        this.grpPlmModeId.setLayout((Layout)plmModeIdGroupLayout);
        if (this.modeIdList == null || this.modeIdList.size() == 0) {
            this.chkPlmModeIdGroup.setSelection(false);
            this.chkPlmModeIdGroup.setEnabled(false);
            Button tempButton = new Button(cmpPlmModelId, 32);
            tempButton.setText("1");
            tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
            grpPlmModeIdGroupData.height = 1 * tempButton.computeSize((int)-1, (int)-1).y + plmModeIdGroupLayout.verticalSpacing * 1 + 2 * plmModeIdGroupLayout.marginHeight;
            tempButton.dispose();
        } else {
            if (this.modeIdList.size() < 6) {
                Button tempButton = new Button(cmpPlmModelId, 32);
                tempButton.setText("1");
                tempButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                grpPlmModeIdGroupData.width = 6 * tempButton.computeSize((int)-1, (int)-1).x + plmModeIdGroupLayout.horizontalSpacing * 6 + 2 * plmModeIdGroupLayout.marginWidth;
                tempButton.dispose();
            }
            this.chkPlmModeIdGroup.setSelection(true);
            for (int i = 0; i < this.modeIdList.size(); ++i) {
                Button addBtn = new Button((Composite)this.grpPlmModeId, 32);
                addBtn.setText(this.modeIdList.get(i).toString());
                addBtn.setData((Object)(1 << this.modeIdList.get(i)));
                addBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            }
        }
        this.grpPlmModeId.setLayoutData((Object)grpPlmModeIdGroupData);
        this.chkPlmModeIdGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!OnTableDetectionCalibration.this.chkPlmModeIdGroup.getSelection()) {
                    OnTableDetectionCalibration.this.setSubCheckboxSelection((Composite)OnTableDetectionCalibration.this.grpPlmModeId, false);
                    OnTableDetectionCalibration.this.setChildrenEnable((Composite)OnTableDetectionCalibration.this.grpPlmModeId, false);
                } else {
                    OnTableDetectionCalibration.this.setChildrenEnable((Composite)OnTableDetectionCalibration.this.grpPlmModeId, true);
                }
            }
        });
        this.spnEnterHysteresis.setMinimum(0);
        this.spnExitHysteresis.setMinimum(0);
        this.dbhEnterThresh.setMinClosedInterval(false);
        this.dbhExitThreshBase.setMinClosedInterval(false);
        this.dbhExitThreshMax.setMinClosedInterval(false);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlEditConfiguration, 0, 131072, 0x1000000, false, false, 2, 1, 2);
        Button btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        ((GridData)this.tblAutoBomCalibrations.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.tblAutoBomCalibrations) * 10;
        ((GridData)this.grpAutoBomCalibrations.getLayoutData()).exclude = true;
        this.grpAutoBomCalibrations.setVisible(false);
        this.cmbFormatId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this.upadteControlState();
            }
        });
        this.spnVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhEnterThresh.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhExitThreshBase.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhExitThreshMax.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        this.dbhStepFactor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OnTableDetectionCalibration.this._modified = true;
            }
        });
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnTableDetectionCalibration.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OnTableDetectionCalibration.this.shlEditConfiguration.close();
            }
        });
        this.rbtnNormalMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ((GridData)((OnTableDetectionCalibration)OnTableDetectionCalibration.this).grpAutoBomCalibrations.getLayoutData()).exclude = true;
                OnTableDetectionCalibration.this.grpAutoBomCalibrations.setVisible(false);
                OnTableDetectionCalibration.this.grpThreshold.setVisible(true);
                ((GridData)((OnTableDetectionCalibration)OnTableDetectionCalibration.this).grpThreshold.getLayoutData()).exclude = false;
                OnTableDetectionCalibration.this.shlEditConfiguration.layout();
                OnTableDetectionCalibration.this.shlEditConfiguration.setSize(OnTableDetectionCalibration.this.shlEditConfiguration.computeSize(-1, -1));
            }
        });
        this.rbtnAutoBomMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                OnTableDetectionCalibration.this.dbhEnterThresh.setValue(1.5);
                OnTableDetectionCalibration.this.dbhExitThreshBase.setValue(5.0);
                OnTableDetectionCalibration.this.dbhExitThreshMax.setValue(15.0);
                OnTableDetectionCalibration.this.dbhStepFactor.setValue(0.002);
                OnTableDetectionCalibration.this.spnEnterHysteresis.setSelection(20);
                OnTableDetectionCalibration.this.spnExitHysteresis.setSelection(0);
                OnTableDetectionCalibration.this.grpThreshold.setVisible(false);
                ((GridData)((OnTableDetectionCalibration)OnTableDetectionCalibration.this).grpThreshold.getLayoutData()).exclude = true;
                OnTableDetectionCalibration.this.grpAutoBomCalibrations.setVisible(true);
                ((GridData)((OnTableDetectionCalibration)OnTableDetectionCalibration.this).grpAutoBomCalibrations.getLayoutData()).exclude = false;
                OnTableDetectionCalibration.this.shlEditConfiguration.layout();
                OnTableDetectionCalibration.this.shlEditConfiguration.setSize(OnTableDetectionCalibration.this.shlEditConfiguration.computeSize(-1, -1));
            }
        });
        this.chkHorizontalEnable.notifyListeners(13, new Event());
        ((GridData)this.spnVersion.getLayoutData()).minimumWidth = longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditConfiguration) * 1.5);
        ((GridData)this.dbhEnterThresh.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhExitThreshBase.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhExitThreshMax.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.dbhStepFactor.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnEnterHysteresis.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnExitHysteresis.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.tblAutoBomCalibrations.getLayoutData()).minimumWidth = 4 * longSpinnerMinWidth;
        ((GridData)cmpHorizontalPlmMode.getLayoutData()).widthHint = group.computeSize((int)-1, (int)-1).x;
        ((FormData)grpHorizontalPlmMode.getLayoutData()).width = group.computeSize((int)-1, (int)-1).x - 6;
        this.shlEditConfiguration.setSize(this.shlEditConfiguration.computeSize(-1, -1));
        this.shlEditConfiguration.setLocation(GuiUtils.getMiddleLocation(this.shlEditConfiguration, this.display));
    }

    public void addAutoBomToTable(OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload itemData) {
        try {
            DecimalFormat df = new DecimalFormat("##0.0000");
            TableItem item = new TableItem(this.tblAutoBomCalibrations, 0);
            Luid emptyLuid = new Luid(0, 0, 0, 0, 0);
            Color itemColor = new Color((Device)Display.getCurrent(), 0, 0, 0);
            if (!emptyLuid.equals(itemData.getLuid()) && (!DataStore.getInstance().isSensorExists(itemData.getLuid()) || this._sensor != null && itemData.getLuid().getInstanceId() != this._sensor.getLuid().getInstanceId())) {
                itemColor = new Color((Device)Display.getCurrent(), 255, 0, 0);
            }
            item.setForeground(itemColor);
            item.setText(0, InformationStore.getInstance().getVendorName(itemData.getLuid().getVendorId()));
            item.setText(1, InformationStore.getInstance().getModelName(true, 115, itemData.getLuid().getVendorId(), itemData.getLuid().getSensorSubTypeId()));
            item.setText(2, String.valueOf(itemData.getLuid().getInstanceId()));
            item.setText(3, String.valueOf(df.format(itemData.getEnterThresh())));
            item.setText(4, String.valueOf(df.format(itemData.getExitThreshBase())));
            item.setText(5, String.valueOf(df.format(itemData.getExitThreshMax())));
            item.setText(6, String.valueOf(df.format(itemData.getStepFactor())));
            item.setText(7, String.valueOf(itemData.getEnterHysteresis()));
            item.setText(8, String.valueOf(itemData.getExitHysteresis()));
            item.setData("Data", (Object)itemData);
            this.updateAutoBomTableButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAutoBomToTable(OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload itemData, int index) {
        try {
            TableItem item = this.tblAutoBomCalibrations.getItem(index);
            Luid emptyLuid = new Luid(0, 0, 0, 0, 0);
            Color itemColor = new Color((Device)Display.getCurrent(), 0, 0, 0);
            if (!emptyLuid.equals(itemData.getLuid()) && (!DataStore.getInstance().isSensorExists(itemData.getLuid()) || this._sensor != null && itemData.getLuid().getInstanceId() != this._sensor.getLuid().getInstanceId())) {
                itemColor = new Color((Device)Display.getCurrent(), 255, 0, 0);
            }
            item.setForeground(itemColor);
            item.setText(0, InformationStore.getInstance().getVendorName(itemData.getLuid().getVendorId()));
            item.setText(1, InformationStore.getInstance().getModelName(true, 115, itemData.getLuid().getVendorId(), itemData.getLuid().getSensorSubTypeId()));
            item.setText(2, String.valueOf(itemData.getLuid().getInstanceId()));
            item.setText(3, String.valueOf(itemData.getEnterThresh()));
            item.setText(4, String.valueOf(itemData.getExitThreshBase()));
            item.setText(5, String.valueOf(itemData.getExitThreshMax()));
            item.setText(6, String.valueOf(itemData.getStepFactor()));
            item.setText(7, String.valueOf(itemData.getEnterHysteresis()));
            item.setText(8, String.valueOf(itemData.getExitHysteresis()));
            item.setData("Data", (Object)itemData);
            this.updateAutoBomTableButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<Integer, List<Sensor>> getAccVendorAndModelMap(boolean isNew) {
        HashMap<Integer, List<Sensor>> vendorAndModelMap = new HashMap<Integer, List<Sensor>>();
        ArrayList<Sensor> sensorList = DataStore.getInstance().getAllPhysicalSensors();
        TableItem[] items = this.tblAutoBomCalibrations.getItems();
        TableItem[] selectedItems = this.tblAutoBomCalibrations.getSelection();
        for (Sensor sensor : sensorList) {
            if (sensor.getLuid().getSensorTypeId() != 115 || sensor.getLuid().getInstanceId() != this._sensor.getLuid().getInstanceId()) continue;
            boolean isAdded = false;
            for (TableItem item : items) {
                OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload payload;
                if (!isNew) {
                    boolean isSkip = false;
                    for (TableItem selectedItem : selectedItems) {
                        if (!selectedItem.equals(item)) continue;
                        isSkip = true;
                    }
                    if (isSkip) continue;
                }
                if (!(payload = (OnTableDetectionCalibrationPayload.AutoBomCalibrationPayload)item.getData("Data")).getLuid().equals(sensor.getLuid())) continue;
                isAdded = true;
            }
            if (isAdded) continue;
            int vendorId = sensor.getLuid().getVendorId();
            if (vendorAndModelMap.containsKey(vendorId)) {
                List newSensorList = (List)vendorAndModelMap.get(vendorId);
                newSensorList.add(sensor);
                continue;
            }
            ArrayList<Sensor> newSensorList = new ArrayList<Sensor>();
            newSensorList.add(sensor);
            vendorAndModelMap.put(sensor.getLuid().getVendorId(), newSensorList);
        }
        return vendorAndModelMap;
    }

    public ArrayList<Integer> getSupportPlmModeIds() {
        ArrayList<Payload> payloads = null;
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = null;
        ArrayList<Integer> supportPlmModeIds = new ArrayList<Integer>();
        if (this._dataStore.getCurrentDevice() == null) {
            return supportPlmModeIds;
        }
        ArrayList<Sensor> sensors = this._dataStore.getCurrentDevice().getSensors();
        for (Sensor sensor : sensors) {
            if (sensor.getLuid().getSensorTypeId() != 768) continue;
            payloads = sensor.getPayloads();
            break;
        }
        if (payloads == null) {
            return supportPlmModeIds;
        }
        for (Payload payload : payloads) {
            if (payload.getClass() != LidModeConfigurationPayload.class) continue;
            tableEntries = ((LidModeConfigurationPayload)payload).getTableEntries();
            break;
        }
        if (tableEntries == null) {
            return supportPlmModeIds;
        }
        for (LidModeConfigurationPayload.TableEntry entry : tableEntries) {
            supportPlmModeIds.add(entry.modeId);
        }
        return supportPlmModeIds;
    }

    public void setSubCheckboxSelection(Composite parentControl, boolean selection) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            ((Button)control).setSelection(selection);
        }
    }

    public void setChildrenEnable(Composite parentControl, boolean isEnabled) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (!(control instanceof Button) || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0) continue;
            control.setEnabled(isEnabled);
        }
    }

    public void setChildrenCheckboxBySelectedData(Composite parentControl, int data) {
        Control[] child;
        for (Control control : child = parentControl.getChildren()) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0) continue;
            int bitValue = (Integer)control.getData();
            if ((bitValue & data) > 0) {
                ((Button)control).setSelection(true);
                continue;
            }
            ((Button)control).setSelection(false);
        }
    }

    public int getChildrenCheckboxSelectedDataAsInt(Composite parentControl) {
        Control[] child = parentControl.getChildren();
        int ret = 0;
        for (Control control : child) {
            if (control.getClass() != Button.class || (control.getStyle() & 0x20) <= 0 && (control.getStyle() & 0x10) <= 0 || !((Button)control).getSelection()) continue;
            int value = (Integer)control.getData();
            ret |= value;
        }
        if (ret == 0) {
            ret = -1;
        }
        return ret;
    }
}

