/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import binTools.BinWriter;
import dbgConfig.DbgConfig;
import dbgConfig.DbgConfigGui;
import java.awt.MouseInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import packaging.NvarPackage;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.IMainWindow;
import pdtEditor.InformationStore;
import pdtEditor.Logger;
import pdtEditor.PDTExternalInfo;
import pdtEditor.PdtFile;
import pdtEditor.PdtWriter;
import pdtEditor.Sensor;
import pdtEditor.UserPreferences;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.gui.About;
import pdtEditor.gui.BoardDescriptionTableEditor;
import pdtEditor.gui.CustomDataEntry;
import pdtEditor.gui.DeviceProperties;
import pdtEditor.gui.FormFactor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.HeciConfiguration;
import pdtEditor.gui.LoadingWindow;
import pdtEditor.gui.MoveSensors;
import pdtEditor.gui.PlatformId;
import pdtEditor.gui.Properties;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.SensorModifierOpener;
import pdtEditor.gui.calibration.ViewCalibrations;
import pdtEditor.gui.treeViewer.IssuesContentProvider;
import pdtEditor.gui.treeViewer.IssuesLabelProvider;
import pdtEditor.gui.treeViewer.PdtContentProvider;
import pdtEditor.gui.treeViewer.PdtLabelProvider;
import pdtEditor.validation.IValidatable;
import pdtEditor.validation.Issue;

public class MainWindow
implements IMainWindow,
SensorModifierOpener {
    public static final String WINDOW_TITLE_TEXT = "Intel\u00ae Integrated Sensor Solution - Platform Description Table (PDT) Editor";
    private static final String FDK_DIR = InformationStore.getFDKPath();
    public static final boolean IMPORT_POSSIBLE = FDK_DIR != null && new File(FDK_DIR).exists();
    protected Shell shlIntelrIsh;
    private Display display;
    private boolean _modified = false;
    private DataStore _dataStore;
    private MainWindow thisWindow = this;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private MenuItem mntmSaveAs;
    private MenuItem mntmDeleteSelected;
    private MenuItem mntmPlatformId;
    private String _argsGivenInputPath = null;
    private boolean _isArgsGivenOutputPath = false;
    private boolean _keepOnlyImportedSensors = false;
    private boolean _silentValidation = false;
    private ArrayList<SensorModifier> _openedwindows = new ArrayList();
    private Combo devicesCombo;
    private Text statusBar;
    private MenuItem mntmCalibration;
    private MenuItem mntmManageIcBoard;
    private MenuItem mntmManageCustomDataEntry;
    private boolean _autoExportXml;
    private String _importExternalFilesPath = null;
    private String _sensorFilteringXmlPath;
    private MenuItem mntmAddPhysicalSensor;
    private MenuItem mntmAddVirtualSensor;
    private MenuItem mntmImportSensor;
    private MenuItem mntmHostInterfaceheci;
    private MenuItem mntmManageFormFactor;
    private MenuItem mntmRestoreIgnored;
    private Menu mntmBdt;
    private MenuItem mntmTreeRightMoveDevice;
    private MenuItem mntmTreeRightCloneSensor;
    private MenuItem mntmTreeRightDelete;
    private MenuItem mntmTreeRightModify;
    private MenuItem mntmTreeRightAddPhysical;
    private MenuItem mntmTreeRightAddVirtual;
    private MenuItem mntmTreeRightAddDevice;
    private MenuItem mntmTreeRightImportSensor;
    private MenuItem mntmFixIssue;
    private MenuItem mntmShowDescription;
    private MenuItem mntmIgnoreIssue;
    private TreeViewer treeViewer;
    private Tree tree;
    private TreeViewer issuesTreeViewer;
    private Tree issuesTree;
    ToolTip issueTooltip = null;
    private Text mainMessage;
    private Button saveAndCloseButton;
    private Composite continueNoteComposite;
    private SashForm sashForm;
    private MenuItem mntmAddDevice;
    private boolean _checkIssue = false;
    private boolean _pdtContainsIssue = false;
    private boolean _pdtContainsCriticalIssue = false;
    private boolean _isInvalidPdt = false;
    private boolean _check_invalid_pdt = false;

    public MainWindow(boolean autoExportXml) {
        this._autoExportXml = autoExportXml;
        PdtFile pdtFile = new PdtFile("");
        pdtFile.setPath(null);
        DataStore.getInstance().addPdtFile(pdtFile);
    }

    public MainWindow(String inputPath, String outputPath, boolean silentValidation, boolean autoExportXml) throws Exception {
        this._silentValidation = silentValidation;
        this._autoExportXml = autoExportXml;
        if (inputPath != null) {
            File inputFile = new File(inputPath);
            if (inputFile == null || !inputFile.exists()) {
                throw new Exception("Invalid input path");
            }
            this._argsGivenInputPath = inputPath;
        }
        if (outputPath != null) {
            this._isArgsGivenOutputPath = true;
        }
        DataStore.getInstance().addPdtFile(new PdtFile(outputPath));
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow window = new MainWindow(false);
                    window.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void loadEditor() {
        if (this._argsGivenInputPath != null) {
            this.loadFrom(this._argsGivenInputPath, false);
        }
        final PdtFile preImportPdt = this._dataStore.getCurrentPdtFile().clone();
        if (this._importExternalFilesPath != null) {
            this.importSensors(this._importExternalFilesPath, this._keepOnlyImportedSensors);
        }
        if (this._dataStore.getCurrentPdtFile() != null) {
            if (this._sensorFilteringXmlPath != null) {
                try {
                    this._dataStore.getCurrentPdtFile().filterSensors(this._sensorFilteringXmlPath);
                }
                catch (Exception e) {
                    System.err.println("Cannot filter the sensors: " + e.getMessage());
                }
            }
            this._dataStore.getCurrentPdtFile().checkValidity();
            if (this._check_invalid_pdt) {
                throw new CancellationException();
            }
            if (this._checkIssue) {
                if (this._dataStore.getCurrentPdtFile().hasCriticalIssues()) {
                    this._pdtContainsCriticalIssue = true;
                } else if (this._dataStore.getCurrentPdtFile().hasActiveIssues()) {
                    this._pdtContainsIssue = true;
                }
                throw new CancellationException();
            }
            if (this._silentValidation && !this._dataStore.getCurrentPdtFile().hasActiveIssues()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.quickSave();
                    }
                });
                throw new CancellationException();
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MainWindow.this._dataStore.getCurrentPdtFile() != null && !MainWindow.this._dataStore.getCurrentPdtFile().equals(preImportPdt)) {
                    MainWindow.this.setModified();
                }
                MainWindow.this.refresh();
                if (MainWindow.this._silentValidation) {
                    MainWindow.this.mainMessage.setText("The following issues may require your attention. Click 'Continue' when you are ready to proceed.\nTo resolve an issue, select an item with an error, warning, or information icon, and read the details in the Issues pane below.");
                    MainWindow.this.tree.setSize(((MainWindow)MainWindow.this).tree.getSize().x, ((MainWindow)MainWindow.this).tree.getSize().y - ((MainWindow)MainWindow.this).mainMessage.getSize().y);
                    MainWindow.this.tree.setLocation(((MainWindow)MainWindow.this).tree.getLocation().x, ((MainWindow)MainWindow.this).tree.getLocation().y + ((MainWindow)MainWindow.this).mainMessage.getSize().y);
                    ((GridData)((MainWindow)MainWindow.this).mainMessage.getLayoutData()).exclude = false;
                    MainWindow.this.saveAndCloseButton.setText("Continue");
                }
                if (MainWindow.this._isArgsGivenOutputPath) {
                    MainWindow.this.mntmSaveAs.setEnabled(false);
                }
                MainWindow.this.updateStatus("");
            }
        });
    }

    public void open() {
        this._dataStore = DataStore.getInstance();
        this.display = Display.getDefault();
        this.createContents();
        try {
            InformationStore.verifyMandatoryFiles();
        }
        catch (FileNotFoundException e) {
            MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 33);
            messageBox.setText("Missing files");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        LoadingWindow.Task task = new LoadingWindow.Task("Initializing"){

            @Override
            public void process() {
                try {
                    MainWindow.this.loadEditor();
                }
                catch (CancellationException e) {
                    this.setSuccess(false);
                    return;
                }
            }
        };
        LoadingWindow.instance().runTask(task);
        if (!task.isSuccessfull()) {
            return;
        }
        this.treeViewer.expandAll();
        this.shlIntelrIsh.open();
        this.shlIntelrIsh.forceActive();
        while (!this.shlIntelrIsh.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void setImportProperties(String importExternalFilesPath, boolean keepOnlyImportedSensors) {
        if (!IMPORT_POSSIBLE && importExternalFilesPath != null) {
            System.err.println("Error: Install the Intel(R) ISS FDK in order to enable sensor importing.");
            return;
        }
        this._importExternalFilesPath = importExternalFilesPath;
        this._keepOnlyImportedSensors = keepOnlyImportedSensors;
    }

    public void setSensorFilteringProperties(String sensorFilteringPath) {
        this._sensorFilteringXmlPath = sensorFilteringPath;
    }

    @Override
    public void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.fillData();
                String windowTitle = MainWindow.WINDOW_TITLE_TEXT;
                if (MainWindow.this._dataStore.getCurrentPdtFile() != null && MainWindow.this._dataStore.getCurrentPdtFile().getDisplayedPath().length() > 0) {
                    windowTitle = windowTitle + " - " + MainWindow.this._dataStore.getCurrentPdtFile().getDisplayedPath();
                }
                MainWindow.this.shlIntelrIsh.setText(windowTitle);
                boolean enableBdt = MainWindow.this._dataStore.getPdtFormatVersion() >= 4;
                MainWindow.this.mntmBdt.setEnabled(enableBdt);
                MainWindow.this.mntmManageIcBoard.setEnabled(enableBdt);
                MainWindow.this.mntmHostInterfaceheci.setEnabled(enableBdt);
                MainWindow.this.mntmManageFormFactor.setEnabled(enableBdt);
                MainWindow.this.mntmManageCustomDataEntry.setEnabled(enableBdt);
                MainWindow.this.refreshEnablement();
            }
        });
    }

    @Override
    public void setModified() {
        this._modified = true;
        this.updateStatus("Unsaved Changes.");
    }

    public void updateStatus(String status) {
        String text = status;
        String addition = "";
        if (this._dataStore.getCurrentPdtFile() != null) {
            if (this._dataStore.getCurrentPdtFile().getDevices().size() >= 6) {
                addition = addition + (addition.length() > 0 ? " | " : "") + "The maximum " + 6 + " devices has been reached";
            }
            if (this._dataStore.getCurrentPdtFile().getAllSensors().size() >= 64) {
                addition = addition + (addition.length() > 0 ? " | " : "") + "The maximum " + 64 + " sensors has been reached.";
            }
            if (this._dataStore.getCurrentPdtFile().getPath() != null && !this._dataStore.getCurrentPdtFile().getPath().isEmpty()) {
                addition = addition + (addition.length() > 0 ? " | " : "") + "Saving Destination: " + this._dataStore.getCurrentPdtFile().getPath();
            }
        }
        if (!addition.isEmpty()) {
            text = text + (status != null && status.length() > 0 ? " | " : "") + addition;
        }
        this.statusBar.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(String path, boolean refresh) {
        String oldPath = this._dataStore.getCurrentPdtFile().getPath();
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.enableTables(false);
                }
            });
            try {
                this.clearDataAndCreatePdt(false);
                System.out.println("Loading files: " + path);
                if (NvarPackage.isNVARPackage(path)) {
                    DataStore.getInstance().clearData();
                    if (this._autoExportXml) {
                        DataStore.getInstance().setNVARPackageXml(path);
                    }
                    DataStore.getInstance().loadNVARPAckage(path);
                    if (DataStore.getInstance().getCurrentPdtFile() == null) {
                        throw new Exception("Bad PDT file");
                    }
                } else {
                    this._dataStore.getCurrentPdtFile().setPath(path);
                    if (this._autoExportXml) {
                        this._dataStore.setXmlDestPath(new File(path + ".xml"));
                    }
                    this._dataStore.loadFromPdtBin(this._dataStore.getCurrentPdtFile());
                    DbgConfig dbgConf = new DbgConfig();
                    dbgConf.setBinPath(this._dataStore.getCurrentPdtFile().getDirectoryPath() + File.separator + dbgConf.getFileName());
                    if (this._autoExportXml) {
                        dbgConf.setXmlPath(dbgConf.getBinPath() + ".xml");
                    }
                    if (dbgConf.fileExists()) {
                        this._dataStore.loadDebugConfig(dbgConf);
                    }
                }
            }
            catch (FeatureNotSupportedYetException e) {
                this.clearDataAndCreatePdt(true);
                if (!this._check_invalid_pdt) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String message = "Your version of the PDT Editor is older than the one that was used to create this PDT binary file. You will need to open it using a newer version.";
                            System.err.println("Your version of the PDT Editor is older than the one that was used to create this PDT binary file. You will need to open it using a newer version. Object: " + e.getThrowingObject());
                            MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 33);
                            messageBox.setText("Loading failure");
                            messageBox.setMessage("Your version of the PDT Editor is older than the one that was used to create this PDT binary file. You will need to open it using a newer version.");
                            messageBox.open();
                        }
                    });
                } else {
                    this._isInvalidPdt = true;
                }
                throw new CancellationException(e.getMessage());
            }
            catch (UnsupportedOperationException e) {
                this.clearDataAndCreatePdt(true);
                if (!this._check_invalid_pdt) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            System.err.println(e.getMessage());
                            MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 33);
                            messageBox.setText("Loading failure");
                            messageBox.setMessage(e.getMessage());
                            messageBox.open();
                        }
                    });
                } else {
                    this._isInvalidPdt = true;
                }
                throw new CancellationException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.clearDataAndCreatePdt(true);
                if (!this._check_invalid_pdt) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            System.err.println("Cannot load and parse the specified file. Loading failed.");
                            MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 33);
                            messageBox.setText("PDT loading failure");
                            messageBox.setMessage("Cannot load and parse the specified file. Loading failed.");
                            messageBox.open();
                        }
                    });
                } else {
                    this._isInvalidPdt = true;
                }
                throw new CancellationException(e.getMessage());
            }
            this._modified = false;
            if (path.toLowerCase().endsWith(".pdttemplate") || this._isArgsGivenOutputPath) {
                this._dataStore.getCurrentPdtFile().setPath(oldPath);
            }
            if (!DataStore.getInstance().isPdtFormatVersionSupportEditing()) {
                Display.getDefault().syncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 200);
                        messageBox.setText("Old PDT Format");
                        messageBox.setMessage("The PDT file that you are attempting to load is of an old format  (version " + DataStore.getInstance().getPdtFormatVersion() + ") and cannot be displayed using this editor. Would you like to upgrade the file to the newest format (" + 5 + ") so it can be loaded?");
                        if (messageBox.open() == 64) {
                            File logFile = new File("PDT_Upgrade_log.txt");
                            DataStore.FlowResults upgradeResults = new DataStore.FlowResults();
                            try {
                                Logger.instance().setFlow(Logger.Flow.PDT_FORMAT_UPGRADE);
                                DataStore.getInstance().setPdtFormatVersion(5, upgradeResults);
                                if (upgradeResults.hasErrors) {
                                    messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 33);
                                    messageBox.setText("Upgrade results");
                                    messageBox.setMessage("The format upgrade has been completed, but errors occurred. See the log at: " + logFile.getAbsolutePath());
                                    messageBox.open();
                                    return;
                                }
                                if (!upgradeResults.hasWarnings) return;
                                messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 40);
                                messageBox.setText("Upgrade results");
                                messageBox.setMessage("The format upgrade has been completed, but changes have been made that require your attention. See the warnings in the log at: " + logFile.getAbsolutePath());
                                messageBox.open();
                                return;
                            }
                            finally {
                                try {
                                    Logger.instance().exportToFile(logFile, Logger.Column.DATE.value() | Logger.Column.LOG_LEVEL.value() | Logger.Column.COMPONENT.value() | Logger.Column.MESSAGE.value());
                                }
                                catch (Exception e) {
                                    System.err.println("Failed to produce the format upgrade log.");
                                    e.printStackTrace();
                                    MainWindow.this.setModified();
                                }
                                finally {
                                    Logger.instance().endFlow();
                                }
                            }
                        }
                        MainWindow.this.clearDataAndCreatePdt(true);
                        MainWindow.this.treeViewer.expandAll();
                    }
                });
            }
            if (refresh) {
                this.refresh();
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.treeViewer.expandAll();
                    MainWindow.this.updateStatus("Loaded.");
                }
            });
        }
        catch (Throwable throwable) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.enableTables(true);
                }
            });
            throw throwable;
        }
        Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
    }

    private void preLoadingActions() {
        if (this._modified) {
            MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 296);
            messageBox.setText("Modified PDT file");
            messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
            int msgRes = messageBox.open();
            if (msgRes == 256) {
                throw new CancellationException();
            }
        }
        ArrayList<SensorModifier> modifiers = new ArrayList<SensorModifier>(this._openedwindows);
        for (SensorModifier modifier : modifiers) {
            modifier.shlSensorModifier.close();
            if (modifier.shlSensorModifier.isDisposed()) continue;
            return;
        }
    }

    public void loadPDT() {
        try {
            this.preLoadingActions();
        }
        catch (CancellationException e) {
            return;
        }
        FileDialog fd = new FileDialog(this.shlIntelrIsh, 4096);
        fd.setText("Load files");
        File savedWorkingDir = UserPreferences.getInstance().getWorkingDirectory();
        fd.setFilterPath(this._dataStore.getCurrentPdtFile() != null && this._dataStore.getCurrentPdtFile().getPath() != null ? this._dataStore.getCurrentPdtFile().getDirectoryPath() : (savedWorkingDir != null ? savedWorkingDir.getAbsolutePath() : "."));
        String[] filterExt = new String[]{"*.pdtTemplate; *.bin; *.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            this.loadFrom(path, true);
        }
        catch (CancellationException e) {
            return;
        }
        UserPreferences.getInstance().setWorkingDirectory(path);
    }

    private void writeDebugConfigData(DbgConfig dbgConf) throws AccessDeniedException, TransformerException {
        if (dbgConf != null) {
            System.out.println("Saving debug configurations...");
            dbgConf.setBinPath(this._dataStore.getCurrentPdtFile().getDirectoryPath() + File.separator + dbgConf.getFileName());
            if (this._autoExportXml) {
                dbgConf.setXmlPath(dbgConf.getBinPath() + ".xml");
            }
            dbgConf.writeDbgConfig();
        } else {
            dbgConf = new DbgConfig();
            String defaultBinPath = this._dataStore.getCurrentPdtFile().getDirectoryPath() + File.separator + "trace_config";
            dbgConf.setBinPath(defaultBinPath);
            if (dbgConf.fileExists()) {
                MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 194);
                messageBox.setText("Existing Debug Configuration File");
                messageBox.setMessage("Your current settings do not include a debug configuration, but the selected folder contains such a file. Would you like to delete it?");
                if (messageBox.open() == 64) {
                    new File(defaultBinPath).delete();
                }
            }
        }
    }

    private void saveFiles() {
        if (this._dataStore.getCurrentPdtFile().getPath() == null || this._dataStore.getCurrentPdtFile().getPath().isEmpty()) {
            return;
        }
        try {
            this._dataStore.getCurrentPdtFile().saveAllIgnoredIssues();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            boolean savingToNvarPackage = NvarPackage.isNVARPackage(this._dataStore.getCurrentPdtFile().getPath());
            if (this._autoExportXml) {
                this._dataStore.setXmlDestPath(new File(this._dataStore.getCurrentPdtFile().getPath() + ".xml"));
            }
            DbgConfig dbgConfig = DataStore.getInstance().getDbgConfigData();
            NvarPackage nvarPackage = new NvarPackage();
            nvarPackage.setPdtGivenName(this._dataStore.getCurrentPdtFile().getPDTName());
            if (savingToNvarPackage) {
                nvarPackage.setBinPath(this._dataStore.getCurrentPdtFile().getPath());
            } else {
                this._dataStore.saveToPdtBin(this._dataStore.getCurrentPdtFile());
                this.writeDebugConfigData(dbgConfig);
                nvarPackage.setBinPath(this._dataStore.getCurrentPdtFile().getDirectoryPath() + File.separator + nvarPackage.getFileName());
            }
            BinWriter pdtWriter = new BinWriter(true, "ISH");
            new PdtWriter(pdtWriter, this._dataStore.getCurrentPdtFile()).writePdtContent();
            Element headElement = pdtWriter.getHeadElement();
            if (dbgConfig != null) {
                nvarPackage.setDebugConfContent(dbgConfig.getBinaryContent());
                Element dbgHeadElement = dbgConfig.getBinWriter().getHeadElement();
                if (headElement != null) {
                    NodeList nlDbgChildElements = dbgHeadElement.getChildNodes();
                    for (int i = 0; i < nlDbgChildElements.getLength(); ++i) {
                        Node newChild = headElement.getOwnerDocument().importNode(nlDbgChildElements.item(i), true);
                        headElement.appendChild(newChild);
                    }
                }
            }
            nvarPackage.setPdtContent(this._dataStore.getCurrentPdtFile().getPdtBinaryContent());
            nvarPackage.writeNvarPackage(headElement, this._autoExportXml);
            this._modified = false;
            this.updateStatus("Saved.");
        }
        catch (AccessDeniedException e) {
            System.err.println("Saving failed: " + e.getMessage());
            MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 33);
            messageBox.setText("Saving failure");
            messageBox.setMessage("Please check if the PDT file is read-only.");
            messageBox.open();
            throw new CancellationException("Saving was canceled by user.");
        }
        catch (UnsupportedOperationException e) {
            System.err.println("Saving failed: " + e.getMessage());
            MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 33);
            messageBox.setText("Saving failure");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        catch (Exception e) {
            System.err.println("Saving failed: " + e.getMessage());
            MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 33);
            messageBox.setText("Saving failure");
            messageBox.setMessage("Saving failed");
            messageBox.open();
            return;
        }
    }

    private void saveFilesAs() {
        FileDialog fd = new FileDialog(this.shlIntelrIsh, 8192);
        fd.setText("Save As");
        File savedWorkingDir = UserPreferences.getInstance().getWorkingDirectory();
        fd.setFilterPath(this._dataStore.getCurrentPdtFile() != null && this._dataStore.getCurrentPdtFile().getPath() != null ? this._dataStore.getCurrentPdtFile().getDirectoryPath() : (savedWorkingDir != null ? savedWorkingDir.getAbsolutePath() : "."));
        String[] filterExt = new String[]{"*.bin; *.*"};
        fd.setFilterExtensions(filterExt);
        String path = null;
        while (path == null) {
            MessageBox messageBox;
            path = fd.open();
            if (path == null || path.isEmpty()) {
                throw new CancellationException("Saving was canceled by user.");
            }
            File newFile = new File(path);
            if (newFile.getName().equals("trace_config")) {
                messageBox = new MessageBox(this.shlIntelrIsh, 289);
                messageBox.setText("Invalid Filename");
                messageBox.setMessage("The filename you entered is reserved. Please choose another.");
                path = null;
                if (messageBox.open() != 32) {
                    return;
                }
            }
            try {
                if (!newFile.isFile() || !NvarPackage.isNVARPackage(path)) continue;
                messageBox = new MessageBox(this.shlIntelrIsh, 296);
                messageBox.setText("Warning");
                messageBox.setMessage("You are currently saving a PDT binary file, but the file you selected is an NVAR package. If you continue, the NVAR package will be overwritten; you will be able to find your new NVAR package in the same folder, under the name '" + NvarPackage.getFileName(newFile.getName().substring(0, newFile.getName().lastIndexOf(".bin"))));
                if (messageBox.open() != 32) {
                    path = null;
                }
                newFile.delete();
            }
            catch (Exception e) {
                return;
            }
        }
        this._dataStore.getCurrentPdtFile().setPath(path);
        this.saveFiles();
        this.refresh();
        UserPreferences.getInstance().setWorkingDirectory(path);
    }

    private void quickSave() {
        if (this._dataStore.getCurrentPdtFile().getPath() == null || this._dataStore.getCurrentPdtFile().getPath().isEmpty()) {
            this.saveFilesAs();
        } else {
            this.saveFiles();
        }
    }

    public void clearDataAndCreatePdt(boolean refresh) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.tree.removeAll();
                MainWindow.this.issuesTree.removeAll();
                MainWindow.this._dataStore.clearData();
                PdtFile pdtFile = new PdtFile("");
                pdtFile.setPath(null);
                MainWindow.this._dataStore.addPdtFile(pdtFile);
                MainWindow.this._dataStore.createNewDefaultDevice();
            }
        });
        if (refresh) {
            this.refresh();
        }
    }

    public void enableTables(boolean enabled) {
        this.tree.setEnabled(enabled);
        this.issuesTree.setEnabled(enabled);
    }

    @Override
    public void onSensorModifierClose(SensorModifier modifier) {
        this._openedwindows.remove(modifier);
    }

    private SensorModifier getOpenedSensorModifier(Sensor sensor) {
        for (int i = 0; i < this._openedwindows.size(); ++i) {
            SensorModifier modifier = this._openedwindows.get(i);
            if (modifier.getSensor() == null || !modifier.getSensor().equals(sensor)) continue;
            return modifier;
        }
        return null;
    }

    private void openSensorModifiers(ArrayList<Sensor> sensors) {
        if (sensors == null || sensors.size() == 0) {
            return;
        }
        for (Sensor sensor : sensors) {
            SensorModifier modifier = this.getOpenedSensorModifier(sensor);
            if (modifier != null) {
                modifier.shlSensorModifier.setFocus();
                continue;
            }
            modifier = new SensorModifier(this, this._dataStore.getDevicesOfSensor(sensor).get(0), sensor, false);
            this._openedwindows.add(modifier);
            this.treeSelectedActions();
            modifier.open();
        }
    }

    private void selectItem(Object object) {
        this.tree.deselectAll();
        StructuredSelection toSelect = new StructuredSelection(object);
        this.treeViewer.setSelection((ISelection)toSelect, true);
        this.treeSelectedActions();
    }

    private void addNewDevice() {
        Device newDevice = this._dataStore.createNewDefaultDevice();
        this.setModified();
        this.refresh();
        this.selectItem(newDevice);
    }

    private void addNewPhysicalSensor() {
        if (this._dataStore.getCurrentDevice() == null) {
            return;
        }
        SensorModifier modifier = new SensorModifier(this, this._dataStore.getCurrentDevice(), true, null, false);
        this._openedwindows.add(modifier);
        modifier.open();
    }

    private void addNewVirtualSensor() {
        if (this._dataStore.getCurrentDevice() == null) {
            return;
        }
        SensorModifier modifier = new SensorModifier(this, this._dataStore.getCurrentDevice(), false, null, false);
        this._openedwindows.add(modifier);
        modifier.open();
    }

    private void updateCurrentDevice() {
        Device currentDevice = null;
        ArrayList<Sensor> selectedSensors = this.getSelectedSensors();
        ArrayList<Device> selectedDevices = this.getSelectedDevices();
        if (selectedDevices != null) {
            if (selectedDevices.size() == 1) {
                currentDevice = selectedDevices.get(0);
            } else if (selectedDevices.size() > 1) {
                this._dataStore.setCurrentDevice(null);
                return;
            }
        }
        if (selectedSensors.size() > 0) {
            for (Sensor sensor : selectedSensors) {
                for (Device dev : DataStore.getInstance().getDevicesOfSensor(sensor)) {
                    if (currentDevice != null && !dev.equals(currentDevice)) {
                        this._dataStore.setCurrentDevice(null);
                        return;
                    }
                    currentDevice = dev;
                }
            }
        }
        this._dataStore.setCurrentDevice(currentDevice);
    }

    private TreeItem getTreeItemOfObjectHelper(TreeItem parent, Object object) {
        for (TreeItem item : parent.getItems()) {
            if (item.getData().equals(object)) {
                return item;
            }
            TreeItem subObjectItem = this.getTreeItemOfObjectHelper(item, object);
            if (subObjectItem == null) continue;
            return subObjectItem;
        }
        return null;
    }

    public TreeItem getTreeItemOfObject(Object object) {
        return this.getTreeItemOfObjectHelper(this.tree.getTopItem(), object);
    }

    private ArrayList<Device> getSelectedDevices() {
        ArrayList<Device> res = new ArrayList<Device>();
        for (TreeItem item : this.tree.getSelection()) {
            if (item.getData() instanceof PdtFile) {
                res.addAll(((PdtFile)item.getData()).getDevices());
            }
            if (!(item.getData() instanceof Device)) continue;
            res.add((Device)item.getData());
        }
        return res;
    }

    private ArrayList<Sensor> getSelectedSensors() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        for (TreeItem item : this.tree.getSelection()) {
            if (item.getData() instanceof PdtFile) {
                res.addAll(((PdtFile)item.getData()).getAllSensors());
                continue;
            }
            if (item.getData() instanceof Device) {
                res.addAll(((Device)item.getData()).getSensors());
                continue;
            }
            if (!(item.getData() instanceof Sensor)) continue;
            res.add((Sensor)item.getData());
        }
        return res;
    }

    private void setAddSensorsEnablment() {
        boolean addingSensorEnabled;
        boolean bl = addingSensorEnabled = this._dataStore.getCurrentPdtFile().getAllSensors().size() < 64 && DataStore.getInstance().getCurrentDevice() != null;
        if (this.mntmAddPhysicalSensor != null && !this.mntmAddPhysicalSensor.isDisposed()) {
            this.mntmAddPhysicalSensor.setEnabled(addingSensorEnabled);
        }
        if (this.mntmTreeRightAddPhysical != null && !this.mntmTreeRightAddPhysical.isDisposed()) {
            this.mntmTreeRightAddPhysical.setEnabled(addingSensorEnabled);
        }
        if (this.mntmAddVirtualSensor != null && !this.mntmAddVirtualSensor.isDisposed()) {
            this.mntmAddVirtualSensor.setEnabled(addingSensorEnabled);
        }
        if (this.mntmTreeRightAddVirtual != null && !this.mntmTreeRightAddVirtual.isDisposed()) {
            this.mntmTreeRightAddVirtual.setEnabled(addingSensorEnabled);
        }
        if (this.mntmImportSensor != null && !this.mntmImportSensor.isDisposed()) {
            this.mntmImportSensor.setEnabled(IMPORT_POSSIBLE && addingSensorEnabled);
        }
        if (this.mntmTreeRightImportSensor != null && !this.mntmTreeRightImportSensor.isDisposed()) {
            this.mntmTreeRightImportSensor.setEnabled(IMPORT_POSSIBLE && addingSensorEnabled);
        }
    }

    private void setAddDeviceEnablment() {
        boolean addDeviceEnabled;
        boolean bl = addDeviceEnabled = this._dataStore.getCurrentPdtFile().getDevices().size() < 6;
        if (this.mntmAddDevice != null && !this.mntmAddDevice.isDisposed()) {
            this.mntmAddDevice.setEnabled(addDeviceEnabled);
        }
        if (this.mntmTreeRightAddDevice != null && !this.mntmTreeRightAddDevice.isDisposed()) {
            this.mntmTreeRightAddDevice.setEnabled(addDeviceEnabled);
        }
    }

    private void setEditEnablment() {
        boolean editEnabled;
        boolean bl = editEnabled = this.tree.getSelectionCount() == 1 && this.tree.getSelection()[0].getData() != null && (this.tree.getSelection()[0].getData() instanceof Sensor || this.tree.getSelection()[0].getData() instanceof Device);
        if (this.mntmTreeRightModify != null && !this.mntmTreeRightModify.isDisposed()) {
            this.mntmTreeRightModify.setEnabled(editEnabled);
        }
    }

    private void setMoveToDeviceEnablement(boolean allowEnable) {
        boolean moveToDeviceEnabled;
        boolean bl = moveToDeviceEnabled = allowEnable && this.getSelectedSensors().size() > 0 && this._dataStore.getCurrentPdtFile() != null && this._dataStore.getCurrentPdtFile().getDevices() != null && this._dataStore.getCurrentPdtFile().getDevices().size() > 1;
        if (this.mntmTreeRightMoveDevice != null && !this.mntmTreeRightMoveDevice.isDisposed()) {
            this.mntmTreeRightMoveDevice.setEnabled(moveToDeviceEnabled);
        }
    }

    private void setCloneEnablement() {
        boolean cloneEnabled;
        boolean bl = cloneEnabled = this.getSelectedSensors().size() == 1 && this._dataStore.getCurrentPdtFile().getAllSensors().size() < 64;
        if (this.mntmTreeRightCloneSensor != null && !this.mntmTreeRightCloneSensor.isDisposed()) {
            this.mntmTreeRightCloneSensor.setEnabled(cloneEnabled);
        }
    }

    private void refreshEnablement() {
        this.setAddSensorsEnablment();
        this.setAddDeviceEnablment();
        if (this.mntmRestoreIgnored != null && !this.mntmRestoreIgnored.isDisposed()) {
            this.mntmRestoreIgnored.setEnabled(this._dataStore.getCurrentPdtFile() != null && this._dataStore.getCurrentPdtFile().hasIgnoredIssues());
        }
        if (this.mntmCalibration != null && !this.mntmCalibration.isDisposed()) {
            this.mntmCalibration.setEnabled(this._dataStore.getCurrentDevice() != null && this._dataStore.getCurrentDevice().getSensors().size() > 0);
        }
        try {
            if (DataStore.getInstance().getPDTExternalInfo() != null) {
                PDTExternalInfo.ExternalPreferences externalPreferences = DataStore.getInstance().getPDTExternalInfo().loadExternalPreferences();
                boolean continueEnabled = DataStore.getInstance().getRunType() != DataStore.RunType.FDK_RUN_PROJECT || !DataStore.getInstance().getCurrentPdtFile().hasCriticalIssues() || DataStore.getInstance().getPDTExternalInfo() != null && externalPreferences != null && externalPreferences.allowContinueOnCritical;
                this.saveAndCloseButton.setEnabled(continueEnabled);
                this.continueNoteComposite.setToolTipText(continueEnabled ? "" : "You cannot continue until all critical issues have been resolved.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.getSelectedSensors().size() + this.getSelectedDevices().size() <= 0) {
            this.setDeleteEnablement(false);
            if (this.mntmTreeRightDelete != null && !this.mntmTreeRightDelete.isDisposed()) {
                this.mntmTreeRightDelete.setEnabled(false);
            }
            if (this.mntmTreeRightModify != null && !this.mntmTreeRightModify.isDisposed()) {
                this.mntmTreeRightModify.setEnabled(false);
            }
            if (this.mntmTreeRightMoveDevice != null && !this.mntmTreeRightMoveDevice.isDisposed()) {
                this.mntmTreeRightMoveDevice.setEnabled(false);
            }
            if (this.mntmTreeRightCloneSensor != null && !this.mntmTreeRightCloneSensor.isDisposed()) {
                this.mntmTreeRightCloneSensor.setEnabled(false);
            }
            return;
        }
        boolean windowOpened = false;
        block2: for (int i = 0; i < this._openedwindows.size(); ++i) {
            SensorModifier modifier = this._openedwindows.get(i);
            if (modifier == null) continue;
            for (int j = 0; j < this.getSelectedSensors().size(); ++j) {
                if (modifier.getSensor() == null || !modifier.getSensor().equals(this.getSelectedSensors().get(j))) continue;
                windowOpened = true;
                continue block2;
            }
        }
        boolean allDevicesSelected = this.getSelectedDevices().size() == this._dataStore.getCurrentPdtFile().getDevices().size();
        this.setDeleteEnablement(!windowOpened && !allDevicesSelected);
        this.setEditEnablment();
        this.setMoveToDeviceEnablement(!windowOpened);
        this.setCloneEnablement();
    }

    private void fixSelectedIssue() {
        Issue issue;
        if (this.issuesTree.getSelectionCount() != 1) {
            return;
        }
        TreeItem item = this.issuesTree.getSelection()[0];
        if (item.getData() instanceof Issue && (issue = (Issue)item.getData()).hasFixer()) {
            SensorModifier openedModifier;
            Sensor modifiedSensor = issue.fixer.getModifiedSensor();
            if (modifiedSensor != null && (openedModifier = this.getOpenedSensorModifier(modifiedSensor)) != null) {
                MessageBox messageBox = new MessageBox(openedModifier.shlSensorModifier, 33);
                messageBox.setText("Already Open");
                messageBox.setMessage("The Sensor Modifier window needed to address this issue is already open. Close the window and try again.");
                messageBox.open();
                return;
            }
            issue.fixer.fix();
            this._dataStore.getCurrentPdtFile().checkValidity();
            this.shapeIssuesTreeItems(this.issuesTree.getTopItem());
            this.refreshIssuesTree();
        }
        this.refresh();
    }

    public void shapeIssueItem(TreeItem item) {
        Font defaultFont;
        Color foreColor;
        if (item.getData() == null || !(item.getData() instanceof Issue)) {
            return;
        }
        Issue issue = (Issue)item.getData();
        ArrayList<Issue> allIgnoredIssues = this._dataStore.getCurrentPdtFile().getAllIgnoredIssues();
        if (!this._dataStore.getCurrentPdtFile().getAllIssues().contains(issue)) {
            foreColor = new Color((org.eclipse.swt.graphics.Device)Display.getCurrent(), 160, 160, 160);
            issue.fixer = null;
            item.setForeground(foreColor);
            FontData fontData = new FontData("Arial", 9, 2);
            defaultFont = new Font((org.eclipse.swt.graphics.Device)this.tree.getDisplay(), fontData);
            fontData.data.lfStrikeOut = 1;
            item.setFont(defaultFont);
        } else if (allIgnoredIssues != null && allIgnoredIssues.contains(issue)) {
            foreColor = new Color((org.eclipse.swt.graphics.Device)Display.getCurrent(), 192, 192, 192);
            defaultFont = new Font((org.eclipse.swt.graphics.Device)this.tree.getDisplay(), new FontData("Arial", 9, 2));
            item.setForeground(foreColor);
            item.setFont(defaultFont);
        } else {
            foreColor = new Color((org.eclipse.swt.graphics.Device)Display.getCurrent(), 0, 0, 0);
            item.setForeground(foreColor);
            FontData fontData = new FontData("Arial", 9, 0);
            fontData.data.lfStrikeOut = 0;
            defaultFont = new Font((org.eclipse.swt.graphics.Device)this.tree.getDisplay(), fontData);
            item.setFont(defaultFont);
        }
        foreColor.dispose();
        defaultFont.dispose();
    }

    public void shapeIssuesTreeItems(TreeItem parent) {
        if (parent == null) {
            return;
        }
        this.shapeIssueItem(parent);
        for (TreeItem item : parent.getItems()) {
            this.shapeIssuesTreeItems(item);
        }
    }

    public String getIssueDescription(TreeItem item) {
        String description = "";
        if (item.getData() instanceof Issue) {
            Issue issue = (Issue)item.getData();
            if (issue.description != null) {
                description = description + issue.description;
            }
            if (issue.hasFixer()) {
                description = description + "\n" + issue.fixer.getFixDescription();
            }
        }
        return description;
    }

    public void createIssuesRightClickMenu() {
        final Menu rightMenu = new Menu((Control)this.issuesTree);
        this.issuesTree.setMenu(rightMenu);
        rightMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = rightMenu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                if (MainWindow.this.issuesTree.getSelectionCount() == 1 && MainWindow.this.issuesTree.getSelection()[0].getData() != null && MainWindow.this.issuesTree.getSelection()[0].getData() instanceof Issue) {
                    Issue issue;
                    MainWindow.this.mntmFixIssue = new MenuItem(rightMenu, 0);
                    MainWindow.this.mntmFixIssue.setText("Fix Issue");
                    MainWindow.this.mntmFixIssue.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent arg0) {
                            MainWindow.this.fixSelectedIssue();
                        }

                        public void widgetDefaultSelected(SelectionEvent arg0) {
                        }
                    });
                    MainWindow.this.mntmShowDescription = new MenuItem(rightMenu, 0);
                    MainWindow.this.mntmShowDescription.setText("Show Description");
                    MainWindow.this.mntmShowDescription.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent arg0) {
                            if (MainWindow.this.issuesTree.getSelectionCount() != 1) {
                                return;
                            }
                            TreeItem item = MainWindow.this.issuesTree.getSelection()[0];
                            MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 34);
                            messageBox.setText("Issue Description");
                            messageBox.setMessage(MainWindow.this.getIssueDescription(item));
                            messageBox.open();
                        }

                        public void widgetDefaultSelected(SelectionEvent arg0) {
                        }
                    });
                    if (DataStore.getInstance().isFdkRun()) {
                        MainWindow.this.mntmIgnoreIssue = new MenuItem(rightMenu, 0);
                        MainWindow.this.mntmIgnoreIssue.setText("Ignore Issue");
                        MainWindow.this.mntmIgnoreIssue.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent arg0) {
                                MainWindow.this._dataStore.getCurrentPdtFile().ignoreIssue((Issue)MainWindow.this.issuesTree.getSelection()[0].getData());
                                MainWindow.this.shapeIssueItem(MainWindow.this.issuesTree.getSelection()[0]);
                                MainWindow.this.treeViewer.refresh();
                            }

                            public void widgetDefaultSelected(SelectionEvent arg0) {
                            }
                        });
                    }
                    MainWindow.this.mntmFixIssue.setEnabled(false);
                    MainWindow.this.mntmShowDescription.setEnabled(MainWindow.this.getIssueDescription(MainWindow.this.issuesTree.getSelection()[0]).length() > 0);
                    if (MainWindow.this.mntmIgnoreIssue != null) {
                        MainWindow.this.mntmIgnoreIssue.setEnabled(((Issue)MainWindow.this.issuesTree.getSelection()[0].getData()).isIgnorable());
                    }
                    if ((issue = (Issue)MainWindow.this.issuesTree.getSelection()[0].getData()).hasFixer()) {
                        MainWindow.this.mntmFixIssue.setEnabled(true);
                    } else {
                        MainWindow.this.mntmFixIssue.setText(MainWindow.this.mntmFixIssue.getText() + " (No Immediate Fix)");
                    }
                }
            }
        });
    }

    private void refreshIssuesTree() {
        if (this.issueTooltip != null) {
            this.issueTooltip.setVisible(false);
            this.issueTooltip = null;
        }
        ArrayList<IValidatable> selectedObjects = new ArrayList<IValidatable>();
        for (TreeItem selected : this.tree.getSelection()) {
            IValidatable object;
            if (!(selected.getData() instanceof IValidatable) || (object = (IValidatable)selected.getData()).getAllActiveIssues().size() <= 0) continue;
            selectedObjects.add(object);
        }
        this.issuesTreeViewer.setInput(selectedObjects);
        this.issuesTreeViewer.expandAll();
        this.createIssuesRightClickMenu();
        this.shapeIssuesTreeItems(this.issuesTree.getTopItem());
    }

    private void treeSelectedActions() {
        this.updateCurrentDevice();
        this.createRightClickMenuItem();
        this.refreshEnablement();
        this.refreshIssuesTree();
    }

    public void deleteSelected() {
        ArrayList<Sensor> selectedSensors = this.getSelectedSensors();
        ArrayList<Device> selectedDevices = this.getSelectedDevices();
        int selectedNum = selectedSensors.size() + selectedDevices.size();
        if (selectedNum == 0 || this.getSelectedDevices().size() >= this._dataStore.getCurrentPdtFile().getDevices().size()) {
            return;
        }
        MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 296);
        messageBox.setText("Deleting Items");
        String message = "Are you sure that you want to delete the selected item";
        if (selectedNum > 1) {
            message = message + "s";
        }
        message = message + "?";
        messageBox.setMessage(message);
        if (messageBox.open() != 32) {
            return;
        }
        this.tree.deselectAll();
        for (Device device : this._dataStore.getCurrentPdtFile().getDevices()) {
            for (Sensor sensor : selectedSensors) {
                device.removeSensor(sensor);
            }
        }
        for (Device device : selectedDevices) {
            this._dataStore.getCurrentPdtFile().removeDevice(device);
        }
        this._dataStore.setCurrentDevice(-1);
        this.treeViewer.remove(selectedSensors.toArray());
        this.treeViewer.remove(selectedDevices.toArray());
        this.issuesTreeViewer.setInput(null);
        this.refresh();
        this.setDeleteEnablement(false);
        this.setModified();
    }

    public void moveSensorsToDevice() {
        ArrayList<Sensor> selectedSensors = this.getSelectedSensors();
        if (selectedSensors == null || selectedSensors.size() == 0) {
            return;
        }
        new MoveSensors(this, selectedSensors).open();
        this.refresh();
    }

    public void openEditCalibrationWindow() {
        if (this._dataStore.getCurrentDevice() == null) {
            return;
        }
        ViewCalibrations calibWindow = new ViewCalibrations(this, this._dataStore.getCurrentDevice());
        calibWindow.open();
    }

    public void cloneSensor() {
        if (this._dataStore.getCurrentDevice() == null) {
            return;
        }
        ArrayList<Sensor> selectedSensors = this.getSelectedSensors();
        if (selectedSensors == null || selectedSensors.size() != 1 || selectedSensors.get(0) == null) {
            return;
        }
        Sensor selecterSensor = selectedSensors.get(0);
        SensorModifier modifier = new SensorModifier(this, this._dataStore.getCurrentDevice(), selecterSensor.getLuid().getIsPhysical(), selecterSensor.clone(), false);
        this._openedwindows.add(modifier);
        modifier.open();
    }

    public void editDevice(Device device) {
        new DeviceProperties(this.thisWindow, device).open();
    }

    public void editSensors() {
        ArrayList<Sensor> selectedSensors = this.getSelectedSensors();
        ArrayList<Device> selectedDevices = this.getSelectedDevices();
        if (selectedSensors == null || selectedDevices != null && selectedDevices.size() > 0 || selectedSensors.size() != 1) {
            return;
        }
        this.openSensorModifiers(selectedSensors);
    }

    private void onTreeDoubleClick(MouseEvent arg0) {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        if (this.tree.getSelection()[0].getData() instanceof Device) {
            this.editDevice((Device)this.tree.getSelection()[0].getData());
            return;
        }
        this.editSensors();
    }

    public void deviceSelected() {
        int selection = this.devicesCombo.getSelectionIndex();
        if (selection == this.devicesCombo.getItemCount() - 1 && this._dataStore.getCurrentPdtFile().getDevices().size() < 6) {
            MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 196);
            messageBox.setText("Creating a new device");
            messageBox.setMessage("You are about to create a new device. Do you want to continue?");
            if (messageBox.open() != 64) {
                return;
            }
            this._dataStore.createNewDefaultDevice();
            this.setModified();
        }
        this._dataStore.setCurrentDevice(selection);
        this.fillData();
        this.refresh();
    }

    public void fillData() {
        boolean isModified;
        DataStore.getInstance().getCurrentPdtFile().checkValidity();
        this.treeViewer.refresh();
        this.setDeleteEnablement(false);
        String statusBarText = this.statusBar.getText();
        this._modified = isModified = this._modified;
        this.statusBar.setText(statusBarText);
    }

    public void newFile() {
        if (this._modified) {
            MessageBox messageBox = new MessageBox(this.shlIntelrIsh, 296);
            messageBox.setText("Creating a new PDT file");
            messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
            if (messageBox.open() != 32) {
                return;
            }
        }
        try {
            this.closeAllSensorModifiers();
        }
        catch (CancellationException e) {
            return;
        }
        String _oldPath = this._dataStore.getCurrentPdtFile().getPath();
        this.clearDataAndCreatePdt(true);
        if (this._isArgsGivenOutputPath) {
            this._dataStore.getCurrentPdtFile().setPath(_oldPath);
        }
        this.setDeleteEnablement(false);
        this.refresh();
        this.treeViewer.expandAll();
        this._modified = false;
        this.updateStatus("New PDT file.");
    }

    public void setDeleteEnablement(boolean enable) {
        boolean enableItem;
        boolean bl = enableItem = this.getSelectedDevices().size() < this._dataStore.getCurrentPdtFile().getDevices().size() && enable;
        if (this.mntmDeleteSelected != null && !this.mntmDeleteSelected.isDisposed()) {
            this.mntmDeleteSelected.setEnabled(enableItem);
        }
        if (this.mntmTreeRightDelete != null && !this.mntmTreeRightDelete.isDisposed()) {
            this.mntmTreeRightDelete.setEnabled(enableItem);
        }
    }

    @Override
    public ArrayList<SensorModifier> getOpenedSensorModifiers() {
        return this._openedwindows;
    }

    @Override
    public void closeAllSensorModifiers() {
        ArrayList<SensorModifier> toClose = new ArrayList<SensorModifier>(this._openedwindows);
        for (SensorModifier modifier : toClose) {
            modifier.shlSensorModifier.close();
            if (modifier.shlSensorModifier.isDisposed()) continue;
            throw new CancellationException();
        }
    }

    @Override
    public void addSensor(Sensor sensor) {
        throw new UnsupportedOperationException();
    }

    public void importSensors(String input, boolean removeNonImportedSensors) {
        try {
            DataStore.getInstance().importSensors(input, removeNonImportedSensors, this._dataStore.getCurrentPdtFile(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 33);
                    messageBox.setText("Sensor Importing Failure");
                    String msg = "Failed to load the sensors from the given path";
                    if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                        msg = msg + ": " + e.getMessage();
                    }
                    messageBox.setMessage(msg);
                    messageBox.open();
                }
            });
        }
    }

    public void importSensor(boolean singleFile) {
        FileDialog dialog;
        String filterPath;
        String[] path = null;
        File savedWorkingDir = UserPreferences.getInstance().getWorkingDirectory();
        String string = this._dataStore.getCurrentPdtFile() != null && this._dataStore.getCurrentPdtFile().getPath() != null ? this._dataStore.getCurrentPdtFile().getDirectoryPath() : (filterPath = savedWorkingDir != null ? savedWorkingDir.getAbsolutePath() : ".");
        if (singleFile) {
            dialog = new FileDialog(this.shlIntelrIsh, 2);
            dialog.setText("Import Sensor");
            dialog.setFilterPath(filterPath);
            String[] filterExt = new String[]{"*.o"};
            dialog.setFilterExtensions(filterExt);
            String firstFile = dialog.open();
            if (firstFile != null) {
                path = dialog.getFileNames();
            }
            if (path == null || path.length == 0) {
                return;
            }
            for (int i = 0; i < path.length; ++i) {
                path[i] = dialog.getFilterPath() + File.separator + path[i];
            }
        } else {
            dialog = new DirectoryDialog(this.shlIntelrIsh, 4096);
            dialog.setText("Import Sensor");
            dialog.setFilterPath(filterPath);
            path = new String[]{dialog.open()};
            if (path[0] == null || path[0].isEmpty()) {
                return;
            }
        }
        for (int i = 0; i < path.length; ++i) {
            this.importSensors(path[i], false);
        }
        this.setModified();
        this.refresh();
        UserPreferences.getInstance().setWorkingDirectory(path[0]);
    }

    public void changeSensorLocation(boolean down) {
        Device device = this._dataStore.getCurrentDevice();
        ArrayList<Sensor> selectedSensors = this.getSelectedSensors();
        if (selectedSensors.size() != 1) {
            return;
        }
        Sensor selectedSensor = this.getSelectedSensors().get(0);
        device.moveSensor(selectedSensor, down ? 1 : -1);
        this.refresh();
    }

    public void createRightClickMenuItem() {
        final Menu rightMenu = new Menu((Control)this.tree);
        this.tree.setMenu(rightMenu);
        rightMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = rightMenu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                MainWindow.this.mntmTreeRightModify = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightModify.setText("Edit Item");
                MainWindow.this.mntmTreeRightModify.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        if (MainWindow.this.tree.getSelectionCount() == 1) {
                            if (MainWindow.this.tree.getSelection()[0].getData() instanceof Device) {
                                MainWindow.this.editDevice((Device)MainWindow.this.tree.getSelection()[0].getData());
                            } else if (MainWindow.this.tree.getSelection()[0].getData() instanceof Sensor) {
                                MainWindow.this.editSensors();
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MainWindow.this.mntmTreeRightDelete = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightDelete.setText("Delete Item(s)");
                MainWindow.this.mntmTreeRightDelete.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        MainWindow.this.deleteSelected();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MainWindow.this.mntmTreeRightCloneSensor = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightCloneSensor.setText("Clone Sensor");
                MainWindow.this.mntmTreeRightCloneSensor.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        MainWindow.this.cloneSensor();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MainWindow.this.mntmTreeRightMoveDevice = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightMoveDevice.setText("Move Sensor(s) to Device");
                MainWindow.this.mntmTreeRightMoveDevice.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        MainWindow.this.moveSensorsToDevice();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MenuItem mntmSeparator2 = new MenuItem(rightMenu, 2);
                MainWindow.this.mntmTreeRightAddPhysical = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightAddPhysical.setText("Add Physical Sensor");
                MainWindow.this.mntmTreeRightAddPhysical.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        MainWindow.this.addNewPhysicalSensor();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MainWindow.this.mntmTreeRightAddVirtual = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightAddVirtual.setText("Add Virtual Sensor");
                MainWindow.this.mntmTreeRightAddVirtual.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        MainWindow.this.addNewVirtualSensor();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MainWindow.this.mntmTreeRightImportSensor = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightImportSensor.setText("Import Sensor(s)");
                MainWindow.this.mntmTreeRightImportSensor.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        MainWindow.this.importSensor(true);
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MainWindow.this.mntmTreeRightAddDevice = new MenuItem(rightMenu, 0);
                MainWindow.this.mntmTreeRightAddDevice.setText("Add Device");
                MainWindow.this.mntmTreeRightAddDevice.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        MainWindow.this.addNewDevice();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                MainWindow.this.refreshEnablement();
            }
        });
    }

    protected void createContents() {
        this.shlIntelrIsh = new Shell(1264);
        this.shlIntelrIsh.setImage(SWTResourceManager.getImage(MainWindow.class, "/resources/Intel.ico"));
        this.shlIntelrIsh.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                MainWindow.this.refresh();
            }

            public void shellClosed(ShellEvent e) {
                if (MainWindow.this._modified) {
                    MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 296);
                    messageBox.setText("Closing the editor");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the application?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
                ArrayList modifiers = new ArrayList(MainWindow.this._openedwindows);
                for (SensorModifier modifier : modifiers) {
                    modifier.shlSensorModifier.close();
                    if (modifier.shlSensorModifier.isDisposed()) continue;
                    e.doit = false;
                    return;
                }
                MainWindow.this.clearDataAndCreatePdt(true);
            }
        });
        this.shlIntelrIsh.setText(WINDOW_TITLE_TEXT);
        GuiUtils.setGridLayoutToComposite((Composite)this.shlIntelrIsh, 1);
        Menu menu = new Menu((Decorations)this.shlIntelrIsh, 2);
        this.shlIntelrIsh.setMenuBar(menu);
        MenuItem mntmFile = new MenuItem(menu, 64);
        mntmFile.setText("File");
        Menu menu_1 = new Menu(mntmFile);
        mntmFile.setMenu(menu_1);
        MenuItem mntmNewPdt = new MenuItem(menu_1, 0);
        mntmNewPdt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MainWindow.this.newFile();
            }
        });
        mntmNewPdt.setText("New");
        MenuItem mntmLoadPdtFile = new MenuItem(menu_1, 0);
        mntmLoadPdtFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.loadPDT();
            }
        });
        mntmLoadPdtFile.setText("Load");
        MenuItem mntmSave = new MenuItem(menu_1, 0);
        mntmSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MainWindow.this.quickSave();
                }
                catch (CancellationException e0) {
                    return;
                }
            }
        });
        mntmSave.setText("Save");
        this.mntmSaveAs = new MenuItem(menu_1, 0);
        this.mntmSaveAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MainWindow.this.saveFilesAs();
                }
                catch (CancellationException e0) {
                    System.out.println("Saving operation was cancelled by user");
                }
            }
        });
        this.mntmSaveAs.setText("Save As");
        MenuItem mntmSeparator = new MenuItem(menu_1, 2);
        MenuItem mntmPdtProperties = new MenuItem(menu_1, 0);
        mntmPdtProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new Properties(MainWindow.this._dataStore, MainWindow.this.thisWindow).open();
            }
        });
        mntmPdtProperties.setText("Properties");
        MenuItem mntmSeparator1 = new MenuItem(menu_1, 2);
        MenuItem mntmExit = new MenuItem(menu_1, 0);
        mntmExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.shlIntelrIsh.close();
            }
        });
        mntmExit.setText("Exit");
        MenuItem mntmEdit = new MenuItem(menu, 64);
        mntmEdit.setText("Edit");
        Menu menu_2 = new Menu(mntmEdit);
        mntmEdit.setMenu(menu_2);
        this.mntmDeleteSelected = new MenuItem(menu_2, 0);
        this.mntmDeleteSelected.setEnabled(false);
        this.mntmDeleteSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.deleteSelected();
            }
        });
        this.mntmDeleteSelected.setText("Delete Selection");
        MenuItem mntmBoardConfiguration = new MenuItem(menu_2, 64);
        mntmBoardConfiguration.setText("Board Configuration");
        this.mntmBdt = new Menu(mntmBoardConfiguration);
        mntmBoardConfiguration.setMenu(this.mntmBdt);
        this.mntmManageIcBoard = new MenuItem(this.mntmBdt, 0);
        this.mntmManageIcBoard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new BoardDescriptionTableEditor(DataStore.getInstance(), MainWindow.this.thisWindow).open();
            }
        });
        this.mntmManageIcBoard.setText("Manage I2C Board Configuration");
        this.mntmHostInterfaceheci = new MenuItem(this.mntmBdt, 0);
        this.mntmHostInterfaceheci.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new HeciConfiguration().open();
            }
        });
        this.mntmHostInterfaceheci.setText("Manage Host Interface (HECI) Configuration");
        this.mntmManageFormFactor = new MenuItem(this.mntmBdt, 0);
        this.mntmManageFormFactor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new FormFactor().open();
            }
        });
        this.mntmManageFormFactor.setText("Manage Form Factor");
        this.mntmPlatformId = new MenuItem(this.mntmBdt, 0);
        this.mntmPlatformId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new PlatformId().open();
            }
        });
        this.mntmPlatformId.setText("Manage Platform Id");
        MenuItem mntmNewItem = new MenuItem(menu_2, 0);
        mntmNewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new DbgConfigGui(DataStore.getInstance().getDbgConfigData(), MainWindow.this.thisWindow).open();
            }
        });
        mntmNewItem.setText("Manage Debug Configuration");
        this.mntmCalibration = new MenuItem(menu_2, 0);
        this.mntmCalibration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.openEditCalibrationWindow();
            }
        });
        this.mntmCalibration.setText("Manage Device Calibrations");
        this.mntmManageCustomDataEntry = new MenuItem(menu_2, 0);
        this.mntmManageCustomDataEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new CustomDataEntry(DataStore.getInstance(), MainWindow.this.thisWindow).open();
            }
        });
        this.mntmManageCustomDataEntry.setText("Manage Custom Data Entry");
        if (DataStore.getInstance().isFdkRun()) {
            this.mntmRestoreIgnored = new MenuItem(menu_2, 0);
            this.mntmRestoreIgnored.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MainWindow.this._dataStore.getCurrentPdtFile() == null) {
                        return;
                    }
                    MainWindow.this._dataStore.getCurrentPdtFile().clearAllIgnroedIssues();
                    MainWindow.this.refresh();
                }
            });
            this.mntmRestoreIgnored.setText("Restore All Ignored Issues");
        }
        MenuItem mntmAdd = new MenuItem(menu, 64);
        mntmAdd.setText("Add");
        Menu menu_4 = new Menu(mntmAdd);
        mntmAdd.setMenu(menu_4);
        this.mntmAddDevice = new MenuItem(menu_4, 0);
        this.mntmAddDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.addNewDevice();
            }
        });
        this.mntmAddDevice.setText("Add Device");
        MenuItem menuItem = new MenuItem(menu_4, 2);
        menuItem.setText("Sensors");
        this.mntmAddPhysicalSensor = new MenuItem(menu_4, 0);
        this.mntmAddPhysicalSensor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.addNewPhysicalSensor();
            }
        });
        this.mntmAddPhysicalSensor.setText("Add Physical Sensor");
        this.mntmAddVirtualSensor = new MenuItem(menu_4, 0);
        this.mntmAddVirtualSensor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.addNewVirtualSensor();
            }
        });
        this.mntmAddVirtualSensor.setText("Add Virtual Sensor");
        this.mntmImportSensor = new MenuItem(menu_4, 0);
        this.mntmImportSensor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MainWindow.this.importSensor(true);
            }
        });
        this.mntmImportSensor.setText("Import Sensor(s)");
        MenuItem mntmAbout = new MenuItem(menu, 64);
        mntmAbout.setText("About");
        Menu menu_3 = new Menu(mntmAbout);
        mntmAbout.setMenu(menu_3);
        MenuItem mntmAboutPdtEditor = new MenuItem(menu_3, 0);
        mntmAboutPdtEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new About().open();
            }
        });
        mntmAboutPdtEditor.setText("About Intel\u00ae Integrated Sensor Solution PDT Editor");
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TreeColumn)arg0.getSource()).getWidth() < 50) {
                    ((TreeColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shlIntelrIsh.setLayout((Layout)layout);
        this.mainMessage = new Text((Composite)this.shlIntelrIsh, 2050);
        GridData mainMessageLayoutData = new GridData();
        mainMessageLayoutData.verticalSpan = 10;
        mainMessageLayoutData.horizontalSpan = 5;
        mainMessageLayoutData.horizontalAlignment = 4;
        mainMessageLayoutData.grabExcessHorizontalSpace = true;
        mainMessageLayoutData.exclude = true;
        this.mainMessage.setLayoutData((Object)mainMessageLayoutData);
        this.mainMessage.setEditable(false);
        this.mainMessage.setBackground(SWTResourceManager.getColor(29));
        this.sashForm = new SashForm((Composite)this.shlIntelrIsh, 512);
        GridData sashFormLayoutData = new GridData();
        sashFormLayoutData.verticalAlignment = 4;
        sashFormLayoutData.verticalSpan = 5;
        sashFormLayoutData.horizontalSpan = 5;
        sashFormLayoutData.grabExcessVerticalSpace = true;
        sashFormLayoutData.horizontalAlignment = 4;
        sashFormLayoutData.grabExcessHorizontalSpace = true;
        this.sashForm.setLayoutData((Object)sashFormLayoutData);
        this.treeViewer = new TreeViewer((Composite)this.sashForm, 67586);
        this.tree = this.treeViewer.getTree();
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MainWindow.this.treeSelectedActions();
            }
        });
        this.tree.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent arg0) {
                MainWindow.this.treeSelectedActions();
            }
        });
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    MainWindow.this.deleteSelected();
                } else if ((e.stateMask & 0x40000) == 262144 && MainWindow.this.tree.getSelectionCount() == 1) {
                    Object selectedObject = MainWindow.this.tree.getSelection()[0].getData();
                    if (e.keyCode == 0x1000001) {
                        MainWindow.this.changeSensorLocation(false);
                    } else if (e.keyCode == 0x1000002) {
                        MainWindow.this.changeSensorLocation(true);
                    }
                    MainWindow.this.selectItem(selectedObject);
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                MainWindow.this.onTreeDoubleClick(arg0);
            }
        });
        this.tree.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.tree.setLocation(11, 10);
        this.formToolkit.paintBordersFor((Composite)this.tree);
        TreeViewerColumn treeViewerColumn_3 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn0 = treeViewerColumn_3.getColumn();
        trclmn0.setWidth(180);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn1 = treeViewerColumn.getColumn();
        trclmn1.setWidth(200);
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn2 = treeViewerColumn_1.getColumn();
        trclmn2.setWidth(150);
        TreeViewerColumn treeViewerColumn_2 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn3 = treeViewerColumn_2.getColumn();
        trclmn3.setWidth(60);
        TreeViewerColumn treeViewerColumn_4 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn4 = treeViewerColumn_4.getColumn();
        trclmn4.setWidth(142);
        TreeViewerColumn treeViewerColumn_7 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn5 = treeViewerColumn_7.getColumn();
        trclmn5.setWidth(125);
        TreeViewerColumn treeViewerColumn_6 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn6 = treeViewerColumn_6.getColumn();
        trclmn6.setWidth(100);
        TreeViewerColumn treeViewerColumn_5 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn7 = treeViewerColumn_5.getColumn();
        trclmn7.setWidth(100);
        TreeViewerColumn treeViewerColumn_9 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn8 = treeViewerColumn_9.getColumn();
        trclmn8.setWidth(110);
        TreeViewerColumn treeViewerColumn_8 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmn9 = treeViewerColumn_8.getColumn();
        trclmn9.setWidth(110);
        trclmn0.setText(PdtLabelProvider.getColumnHeader(0));
        trclmn1.setText(PdtLabelProvider.getColumnHeader(1));
        trclmn2.setText(PdtLabelProvider.getColumnHeader(2));
        trclmn3.setText(PdtLabelProvider.getColumnHeader(3));
        trclmn4.setText(PdtLabelProvider.getColumnHeader(4));
        trclmn5.setText(PdtLabelProvider.getColumnHeader(5));
        trclmn6.setText(PdtLabelProvider.getColumnHeader(6));
        trclmn7.setText(PdtLabelProvider.getColumnHeader(7));
        trclmn8.setText(PdtLabelProvider.getColumnHeader(8));
        trclmn9.setText(PdtLabelProvider.getColumnHeader(9));
        trclmn0.addControlListener((ControlListener)resizeColHandler);
        trclmn1.addControlListener((ControlListener)resizeColHandler);
        trclmn2.addControlListener((ControlListener)resizeColHandler);
        trclmn3.addControlListener((ControlListener)resizeColHandler);
        trclmn4.addControlListener((ControlListener)resizeColHandler);
        trclmn5.addControlListener((ControlListener)resizeColHandler);
        trclmn6.addControlListener((ControlListener)resizeColHandler);
        trclmn7.addControlListener((ControlListener)resizeColHandler);
        trclmn8.addControlListener((ControlListener)resizeColHandler);
        trclmn9.addControlListener((ControlListener)resizeColHandler);
        this.treeViewer.setContentProvider((IContentProvider)new PdtContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PdtLabelProvider());
        this.treeViewer.setInput((Object)DataStore.getInstance());
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        DragSource source = new DragSource((Control)this.tree, operations);
        source.setTransfer(types);
        final TreeItem[] dragSourceItem = new TreeItem[1];
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = MainWindow.this.tree.getSelection();
                if (selection.length == 1 && selection[0].getItemCount() == 0) {
                    event.doit = true;
                    dragSourceItem[0] = selection[0];
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = dragSourceItem[0].getText();
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 2) {
                    dragSourceItem[0].dispose();
                }
                dragSourceItem[0] = null;
            }
        });
        DropTarget target = new DropTarget((Control)this.tree, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 24;
                if (event.item != null) {
                    TreeItem item = (TreeItem)event.item;
                    Sensor draggedSensor = (Sensor)dragSourceItem[0].getData();
                    if (item.getData() instanceof Sensor) {
                        Sensor targetSensor = (Sensor)item.getData();
                        Point pt = MainWindow.this.display.map(null, (Control)MainWindow.this.tree, event.x, event.y);
                        Rectangle bounds = item.getBounds();
                        Sensor lastPhysicalSensor = null;
                        Sensor firstVirtualSensor = null;
                        for (Sensor tempSensor : ((Device)item.getParentItem().getData()).getSensors()) {
                            if (tempSensor.getLuid().getIsPhysical()) {
                                lastPhysicalSensor = tempSensor;
                                continue;
                            }
                            firstVirtualSensor = tempSensor;
                            break;
                        }
                        if (draggedSensor.getLuid().getIsPhysical() == targetSensor.getLuid().getIsPhysical()) {
                            event.feedback = pt.y < bounds.y + bounds.height / 2 ? (event.feedback |= 2) : (event.feedback |= 4);
                        } else if (draggedSensor.getLuid().getIsPhysical() && targetSensor.equals(firstVirtualSensor)) {
                            event.feedback |= 2;
                        } else if (!draggedSensor.getLuid().getIsPhysical() && targetSensor.equals(lastPhysicalSensor)) {
                            event.feedback |= 4;
                        }
                    } else if (item.getData() instanceof Device && (item.getItems().length == 0 || draggedSensor.getLuid().getIsPhysical() || !((Device)item.getData()).getSensor(0).getLuid().getIsPhysical() && !draggedSensor.getLuid().getIsPhysical())) {
                        event.feedback |= 4;
                    }
                }
            }

            public void drop(DropTargetEvent event) {
                event.detail = 0;
                if (event.data == null) {
                    return;
                }
                if (event.item == null) {
                    return;
                }
                TreeItem targetItem = (TreeItem)event.item;
                Point pt = MainWindow.this.display.map(null, (Control)MainWindow.this.tree, event.x, event.y);
                Rectangle bounds = targetItem.getBounds();
                TreeItem targetParent = targetItem.getParentItem();
                int sourceIndex = dragSourceItem[0].getParentItem().indexOf(dragSourceItem[0]);
                Sensor sourceSensor = (Sensor)dragSourceItem[0].getData();
                ArrayList<Device> storeDevices = MainWindow.this._dataStore.getDevicesOfCurrentPdt();
                Device sourceDevice = null;
                Device targetDevice = null;
                if (targetParent != null && targetParent.getData() instanceof Device) {
                    Sensor targetSensor = (Sensor)targetItem.getData();
                    int index = targetParent.indexOf(targetItem);
                    for (Device device : storeDevices) {
                        if (device.equals((Device)dragSourceItem[0].getParentItem().getData())) {
                            sourceDevice = device;
                        }
                        if (!device.equals((Device)targetParent.getData())) continue;
                        targetDevice = device;
                    }
                    if (sourceDevice == null || targetDevice == null) {
                        return;
                    }
                    if (sourceDevice.equals(targetDevice) && sourceIndex < index) {
                        --index;
                    }
                    Sensor lastPhysicalSensor = null;
                    Sensor firstVirtualSensor = null;
                    for (Sensor tempSensor : targetDevice.getSensors()) {
                        if (tempSensor.getLuid().getIsPhysical()) {
                            lastPhysicalSensor = tempSensor;
                            continue;
                        }
                        firstVirtualSensor = tempSensor;
                        break;
                    }
                    if (!sourceSensor.getLuid().getIsPhysical() || firstVirtualSensor == null || !firstVirtualSensor.equals(targetSensor)) {
                        if (!sourceSensor.getLuid().getIsPhysical() && lastPhysicalSensor != null && lastPhysicalSensor.equals(targetSensor)) {
                            ++index;
                        } else {
                            if (sourceSensor.getLuid().getIsPhysical() != ((Sensor)targetItem.getData()).getLuid().getIsPhysical()) {
                                return;
                            }
                            if (pt.y > bounds.y + bounds.height / 2) {
                                ++index;
                            }
                        }
                    }
                    if (sourceDevice.equals(targetDevice)) {
                        sourceDevice.removeSensor(sourceSensor);
                        sourceDevice.addSensor(index, sourceSensor);
                    } else {
                        sourceDevice.removeSensor(sourceSensor);
                        targetDevice.addSensor(index, sourceSensor);
                    }
                    MainWindow.this.treeViewer.refresh();
                    MainWindow.this.setModified();
                } else if (targetItem.getData() instanceof Device) {
                    for (Device device : storeDevices) {
                        if (device.equals((Device)dragSourceItem[0].getParentItem().getData())) {
                            sourceDevice = device;
                        }
                        if (!device.equals((Device)targetItem.getData())) continue;
                        targetDevice = device;
                    }
                    if (targetDevice != null) {
                        if (targetItem.getItems().length == 0) {
                            sourceDevice.removeSensor(sourceSensor);
                            targetDevice.addSensor(sourceSensor);
                        } else if (sourceSensor.getLuid().getIsPhysical() || !targetDevice.getSensor(0).getLuid().getIsPhysical() && !sourceSensor.getLuid().getIsPhysical()) {
                            sourceDevice.removeSensor(sourceSensor);
                            targetDevice.addSensor(0, sourceSensor);
                        }
                    }
                    MainWindow.this.treeViewer.refresh();
                    MainWindow.this.setModified();
                } else {
                    return;
                }
            }
        });
        Composite lowerComposite = new Composite((Composite)this.shlIntelrIsh, 0);
        GridLayout lowerCompositeLayout = new GridLayout();
        lowerCompositeLayout.numColumns = 3;
        lowerComposite.setLayout((Layout)lowerCompositeLayout);
        GridData lowerCompositeLayoutData = new GridData();
        lowerCompositeLayoutData.horizontalAlignment = 4;
        lowerComposite.setLayoutData((Object)lowerCompositeLayoutData);
        this.statusBar = new Text(lowerComposite, 2080);
        this.statusBar.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.statusBar.setEditable(false);
        this.statusBar.setBackground(SWTResourceManager.getColor(19));
        this.statusBar.setFont(SWTResourceManager.getFont("Segoe UI", 9, 0));
        this.statusBar.setText("Status bar");
        Composite saveBtnComposite = new Composite(lowerComposite, 0);
        Button btnSave = new Button(saveBtnComposite, 0);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MainWindow.this.quickSave();
                }
                catch (CancellationException e0) {
                    return;
                }
            }
        });
        this.formToolkit.adapt((Control)btnSave, true, true);
        btnSave.setText("Save");
        this.continueNoteComposite = new Composite(lowerComposite, 0);
        this.saveAndCloseButton = new Button(this.continueNoteComposite, 0);
        this.saveAndCloseButton.setSize(118, 24);
        this.formToolkit.adapt((Control)this.saveAndCloseButton, true, true);
        this.saveAndCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    MainWindow.this.quickSave();
                    if (MainWindow.this._silentValidation && MainWindow.this._dataStore.getCurrentPdtFile() != null && MainWindow.this._dataStore.getCurrentPdtFile().hasActiveIssues()) {
                        MessageBox messageBox = new MessageBox(MainWindow.this.shlIntelrIsh, 200);
                        messageBox.setText("Unresolved Issues");
                        messageBox.setMessage("There are some unresolved issues. Are you sure you want to continue?");
                        if (messageBox.open() != 64) {
                            return;
                        }
                    }
                }
                catch (CancellationException e0) {
                    return;
                }
                MainWindow.this.shlIntelrIsh.close();
            }
        });
        this.saveAndCloseButton.setText("Save and Close");
        lowerComposite.setTabList(new Control[]{saveBtnComposite, this.continueNoteComposite, this.statusBar});
        TabFolder tabFolder = new TabFolder((Composite)this.sashForm, 0);
        this.formToolkit.adapt((Composite)tabFolder);
        this.formToolkit.paintBordersFor((Composite)tabFolder);
        TabItem tbtmIssuestree = new TabItem(tabFolder, 0);
        tbtmIssuestree.setText("Issues");
        this.issuesTreeViewer = new TreeViewer((Composite)tabFolder, 2048);
        this.issuesTreeViewer.setContentProvider((IContentProvider)new IssuesContentProvider());
        this.issuesTreeViewer.setLabelProvider((IBaseLabelProvider)new IssuesLabelProvider());
        this.issuesTree = this.issuesTreeViewer.getTree();
        this.issuesTree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent arg0) {
                TreeItem item;
                if (MainWindow.this.issueTooltip != null) {
                    MainWindow.this.issueTooltip.setVisible(false);
                    MainWindow.this.issueTooltip = null;
                }
                if ((item = MainWindow.this.issuesTree.getItem(new Point(arg0.x, arg0.y))) == null) {
                    return;
                }
                if (MainWindow.this.getIssueDescription(item).length() > 0) {
                    Point MouseLocation = new Point((int)MouseInfo.getPointerInfo().getLocation().getX() + 5, (int)MouseInfo.getPointerInfo().getLocation().getY() + 5);
                    MainWindow.this.issueTooltip = GuiUtils.showToolTip(MainWindow.this.shlIntelrIsh, MouseLocation, MainWindow.this.getIssueDescription(item), 4096, false);
                    MainWindow.this.issuesTree.setFocus();
                }
            }
        });
        this.issuesTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                MainWindow.this.fixSelectedIssue();
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.issuesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
            }
        });
        this.issuesTree.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        tbtmIssuestree.setControl((Control)this.issuesTree);
        this.formToolkit.paintBordersFor((Composite)this.issuesTree);
        this.sashForm.setWeights(new int[]{5, 2});
        int longButtonWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.saveAndCloseButton) * 1.5);
        int shortButtonWidth = GuiUtils.getButtonWidth((Control)btnSave);
        int buttonHeight = (int)((double)GuiUtils.getPixelSizeHeight((Control)this.shlIntelrIsh) * 1.5);
        this.saveAndCloseButton.setSize(longButtonWidth, buttonHeight);
        btnSave.setSize(shortButtonWidth, buttonHeight);
        this.shlIntelrIsh.setSize(964, 679);
        this.shlIntelrIsh.setLocation(GuiUtils.getMiddleLocation(this.shlIntelrIsh, this.display));
        this.initDataBindings();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }

    @Override
    public void selectSensor(Sensor sensor) {
        this.selectItem(sensor);
    }

    public void setCheckIssue(boolean chechIssue) {
        this._checkIssue = chechIssue;
    }

    public boolean getPdtContainsIssue() {
        return this._pdtContainsIssue;
    }

    public boolean getPdtContainsCriticalIssue() {
        return this._pdtContainsCriticalIssue;
    }

    public void setCheckInvalidPdt(boolean checkInvalidPdt) {
        this._check_invalid_pdt = checkInvalidPdt;
    }

    public boolean getIsInvalidPdt() {
        return this._isInvalidPdt;
    }
}

