/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.Common;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pdtEditor.DataStore;
import pdtEditor.PdtFile;
import pdtEditor.validation.Issue;

public class PDTExternalInfo {
    private static final String PDT_EXTRNAL_INFO_FILE = "pdt_external_info.xml";
    private String _pdtExternalInfoDocPath;
    private Document _pdtExtraInfoDoc;

    public void setPdtExternalInfoDocPath(String path) {
        this._pdtExternalInfoDocPath = path;
    }

    public String getPdtExternalInfoDocPath() {
        if (this._pdtExternalInfoDocPath != null) {
            return this._pdtExternalInfoDocPath;
        }
        PdtFile pdt = DataStore.getInstance().getCurrentPdtFile();
        if (pdt == null) {
            return null;
        }
        String dirPath = DataStore.getInstance().getCurrentPdtFile().getDirectoryPath();
        if (dirPath == null) {
            return null;
        }
        return DataStore.getInstance().getCurrentPdtFile().getDirectoryPath() + File.separator + PDT_EXTRNAL_INFO_FILE;
    }

    public void loadPdtExternalInfoDoc() {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            String pdtPath = this.getPdtExternalInfoDocPath();
            if (pdtPath == null || pdtPath.isEmpty()) {
                return;
            }
            File srcXmlFile = new File(pdtPath);
            if (!srcXmlFile.exists()) {
                return;
            }
            this._pdtExtraInfoDoc = dBuilder.parse(srcXmlFile);
        }
        catch (Exception e) {
            System.err.println("Failed to load the list of ignored issues: " + e.getMessage());
        }
    }

    private Document createEmptyPdtExternalFile() throws ParserConfigurationException {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw e;
        }
        Document doc = docBuilder.newDocument();
        Element pdtExtraInfoElement = doc.createElement("PdtExtraInfo");
        doc.appendChild(pdtExtraInfoElement);
        Element pdtExtralPreferences = doc.createElement("Preferences");
        pdtExtraInfoElement.appendChild(pdtExtralPreferences);
        Element validationElement = doc.createElement("Validation");
        pdtExtraInfoElement.appendChild(validationElement);
        Element ignoredIssues = doc.createElement("IgnoredIssues");
        validationElement.appendChild(ignoredIssues);
        return doc;
    }

    public ExternalPreferences loadExternalPreferences() {
        NodeList nodes;
        this.loadPdtExternalInfoDoc();
        if (this._pdtExtraInfoDoc == null) {
            return null;
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//PdtExtraInfo//Preferences");
            nodes = (NodeList)xpr.evaluate(this._pdtExtraInfoDoc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
        ExternalPreferences preferences = new ExternalPreferences();
        if (nodes.getLength() == 1 && nodes.item(0) instanceof Element) {
            Element prefElement = (Element)nodes.item(0);
            preferences.allowContinueOnCritical = prefElement.getAttribute("AllowContinueOnCritical").equals("True");
        }
        return preferences;
    }

    public void writeExternalPreferencesXml(ExternalPreferences preferences) throws ParserConfigurationException {
        Node parent;
        Element newPreferencesNode;
        XPathExpression xpr;
        XPath xpath;
        if (preferences == null) {
            return;
        }
        if (this._pdtExtraInfoDoc == null) {
            this._pdtExtraInfoDoc = this.createEmptyPdtExternalFile();
        }
        Node preferencesNode = null;
        try {
            xpath = XPathFactory.newInstance().newXPath();
            xpr = xpath.compile("//PdtExtraInfo//Preferences");
            preferencesNode = (Element)xpr.evaluate(this._pdtExtraInfoDoc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        if (preferencesNode == null) {
            newPreferencesNode = this._pdtExtraInfoDoc.createElement("Preferences");
            try {
                xpath = XPathFactory.newInstance().newXPath();
                xpr = xpath.compile("//PdtExtraInfo");
                parent = (Element)xpr.evaluate(this._pdtExtraInfoDoc, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
                return;
            }
        } else {
            newPreferencesNode = this._pdtExtraInfoDoc.createElement(preferencesNode.getNodeName());
            parent = preferencesNode.getParentNode();
            parent.removeChild(preferencesNode);
        }
        parent.appendChild(newPreferencesNode);
        preferencesNode = newPreferencesNode;
        preferencesNode.setAttribute("AllowContinueOnCritical", preferences.allowContinueOnCritical ? "True" : "False");
        this.writeExternalInfoXml();
    }

    public ArrayList<Issue> getIgnoredIssuesList() {
        NodeList issueNodes;
        this.loadPdtExternalInfoDoc();
        if (this._pdtExtraInfoDoc == null) {
            return null;
        }
        ArrayList<Issue> ignoredIssues = new ArrayList<Issue>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//PdtExtraInfo/Validation/IgnoredIssues/Element/Issue");
            issueNodes = (NodeList)xpr.evaluate(this._pdtExtraInfoDoc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
        for (int i = 0; i < issueNodes.getLength(); ++i) {
            if (issueNodes.item(i).getNodeType() != 1 || !issueNodes.item(i).getNodeName().equals("Issue")) continue;
            Element issueElement = (Element)issueNodes.item(i);
            Issue issue = new Issue(Issue.IssueType.NOTIFICATION, null);
            Element elementElement = (Element)issueElement.getParentNode();
            issue.element = elementElement.getAttribute("Name");
            issue.setBasicMessage(issueElement.getAttribute("Message"));
            ignoredIssues.add(issue);
        }
        return ignoredIssues;
    }

    public void writeIgnoredIssuesXml(ArrayList<Issue> ignoredIssues) throws ParserConfigurationException {
        Node ignoredIssuesNode;
        if (ignoredIssues == null) {
            return;
        }
        if (this._pdtExtraInfoDoc == null) {
            this._pdtExtraInfoDoc = this.createEmptyPdtExternalFile();
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//PdtExtraInfo/Validation/IgnoredIssues");
            ignoredIssuesNode = (Node)xpr.evaluate(this._pdtExtraInfoDoc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return;
        }
        if (ignoredIssuesNode != null) {
            Element newIgnoredIssuesNode = this._pdtExtraInfoDoc.createElement(ignoredIssuesNode.getNodeName());
            Node parent = ignoredIssuesNode.getParentNode();
            parent.removeChild(ignoredIssuesNode);
            parent.appendChild(newIgnoredIssuesNode);
            ignoredIssuesNode = newIgnoredIssuesNode;
        }
        HashMap<String, ArrayList<String>> elementToIssues = new HashMap<String, ArrayList<String>>();
        for (Issue ignoredIssue : ignoredIssues) {
            ArrayList<String> issuesOfElement = (ArrayList<String>)elementToIssues.get(ignoredIssue.getElement());
            if (issuesOfElement == null) {
                issuesOfElement = new ArrayList<String>();
                elementToIssues.put(ignoredIssue.getElement(), issuesOfElement);
            }
            issuesOfElement.add(ignoredIssue.getBasicMessage());
        }
        for (String element : elementToIssues.keySet()) {
            Element elementElement = this._pdtExtraInfoDoc.createElement("Element");
            elementElement.setAttribute("Name", element);
            if (ignoredIssuesNode != null) {
                ignoredIssuesNode.appendChild(elementElement);
            }
            for (String issueMessage : (ArrayList)elementToIssues.get(element)) {
                Element issueElement = this._pdtExtraInfoDoc.createElement("Issue");
                issueElement.setAttribute("Message", issueMessage);
                elementElement.appendChild(issueElement);
            }
        }
        this.writeExternalInfoXml();
    }

    public void writeExternalInfoXml() {
        try {
            String pdtExternalInfoDocPath = this.getPdtExternalInfoDocPath();
            if (pdtExternalInfoDocPath != null) {
                Common.exportXmlDoc(this._pdtExtraInfoDoc, pdtExternalInfoDocPath);
            }
        }
        catch (TransformerException e) {
            throw new UnsupportedOperationException("Failed to add to the list of ignored issues: " + e.getMessage());
        }
    }

    public static class ExternalPreferences {
        public boolean allowContinueOnCritical = false;
    }
}

