/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.internal.expressions.AlwaysEnabledExpression;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContributionRoot
implements IContributionRoot {
    private List topLevelItems = new ArrayList();
    private Map<IContributionItem, Expression> itemsToExpressions = new HashMap<IContributionItem, Expression>();
    Set restriction;
    private ContributionManager mgr;
    private AbstractContributionFactory factory;

    public ContributionRoot(IMenuService menuService, Set restriction, ContributionManager mgr, AbstractContributionFactory factory) {
        this.restriction = restriction;
        this.mgr = mgr;
        this.factory = factory;
    }

    @Override
    public void addContributionItem(IContributionItem item, Expression visibleWhen) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        this.topLevelItems.add(item);
        if (visibleWhen == null) {
            visibleWhen = AlwaysEnabledExpression.INSTANCE;
        }
        this.itemsToExpressions.put(item, visibleWhen);
    }

    String createIdentifierId(IContributionItem item) {
        String namespace = this.factory.getNamespace();
        String identifierID = namespace != null ? String.valueOf(namespace) + '/' + item.getId() : null;
        return identifierID;
    }

    public List getItems() {
        return this.topLevelItems;
    }

    public Map<IContributionItem, Expression> getVisibleWhen() {
        return this.itemsToExpressions;
    }

    public void release() {
        for (IContributionItem item : this.itemsToExpressions.keySet()) {
            item.dispose();
        }
        this.itemsToExpressions.clear();
        this.topLevelItems.clear();
    }

    @Override
    public void registerVisibilityForChild(IContributionItem item, Expression visibleWhen) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (visibleWhen == null) {
            visibleWhen = AlwaysEnabledExpression.INSTANCE;
        }
        this.itemsToExpressions.put(item, visibleWhen);
    }

    public ContributionManager getManager() {
        return this.mgr;
    }
}

