/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.service;

import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.SensorsDefinitionsMapping;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.SensorTypeListDao;
import com.intel.sensing.fdk.model.dao.VendorListDao;
import com.intel.sensing.fdk.model.entity.SensorTypeListEntity;
import com.intel.sensing.fdk.model.entity.SensorTypeMapEntity;
import com.intel.sensing.fdk.model.entity.VendorListEntity;
import com.intel.sensing.fdk.model.entity.VendorMapEntity;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DefinitionFileService {
    public static void saveDefinitionsChanges(HashMap<Integer, String> existingMap, HashMap<Integer, String> updatedMap, String _itemTagName, String _itemsTagName, String _idTagName, String _nameTagName, ManagerEnums.ObjectTypes objectType) throws Exception {
        for (Map.Entry<Integer, String> oldItem : existingMap.entrySet()) {
            boolean stillExists = false;
            for (Map.Entry<Integer, String> newItem : updatedMap.entrySet()) {
                if (!newItem.getKey().equals(oldItem.getKey()) || !newItem.getValue().equals(oldItem.getValue())) continue;
                stillExists = true;
                break;
            }
            if (stillExists) continue;
            if (_itemTagName.equals("Vendor")) {
                DefinitionFileService.removeFromUserVendorJson(oldItem);
                SensorsDefinitionsMapping.getInstance().removeVendor(oldItem.getKey(), oldItem.getValue());
                continue;
            }
            if (_itemTagName.equals("SensorType")) {
                DefinitionFileService.removeFromUserSensorTypeJson(oldItem);
                SensorsDefinitionsMapping.getInstance().removeSensorType(oldItem.getKey(), oldItem.getValue());
                continue;
            }
            throw new Exception("Unrecognized item type.");
        }
        for (Map.Entry<Integer, String> newItem : updatedMap.entrySet()) {
            if (existingMap.get(newItem.getKey()) != null) continue;
            if (_itemTagName.equals("Vendor")) {
                DefinitionFileService.addToUserVendorJson(newItem);
                SensorsDefinitionsMapping.getInstance().addVendor(newItem.getKey(), newItem.getValue());
                continue;
            }
            if (_itemTagName.equals("SensorType")) {
                DefinitionFileService.addToUserSensorTypeJson(newItem);
                SensorsDefinitionsMapping.getInstance().addSensorType(newItem.getKey(), newItem.getValue());
                continue;
            }
            throw new Exception("Unrecognized item type.");
        }
    }

    private static void removeFromUserSensorTypeJson(Map.Entry<Integer, String> oldItem) throws Exception, ISSException {
        String file = ManagerFileUtils.getUserSensorTypeDefinitionsFilePath();
        if (new File(file).exists()) {
            SensorTypeListDao SensorTypeDao = DaoFactory.getDao(SensorTypeListDao.class);
            SensorTypeListEntity SensorTypeList = SensorTypeDao.getEntityByFilePath(file);
            SensorTypeMapEntity SensorTypeMapItem = new SensorTypeMapEntity(file);
            SensorTypeMapItem.setJsonFilePath(file);
            SensorTypeMapItem.setSensorTypeID(oldItem.getKey());
            SensorTypeMapItem.setSensorTypeName(oldItem.getValue());
            SensorTypeDao.removeSensorType(SensorTypeList, SensorTypeMapItem);
            SensorTypeDao.saveEntity(SensorTypeList);
        }
    }

    private static void addToUserSensorTypeJson(Map.Entry<Integer, String> newItem) throws Exception, ISSException {
        String file = ManagerFileUtils.getUserSensorTypeDefinitionsFilePath();
        SensorTypeListDao SensorTypeDao = DaoFactory.getDao(SensorTypeListDao.class);
        SensorTypeListEntity SensorTypeList = new File(file).exists() ? SensorTypeDao.getEntityByFilePath(file) : new SensorTypeListEntity(file);
        SensorTypeMapEntity SensorTypeMapItem = new SensorTypeMapEntity(file);
        SensorTypeMapItem.setJsonFilePath(file);
        SensorTypeMapItem.setSensorTypeID(newItem.getKey());
        SensorTypeMapItem.setSensorTypeName(newItem.getValue());
        SensorTypeDao.addSensorType(SensorTypeList, SensorTypeMapItem);
        SensorTypeDao.saveEntity(SensorTypeList);
    }

    private static void removeFromUserVendorJson(Map.Entry<Integer, String> oldItem) throws Exception, ISSException {
        String file = ManagerFileUtils.getUserSensorVendorListFilePath();
        if (new File(file).exists()) {
            VendorListDao VendorDao = DaoFactory.getDao(VendorListDao.class);
            VendorListEntity VendorList = VendorDao.getEntityByFilePath(file);
            VendorMapEntity VendorMapItem = new VendorMapEntity(file);
            VendorMapItem.setJsonFilePath(file);
            VendorMapItem.setVendorID(oldItem.getKey());
            VendorMapItem.setVendorName(oldItem.getValue());
            VendorDao.removeVendor(VendorList, VendorMapItem);
            VendorDao.saveEntity(VendorList);
        }
    }

    private static void addToUserVendorJson(Map.Entry<Integer, String> newItem) throws Exception, ISSException {
        String file = ManagerFileUtils.getUserSensorVendorListFilePath();
        VendorListDao VendorDao = DaoFactory.getDao(VendorListDao.class);
        VendorListEntity VendorList = new File(file).exists() ? VendorDao.getEntityByFilePath(file) : new VendorListEntity(file);
        VendorMapEntity VendorMapItem = new VendorMapEntity(file);
        VendorMapItem.setJsonFilePath(file);
        VendorMapItem.setVendorID(newItem.getKey());
        VendorMapItem.setVendorName(newItem.getValue());
        VendorDao.addVendor(VendorList, VendorMapItem);
        VendorDao.saveEntity(VendorList);
    }
}

