<HTML>
<HEAD>
<meta http-equiv="pragma" content="no-cache">
<TITLE>Marvel RAID Application :- Events Message</TITLE>
<SCRIPT language='JavaScript'>
	function doLoad(){ 
		setTimeout( 'closeMe()', 5*1000 ); 
	}
	function closeMe(){ 
		self.close();
	}
</SCRIPT>
</HEAD>
<BODY onload="doLoad()">
<center>
<font size="2">
<?php gettext('Events Notify Mail Sent');?>
</font>
<br><br><input type="button" value="Close" onClick="self.close();">
</center>
</BODY>
</HTML>
<?php
include_once("../phpsrc/include.php");

if(constant('MAC_LOCAL_MAIL_SUPPORT') == 1)
{
	include_once("../phpsrc/mail/MacMailer.class.php");
	//get system settings
	$systemDataAccess = new SystemSettingDataAccess();
	$sysSetting = $systemDataAccess->getSystemSetting();

	//get the index
	$startNo = $sysSetting->getEventReadIndex();
	if(trim($startNo) === "")
		$startNo = 0;
	else
		$startNo += 1;

	//get all events from index read
	$eventsList = new CtnAllEventList();
	$eventsList->setStartNo($startNo);
	$eventsList->initData();
	$eventsList = $eventsList->getAllEvents();

	if (! $eventsList) {
		//if no events then do nothing;
		return;
	}

	$mailer = new MacMailer();

	$userDataAccess = new UserDataAccess();
	$EventNotifyAll = EventNotifyType::INFO
				| EventNotifyType::WARNING
				| EventNotifyType::ERROR;

	//send mail for users one by one
	$notifyUsers = $userDataAccess->getAllUser();
	foreach ($notifyUsers as $user)
	{
		$domain = $user->getDomain();
		
		//ignore all domain users
		if (strcasecmp($domain, getenv('COMPUTERNAME')) != 0 && trim($domain) !== "")
		{
			continue;
		}
	
		//check whether the user exists
		//deleted when user not exist
		$cmd = new XMLAPICommand();
		$cmd->setCommand(XMLAPICommand::MV_GetUserGroup);
		$cmd->setCommandPara("lpszUsername", $user->getLoginName());
		$cmd->setCommandPara("lpszDomain", $domain);
		$cmd->issueCommand();
	
		if(strcmp($cmd->getResult()->UserGroup . "", "UnknownUser") == 0)
		{
			//if user don't exists
			//delete the user and don't send mail to this user
			$userDataAccess->deleteUserByLoginName($user->getLoginName(), $domain);
			continue;
		}else if (strcmp($cmd->getResult()->UserGroup . "", "ValidUser") == 0) {
			continue;
		}
	
		//only administrators will receive mail
		$level = $user->getEventNotify();
		if ($eventsList && $level) {
			$ret = sendNotify($eventsList,$user->getEmailAddr(),$level,$mailer);
			if (!$ret) {
				//send fail
				return;
			}
		}
	}
}
else
{

if (!constant('MAIL_SUPPORT'))
{
	return;
}

//add mail class
include_once("../phpsrc/mail/MRUMailer.class.php");

//get system settings
$systemDataAccess = new SystemSettingDataAccess();
$sysSetting = $systemDataAccess->getSystemSetting();

//get the index
$startNo = $sysSetting->getEventReadIndex();
if(trim($startNo) === "")
	$startNo = 0;
else
	$startNo += 1;

//get all events from index read
$eventsList = new CtnAllEventList();
$eventsList->setStartNo($startNo);
$eventsList->initData();
$eventsList = $eventsList->getAllEvents();

if (! $eventsList) {
	//if no events then do nothing;
	return;
}
//initialize mailer
$mailer = initMailer($sysSetting);
if ($mailer == null) {
	//if initialization fail, then nothing will be done.
	return;
}

$userDataAccess = new UserDataAccess();
$EventNotifyAll = EventNotifyType::INFO
				| EventNotifyType::WARNING
				| EventNotifyType::ERROR;
//send mail for all level of event notify
/*
for ($i = 1;$i <= $EventNotifyAll; $i++)
{
	$notifyUsers = $userDataAccess->getUsersByEventNotifyLevel($i);
	if ($notifyUsers && $eventsList) {
		$ret = sendNotify($eventsList,$notifyUsers,$i,$mailer);
		if (!$ret) {
			//send fail
			return;
		}
	}
}
*/

//send mail for users one by one
$notifyUsers = $userDataAccess->getAllUser();
foreach ($notifyUsers as $user)
{
	$domain = $user->getDomain();
	
	//ignore all domain users
	if (strcasecmp($domain, getenv('COMPUTERNAME')) != 0 && trim($domain) !== "")
	{
		continue;
	}
	
	//check whether the user exists
	//deleted when user not exist
	$cmd = new XMLAPICommand();
	$cmd->setCommand(XMLAPICommand::MV_GetUserGroup);
	$cmd->setCommandPara("lpszUsername", $user->getLoginName());
	$cmd->setCommandPara("lpszDomain", $domain);
	$cmd->issueCommand();
	
	if(strcmp($cmd->getResult()->UserGroup . "", "UnknownUser") == 0)
	{
		//if user don't exists
		//delete the user and don't send mail to this user
		$userDataAccess->deleteUserByLoginName($user->getLoginName(), $domain);
		continue;
	}else if (strcmp($cmd->getResult()->UserGroup . "", "ValidUser") == 0) {
		continue;
	}
	
	//only administrators will receive mail
	$level = $user->getEventNotify();
	if ($eventsList && $level) {
		$ret = sendNotify($eventsList,array($user),$level,$mailer);
		if (!$ret) {
			//send fail
			return;
		}
	}
}
}

//update Event Read Index for next send mail
$max = intval(EventList::GetEventEndNo());
$systemDataAccess->updateEventReadIndex($max);

//send events of related notify level to $users
//by using mailer initilized above.
function sendNotify($eventsList,$users,$eventNotify,$mailer)
{
	$contacts = array();
if(is_array($users) && !empty($users)){  
	foreach ($users as $user)
	{
		$contacts[$user->getEmailAddr()] = $user->getNickName();
	}
}

	if ($eventNotify != 0) {
		
		$minServerity1 = -1;
		$maxServerity1 = -1;
		$minServerity2 = -1;
		$maxServerity2 = -1;
		$minServerity3 = -1;
		$maxServerity3 = -1;
		
		//set event notify related level
		if ($eventNotify & EventNotifyType::ERROR) {
			$severityRegion = EventSeverity::getSeverityRegion(EventNotifyType::ERROR);
			$minServerity1 = $severityRegion[0];
			$maxServerity1 = $severityRegion[1];
		}
		
		if ($eventNotify & EventNotifyType::WARNING) {
			$severityRegion = EventSeverity::getSeverityRegion(EventNotifyType::WARNING);
			$minServerity2 = $severityRegion[0];
			$maxServerity2 = $severityRegion[1];
		}
		
		if ($eventNotify & EventNotifyType::INFO) {
			$severityRegion = EventSeverity::getSeverityRegion(EventNotifyType::INFO);
			$minServerity3 = $severityRegion[0];
			$maxServerity3 = $severityRegion[1];
		}
		
		$eventRelated = array();
		
		foreach ($eventsList as $event)
		{
			//only events of related level will be added to events array
			if (($event->Severity >= $minServerity1 && $event->Severity <= $maxServerity1)
				|| ($event->Severity >= $minServerity2 && $event->Severity <= $maxServerity2)
				|| ($event->Severity >= $minServerity3 && $event->Severity <= $maxServerity3)
			) {
				$eventRelated[] = $event;
			}
		}
		
		if ($eventRelated) {
		if(constant('MAC_LOCAL_MAIL_SUPPORT') == 0){
			try {
				$mailer->sendEventNotify($contacts,$eventRelated);
			}
			catch (Exception $e)
			{
				//echo $e->getMessage();
				return false;
			}
		}
		else{
			$mailer->sendEventNotify($users,$eventRelated);
		}
		}
	}
	
	return true;
}

//initialize mailer
//if failed (connection failure),return null.
function initMailer($sysSetting)
{
if(constant('MAC_LOCAL_MAIL_SUPPORT') == 0){	
	$mailer = new MRUMailer();
	$mailer->setUserName($sysSetting->getUserName());
	$mailer->setPasswd($sysSetting->getPasswd());
	$mailer->setServerAddr($sysSetting->getServerAddr());
	$mailer->setPort($sysSetting->getPort());
	$mailer->setSSL($sysSetting->isSSL());
	
	if ($mailer->getServerAddr() == null) {
		return null;
	}
	
	try {
		$mailer->initMailer();
	}
	catch (Exception $e)
	{
		//echo $e->getMessage();
		return null;
	}
	
	return $mailer;
}
else
	return new MacMailer();
}
?>
