<?php
//include_once("PageDisplayer.class.php");
//For WD quick create page

class PgQCRaidModeDisplayer extends PageDisplayer
{
	protected function initPage()
	{
		if(!getSessionPara('isAdmin'))
		{
			$this->displayDefaultPage(Target::LdListPage);
			return;
		}
		
		$smarty = $this->smarty;
		//hd list
		$HDList = new FreeDiskList();
		$HDList->initData();
		
		if (intval($HDList->getHDCount()) == 0)
		{
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}

		//get request para
		$RaidMode = 0xff;
		$QuickRaidMode = getRequestPara('QuickRaidMode');
		if (isset($QuickRaidMode))
		{
			$RaidMode = $QuickRaidMode;
		}

		$HDs = $HDList->getHDIDs();
		$HDIDs = array();
		//
		$str_HDIDs = explode(" ",$HDs);
		for ($i=0; $i< $HDList->getHDCount(); $i++)
		{
			$HDIDs[$i] = $str_HDIDs[$i];
		}
		
		$selectedHBAID = $this->getAdapterID();
		$LDName = "WD";
		$InitType = "0";
		$ReadCache = "0";
		$GBRounding = "0";
		$SectorSize = "1";
		$StripeSize = "64";
		
		$HBAList = new HBAList();
		$HBAList->toGetHBAInfo();
		$HBAList->initData();
		
		$HBAs = $HBAList->getBaseClasses();
		
		$supportRaidHBAIDs = array();
		foreach ($HBAs as $HBA)
		{
			if ($HBA->supportRAID()) {
				$supportRaidHBAIDs[] = $HBA->getDeviceID();
			}
		}
			
		if (sizeof($supportRaidHBAIDs) == 0) {
			$this->displayDefaultPage(Target::LdListPage);
			return;
		}
		
		$smarty->assign("HBAIDs",$supportRaidHBAIDs);
		
		if ($selectedHBAID == null) {
			$selectedHBAID = $supportRaidHBAIDs[0];
		}
		
		$hba = HBAFactory::getInstance($selectedHBAID);
		//$hba = new HBA();
		$supportRaids = array();
		if ($hba->supportLDRaid0() && $HDList->getHDCount() > 1) {
			$supportRaids[RAIDMode::LD_MODE_RAID0] = RAIDMode::RAID0;
		}
		if ($hba->supportLDRaid1() && $HDList->getHDCount() == 2) {
			$supportRaids[RAIDMode::LD_MODE_RAID1] = RAIDMode::RAID1;
		}
		if ($hba->supportLDRaid10() && $HDList->getHDCount() >= 4) {
			$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
		}
		if ($hba->supportLDRaid1E() && $HDList->getHDCount() >= 3) {
			$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
		}
		if ($hba->supportLDRaid5()  && $HDList->getHDCount() >= 3) {
			$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
		}
		if ($hba->supportLDRaid50() && $HDList->getHDCount() >= 6) {
			$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
		}
		if ($hba->supportLDRaid6()  && $HDList->getHDCount() >= 4) {
			$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
		}
		if ($hba->supportLDRaid60() && $HDList->getHDCount() >= 8) {
			$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
		}
		if ($hba->supportLDRaidJBOD() && $HDList->getHDCount() >= 1) {
			$supportRaids[RAIDMode::LD_MODE_JBOD] = RAIDMode::JBOD;
		}

			
		$smarty->assign("RaidMode", $RaidMode);
		
		$smarty->assign("LDName", $LDName);
		$smarty->assign("InitType", $InitType);
		$smarty->assign("WriteCache", $HDList->getPolicy());
		$smarty->assign("GBRounding", $GBRounding);
		$smarty->assign("SectorSize", $SectorSize);
		$smarty->assign("StripeSize", $StripeSize);
		$smarty->assign("HBAID", $selectedHBAID);
		$smarty->assign("supportRaids", $supportRaids);
		$smarty->assign("HDIDArr", $HDIDs);		

		$this->setPageName(Target::CreateRaidModePage . ".tpl");
	}
}
?>