<?php
class PM extends Device 
{
	private $AdapterID;
	private $ProductRevision;
	private $PMSpecRevision;
	private $NumberOfPorts;
	private $VendorId;
	private $ModelId;
	
	private $EnclosureID;
	
	public function __construct()
	{
		$this->setDevType(DeviceType::DEVICE_TYPE_PM);
	}
	
	public function setAdapterID($AdapterID)
	{
		$this->AdapterID = $AdapterID;
	}
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function setProductRevision($ProductRevision)
	{
		$this->ProductRevision = $ProductRevision;
	}
	public function getProductRevision()
	{
		return $this->ProductRevision;
	}
	
	public function setPMSpecRevision($PMSpecRevision)
	{
		$this->PMSpecRevision = $PMSpecRevision;
	}
	public function getPMSpecRevision()
	{
		return $this->PMSpecRevision;
	}
	
	public function setNumberOfPorts($NumberOfPorts)
	{
		$this->NumberOfPorts = $NumberOfPorts;
	}
	public function getNumberOfPorts()
	{
		return $this->NumberOfPorts;
	}
	
	public function setVendorId($VendorId)
	{
		$this->VendorId = $VendorId;
	}
	public function getVendorId()
	{
		return $this->VendorId;
	}
	
	public function setModelId($ModelId)
	{
		$this->ModelId = $ModelId;
	}
	public function getModelId()
	{
		return $this->ModelId;
	}
	
	public function isSAS()
	{
		return false;
	}
	
	public function setEnclosureID($EnclosureID)
	{
		$this->EnclosureID = $EnclosureID;
	}
	
	public function getEnclosureID()
	{
		return $this->EnclosureID;
	}
	
	public function setPMInfo($Info)
	{		
		//set topology info
		foreach ($Info->Link as $Link)
		{
			$this->setTopologyLink($Link);
		}
		
		foreach ($Info->Link as $Link)
		{
			foreach ($Link->Self as $self)
			{
				if (isset($self->EnclosureID)) {
					$this->EnclosureID = trim($self->EnclosureID);
				}
			}
		}
		
		if (isset($Info->AdapterID)) {
			$this->AdapterID = trim($Info->AdapterID);
		}
		if (isset($Info->ProductRevision)) {
			$this->ProductRevision = dechex(trim($Info->ProductRevision));
		}
		if (isset($Info->PMSpecRevision)) {
			$this->PMSpecRevision = intval(trim($Info->PMSpecRevision));
		}
		if (isset($Info->NumberOfPorts)) {
			$this->NumberOfPorts = trim($Info->NumberOfPorts);
		}
		if (isset($Info->VendorId)) {
			$this->VendorId = dechex(trim($Info->VendorId));
		}
		if (isset($Info->DeviceId)) {
			$this->ModelId = dechex(trim($Info->DeviceId));
		}
	}
}

?>