<?php

abstract class BaseData{
	private $ErrCd;
	protected $XMLAPICommandList = array();
	protected $BaseClasses = array();
	//debug flag
	const DebugTest = 0;
	
	protected $AdapterID = 0xff;
	
	//return base data array
	public function getBaseClasses()
	{
		return $this->BaseClasses;
	}
	
	public function getBaseDetail()
	{
		$tmp = $this->BaseClasses;
		return array_shift($tmp);
	}
	
	public function setErrorCd($ErrorCd)
	{
		$this->ErrCd = $ErrorCd;
	}
	public function getErrorCd()
	{
		return $this->ErrCd;
	}
	
	public function setAdapterID($AdapterID)
	{
		$this->AdapterID = $AdapterID;
	}
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	//initialize base data
	public function initData()
	{
		if (self::DebugTest) {
			$this->prepareAPICommands();
			$this->loadTestData();
		}
		else 
			$this->initBaseClass();
	}
	
	//prepare commands,run commands,set commands result to base data array
	public function initBaseClass()
	{
		$this->prepareAPICommands();
		$this->runAPICommands();
		$this->setDataToBaseClass();
	}
	
	//run commands
	private function runAPICommands()
	{
		foreach ($this->XMLAPICommandList as $CallBack => $XmlApiCmd)
		{			
			if ($XmlApiCmd->issueCommand()) {
				$XMLRoot = $XmlApiCmd->getResult();

                                if(isset($XMLRoot))
                                    $this->$CallBack($XMLRoot);
								
				//set error cd
				if (isset($XMLRoot->RetVal)) {
					$this->setErrorCd(intval($XMLRoot->RetVal));
					//break;
				}
			}
			else {
				return false;
			}
		}
	}
	
	//prepare commands: set command parameter
	protected function prepareAPICommands()
	{
		//set adapter id for commands
		foreach ($this->XMLAPICommandList as $CallBack => $XmlApiCmd)
		{
			$XmlApiCmd->setCommandPara("AdapterID", $this->AdapterID);
		}
	}
	
	protected function setDataToBaseClass()
	{
		//do nothing defaultly
	}

	//load test data for debug
	public abstract function loadTestData();
}
?>