<?php
class CheckHyperSSDMode {
	
	private $HBAID;
	private $HDIDs;
	
	private function initPara()
	{
		$this->HBAID = getRequestPara("HBAID");
		$this->HDIDs = getRequestPara("HDIDs");
	}
	
	
	public function check()
	{
		$HDCount = 0;
		$hds = explode(" ",$this->HDIDs);
		
		/*foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$HDCount ++;
			}
		}
		
		if ($HDCount != 2) {
			$this->setCheckCmdXmlRetFailed();
			return;
		}*/
		
		$hdDtl1 = new HdDetail(); 
		$hdDtl1->setAdapterID($this->HBAID);
		$hdDtl1->setID($hds[0]);
		$hdDtl1->toGetHDInfo();
		$hdDtl1->initData();
		$hd1 = $hdDtl1->getBaseClasses();
		
		$hdDtl2 = new HdDetail(); 
		$hdDtl2->setAdapterID($this->HBAID);
		$hdDtl2->setID($hds[1]);
		$hdDtl2->toGetHDInfo();
		$hdDtl2->initData();
		$hd2 = $hdDtl2->getBaseClasses();
			
		if ($hd1->isSSD() == $hd2->isSSD()) {
			$this->setCheckCmdXmlRetFailed();
			return;
		}
		
		$this->setCheckCmdXmlRetSuccess();
		return;
		
	}
	
	private function setCheckCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = "JumpPage.php?Target=" . Target::getSSDVolumeDetail . "&HBAID=" . $this->HBAID . "&newCreate=1";
		
		$display = new XMLRetDisplayer();
		$display->assignSmarty($this->smarty);
		$display->display($this->xmlRet);
	}
	
	private function setCheckCmdXmlRetFailed()
	{
		$this->xmlRet = new FailXMLRet();
		//$XMLRoot = $this->ApiCmd->getResult();
		//if ($XMLRoot->RetVal . "") {
		$errStatus = $this->ApiCmd->getResult()->SSDStatus->Status;
			if ($errStatus == ComError::ERR_INVALID_ADAPTER_ID 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID;
			}
			//$Err = ComError::getErrStr(ComError::ERR_FAIL);
			$Err = SSDCreateVolumeStatus::getErrorMsg($errStatus);
			$this->xmlRet->Msg = $Err;
		//}
		
		$display = new XMLRetDisplayer();
		$display->assignSmarty($this->smarty);
		$display->display($this->xmlRet);
	}
	
	public function displayResultXML()
	{
		$this->TplFile = "XML_AllSSDStatus.tpl";
		$this->initPara();
		$this->setAllSSDStatus();
		
		if ($this->status >= SSDCreateVolumeStatus::CREATE_VD_FAIL){
			$this->setCreateVolumeCmdXmlRetFailed();
		}
		elseif ($this->status == SSDCreateVolumeStatus::CREATE_VD_SUCCESS ){
			$this->setCreateVolumeCmdXmlRetSuccess();
		}
		else 
		{
			$this->smarty->display($this->TplFile);
			//$this->setCreateVolumeCmdXmlRetSuccess();
		}
		
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}

?>