<?php
class ActionQuickCreateDG extends UserAction 
{
	private $quickCreateType;
	private $VDID = GET_ALL;
	private $HBAID = 0;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->HBAID = $this->getAdapterID();
		$this->quickCreateType = getRequestPara("type");
	}
	
	private function doCreateDGVD()
	{	
		include_once("../phpsrc/baseclass/LD.class.php");
		include_once("../phpsrc/baseclass/LdList.class.php");
		$oldVDs = new LdList();
		$oldVDs->setAdapterID($this->HBAID);
		$oldVDs->toGetLDInfo();
		
		$oldVDIDs = array();
		foreach ($oldVDs->getBaseClasses() as $vd)
		{
			$oldVDIDs[] = $vd->getID();
		}
		
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_LD_DG_QuickCreate);
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		$this->ApiCmd->setCommandPara("Type",$this->quickCreateType);
		
		$this->ApiCmd->issueCommand();
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setLDCreateFail();
			return ;
		}
		else {
            $sysFeature = AdapterFeature::getInstance($this->getAdapterID());

			$newVDs = new LdList();
			$newVDs->setAdapterID($this->getAdapterID());
			$newVDs->toGetLDInfo();
			
			$newVDIDs = array();
			foreach ($newVDs->getBaseClasses() as $vd)
			{
				$newVDIDs[] = $vd->getID();
			}
			$arr = array_diff($newVDIDs, $oldVDIDs);
			if ($arr) {
				$this->VDID = array_shift($arr);
			}

            if ($sysFeature->supportPackageVD)
			    $this->setPackageVDCreateCmdXmlRetSuccess();
            else
			    $this->setLDCreateCmdXmlRetSuccess();
		}
	}
	
	private function setPackageVDCreateCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
			."?Target=" . Target::getPackageVDPage . "&ID=" . $this->VDID . "&HBAID=" . $this->HBAID;
	}

	private function setLDCreateCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
			."?Target=" . Target::getVDSubPage . "&ID=" . $this->VDID . "&HBAID=" . $this->HBAID;
	}
	
	private function setLDCreateFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	
	protected function doAction()
	{
		$this->doCreateDGVD();
	}
}
?>