<?php

abstract class CtnAcceleratorStatusDisplayer extends CtnDisplayer {
    protected $accStatus;
    protected $hasOperationRunning;
    protected $applications;

    //put your code here
    protected function handlerAppStatusByVol($vol) {
        $smarty = $this->smarty;
        $appDA = new ApplicationDataAccess();
        if ($vol == null) {
            $this->applications = $appDA->findAll();
        } else {
            $this->applications = $appDA->findAllByVolume($vol);
        }
        $appList = array();

        $taskDA = new AcceleratorTaskDataAccess();
        $tasks = $taskDA->findAll();

        $this->accStatus = new AcceleratorStatus();

        if($this->accStatus->isDefragging()) {
            foreach($this->applications as $app) {
                foreach($tasks as $aTask) {
                    if($aTask->getTaskParam() == ("" . $app->getKeyId())) {
                        if($aTask->getTaskStatus() == AcceleratorTaskStatus::STATUS_RUNNING) {
                            if(AcceleratorTaskType::TASK_TYPE_PIN_APP == $aTask->getTaskType())
                                $app->setAppStatus(AppStatus::STATUS_PINNING);
                            else if(AcceleratorTaskType::TASK_TYPE_UNPIN_APP == $aTask->getTaskType())
                                $app->setAppStatus(AppStatus::STATUS_UNPINNING);
                        } else if($aTask->getTaskStatus() == AcceleratorTaskStatus::STATUS_NOT_RUN) {
                            if(AcceleratorTaskType::TASK_TYPE_PIN_APP == $aTask->getTaskType())
                                $app->setAppStatus(AppStatus::STATUS_TO_PIN_ON_QUEUE);
                            else if(AcceleratorTaskType::TASK_TYPE_UNPIN_APP == $aTask->getTaskType())
                                $app->setAppStatus(AppStatus::STATUS_TO_UNPIN_ON_QUEUE);
                        } else if($aTask->getTaskStatus() == AcceleratorTaskStatus::STATUS_PAUSED) {
                            if(AcceleratorTaskType::TASK_TYPE_PIN_APP == $aTask->getTaskType())
                                $app->setAppStatus(AppStatus::STATUS_PINNING_PAUSED);
                            else if(AcceleratorTaskType::TASK_TYPE_UNPIN_APP == $aTask->getTaskType())
                                $app->setAppStatus(AppStatus::STATUS_UNPINNING_PAUSED);
                        }
                        break;
                    }
                }
            }
        } else {
            if($this->accStatus->hasOperationRunning()) {
                foreach($this->applications as $app) {
                    if ($app->getAppStatus() == AppStatus::STATUS_NOT_SYNC) {
                    }
                }
            }
        }

        include_once("../phpsrc/action/GetAcceleratingStatus.class.php");
        $status = new GetAcceleratingStatus();
        $status->smartyAssign($smarty);
        $status->setAcceleratingStatus();
        $hasRunningTask = $status->hasRunningTask();

        $smarty->assign("isScanningApp", $this->accStatus->isScanning());
        $smarty->assign("isAutoSelecting", $this->accStatus->isAutoSelecting());
        $smarty->assign("isDefragRunning", $this->accStatus->isDefragRunning());
        $smarty->assign("isDefragPaused", $this->accStatus->isDefragPaused());
        $smarty->assign("isDefragging", $this->accStatus->isDefragging());
        $smarty->assign("isMaintainning", $this->accStatus->isMaintainning());
        $smarty->assign("isTriming", $this->accStatus->isTriming());
        $smarty->assign("isSSDSizeUpdating", $this->accStatus->isSSDSizeUpdating());

        $this->hasOperationRunning = $this->accStatus->isScanning() || $this->accStatus->isDefragging()
                || $this->accStatus->isAutoSelecting()
                || $this->accStatus->isDefragPaused() || $hasRunningTask
                || $this->accStatus->isMaintainning() || $this->accStatus->isSSDSizeUpdating()
                || $this->accStatus->isTriming() || $this->accStatus->isSSDSizeUpdating();

    }

}
?>
