<?php
class BlockXmlHandler extends XmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		//$Flag = BlockFlag::VALID | BlockFlag::ASSIGNED; // int val
		if (isset($XMLRoot->blockInfo))
		{
			foreach ($XMLRoot->blockInfo as $ldBlock)
	 		{
	 			$id = trim($ldBlock->ID);
	 			if ($factory->hasObj($id)) {
					$blk = $factory->getObj($id);
					$blk->setBlkInfo($ldBlock);
				}
				else {
					$blk = $this->getFactory()->createObj($id);
					$blk->setBlkInfo($ldBlock);
				}
	 		}
		}
	}
}

class BlockList extends BaseFactory
{	
	protected function createObject()
	{
		return new Block();
	}
	
	public function toGetBlkInfo()
	{
		$handler = new BlockXmlHandler();
		
		$this->runCommand(XMLAPICommand::MV_BLK_GetInfo, $handler);
	}
	
	public function setRequestSender()
	{
		$this->reqSender = new BaseMultiRequestSender();
		$this->reqSender->setStartNo(0);
		$this->reqSender->setMaxNoPerRequest(APIMaxSupport::MAX_BLOCK_SUPPORTED_API);
		$this->reqSender->setNumRequested(65535);
	}
}

?>