<?php
//the class for getting Migrated target LD size
class GetMigratedLDSize
{
	private $ApiCmd;
	private $TplFile;
	private $ApiCmdGetChange;
	private $smarty;
	
	private $HDs;
	private $RaidMode;
	private $LDID;
	private $HBAID = 0;
	private $NumOfParityDisk = 0; //default value
	private $UseThorSizePolicy = 0;
	
	private function initPara()
	{
		$this->HDs = getRequestPara("HDs");
		$this->RaidMode = getRequestPara("RaidMode");
		$this->LDID = getRequestPara("LDID");
		$this->HBAID = getRequestPara("HBAID");
		
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID6 || $this->RaidMode == RAIDMode::LD_MODE_RAID60 ) {
			$this->NumOfParityDisk = getRequestPara("NumOfParityDisk");
		}
		
		$sysFeature = AdapterFeature::getInstance($this->HBAID);
		$this->UseThorSizePolicy = $sysFeature->isThor;
	}
	
	private function setMigrateLDSize()
	{
		$Cmd = new XMLAPICommand();
		$Cmd->setCommand(XMLAPICommand::MV_LD_GetMigratedLdSize);
		$Cmd->setCommandPara("AdapterID",$this->HBAID);
		$Cmd->setCommandPara("RaidMode",$this->RaidMode);
		$Cmd->setCommandPara("NumParityDisk",$this->NumOfParityDisk);
		$Cmd->setCommandPara("HDIDs",$this->HDs);
		$Cmd->setCommandPara("LDID",$this->LDID);
		
		//HDCount
		$HDCount = 0;
		$hds = explode(" ",$this->HDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$HDCount ++;
			}
		}
		$Cmd->setCommandPara("HDCount",$HDCount);
		
		if ($Cmd->issueCommand()) {
			$size = $Cmd->getResult()->CreateLDParam->Size;
			$this->smarty->assign("MigratedSizeGB",FormatSize($size,$this->UseThorSizePolicy));
			$this->smarty->assign("MigratedSize",ConvertSize($size,$this->UseThorSizePolicy));
		}
	}
	
	private function setTestData()
	{
		$size = 123333333;
		$this->smarty->assign("MigratedSizeGB",FormatSize($size));
		$this->smarty->assign("MigratedSize",ConvertSize($size));
	}
	
	public function displayResultXML()
	{
		$this->TplFile = "XML_MigratedLDSize.tpl";
		if (BaseData::DebugTest) {
			$this->setTestData();
			$this->smarty->display($this->TplFile);
			return;
		}
		$this->initPara();
		$this->setMigrateLDSize();
		$this->smarty->display($this->TplFile);
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}
?>