<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/

/**
 * Description of AcceleratorStatusclass
 *
 * @author hank
 */
class AcceleratorStatus {

    private $isScanning;
    private $isAutoSelecting;
    private $isDefragging;
    private $isMaintainning;
    private $isSSDSizeUpdating;
    private $isTriming;

    private $defraggerState;
    private $scannerState;
    private $selectorState;
    private $maintainerState;
    private $ssdSizeUpdatorState;
    private $trimerState;

    private $status;

    const MV_ACCELERATOR_STATUS_DEFRAGGING = 1;
    const MV_ACCELERATOR_STATUS_SCANNING	= 2;
    const MV_ACCELERATOR_STATUS_AUTOSELECTING = 4;
    const MV_ACCELERATOR_STATUS_MAINTAINING	= 8;
    const MV_ACCELERATOR_STATUS_FREE_SIZE_UPDATING = 16;
    const MV_ACCELERATOR_STATUS_TRIMING = 32;

    function  __construct() {
        $ApiCmd = new XMLAPICommand();
        $ApiCmd->setCommand(XMLAPICommand::MV_Accelerator_GetStatus);
        $ApiCmd->issueCommand();

        $res = $ApiCmd->getResult();

        //var_dump($ApiCmd);

        if(isset($res)) {
            if(intval($res->RetVal) == 0) {
                if(isset($res->StatusInfo) && !empty($res->StatusInfo)) {
                    foreach($res->StatusInfo as $statusInfo) {

                        $this->status = intval($statusInfo->Status);

                        if($this->status > 0) {
                            $this->isAutoSelecting = ($this->status & self::MV_ACCELERATOR_STATUS_AUTOSELECTING) > 0;
                            $this->isScanning = ($this->status & self::MV_ACCELERATOR_STATUS_SCANNING) > 0;
                            $this->isDefragging = ($this->status & self::MV_ACCELERATOR_STATUS_DEFRAGGING) > 0;
                            $this->isMaintainning =  ($this->status & self::MV_ACCELERATOR_STATUS_MAINTAINING) > 0;
                            $this->isSSDSizeUpdating =  ($this->status & self::MV_ACCELERATOR_STATUS_FREE_SIZE_UPDATING) > 0;
                            $this->isTriming = ($this->status & self::MV_ACCELERATOR_STATUS_TRIMING) > 0;

                            $this->defraggerState = intval($statusInfo->DefraggerState);
                            $this->scannerState = intval($statusInfo->ScannerState);
                            $this->selectorState = intval($statusInfo->SelectorState);
                            $this->maintainerState = intval($statusInfo->MaintainerState);
                            $this->ssdSizeUpdatorState = intval($statusInfo->SSDSizeUpdatorState);
                            $this->trimerState = intval($statusInfo->TrimerState);

                            if($this->defraggerState == AcceleratorState::ACCELERATOR_STATE_ABORTED) {
                                $this->defraggerState = 0;
                            }
                        }

                    }
                }
            }
        }
    }

    public function isTriming() {
        return $this->isTriming;
    }

    public function isScanning() {
        return $this->isScanning;
    }

    public function isAutoSelecting() {
        return $this->isAutoSelecting;
    }

    public function isDefragging() {
        return $this->isDefragging;
    }

    public function isMaintainning() {
        return $this->isMaintainning;
    }

    public function isSSDSizeUpdating() {
        return $this->isSSDSizeUpdating;
    }

    public function getDefraggerState() {
        return $this->defraggerState;
    }

    public function getScannerState() {
        return $this->scannerState;
    }

    public function getSelectorState() {
        return $this->selectorState;
    }

    public function getMaintainerState() {
        return $this->maintainerState;
    }

    public function isDefragPaused() {
        return ($this->isDefragging && ($this->getDefraggerState() == AcceleratorState::ACCELERATOR_STATE_PAUSED
                                ||$this->getDefraggerState() == AcceleratorState::ACCELERATOR_STATE_AUTOPAUSED));
    }

    public function isDefragRunning() {
        return ($this->isDefragging && $this->getDefraggerState() == AcceleratorState::ACCELERATOR_STATE_RUNNING);
    }

    public function hasOperationRunning() {

        return $this->isScanning() || $this->isDefragging()
                    || $this->isAutoSelecting() || $this->isDefragPaused()
                    || $this->isMaintainning() || $this->isSSDSizeUpdating();
    }
}
?>
