<?php
//include_once("PageDisplayer.class.php");

class PgRebuildPackageVDDisplayer extends BGAPageDisplayer
{
	
	protected function setDisplayInfo()
	{
		if ($this->cmdPara != null) {
			$HDID = getUrlPropertyValue($this->cmdPara,'HDID');
			$this->smarty->assign('HDID',$HDID);
		}

		$this->setPageName(Target::RebuildPackageVDPage . ".tpl");
	}
	
	protected function setInfo()
	{
		$ID = getRequestPara('ID');
		$HBAID = $this->getAdapterID();
		if ($ID == null) {
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$smarty = $this->smarty;
		
		//add for sub menu
		$container = new CtnPackageVDDetail();
		$container->setAdapterID($HBAID);		
		$container->setLDID($ID);
		$container->toGetLDInfo();
		$container->toGetHDInfo();
		$container->toGetBlockInfo();
		$container->smartyAssign($smarty);
		$container->initContainer();
		
		$ldlst = $container->getBase()->getBaseClasses();
		if (!sizeof($ldlst)) {
			$Name = gettext('VD Not Exist');
			$smarty->assign('VDNotExist',1);
		}
		else {
			$ldDetail = array_shift($ldlst);
			$Name = $ldDetail->getName();
			$blklst = $ldDetail->getBlockList();
			if ($blklst) {
				$HDs =array();
				foreach ($blklst as $aBlk)
				{
					$aHd = $aBlk->belongHD();
					$HDs[] = $aHd;
				}

				$blk = array_shift($blklst);
				$blkSize = $blk->getSize();
				if ($HDs) {
					$filter = new HdRebuildFilter($blkSize,$HDs);
					$hdList = new CtnHdList();
					$hdList->setAdapterID($this->getAdapterID());
					$hdList->toGetHDInfo();
					$hdList->toGetValidSize();
					$hdList->toGetSpareInfo();
					$hdList->toGetHdFreeInfo();
					$hdList->setFilter($filter);
					$hdList->smartyAssign($smarty);
					$hdList->initContainer();
				}
			}
		}
		
    	$CancelAlert = gettext(AlertMsg::REBUILD_CANCEL)."?";
    	$smarty->assign("CancelAlert",$CancelAlert);
    	$smarty->assign("ID",$ID);
    	$smarty->assign("HBAID",$HBAID);
    	$smarty->assign("Name",$Name);

	}
}
?>