<?php
class ElementInfo
{
	public static $FanNum = 0;
	public static $PowerNum = 0;
	public static $TprNum = 0;
	public static $VolNum = 0;
	public $ID;
	public $Index;
	public $ElementImg;
	public $isFan = 0;
	public $isPower = 0;
	public $isTpr = 0;
	public $isVol = 0;
	public $TypeInt;
	public $TypeStr;
	public $StatusInt;
	public $StatusStr;
	public $NotAvail = 0;
	
	//public $WarnBit;
	//public $WarnStr;
	public $WarnArr = array();
	public $TempWarn;
	public $HotSwap;
	public $DCOverVoltage;
	public $DCUnderVoltage;
	public $DCOverCurrent;
	
	public $OTFailure;
	public $OTWarning;
	public $UTFailure;
	public $UTWarning;
	
	public $WarnNum;
	
	public $VoltageType;
	public $Voltage;
	public $CurSpeedcode;
	public $CurSpeedLevel;
	public $CurSpeed;
	public $Temperature;
	public $TemperatureF;
	public $HCT;  //Temperature High Critical Threshold
	public $HWT;  //Temperature High Warning Threshold
	public $LCT;  //Temperature Low Critical Threshold
	public $LWT;  //Temperature Low Warning Threshold
	public $HCTF;
	public $HWTF;
	public $LCTF;
	public $LWTF;
	
	public function getFanNum()
	{
		return self::$FanNum;
	}
	
	public function getVolNum()
	{
		return self::$VolNum;
	}
	
	public function getPowerNum()
	{
		return self::$PowerNum;
	}
	
	public function getTprNum()
	{
		return self::$TprNum;
	}
	
	private function YesOrNo($int)
	{
		switch ($int) {
			case 0:
				return gettext("No");
			case 1:
			default:
				return gettext("Yes");
		}
	}
	
	public function setElementInfo($Info)
	{
		$this->ID = $Info->getID();
		$this->Index = ($this->ID)+1;
		$this->StatusInt = $Info->getStatus();
		$this->NotAvail = ($this->StatusInt == ENCElementStatus::SES2_ELEMENT_STATUS_NOTAVAILABLE 
							|| $this->StatusInt == ENCElementStatus::SES2_ELEMENT_STATUS_NOTINSTALL 
							|| $this->StatusInt == ENCElementStatus::SES2_ELEMENT_STATUS_UNSUPPORT 
							|| $this->StatusInt == ENCElementStatus::SES2_ELEMENT_STATUS_UNKNOWN);
		$this->TypeInt = $Info->getType();
		$this->StatusStr = gettext(ENCElementStatus::getENCElementStatus($this->StatusInt));
		$this->TypeStr = gettext(ENCElementType::GetTypeStr($this->TypeInt));
		$this->isFan = $Info->getType() == ENCElementType::ENC_ELEMENTTYPE_COOLING ;
		$this->isPower = $Info->getType() == ENCElementType::ENC_ELEMENTTYPE_POWERSUPPLY ;
		$this->isTpr = $Info->getType() == ENCElementType::ENC_ELEMENTTYPE_TEMPERATURE ;
		$this->isVol = $Info->getType() == ENCElementType::ENC_ELEMENTTYPE_VOLTAGESENSOR  ;
		
		if ($this->isFan)
		{
			self::$FanNum++;
			$this->CurSpeedcode = $Info->getCurSpeedcode();
			$this->CurSpeed = $Info->getCurSpeed();
			if(($this->StatusInt == ENCElementStatus::SES2_ELEMENT_STATUS_OK )
			    && $this->CurSpeed == 0) {
			    	$this->CurSpeedLevel = gettext(ENCFan::GetFanSpeedLevel($this->CurSpeedcode));
			}
			$this->ElementImg = ENCElementImg::GetFanImg($this->StatusInt);//ENC_COOLING_IMG;
		} elseif ($this->isPower) {
			self::$PowerNum++;
			$this->ElementImg = ENCElementImg::GetPowerImg($this->StatusInt);
			$this->TempWarn = $Info->getTempWarn();
			$this->HotSwap = $Info->getHotSwap();
			$this->DCOverCurrent = $Info->getDCOverCurrent();
			$this->DCOverVoltage = $Info->getDCOverVoltage();
			$this->DCUnderVoltage = $Info->getDCUnderVoltage();
			
			$this->WarnArr[gettext(ENCElementWarnBit::ENC_TEMPSENSOR_OTWARN_STR)] = $this->YesOrNo($this->TempWarn);
			$this->WarnArr[gettext(ENCElementWarnBit::ENC_POWERSUPPLY_HOTSWAP_STR )] = $this->YesOrNo($this->HotSwap);
			$this->WarnArr[gettext(ENCElementWarnBit::ENC_POWERSUPPLY_DCOVER_STR)] = $this->YesOrNo($this->DCOverVoltage);
			$this->WarnArr[gettext(ENCElementWarnBit::ENC_POWERSUPPLY_DCOVERCURRENT_STR )] = $this->YesOrNo($this->DCOverCurrent);
			$this->WarnArr[gettext(ENCElementWarnBit::ENC_POWERSUPPLY_DCUNDER_STR )] = $this->YesOrNo($this->DCUnderVoltage);
			
			$this->VoltageType = $Info->getVoltageType();
		} elseif ($this->isTpr) {
			self::$TprNum++;
			$this->ElementImg = ENCElementImg::ENC_TPR_IMG;
			$this->UTFailure = $Info->getUTFailure();
			$this->UTWarning = $Info->getUTWarning();
			$this->OTFailure = $Info->getOTFailure();
			$this->OTWarning = $Info->getOTWarning();
			
			if ($this->UTFailure)
				$this->WarnArr[] = gettext(ENCElementWarnBit::ENC_TEMPSENSOR_UTFAIL_STR);
			if ($this->UTWarning)
				$this->WarnArr[] = gettext(ENCElementWarnBit::ENC_TEMPSENSOR_UTWARN_STR);
			if ($this->OTFailure)
				$this->WarnArr[] = gettext(ENCElementWarnBit::ENC_TEMPSENSOR_OTFAIL_STR);
			if ($this->OTWarning)
				$this->WarnArr[] = gettext(ENCElementWarnBit::ENC_TEMPSENSOR_OTWARN_STR);
			
			$this->WarnNum = sizeof($this->WarnArr);
		
			if ($this->WarnNum == 0) {
				$this->WarnArr[] = gettext("None");
			}
			for ($i=0; $i < ($this->WarnNum-1); $i++)
			{
				$this->WarnArr[$i] .= "/";
			}
			
			$this->Temperature = $Info->getTemperature();
			if(isset($this->Temperature) && $this->Temperature != 0) {
				$this->Temperature -= 20;
				$this->TemperatureF = (($this->Temperature * 9)/5) + 32;
			}
			
			$this->HCT = $Info->getHCT();
			if(isset($this->HCT) && $this->HCT != 0){
				$this->HCT -= 20;
				$this->HCTF = (($this->HCT * 9)/5) + 32;
			}
			$this->HWT = $Info->getHWT();
			if(isset($this->HWT) && $this->HWT != 0){
				$this->HWT -= 20;
				$this->HWTF = (($this->HWT * 9)/5) + 32;
			}
			$this->LCT = $Info->getLCT();
			if(isset($this->LCT) && $this->LCT != 0){
				$this->LCT -= 20;
				$this->LCTF = (($this->LCT * 9)/5) + 32;
			}
			$this->LWT = $Info->getLWT();
			if(isset($this->LWT) && $this->LWT != 0){
				$this->LWT -= 20;
				$this->LWTF = (($this->LWT * 9)/5) + 32;
			}
		} elseif ($this->isVol) {
			self::$VolNum++;
			$this->ElementImg = ENCElementImg::ENC_VOL_IMG;
			$this->Voltage = $Info->getVoltage();
			$this->HCT = $Info->getHCT();
			$this->HWT = $Info->getHWT();
			$this->LCT = $Info->getLCT();
			$this->LWT = $Info->getLWT();
		}
	}
}

class EnclInfo extends DevInfo 
{
	public $ID;
	public $AdapterID;
	public $Status;
	public $ProductRevision;
	public $VendorId;
	public $ProductId;
	public $FanNum;
	public $PowerNum;
	public $TprNum;
	public $VolNum;
	public $FanList = array();
	public $PowerList = array();
	public $TprList = array();
	public $ExpanderCount;
	public $ExpanderIDs = array();
	public $ExpanderList = array();
	public $PMCount;
	public $PMIDs = array();
	public $PMList = array();
	public $hasExpander = 0;
	public $hasPM = 0;
	
	public function setEnclInfo($Info)
	{
		$this->ID = $Info->getDeviceID();
		$this->AdapterID = $Info->getAdapterID();
		$this->Status = gettext(ENCStatus::GetStatusStr($Info->getStatus()));
		$this->ProductRevision = $Info->getProductRevision();
		$this->VendorId = $Info->getVendorId();
		$this->ProductId = $Info->getProductId();
		$this->ExpanderCount = $Info->getExpandercount();
	
		$this->ExpanderIDs = $Info->getExpanderIDs();
		$this->PMIDs = $Info->getPMIDs();
		
		if ($this->PMIDs) $this->hasPM = 1;
		if ($this->ExpanderIDs) $this->hasExpander = 1;
	}
	
	public function setEnclDtl($Dtl)
	{
		foreach ($Dtl->getElementList() as $element)
		{
			$eleInfo = new ElementInfo();
			$eleInfo->setElementInfo($element);
			if ($eleInfo->isFan) {
				$this->FanList[] = $eleInfo;
			}
			if ($eleInfo->isPower) {
				$this->PowerList[] = $eleInfo;
			}
			if ($eleInfo->isTpr) {
				$this->TprList[] = $eleInfo;
			}
		}
		$eleInfo = new ElementInfo();
		$this->FanNum = $eleInfo->getFanNum();
		$this->PowerNum = $eleInfo->getPowerNum();
		$this->VolNum = $eleInfo->getVolNum();
		$this->TprNum = $eleInfo->getTprNum();
		
		$index = 0;
		foreach ($Dtl->getExpanderList() as $expander) {
			$expInfo = new ExpanderInfo();
			$expInfo->setExpanderInfo($expander);
			$expInfo->setExpanderDtl($expander);
			$index++;
			$expInfo->index = $index;
			$this->ExpanderList[] = $expInfo;
			$this->hasExpander = 1;
		}
		
		$index = 0;
		foreach ($Dtl->getPMList() as $pm) {
			$pmInfo = new PMInfo();
			$pmInfo->setPMInfo($pm);
			$pmInfo->setPMDtl($pm);
			$index++;
			$pmInfo->index = $index;
			$this->PMList[] = $pmInfo;
			$this->hasPM = 1;
		}
		$this->PMCount = sizeof($this->PMList);
	}
}

?>