<?php
class Block
{
	private $ID;
	private $PtrHD;
	private $PrtLD;
	private $LDID;
	private $HDID;
	
	private $StartLBA;
	private $Size;
	private $IndexInLd;
	
	private $Status;
	private $Flag;
	
	public function setIndexInLd($index)
	{
		$this->IndexInLd = $index;
	}
	
	public function getIndexInLd()
	{
		return $this->IndexInLd;
	}

	public function setID($ID)
	{
		$this->ID = $ID;
	}
	public function getID()
	{
		return $this->ID;
	}
	
	public function setLDID($LDID)
	{
		$this->LDID = $LDID;
	}
	public function getLDID()
	{
		return $this->LDID;
	}
	
	public function setHDID($HDID)
	{
		$this->HDID = $HDID;
	}
	public function getHDID()
	{
		return $this->HDID;
	}
	
	public function setStatus($Status)
	{
		$this->Status = $Status;
	}
	public function getStatus()
	{
		return $this->Status;
	}
	
	public function setFlag($Flag)
	{
		$this->Flag = $Flag;
	}
	public function getFlag()
	{
		return $this->Flag;
	}
	
	public function setSize($Size)
	{
		$this->Size = $Size;
	}
	public function getSize()
	{
		return $this->Size;
	}
	
	public function setStartLBA($StartLBA)
	{
		$this->StartLBA = $StartLBA;
	}
	public function getStartLBA()
	{
		return $this->StartLBA;
	}
	
	public function belongHD()
	{
		return $this->PtrHD;
	}
	
	public function linkHD($HD)
	{
		$this->PtrHD=$HD;
		if (! $HD->hasBlock($this->getID())) {
			$HD->addBlock($this);
		}
	}
	
	public function belongLD()
	{
		return $this->PtrLD;
	}
	
	public function linkLD($LD)
	{
		$this->PtrLD=$LD;
		if (! $LD->hasBlock($this->getID())) {
			$LD->addBlock($this);
		}
	}
	
	//set Block data from xml element
	public function setBlkInfo($Info)
	{
		if (isset($Info->ID)) {
			$this->ID = trim($Info->ID);
		}
		if (isset($Info->HDID)) {
			$this->HDID = trim($Info->HDID);
		}
		if (isset($Info->LDID)) {
			$this->LDID = trim($Info->LDID);
		}
		if (isset($Info->Flags)) {
			$this->Flag = trim($Info->Flags);
		}
		if (isset($Info->StartLBA)) {
			$this->StartLBA = trim($Info->StartLBA);
		}
		if (isset($Info->Status)) {
			$this->Status = trim($Info->Status);
		}
		if (isset($Info->Size)) {
			$this->Size = floatval(trim($Info->Size));
		}
	}
}

?>