/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.validation;

import java.util.ArrayList;
import pdtEditor.DataStore;
import pdtEditor.PdtFile;
import pdtEditor.validation.Fixer;
import pdtEditor.validation.IValidatable;

public class Issue {
    public IssueType _issueType;
    public String element;
    private String message;
    public String description;
    public Fixer fixer;
    private IValidatable object = null;

    public Issue(IssueType type, IValidatable paentObject) {
        this._issueType = type;
        this.object = paentObject;
        if (paentObject != null) {
            this.element = paentObject.getElementName();
        }
    }

    public void setType(IssueType type) {
        this._issueType = type;
    }

    public boolean isCritical() {
        return this._issueType == IssueType.CRITICAL;
    }

    public boolean hasFixer() {
        return this.fixer != null;
    }

    public String getElement() {
        return this.element;
    }

    public String getBasicMessage() {
        return this.message;
    }

    public void setBasicMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this._issueType.getPrefix() + this.message;
    }

    public void setMessage(String msg) {
        this.message = msg.startsWith(this._issueType.getPrefix()) ? msg.substring(this._issueType.getPrefix().length()) : msg;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(IValidatable object) {
        this.object = object;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)arg0;
        return (this.element == null && other.element == null || this.element != null && this.element.equals(other.element)) && (this.message == null && other.message == null || this.message != null && this.message.equals(other.message));
    }

    public boolean isIgnorable() {
        return this._issueType != IssueType.CRITICAL && !this.isIgnored() && (this.object == null || this.object.getActiveIssues().contains(this));
    }

    public boolean isIgnored() {
        PdtFile pdtFile = DataStore.getInstance().getCurrentPdtFile();
        ArrayList<Issue> issues = DataStore.getInstance().getCurrentPdtFile().getAllIgnoredIssues();
        if (pdtFile == null) {
            return false;
        }
        return issues != null && issues.contains(this);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static enum IssueType implements Comparable<IssueType>
    {
        CRITICAL(0, "Critical"),
        WARNING(1, "Warning"),
        NOTIFICATION(2, "Notification");

        int _value;
        String _name;

        private IssueType(int value, String name) {
            this._value = value;
            this._name = name;
        }

        public String getPrefix() {
            return this._name + ": ";
        }
    }
}

