/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class DevicePostureConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 106;
    public static final String CALIBRATION_FORMAT_STRING = "Device Posture Configuration";
    private static final int LATEST_FORMAT_ID = 0;
    public static final int NOT_AVAILABLE_VALUE = -1;
    public static final String NOT_AVAILABLE_TEXT = "Not Available";
    public static final int MIN_ROWS_IN_CONF_TABLE = 1;
    public static final int MAX_ROWS_IN_CONF_TABLE = 15;
    public static final int MAX_ROWS_IN_GPIO_TABLE = 15;
    public static final int MAX_ROWS_IN_ACTION_TABLE = 64;
    public static final String SDO_STATE_TEXT_NOT_ROTATED = "Not Rotated";
    public static final String SDO_STATE_TEXT_ROTATED_90 = "Rotated 90";
    public static final String SDO_STATE_TEXT_ROTATED_180 = "Rotated 180";
    public static final String SDO_STATE_TEXT_ROTATED_270 = "Rotated 270";
    public static final String SDO_STATE_TEXT_FACE_UP = "Face up";
    public static final String SDO_STATE_TEXT_FACE_DOWN = "Face down";
    public static final String SDO_STATE_TEXT_NOT_AVAILABLE = "Not Available";
    public static final int SDO_STATE_VALUE_NOT_ROTATED = 1;
    public static final int SDO_STATE_VALUE_ROTATED_90 = 2;
    public static final int SDO_STATE_VALUE_ROTATED_180 = 4;
    public static final int SDO_STATE_VALUE_ROTATED_270 = 8;
    public static final int SDO_STATE_VALUE_FACE_UP = 16;
    public static final int SDO_STATE_VALUE_FACE_DOWN = 32;
    public static final int SDO_STATE_VALUE_NOT_AVAILABLE = 255;
    public static final String TABLET_MODE_TEXT_TABLET_MODE = "Yes";
    public static final String TABLET_MODE_TEXT_NOT_TABLET_MODE = "No";
    public static final String TABLET_MODE_TEXT_NOT_AVAILABLE = "Not Available";
    public static final int TABLET_MODE_VALUE_TABLET_MODE = 1;
    public static final int TABLET_MODE_VALUE_NOT_TABLET_MODE = 0;
    public static final int TABLET_MODE_VALUE_NOT_AVAILABLE = 255;
    public static final int POSTURE_MODE_ID_FIELD_SIZE = 1;
    public static final int PLM_MODE_ID_FIELD_SIZE = 4;
    public static final int SDO_STATE_PRIMARY_FIELD_SIZE = 1;
    public static final int SDO_STATE_SECONDARY_FIELD_SIZE = 1;
    public static final int TABLET_MODE_SIZE = 1;
    public static final int ACTION_MODEID_FILED_SIZE = 1;
    public static final int ACTION_GPIO_PURPOSE_ID_FIELD_SIZE = 1;
    public static final int ACTION_VALUE_FIELD_SIZE = 1;
    public static final int DEFAULT_VALUE_POSTURE_ID = 0;
    public static final int DEFAULT_VALUE_PLM_MODE_ID = 0;
    public static final int DEFAULT_VALUE_SDO_STATE_PRIMARY = 1;
    public static final int DEFAULT_VALUE_SDO_STATE_SECONDARY = 1;
    public static final int DEFAULT_VALUE_TABLET_MODE = 255;
    private ArrayList<ConditionTable> conditionList = new ArrayList();
    private ArrayList<ActionEntry> actionList = new ArrayList();
    private int _formatID = 0;
    private int _version;

    public DevicePostureConfigurationPayload() {
    }

    public DevicePostureConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        int i;
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"DevicePostureConfiguration", (Node)payloadXmlNode).xmlElement;
        int configTableRows = reader.readNewField((String)"NumConfigurationRows", (int)1, (boolean)false, (Node)configurationElement).value;
        int numActionRows = reader.readNewField((String)"NumActionRows", (int)1, (boolean)false, (Node)configurationElement).value;
        for (i = 1; i <= configTableRows; ++i) {
            Element configurationRowElement = reader.readNewField((String)new StringBuilder().append((String)"ConfigurationRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            ConditionTable condition = new ConditionTable();
            condition.postureId = reader.readNewField((String)"DevicePostureId", (int)1, (boolean)false, (Node)configurationRowElement).value;
            condition.plmModeId = reader.readNewField((String)"PlmModeID", (int)4, (boolean)false, (Node)configurationRowElement).value;
            condition.tabletMode = reader.readNewField((String)"TabletMode", (int)1, (boolean)false, (Node)configurationRowElement).value;
            condition.sdoStatePrimary = reader.readNewField((String)"SdoStatePrimary", (int)1, (boolean)false, (Node)configurationRowElement).value;
            condition.sdoStateSecondary = reader.readNewField((String)"SdoStateSecondary", (int)1, (boolean)false, (Node)configurationRowElement).value;
            this.conditionList.add(condition);
        }
        for (i = 1; i <= numActionRows; ++i) {
            Element actionRowElement = reader.readNewField((String)new StringBuilder().append((String)"ActionRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            ActionEntry actionEntry = new ActionEntry();
            actionEntry.mode = reader.readNewField((String)"ModeId", (int)1, (boolean)false, (Node)actionRowElement).value;
            actionEntry.gpioPurposeId = reader.readNewField((String)"Purpose", (int)1, (boolean)false, (Node)actionRowElement).value;
            actionEntry.value = reader.readNewField((String)"Value", (int)1, (boolean)false, (Node)actionRowElement).value;
            this.actionList.add(actionEntry);
        }
    }

    public DevicePostureConfigurationPayload(DevicePostureConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        if (other.conditionList != null) {
            for (ConditionTable condition : other.conditionList) {
                this.conditionList.add(condition);
            }
        } else {
            this.conditionList = new ArrayList();
        }
        if (other.actionList != null) {
            for (ActionEntry byteData : other.actionList) {
                this.actionList.add(byteData);
            }
        } else {
            this.actionList = new ArrayList();
        }
    }

    public void setConditionList(ArrayList<ConditionTable> data) {
        this.conditionList = data;
    }

    public ArrayList<ConditionTable> getConditionList() {
        return this.conditionList;
    }

    public void setActionList(ArrayList<ActionEntry> data) {
        this.actionList = data;
    }

    public ArrayList<ActionEntry> getActionList() {
        return this.actionList;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public DevicePostureConfigurationPayload clone() {
        return new DevicePostureConfigurationPayload(this);
    }

    @Override
    public String getConfigurationFormatString() {
        return null;
    }

    @Override
    public String getConfigurationDataString() {
        return null;
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        int i;
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configurationElement = writer.writeNewField((String)"DevicePostureConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("NumConfigurationRows", 1, this.conditionList.size(), (Node)configurationElement);
        writer.writeNewField("NumActionRows", 1, this.actionList.size(), (Node)configurationElement);
        for (i = 1; i <= this.conditionList.size(); ++i) {
            ConditionTable condition = this.conditionList.get(i - 1);
            Element configurationRowElement = writer.writeNewField((String)new StringBuilder().append((String)"ConfigurationRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            writer.writeNewField("DevicePostureId", 1, condition.postureId, (Node)configurationRowElement);
            writer.writeNewField("PlmModeID", 4, condition.plmModeId, (Node)configurationRowElement);
            writer.writeNewField("TabletMode", 1, condition.tabletMode, (Node)configurationRowElement);
            writer.writeNewField("SdoStatePrimary", 1, condition.sdoStatePrimary, (Node)configurationRowElement);
            writer.writeNewField("SdoStateSecondary", 1, condition.sdoStateSecondary, (Node)configurationRowElement);
        }
        for (i = 1; i <= this.actionList.size(); ++i) {
            ActionEntry actionEntry = this.actionList.get(i - 1);
            Element actionRowElement = writer.writeNewField((String)new StringBuilder().append((String)"ActionRow").append((int)i).toString(), (Node)configurationElement).xmlElement;
            writer.writeNewField("ModeId", 1, actionEntry.mode, (Node)actionRowElement);
            writer.writeNewField("Purpose", 1, actionEntry.gpioPurposeId, (Node)actionRowElement);
            writer.writeNewField("Value", 1, actionEntry.value, (Node)actionRowElement);
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    public static class ActionEntry {
        public int mode;
        public int gpioPurposeId;
        public int value;

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof ActionEntry)) {
                return false;
            }
            ActionEntry other = (ActionEntry)arg0;
            return this.mode == other.mode && this.gpioPurposeId == other.gpioPurposeId && this.value == other.value;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ActionInfo {
        public String name;
        public int value;
        public boolean needGpio;
    }

    public static class ConditionTable {
        public int postureId;
        public int plmModeId;
        public int tabletMode;
        public int sdoStatePrimary;
        public int sdoStateSecondary;

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof ConditionTable)) {
                return false;
            }
            ConditionTable other = (ConditionTable)arg0;
            return this.postureId == other.postureId && this.plmModeId == other.plmModeId && this.tabletMode == other.tabletMode && this.sdoStatePrimary == other.sdoStatePrimary && this.sdoStateSecondary == other.sdoStateSecondary;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

