/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.utils;

import com.intel.sensing.fdk.common.log.ISSLogger;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

public abstract class FolderWatcher
extends Thread {
    private final WatchService watcher = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final boolean recursive;
    private final int maxDepth;
    private final Path rootPath;

    public FolderWatcher(Path dir, boolean recursive, int maxDepth) throws IOException {
        this.recursive = recursive;
        this.maxDepth = maxDepth;
        this.rootPath = dir;
        if (recursive && maxDepth == 0) {
            ISSLogger.log((Level)Level.INFO, (String)("Scanning ..." + dir));
            this.registerAll(dir);
            ISSLogger.log((Level)Level.INFO, (String)("Scanning ..." + dir + " done"));
        } else if (recursive && maxDepth > 0) {
            this.registerInDepth(dir, maxDepth);
        } else {
            this.register(dir);
        }
    }

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        if (this.keys.containsValue(dir)) {
            return;
        }
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, dir);
    }

    private void registerInDepth(Path start, int maxDepth) throws IOException {
        HashSet<FileVisitOption> visitOptionSet = new HashSet<FileVisitOption>();
        visitOptionSet.add(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(start, visitOptionSet, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FolderWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FolderWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void run() {
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) {
                ISSLogger.e((String)"WatchKey not recognized!!");
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = FolderWatcher.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                ISSLogger.log((Level)Level.INFO, (String)(String.valueOf(event.kind().name()) + ": " + child + "\n"));
                if (this.recursive && kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    try {
                        if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                            if (this.maxDepth == 0) {
                                this.registerAll(child);
                            } else if (this.maxDepth > 0) {
                                this.registerInDepth(this.rootPath, this.maxDepth);
                            }
                        }
                    }
                    catch (IOException x) {
                        ISSLogger.e((Exception)x);
                    }
                }
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.processCreateEvent(child);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    this.processModifyEvent(child);
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this.processDeleteEvent(child);
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    protected abstract void processCreateEvent(Path var1);

    protected abstract void processModifyEvent(Path var1);

    protected abstract void processDeleteEvent(Path var1);

    static void usage() {
        System.exit(-1);
    }
}

