/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.utils;

import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import java.io.File;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class OneBuildUtils {
    private static final ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.intel.sensing.fdk.ui");
    private static String FdkPackSensorFolderPath = String.valueOf(ManagerFileUtils.getFDKDir()) + System.getProperty("fdkpack.dir");
    private static String XtensaFdkPackSensorFolderPath = String.valueOf(ManagerFileUtils.getFDKDir()) + System.getProperty("fdkpack.dir");
    private static String InstalledSensorFolderPath = ManagerFileUtils.getInstalledRootDir();
    private static String GCCFolderPath = String.valueOf(ManagerFileUtils.getFDKDir()) + System.getProperty("toolchains.dir");
    private static boolean _debug = System.getProperty("debug") != null && Boolean.parseBoolean(System.getProperty("debug"));

    public static void setDebug(boolean _debug) {
        OneBuildUtils._debug = _debug;
    }

    public static void setDebugParams(String FdkPackSensorFolderPath, String InstalledSensorFolderPath) {
        OneBuildUtils.FdkPackSensorFolderPath = FdkPackSensorFolderPath;
        OneBuildUtils.InstalledSensorFolderPath = InstalledSensorFolderPath;
    }

    public static String getFdkPackSensorFolderPath(String platform, String fwVersion) throws Exception {
        return OneBuildUtils.getX86FdkPackFolderPath(platform, fwVersion);
    }

    private static String getX86FdkPackFolderPath(String platform, String fwVersion) throws Exception {
        if (_debug && !FdkPackSensorFolderPath.isEmpty()) {
            return FdkPackSensorFolderPath;
        }
        FdkPackSensorFolderPath = String.valueOf(ManagerFileUtils.getKitsBaseDir()) + File.separator + platform + File.separator + fwVersion;
        if (FdkPackSensorFolderPath == null || FdkPackSensorFolderPath.isEmpty() || !new File(FdkPackSensorFolderPath).exists()) {
            throw new Exception("Fdk Pack Path does not set correctly.");
        }
        return FdkPackSensorFolderPath;
    }

    public static String getInstalledSensorFolderPath() throws Exception {
        if (_debug && !InstalledSensorFolderPath.isEmpty()) {
            return InstalledSensorFolderPath;
        }
        if (InstalledSensorFolderPath == null || InstalledSensorFolderPath.isEmpty() || !new File(InstalledSensorFolderPath).exists()) {
            throw new Exception("Installed Module Path does not set correctly.");
        }
        return InstalledSensorFolderPath;
    }

    public static String getGCCFolderPath() throws Exception {
        if (_debug && !GCCFolderPath.isEmpty()) {
            return GCCFolderPath;
        }
        if (GCCFolderPath == null || GCCFolderPath.isEmpty() || !new File(GCCFolderPath).exists()) {
            throw new Exception("GCC Path does not set correctly.");
        }
        return GCCFolderPath;
    }

    public static String getCmakeToolchainFilePath() {
        return "toolchains_spec/toolchain_ish_x86_gcc_8.3.cmake";
    }

    private static String getXtensaFdkPackSensorFolderPath() throws Exception {
        if (_debug && !XtensaFdkPackSensorFolderPath.isEmpty()) {
            return XtensaFdkPackSensorFolderPath;
        }
        XtensaFdkPackSensorFolderPath = store.getString("XTENSA_FDK_PACK_PATH");
        if (XtensaFdkPackSensorFolderPath == null || XtensaFdkPackSensorFolderPath.isEmpty() || !new File(FdkPackSensorFolderPath).exists()) {
            throw new Exception("Fdk Pack Path does not set correctly.");
        }
        return XtensaFdkPackSensorFolderPath;
    }

    public static boolean isFwKitPath(String folderPath) {
        block4: {
            if (!folderPath.contains(ManagerFileUtils.getKitsBaseDir())) break block4;
            return true;
        }
        try {
            if (folderPath.contains(OneBuildUtils.getXtensaFdkPackSensorFolderPath())) {
                return true;
            }
        }
        catch (Exception e) {
            ISSLogger.e(e);
        }
        return false;
    }
}

