/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class AngleRegulatorConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 104;
    public static final String CALIBRATION_FORMAT_STRING = "Angle Regulator Configuration";
    public static final int FIELD_UNCHECKED_VALUE = 65535;
    public static final int LID_CLOSED_ANGLE_FIELD_SIZE = 2;
    public static final int LID_CLOSED_ANGLE_MIN_VALUE = 0;
    public static final int LID_CLOSED_ANGLE_MAX_VALUE = 360;
    public static final int TABLET_MODE_ANGLE_FIELD_SIZE = 2;
    public static final int TABLET_MODE_ANGLE_MIN_VALUE = 0;
    public static final int TABLET_MODE_ANGLE_MAX_VALUE = 360;
    public static final int KICKSTAND_CLOSED_ANGLE_FIELD_SIZE = 2;
    public static final int KICKSTAND_CLOSED_ANGLE_MIN_VALUE = 0;
    public static final int KICKSTAND_CLOSED_ANGLE_MAX_VALUE = 360;
    public static final int VALID_ANGLE_RANGE_FIELD_SIZE = 2;
    public static final int VALID_ANGLE_RANGE_MIN_VALUE = 0;
    public static final int VALID_ANGLE_RANGE_MAX_VALUE = 360;
    public static final int VALID_ANGLE_RANGE_DEFAULT_MIN_VALUE = 0;
    public static final int VALID_ANGLE_RANGE_DEFAULT_MAX_VALUE = 360;
    public static final int DEFAULT_ANGLE_FIELD_SIZE = 2;
    public static final int DEFAULT_ANGLE_MIN_VALUE = 0;
    public static final int DEFAULT_ANGLE_MAX_VALUE = 360;
    public static final int DEFAULT_ANGLE_DEFAULT_VALUE = 0;
    public static final int TIME_HYSTERESIS_FIELD_SIZE = 2;
    public static final int TIME_HYSTERESIS_MIN_VALUE = 200;
    public static final int TIME_HYSTERESIS_MAX_VALUE = 800;
    public static final int TIME_HYSTERESIS_DEFAULT_VALUE = 250;
    public static final int ANGLE_RANGE_FIELD_SIZE = 2;
    public static final int ANGLE_RANGE_MIN_VALUE = 0;
    public static final int ANGLE_RANGE_MAX_VALUE = 360;
    public static final int ANGLE_RANGE_DEFAULT_VALUE = 2;
    public static final int LATEST_FORMAT_ID = 0;
    private int _formatID = 0;
    private int _version = 0;
    private int _lidClosedAngle = 0;
    private int _tabletModeAngle = 0;
    private int _kickstandClosedAngle = 0;
    private int _validAngleRangeMin = 0;
    private int _validAngleRangeMax = 360;
    private int _defaultAngle = 0;
    private int _timeHysteresis = 0;
    private int _angleRange = 0;

    public AngleRegulatorConfigurationPayload() {
    }

    public AngleRegulatorConfigurationPayload(AngleRegulatorConfigurationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._lidClosedAngle = other._lidClosedAngle;
        this._tabletModeAngle = other._tabletModeAngle;
        this._kickstandClosedAngle = other._kickstandClosedAngle;
        this._validAngleRangeMin = other._validAngleRangeMin;
        this._validAngleRangeMax = other._validAngleRangeMax;
        this._defaultAngle = other._defaultAngle;
        this._timeHysteresis = other._timeHysteresis;
        this._angleRange = other._angleRange;
    }

    public AngleRegulatorConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configPayload = reader.readNewField((String)"AngleRegulatorConfiguration", (Node)payloadXmlNode).xmlElement;
        this._lidClosedAngle = reader.readNewField((String)"LidClosedAngle", (int)2, (boolean)false, (Node)configPayload).value;
        this._tabletModeAngle = reader.readNewField((String)"TabletModeAngle", (int)2, (boolean)false, (Node)configPayload).value;
        this._kickstandClosedAngle = reader.readNewField((String)"KickstandClosedAngle", (int)2, (boolean)false, (Node)configPayload).value;
        this._validAngleRangeMin = reader.readNewField((String)"ValidAngleRangeMin", (int)2, (boolean)false, (Node)configPayload).value;
        this._validAngleRangeMax = reader.readNewField((String)"ValidAngleRangeMax", (int)2, (boolean)false, (Node)configPayload).value;
        this._defaultAngle = reader.readNewField((String)"DefaultAngle", (int)2, (boolean)false, (Node)configPayload).value;
        this._timeHysteresis = reader.readNewField((String)"TimeHysteresis", (int)2, (boolean)false, (Node)configPayload).value;
        this._angleRange = reader.readNewField((String)"AngleRange", (int)2, (boolean)false, (Node)configPayload).value;
    }

    @Override
    public ConfigurationPayload clone() {
        return new AngleRegulatorConfigurationPayload(this);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof AngleRegulatorConfigurationPayload)) {
            return false;
        }
        AngleRegulatorConfigurationPayload other = (AngleRegulatorConfigurationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._lidClosedAngle == other._lidClosedAngle && this._tabletModeAngle == other._tabletModeAngle && this._kickstandClosedAngle == other._kickstandClosedAngle && this._validAngleRangeMin == other._validAngleRangeMin && this._validAngleRangeMax == other._validAngleRangeMax && this._defaultAngle == other._defaultAngle && this._timeHysteresis == other._timeHysteresis && this._angleRange == other._angleRange;
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configPayload = writer.writeNewField((String)"AngleRegulatorConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("LidClosedAngle", 2, this._lidClosedAngle, (Node)configPayload);
        writer.writeNewField("TabletModeAngle", 2, this._tabletModeAngle, (Node)configPayload);
        writer.writeNewField("KickstandClosedAngle", 2, this._kickstandClosedAngle, (Node)configPayload);
        writer.writeNewField("ValidAngleRangeMin", 2, this._validAngleRangeMin, (Node)configPayload);
        writer.writeNewField("ValidAngleRangeMax", 2, this._validAngleRangeMax, (Node)configPayload);
        writer.writeNewField("DefaultAngle", 2, this._defaultAngle, (Node)configPayload);
        writer.writeNewField("TimeHysteresis", 2, this._timeHysteresis, (Node)configPayload);
        writer.writeNewField("AngleRange", 2, this._angleRange, (Node)configPayload);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public String getConfigurationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public boolean isLidClosed() {
        return this._lidClosedAngle != 65535;
    }

    public void setLidClosed(boolean lidClosed) {
        if (this._lidClosedAngle == 65535 && lidClosed) {
            this._lidClosedAngle = 0;
        } else if (!lidClosed) {
            this._lidClosedAngle = 65535;
        }
    }

    public int getLidClosedAngle() {
        return this._lidClosedAngle;
    }

    public void setLidClosedAngle(int lidClosedAngle) {
        this._lidClosedAngle = lidClosedAngle;
    }

    public boolean isTabletMode() {
        return this._tabletModeAngle != 65535;
    }

    public void setTabletMode(boolean tableMode) {
        if (this._tabletModeAngle == 65535 && tableMode) {
            this._tabletModeAngle = 0;
        } else if (!tableMode) {
            this._tabletModeAngle = 65535;
        }
    }

    public int getTabletModeAngle() {
        return this._tabletModeAngle;
    }

    public void setTabletModeAngle(int tabletModeAngle) {
        this._tabletModeAngle = tabletModeAngle;
    }

    public boolean isKickstandClosed() {
        return this._kickstandClosedAngle != 65535;
    }

    public void setKickstandClosed(boolean kickstandClosed) {
        if (this._kickstandClosedAngle == 65535 && kickstandClosed) {
            this._kickstandClosedAngle = 0;
        } else if (!kickstandClosed) {
            this._kickstandClosedAngle = 65535;
        }
    }

    public int getKickstandClosedAngle() {
        return this._kickstandClosedAngle;
    }

    public void setKickstandClosedAngle(int kickstandClosedAngle) {
        this._kickstandClosedAngle = kickstandClosedAngle;
    }

    public int getValidAngleRangeMin() {
        return this._validAngleRangeMin;
    }

    public void setValidAngleRangeMin(int validAngleRangeMin) {
        this._validAngleRangeMin = validAngleRangeMin;
    }

    public int getValidAngleRangeMax() {
        return this._validAngleRangeMax;
    }

    public void setValidAngleRangeMax(int validAngleRangeMax) {
        this._validAngleRangeMax = validAngleRangeMax;
    }

    public int getDefaultAngle() {
        return this._defaultAngle;
    }

    public void setDefaultAngle(int defaultAngle) {
        this._defaultAngle = defaultAngle;
    }

    public int getTimeHysteresis() {
        return this._timeHysteresis;
    }

    public void setTimeHysteresis(int timeHysteresis) {
        this._timeHysteresis = timeHysteresis;
    }

    public int getAngleRange() {
        return this._angleRange;
    }

    public void setAngleRange(int angleRange) {
        this._angleRange = angleRange;
    }

    public int getFormatID() {
        return this._formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setFormatID(Integer formatID) {
        this._formatID = formatID;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

