/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.payloads.Payload;
import pdtEditor.validation.Validator;

public class GuidPayload
implements Payload {
    public static final int GUID_FIELD_SIZE = 16;
    private byte[] guid;
    private String guidString = "";
    public static final int INFO_ID = 3;

    public GuidPayload(String guid) {
        this.setGuid(guid);
    }

    public GuidPayload(GuidPayload other) {
        this.setGuid(other.getGuid());
    }

    public GuidPayload(BinReader reader, Element payloadXmlNode) {
        this.guid = reader.readBytes(16, "GUID", payloadXmlNode);
        this.guidString = DatatypeConverter.printHexBinary((byte[])this.guid);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.addComment("GUID Information", parent);
        writer.writeNewField("InfoId", 1, 3, (Node)parent);
        writer.writeNewField("Reserved", 1, 0, (Node)parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writerBinaryField("GUID", this.guid, parent);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public GuidPayload clone() {
        return new GuidPayload(this);
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public String getGuid() {
        return this.guidString;
    }

    public void setGuid(String guidText) {
        this.guidString = guidText;
        this.guid = new byte[16];
        int i = 0;
        int j = 0;
        while (i < guidText.length()) {
            this.guid[j] = (byte)(Integer.parseInt(guidText.substring(i, i + 2), 16) & 0xFF);
            i += 2;
            ++j;
        }
    }
}

