/*
 * Decompiled with CFR 0.152.
 */
package packaging;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NvarPackage {
    private static final int HEADER_VERSION = 1;
    private static final int ENTRY_VERSION = 1;
    private static final int HEADER_LENGTH = 20;
    private static final int MAX_NVAR_NAME_SIZE = 256;
    private static final String HEADER_MARKER = "$NVD";
    public static final String NVAR_BIN_NAME = "PDTD";
    private final String _pdtInternalName = "ish_srv/INTC_pdt";
    private final String _dbgConfInternalName = "ish_srv/trace_config";
    private byte[] _pdtFileContent = null;
    private byte[] _debugConfFileContent = null;
    private String _path;
    private String _pdtGivenName = null;

    public void readNvarPackage() {
        BinReader reader = new BinReader(true);
        reader.loadBinary(this._path);
        Element head = reader.readNewField((String)"NVARPackage", (Node)reader.getHeadElement()).xmlElement;
        reader.readNewField("HeaderMarker", 4, false, head);
        reader.readNewField("BinaryName", 4, false, head);
        int entriesNum = reader.readNewField((String)"NumOfEntries", (int)4, (boolean)false, (Node)head).value;
        reader.readNewField("HeaderVersion", 1, false, head);
        reader.readNewField("EntryVersion", 1, false, head);
        reader.readNewField("HeaderLength", 1, false, head);
        reader.readNewField("CheckSum", 1, false, head);
        reader.readNewField("Reserved", 4, false, head);
        for (int i = 0; i < entriesNum; ++i) {
            Element nvarHead = reader.readNewField((String)"PdtHeader", (Node)reader.getHeadElement()).xmlElement;
            String name = reader.readString((String)"NvarName", (int)256, (Node)nvarHead).strValue.trim();
            int offset = reader.readNewField((String)"Offset", (int)4, (boolean)false, (Node)nvarHead).value;
            int size = reader.readNewField((String)"FileSize", (int)4, (boolean)false, (Node)nvarHead).value;
            reader.readNewField("Reserved", 4, false, nvarHead);
            if (name.equals("ish_srv/INTC_pdt")) {
                this._pdtFileContent = reader.getSubFile(offset, size, "PdtFileContent", nvarHead);
                continue;
            }
            if (name.equals("ish_srv/trace_config")) {
                this._debugConfFileContent = reader.getSubFile(offset, size, "DbgConfigFileContent", nvarHead);
                continue;
            }
            throw new RuntimeException("Unrecognized file name");
        }
    }

    public void writeNvarPackage(Element replacedHead, boolean isExportXml) throws AccessDeniedException, TransformerException {
        BinWriter writer = new BinWriter(true);
        if (replacedHead != null) {
            writer.replaceHead(replacedHead);
        }
        Element head = writer.writeNewField((String)"NVARPackage", (Node)writer.getHeadElement()).xmlElement;
        Node originalFirstChild = writer.getHeadElement().getFirstChild();
        writer.getHeadElement().removeChild(head);
        writer.getHeadElement().insertBefore(head, originalFirstChild);
        writer.writeNewField("HeaderMarker", 4, HEADER_MARKER, (Node)head);
        writer.writeNewField("BinaryName", 4, NVAR_BIN_NAME, (Node)head);
        int fileCount = 0;
        if (this._pdtFileContent != null) {
            ++fileCount;
        }
        if (this._debugConfFileContent != null) {
            ++fileCount;
        }
        writer.writeNewField("NumOfEntries", 4, fileCount, (Node)head);
        writer.writeNewField("HeaderVersion", 1, 1, (Node)head);
        writer.writeNewField("EntryVersion", 1, 1, (Node)head);
        writer.writeNewField("HeaderLength", 1, 20, (Node)head);
        Common.Field checkSum = writer.writeNewField("CheckSum", 1, 0, (Node)head);
        writer.writeNewField("Reserved", 4, 0, (Node)head);
        Common.Field pdtOffset = null;
        if (this._pdtFileContent != null) {
            Element PdtHead = writer.writeNewField((String)"PdtHeader", (Node)writer.getHeadElement()).xmlElement;
            writer.writeNewField("NvarName", 256, "ish_srv/INTC_pdt", (Node)PdtHead);
            pdtOffset = writer.writeNewField("Offset", 4, 0, (Node)PdtHead);
            writer.writeNewField("FileSize", 4, this._pdtFileContent.length, (Node)PdtHead);
            writer.writeNewField("Reserved", 4, 0, (Node)PdtHead);
            writer.getHeadElement().removeChild(PdtHead);
            writer.getHeadElement().insertBefore(PdtHead, originalFirstChild);
        }
        Common.Field dbgOffset = null;
        if (this._debugConfFileContent != null) {
            Element PdtHead = writer.writeNewField((String)"DebugConfHeader", (Node)writer.getHeadElement()).xmlElement;
            writer.writeNewField("NvarName", 256, "ish_srv/trace_config", (Node)PdtHead);
            dbgOffset = writer.writeNewField("Offset", 4, 0, (Node)PdtHead);
            writer.writeNewField("FileSize", 4, this._debugConfFileContent.length, (Node)PdtHead);
            writer.writeNewField("Reserved", 4, 0, (Node)PdtHead);
            writer.getHeadElement().removeChild(PdtHead);
            writer.getHeadElement().insertBefore(PdtHead, originalFirstChild);
        }
        if (this._pdtFileContent != null) {
            writer.updateData(pdtOffset, writer.writeBinarydata(this._pdtFileContent));
        }
        if (this._debugConfFileContent != null) {
            writer.updateData(dbgOffset, writer.writeBinarydata(this._debugConfFileContent));
        }
        writer.updateData(checkSum, writer.calcCheckSumValue());
        writer.createBin(this._path);
        if (isExportXml) {
            writer.exportXML(this._path + ".xml");
        }
    }

    public void writeNvarPackage() throws AccessDeniedException, TransformerException {
        this.writeNvarPackage(null, false);
    }

    public void readPdtFromFile(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        try {
            this._pdtFileContent = Files.readAllBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readDebugConfigFromFile(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        try {
            this._debugConfFileContent = Files.readAllBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPdtContent(byte[] data) {
        this._pdtFileContent = data;
    }

    public void setDebugConfContent(byte[] data) {
        this._debugConfFileContent = data;
    }

    public byte[] getPdtContent() {
        return this._pdtFileContent;
    }

    public byte[] getDebugConfContent() {
        return this._debugConfFileContent;
    }

    public void setBinPath(String path) {
        this._path = path;
    }

    public static String getFileName(String pdtGivenName) {
        String pdtName = pdtGivenName != null ? pdtGivenName : "PDT";
        return pdtName + "_NVAR.bin";
    }

    public String getFileName() {
        return NvarPackage.getFileName(this._pdtGivenName);
    }

    public void setPdtGivenName(String pdtName) {
        this._pdtGivenName = pdtName;
    }

    public static boolean isNVARPackage(String path) {
        if (!new File(path).exists()) {
            return false;
        }
        BinReader reader = new BinReader(true);
        reader.loadBinary(path);
        String headerMarker = reader.readString(null, (int)4, null).strValue;
        String fileName = reader.readString(null, (int)4, null).strValue;
        return headerMarker.equals(HEADER_MARKER) && fileName.equals(NVAR_BIN_NAME);
    }
}

