/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.CalibrationParser;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Validator;

public class CustomCalibrationPayload
extends CalibrationPayload {
    public static final int CALIBRATION_TYPE = 9999;
    public static final String CALIBRATION_FORMAT_STRING = "Vendor custom calibration data";
    public static final int BINARY_DATA_MAX_SIZE = 65000;
    ArrayList<Byte> _data = new ArrayList();
    private int _formatID;
    private int _version;

    public CustomCalibrationPayload() {
    }

    public CustomCalibrationPayload(CustomCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        if (other._data != null) {
            for (Byte byteData : other._data) {
                this._data.add(byteData);
            }
        } else {
            this._data = new ArrayList();
        }
    }

    public CustomCalibrationPayload(int formatId, int dataLength, BinReader reader, Element payloadXmlNode) {
        super(payloadXmlNode);
        this._formatID = formatId;
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        byte[] data = reader.readBytes(dataLength - 2, "BinaryData", payloadXmlNode);
        for (int i = 0; i < data.length; ++i) {
            this._data.add(data[i]);
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof CustomCalibrationPayload)) {
            return false;
        }
        CustomCalibrationPayload other = (CustomCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && (this._data == null && other._data == null || this._data != null && this._data.equals(other._data));
    }

    @Override
    public CustomCalibrationPayload clone() {
        return new CustomCalibrationPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        if (this._data != null) {
            writer.writerBinaryField("BinaryData", this._data, parent);
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    public void setDataFromXalibrationXML(Element calibrationData) {
        Element dataElement = (Element)DataStore.getChildNodeByName(calibrationData, "OEMCustomData");
        this._data = CalibrationParser.getBinaryData(dataElement);
    }

    public void setData(ArrayList<Byte> data) {
        this._data = data;
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        if (this._data == null) {
            return "None";
        }
        StringBuilder res = new StringBuilder();
        for (Byte currByte : this._data) {
            res.append(Integer.toBinaryString(currByte.byteValue()));
        }
        return res.toString();
    }

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int formatID) {
        this._formatID = formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public ArrayList<Byte> getVendorDefinedData() {
        return this._data;
    }

    public void setVendorDefinedData(ArrayList<Byte> vendorDefinedData) {
        this._data = vendorDefinedData;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }
}

