/*
 * Decompiled with CFR 0.152.
 */
package manager.utils;

import java.util.List;
import manager.configure.Firmware;
import manager.configure.ISSFirmwareConfiguration;
import manager.configure.ISSPlatformConfiguration;
import manager.configure.Platform;

public class ManagerConfigs {
    private static ISSPlatformConfiguration sPlatformConfig;
    private static ISSFirmwareConfiguration sFirmwareConfig;

    static {
        try {
            sPlatformConfig = ISSPlatformConfiguration.getInstance();
            sFirmwareConfig = ISSFirmwareConfiguration.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<Platform> getPlatforms() {
        return sPlatformConfig.getSupportedPlatforms();
    }

    public static Platform getPlatformByName(String plat) {
        return sPlatformConfig.getPlatformByName(plat);
    }

    public static String[] getPlatformNames() {
        return sPlatformConfig.getPlatformNames();
    }

    public static String[] getPlatformExternalNames() {
        return sPlatformConfig.getPlatformExternalNames();
    }

    public static Platform getPlatformByValue(double value) {
        return sPlatformConfig.getPlatformByValue(value);
    }

    public static Platform getPlatformByIssVersion(String issStr) {
        return sPlatformConfig.getPlatformByIssVersion(issStr);
    }

    public static Platform getPlatformByExternalName(String externalName) {
        return sPlatformConfig.getPlatformByExternalName(externalName);
    }

    public static Platform getAlternativePlatform(Platform plat) {
        return ManagerConfigs.getPlatformByName(plat.getAlternativePlatform());
    }

    public static Platform getDefaultPlatform() {
        return ManagerConfigs.getPlatformByName("CNL");
    }

    public static List<Firmware> getFirmwares(Platform plat) {
        if (plat == null) {
            return null;
        }
        return sFirmwareConfig.getFirmwares(plat.getName());
    }

    public static List<String> getFirmwareVersions(Platform plat) {
        if (plat == null) {
            return null;
        }
        return sFirmwareConfig.getFirmwareVersions(plat.getName());
    }

    public static Firmware getFirmwareByVersion(Platform plat, String version) {
        if (plat == null || version == null || version.isEmpty()) {
            return null;
        }
        return sFirmwareConfig.getFirmwareByVersion(plat, version);
    }

    public static Firmware getDefaultFirmwareVersion(Platform plat) {
        if (plat == null) {
            return null;
        }
        return sFirmwareConfig.getDefaultFirmwareVersion(plat);
    }

    public static List<Firmware> getNoFDKFirmwares(Platform plat) {
        if (plat == null) {
            return null;
        }
        return sFirmwareConfig.getNoFDKFirmwares(plat);
    }

    public static boolean isFirmwareInstalled(Platform plat, String version) {
        if (version == null || version.isEmpty() || plat == null) {
            return false;
        }
        return sFirmwareConfig.isFirmwareInstalled(plat, version);
    }

    public static void setDefaultFirmwareVersion(String version, Platform plat) throws Exception {
        if (plat == null || version == null || version.isEmpty()) {
            throw new Exception("invalid arguments");
        }
        sFirmwareConfig.setDefaultFirmwareVersion(version, plat);
    }

    public static void removeFirmware(Platform plat, Firmware fm) throws Exception {
        if (plat == null || fm == null) {
            throw new Exception("invalid arguments");
        }
        sFirmwareConfig.removeFirmware(plat, fm);
    }

    public static void removeAllFirmwares(Platform plat) throws Exception {
        if (plat == null) {
            throw new Exception("invalid arguments");
        }
        sFirmwareConfig.removeAllFirmwares(plat);
    }

    public static void addFirmware(Platform plat, Firmware fm) throws Exception {
        if (plat == null) {
            throw new Exception("invalid arguments");
        }
        sFirmwareConfig.addFirmware(plat, fm);
    }

    public static void addFirmwares(List<Firmware> firmwares) throws Exception {
        if (firmwares == null) {
            throw new Exception("invalid arguments");
        }
        sFirmwareConfig.addFirmwares(firmwares);
    }

    public static void removeAllNoFDKFirmwares(Platform plat) throws Exception {
        if (plat == null) {
            throw new Exception("invalid arguments");
        }
        sFirmwareConfig.removeAllNoFDKFirmwares(plat);
    }
}

