/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pdtEditor.InformationStore;

public class UserPreferences
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PREFERENCES_FILE_DEFAULT_NAME = "RunData";
    public static final String PDT_EDITOR_APPDATA_DIR_RELATIVE_PATH = "/AppData/Roaming/Intel_ISS_FDK/PDT_Editor";
    private static UserPreferences instance;
    private static File _preferencesFile;
    private File _workingDirectory = new File("./");

    private void copyMembersFrom(UserPreferences other) {
        this._workingDirectory = other._workingDirectory;
    }

    private UserPreferences() {
        this.setDefaultFilePath();
        try {
            this.deserialize();
        }
        catch (Exception e) {
            System.err.println("Faild to deserialize the RunData file: " + e.getMessage());
        }
    }

    public static UserPreferences getInstance() {
        if (instance == null) {
            instance = new UserPreferences();
        }
        return instance;
    }

    public static String getAppDataEditorDirectoryPath() {
        String homeDir;
        String fdkPath = InformationStore.getFDKPath();
        if (fdkPath != null && (homeDir = System.getProperty("user.home")) != null) {
            return homeDir + PDT_EDITOR_APPDATA_DIR_RELATIVE_PATH;
        }
        return null;
    }

    public void setDefaultFilePath() {
        _preferencesFile = new File("./RunData");
        if (_preferencesFile.exists()) {
            return;
        }
        String appDataDir = UserPreferences.getAppDataEditorDirectoryPath();
        if (appDataDir != null) {
            _preferencesFile = new File(appDataDir + File.separatorChar + PREFERENCES_FILE_DEFAULT_NAME);
            return;
        }
    }

    public void setFilePath(String path) {
        _preferencesFile = new File(path);
    }

    public String getFilePath() {
        if (_preferencesFile == null) {
            return null;
        }
        return _preferencesFile.getPath();
    }

    public void setWorkingDirectory(String path) {
        if (path == null) {
            this._workingDirectory = new File("./");
            return;
        }
        File dir = new File(path);
        if (dir.isFile()) {
            dir = dir.getParentFile();
        }
        if (!dir.isDirectory()) {
            System.err.println("Invalid directory path: " + path);
        }
        this._workingDirectory = dir;
        try {
            this.serialize();
        }
        catch (Exception e) {
            System.err.println("Faild to serialize the RunData file: " + e.getMessage());
        }
    }

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public void serialize() throws IOException {
        if (_preferencesFile == null) {
            throw new RuntimeException("Preferences file hasn't been set.");
        }
        if (!_preferencesFile.getParentFile().exists()) {
            _preferencesFile.getParentFile().mkdir();
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(_preferencesFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (oos != null) {
                oos.close();
            }
        }
    }

    public void deserialize() throws IOException {
        if (_preferencesFile == null) {
            throw new RuntimeException("Preferences file hasn't been set.");
        }
        if (!_preferencesFile.isFile()) {
            return;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(_preferencesFile);
            ois = new ObjectInputStream(fis);
            UserPreferences loadedObject = (UserPreferences)ois.readObject();
            if (loadedObject == null) {
                throw new Exception("Error while loading the preferences.");
            }
            this.copyMembersFrom(loadedObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (ois != null) {
                ois.close();
            }
        }
    }

    static {
        _preferencesFile = new File(PREFERENCES_FILE_DEFAULT_NAME);
    }
}

