#!/bin/bash
if [ ${BASH_VERSION:0:1} -lt '4' ]
then
	echo "bash must support associative arrays"
	exit 1
fi

if [ -r /etc/os-release ]
then
        source /etc/os-release
else
        echo "Unable to determine release"
        exit 1
fi

arch=$(uname -m)
# defaults
declare -A id=(
	# dtype pkgtype pkgdirsuffix
	[rhel]="rhel rpm rpmbuild/RPMS/$arch"
	[rocky]="rhel rpm rpmbuild/RPMS/$arch"
	[centos]="rhel rpm rpmbuild/RPMS/$arch"
	[ol]="rhel rpm rpmbuild/RPMS/$arch"
	[anolis]="rhel rpm rpmbuild/RPMS/$arch"
	[almalinux]="rhel rpm rpmbuild/RPMS/$arch"
	[openEuler]="rhel rpm rpmbuild/RPMS/$arch"
	[sles]="sles rpm rpmbuild/RPMS/$arch"
	[ubuntu]="ubuntu deb ."
)

if [ -z "${id[${ID}]}" ]
then
	# try to determine
	if type dpkg >/dev/null 2>/dev/null
	then
		id_val="ubuntu deb ."
	elif type zypper >/dev/null 2>/dev/null
	then
		id_val="sles rpm rpmbuild/RPMS/$arch"
	elif type dnf >/dev/null 2>/dev/null
	then
		id_val="rhel rpm rpmbuild/RPMS/$arch"
	elif type yum >/dev/null 2>/dev/null
	then
		id_val="rhel rpm rpmbuild/RPMS/$arch"
	else
		echo "Unknown distro"
		exit 1
	fi
else
	id_val="${id[${ID}]}"
fi
read -a val <<< ${id_val}
if [ ${#val[@]} -ne 3 ]
then
	echo "$id_val does not have 3 elements"
	exit 1
fi
dtype=${val[0]}
pkgtype=${val[1]}
pkgdirsuffix=${val[2]}
