/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.service;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.model.SensorsDefinitionsMapping;
import com.intel.sensing.fdk.model.abstractData.Category;
import com.intel.sensing.fdk.model.abstractData.CoreData;
import com.intel.sensing.fdk.model.abstractData.Version;
import com.intel.sensing.fdk.model.entity.FirmwareKit;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.PlatformEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import com.intel.sensing.fdk.model.persistence.cache.Impl.InstalledModuleCacheManager;
import com.intel.sensing.fdk.model.persistence.cache.Impl.KitModuleCacheManager;
import com.intel.sensing.fdk.model.service.FirmwareKitService;
import com.intel.sensing.fdk.model.service.InstalledModuleService;
import com.intel.sensing.fdk.model.service.PlatformService;
import com.intel.sensing.fdk.model.utils.TypeUtils;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PersistenceService {
    private KitModuleCacheManager kitModuleCacheMgr;
    private InstalledModuleCacheManager installedModuleCacheMgr;
    private FirmwareKitService kitService;
    private InstalledModuleService installedModuleService;
    private PlatformService platformService;
    private static PersistenceService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized PersistenceService getDefault() {
        if (service != null) return service;
        Class<KitModuleCacheManager> clazz = KitModuleCacheManager.class;
        synchronized (KitModuleCacheManager.class) {
            if (service != null) return service;
            service = new PersistenceService();
            service.initAllService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void initAllService() {
        ISSLogger.i((String)"Persistence service initializing");
        try {
            this.initPlatformService();
            ISSLogger.i((String)"Persistence platform service initialized");
            this.initCacheService();
            ISSLogger.i((String)"Persistence cache service initialized");
            this.initEntityService();
            ISSLogger.i((String)"Persistence entity service initialized");
            this.initCacheListener();
            ISSLogger.i((String)"Persistence cache listener initialized");
            CoreData.getInstance();
            SensorsDefinitionsMapping.getInstance();
            TypeUtils.fillMap();
            ISSLogger.i((String)"Sensor data initialized");
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
            ISSLogger.e((String)"Persistence service failed");
        }
        ISSLogger.i((String)"Persistence service initialized");
    }

    private void initPlatformService() {
        this.platformService = PlatformService.getInstance();
    }

    public void unInit() {
        this.installedModuleCacheMgr.removePropertyChangeListener(this.installedModuleService);
        this.kitModuleCacheMgr.removePropertyChangeListener(this.kitService);
        this.platformService.shutup();
    }

    private void initCacheService() throws ISSException, IOException {
        this.kitModuleCacheMgr = KitModuleCacheManager.init();
        this.installedModuleCacheMgr = InstalledModuleCacheManager.init();
    }

    private void initEntityService() throws ISSException, IOException {
        this.kitService = FirmwareKitService.init();
        this.installedModuleService = InstalledModuleService.init();
    }

    private void initCacheListener() {
        this.installedModuleCacheMgr.addPropertyChangeListener(this.installedModuleService);
        this.kitModuleCacheMgr.addPropertyChangeListener(this.kitService);
    }

    public static void addFwKitServiceListener(PropertyChangeListener listener) {
        PersistenceService.getDefault().kitService.addPropertyChangeListener(listener);
    }

    public static void removeFwKitServiceListener(PropertyChangeListener listener) {
        PersistenceService.getDefault().kitService.removePropertyChangeListener(listener);
    }

    public static List<FirmwareKit> getAllFwKit() {
        return PersistenceService.getDefault().kitService.getAllFwKit();
    }

    public static List<FirmwareKit> getFwKitByPlatform(String platform) {
        return PersistenceService.getDefault().kitService.getFwKitByPlatform(platform);
    }

    public static FirmwareKit getFwKitByPlatformAndVersion(String platform, Version version) {
        return PersistenceService.getDefault().kitService.getFwKitByPlatformAndVersion(platform, version);
    }

    public static List<ModuleEntity> getFwKitModuleByPlatformAndVersion(String platform, Version version) {
        FirmwareKit fk = PersistenceService.getDefault().kitService.getFwKitByPlatformAndVersion(platform, version);
        if (fk != null) {
            return fk.getModuleList();
        }
        return new ArrayList<ModuleEntity>();
    }

    public static List<ModuleEntity> getAllFwKitModuleList() {
        return PersistenceService.getDefault().kitService.getAllFwKit().stream().flatMap(kit -> kit.getModuleList().stream()).collect(Collectors.toList());
    }

    public static List<SensorDataEntity> getAllFwKitSensorList() {
        return PersistenceService.getAllFwKitModuleList().parallelStream().filter(module -> module.getCategory() != null && module.getCategory().equals(Category.SENSOR.getName())).filter(module -> module.getSensorBundle() != null && module.getSensorBundle().getSensors() != null).flatMap(module -> module.getSensorBundle().getSensors().stream()).filter(sensor -> sensor != null).collect(Collectors.toList());
    }

    public static Set<String> getAvailablePlatform() {
        return PersistenceService.getDefault().kitService.getFwKitMapByPlatform().keySet();
    }

    public static List<Version> getAvailableKitVersionByPlatform(String platform) {
        return PersistenceService.getDefault().kitService.getFwKitMapByPlatform().get(platform).stream().map(kit -> kit.getVersion()).collect(Collectors.toList());
    }

    public static String[] getAvailableKitVersionByPlatformDisplayName(String platformFullStr) {
        String platform = PersistenceService.getPlatformNameByDisplayName(platformFullStr);
        return (String[])PersistenceService.getAvailableKitVersionByPlatform(platform).stream().map(version -> version.toString()).toArray(String[]::new);
    }

    public static String[] getAvailablePlatformAsStr() {
        return (String[])PersistenceService.getAvailablePlatform().stream().map(ps -> {
            PlatformEntity plat = PersistenceService.getPlatformByName(ps);
            if (plat != null) {
                return plat.getExternalName();
            }
            return ps;
        }).toArray(String[]::new);
    }

    public static FirmwareKit getDefaultFirmwareVersion(String platform) {
        return PersistenceService.getDefault().kitService.getFwKitByPlatform(platform).stream().findFirst().orElse(null);
    }

    public static List<FirmwareKit> getNoFDKFirmwares(String platform) {
        return PersistenceService.getDefault().kitService.getFwKitByPlatform(platform).stream().filter(p -> !p.isFDKInstalled()).filter(p -> p != null).collect(Collectors.toList());
    }

    public static boolean isFirmwareInstalled(FirmwareKit firmware) {
        return PersistenceService.getDefault().kitService.getAllFwKit().stream().anyMatch(fw -> fw.equals(firmware));
    }

    public static void addInstalledModuleServiceListener(PropertyChangeListener listener) {
        PersistenceService.getDefault().installedModuleService.addPropertyChangeListener(listener);
    }

    public static void removeInstalledModuleServiceListener(PropertyChangeListener listener) {
        PersistenceService.getDefault().installedModuleService.removePropertyChangeListener(listener);
    }

    public static List<ModuleEntity> getInstalledModule() {
        return PersistenceService.getDefault().installedModuleService.getInstalledModuleEntity();
    }

    public static List<String> getInstalledPackageList() {
        return PersistenceService.getDefault().installedModuleService.getInstalledPackageList();
    }

    public static boolean isModuleInstalled(ModuleEntity module) {
        return PersistenceService.getDefault().installedModuleService.getInstalledModuleEntity().contains(module);
    }

    public static List<SensorDataEntity> getAllInstalledSensorList() {
        return PersistenceService.getInstalledModule().stream().filter(module -> module.getCategoryInData().equals(Category.SENSOR)).filter(module -> module != null).flatMap(module -> module.getSensorBundle().getSensors().stream()).collect(Collectors.toList());
    }

    public static List<ModuleEntity> getAllInstalledLibraryList() {
        return PersistenceService.getInstalledModule().stream().filter(module -> module.getCategoryInData().equals(Category.LIB)).filter(module -> module != null).collect(Collectors.toList());
    }

    public static List<SensorDataEntity> getFwKitSensorList(String platform, Version version) {
        return PersistenceService.getFwKitModuleByPlatformAndVersion(platform, version).stream().filter(module -> module.getCategoryInData() != null && module.getCategoryInData().equals(Category.SENSOR)).filter(module -> module != null && module.getSensorBundle() != null).flatMap(module -> module.getSensorBundle().getSensors().stream()).collect(Collectors.toList());
    }

    public static String getDefaultPlatorm() {
        return PersistenceService.getAvailablePlatform().stream().filter(plat -> plat != null).findFirst().orElse(null);
    }

    public static PlatformEntity getPlatformByName(String platformName) {
        return PersistenceService.getDefault().platformService.getPlatformByName(platformName);
    }

    public static String getUpgradePlatorm(String plat) {
        String alter;
        PlatformEntity pe = PersistenceService.getDefault().platformService.getPlatformByName(plat);
        if (pe != null && PersistenceService.supportPlatform(alter = pe.getAlternativePlatform())) {
            return alter;
        }
        return PersistenceService.getDefaultPlatorm();
    }

    public static String getPlatformNameByDisplayName(String platformName) {
        return PersistenceService.getDefault().platformService.getPlatformNameByDisplayName(platformName);
    }

    public static String getPlatformDisplayName(String plat) {
        return PersistenceService.getDefault().platformService.getPlatformDisplayName(plat);
    }

    public static boolean supportPlatform(String plat) {
        return PersistenceService.getAvailablePlatform().contains(plat);
    }

    public static List<String> getSupportPlatforms() {
        return PersistenceService.getDefault().platformService.getSupportPlatforms();
    }
}

